/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.gui.parser.event.CPAEventData;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.parser.CriticalPairEvent;
import agg.parser.ExcludePairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.xt_basis.Rule;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CriticalPairPanel
extends JPanel
implements ActionListener,
ParserEventListener,
ItemListener,
PopupMenuListener {
    static final Color NOT_SET = Color.white;
    static final Color SCHEDULED = Color.gray;
    static final Color COMPUTING = Color.yellow;
    static final Color CRITIC = Color.red;
    static final Color DEPEND = Color.blue;
    static final Color NOT_CRITIC = Color.green;
    static final Color DISABLED = Color.lightGray;
    static final Color NOT_RELATED = Color.lightGray;
    private ExcludePairContainer container;
    private Hashtable buttons = new Hashtable();
    private Hashtable firstRules = new Hashtable();
    private Hashtable secondRules = new Hashtable();
    private Vector listeners = new Vector();
    private Rule first;
    private Rule second;
    private int tableW;
    private int tableH;
    private JPopupMenu menu;
    private JMenuItem miClear;
    private JMenuItem miVisibleRel;
    private JMenuItem miVisibleRule;
    private String hideRelation = "Hide Relation ( in CPA Graph )";
    private String showRelation = "Show Relation ( in CPA Graph )";
    private String hideRule = "Hide Rule ( in CPA Graph )";
    private String showRule = "Show Rule ( in CPA Graph )";
    private Border border = new JButton().getBorder();
    JScrollPane main;
    boolean active;

    private static Vector createVector(Enumeration en) {
        Vector result = new Vector();
        while (en.hasMoreElements()) {
            result.add(en.nextElement());
        }
        return result;
    }

    public CriticalPairPanel(Enumeration rules, ExcludePairContainer container) {
        this(CriticalPairPanel.createVector(rules), container);
    }

    public CriticalPairPanel(Vector rules, ExcludePairContainer container) {
        super(new BorderLayout(), true);
        if (rules == null || rules.size() == 0) {
            return;
        }
        this.container = container;
        container.addPairEventListener(this);
        this.main = new JScrollPane();
        JPanel rowHead = new JPanel();
        rowHead.setLayout(new GridLayout(rules.size(), 1));
        Enumeration en = rules.elements();
        int i = 1;
        while (en.hasMoreElements()) {
            String text = "" + i + ": " + ((Rule)en.nextElement()).getName();
            JLabel act = new JLabel(text);
            act.setToolTipText("first rule: " + text);
            rowHead.add(act);
            ++i;
        }
        JPanel colHead = new JPanel();
        colHead.setLayout(new GridLayout(1, rules.size()));
        en = rules.elements();
        i = 1;
        while (en.hasMoreElements()) {
            String text = "" + i + ": " + ((Rule)en.nextElement()).getName();
            JLabel act = new JLabel(text);
            act.setToolTipText("second rule: " + text);
            colHead.add(act);
            ++i;
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(rules.size(), rules.size()));
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(this);
        this.miClear = new JMenuItem("Clear");
        this.miClear.addActionListener(this);
        this.miVisibleRel = this.menu.add(new JMenuItem(this.hideRelation));
        this.miVisibleRel.addActionListener(this);
        this.miVisibleRule = new JMenuItem(this.hideRule);
        this.miVisibleRule.addActionListener(this);
        this.menu.add(this.miVisibleRule);
        for (i = 0; i < rules.size(); ++i) {
            for (int ii = 0; ii < rules.size(); ++ii) {
                JButton act = new JButton("?");
                act.setToolTipText("[" + ((Rule)rules.elementAt(i)).getName() + ", " + ((Rule)rules.elementAt(ii)).getName() + "]");
                act.setMinimumSize(new Dimension(act.getHeight(), act.getHeight()));
                act.addActionListener(this);
                act.setComponentPopupMenu(this.menu);
                this.addButton((Rule)rules.elementAt(i), (Rule)rules.elementAt(ii), act);
                mainPanel.add(act);
                this.refreshView((Rule)rules.elementAt(i), (Rule)rules.elementAt(ii), act, -1);
            }
        }
        Dimension dim = mainPanel.getPreferredSize();
        Dimension dim2 = new Dimension();
        dim2.setSize(dim.getWidth(), colHead.getPreferredSize().getHeight());
        colHead.setMinimumSize(dim2);
        colHead.setPreferredSize(dim2);
        this.tableW = (int)dim2.getWidth();
        dim2 = new Dimension();
        dim2.setSize(rowHead.getPreferredSize().getWidth(), dim.getHeight());
        rowHead.setPreferredSize(dim2);
        rowHead.setMinimumSize(dim2);
        this.tableH = (int)dim2.getHeight();
        mainPanel.setPreferredSize(dim);
        mainPanel.setMinimumSize(dim);
        this.main.setRowHeaderView(rowHead);
        this.main.setColumnHeaderView(colHead);
        this.main.setViewportView(mainPanel);
        this.main.setCorner("UPPER_LEFT_CORNER", new JLabel("first \\ second"));
        this.add((Component)this.main, "Center");
        MouseInputAdapter ml = new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
            }
        };
        this.addMouseListener(ml);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JButton b = (JButton)((JPopupMenu)e.getSource()).getInvoker();
        this.first = (Rule)this.firstRules.get(b);
        this.second = (Rule)this.secondRules.get(b);
        ExcludePairContainer.Entry entry = this.container.getEntry(this.first, this.second);
        ExcludePairContainer.Entry entry1 = this.container.getEntry(this.first, this.first);
        ExcludePairContainer.Entry entry2 = this.container.getEntry(this.second, this.second);
        if (entry.getState() == 5) {
            this.menu.removeAll();
            this.menu.add(new JMenuItem(this.first.getName() + " - disabled"));
            this.menu.getComponent(0).setEnabled(false);
            return;
        }
        if (entry.getState() == 4) {
            this.menu.removeAll();
            this.menu.add(new JMenuItem(this.first.getName() + " - not related"));
            this.menu.getComponent(0).setEnabled(false);
            return;
        }
        if (this.menu.getComponents().length == 1) {
            this.menu.removeAll();
            this.menu.add(this.miClear);
            this.menu.add(this.miVisibleRel);
            this.menu.add(this.miVisibleRule);
        }
        if (entry.getState() != 3) {
            this.miClear.setEnabled(false);
            this.miVisibleRel.setEnabled(false);
            this.miVisibleRule.setEnabled(false);
        } else {
            this.miClear.setEnabled(true);
            this.miVisibleRel.setEnabled(true);
            this.miVisibleRule.setEnabled(true);
        }
        if (entry.isRelationVisible()) {
            this.miVisibleRel.setText(this.hideRelation);
        } else {
            this.miVisibleRel.setText(this.showRelation);
        }
        if (entry.isRuleVisible()) {
            this.miVisibleRule.setText(this.hideRule);
        } else {
            this.miVisibleRule.setText(this.showRule);
        }
        if (this.first != this.second) {
            this.miVisibleRule.setEnabled(false);
            if (!entry.isCritical()) {
                this.miVisibleRel.setEnabled(false);
            } else if (!entry1.isRuleVisible() || !entry2.isRuleVisible()) {
                this.miVisibleRel.setEnabled(false);
            } else {
                this.miVisibleRel.setEnabled(true);
            }
        } else {
            this.miVisibleRule.setEnabled(true);
            if (!entry.isCritical()) {
                this.miVisibleRel.setEnabled(false);
            } else {
                this.miVisibleRel.setEnabled(true);
            }
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public Container getMainContainer() {
        return this.main;
    }

    public ExcludePairContainer getPairContainer() {
        return this.container;
    }

    public void setPairContainer(ExcludePairContainer container) {
        this.container = container;
        this.refreshView();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public int getKindOfPairContainer() {
        return this.container.getKindOfConflict();
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public int getTableWidth() {
        return this.tableW;
    }

    public int getTableHeight() {
        return this.tableH;
    }

    public synchronized void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (e.getSource() instanceof JMenuItem) {
            if (this.first != null && this.second != null) {
                ExcludePairContainer.Entry entry = this.container.getEntry(this.first, this.second);
                if (entry.getState() == 3) {
                    if (((JMenuItem)e.getSource()).getText().equals("Clear")) {
                        this.container.clearEntry(this.first, this.second);
                        JButton b = (JButton)((Hashtable)this.buttons.get(this.first)).get(this.second);
                        b.setBackground(NOT_SET);
                        b.setText("?");
                        this.fireParserGUIEvent(null);
                    } else if (((JMenuItem)e.getSource()).getText().equals(this.hideRelation)) {
                        if (entry.isCritical()) {
                            this.setRelationVisible(this.first, this.second, false);
                            this.refreshView();
                        }
                    } else if (((JMenuItem)e.getSource()).getText().equals(this.showRelation)) {
                        if (entry.isCritical() && this.container.getEntry(this.first, this.first).isRuleVisible() && this.container.getEntry(this.second, this.second).isRuleVisible()) {
                            this.setRelationVisible(this.first, this.second, true);
                            this.refreshView();
                        }
                    } else if (((JMenuItem)e.getSource()).getText().equals(this.hideRule)) {
                        this.setRuleContextVisible(this.first, this.second, false);
                        this.setRuleVisible(this.first, this.second, false);
                        this.refreshView();
                    } else if (((JMenuItem)e.getSource()).getText().equals(this.showRule)) {
                        this.setRuleContextVisible(this.first, this.second, true);
                        this.setRuleVisible(this.first, this.second, true);
                        this.refreshView();
                    }
                } else if (((JMenuItem)e.getSource()).getText().equals(this.hideRule)) {
                    this.setRuleContextVisible(this.first, this.second, false);
                    this.setRuleVisible(this.first, this.second, false);
                    this.refreshView();
                } else if (((JMenuItem)e.getSource()).getText().equals(this.showRule)) {
                    this.setRuleContextVisible(this.first, this.second, true);
                    this.setRuleVisible(this.first, this.second, true);
                    this.refreshView();
                }
            }
        } else if (e.getSource() instanceof JButton) {
            ExcludePairContainer.Entry entry;
            this.first = (Rule)this.firstRules.get(source);
            this.second = (Rule)this.secondRules.get(source);
            if (this.first != null && this.second != null && (entry = this.container.getEntry(this.first, this.second)).getState() != 5 && entry.getState() != 4) {
                Pair pair = new Pair(this.first, this.second);
                this.fireParserGUIEvent(pair);
            }
        }
    }

    private void setRuleVisible(Rule rule1, Rule rule2, boolean vis) {
        JButton b = (JButton)((Hashtable)this.buttons.get(rule1)).get(rule2);
        if (!vis) {
            b.setForeground(Color.darkGray);
            b.setToolTipText(b.getToolTipText() + ":HIDDEN");
        } else {
            b.setForeground(Color.white);
            b.setToolTipText("[" + rule1.getName() + ", " + rule2.getName() + "]");
        }
        if (this.container.getKindOfConflict() == 0) {
            this.fireParserGUIEvent(new CPAEventData(rule1, rule2, CPAEventData.SHOW_RULE, "C", vis));
        } else {
            this.fireParserGUIEvent(new CPAEventData(rule1, rule2, CPAEventData.SHOW_RULE, "D", vis));
        }
        this.container.setEntryRuleVisible(rule1, rule2, vis, true, false);
    }

    private void setRuleContextVisible(Rule rule1, Rule rule2, boolean vis) {
        Enumeration keys = this.container.getExcludeContainer().keys();
        while (keys.hasMoreElements()) {
            ExcludePairContainer.Entry entry;
            Rule r2;
            Rule r1 = (Rule)keys.nextElement();
            if (r1 != rule1) continue;
            Hashtable secondPart = (Hashtable)this.container.getExcludeContainer().get(r1);
            Enumeration k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = (Rule)k2.nextElement();
                entry = this.container.getEntry(r1, r2);
                this.setRelationVisible(r1, r2, vis);
            }
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = (Rule)k2.nextElement();
                entry = this.container.getEntry(r2, r1);
                this.setRelationVisible(r2, r1, vis);
            }
            break block0;
        }
    }

    private void setRelationVisible(Rule rule1, Rule rule2, boolean vis) {
        JButton b = (JButton)((Hashtable)this.buttons.get(rule1)).get(rule2);
        if (!vis) {
            b.setForeground(Color.darkGray);
            b.setToolTipText(b.getToolTipText() + ":HIDDEN");
        } else {
            b.setForeground(Color.white);
            b.setToolTipText("[" + rule1.getName() + ", " + rule2.getName() + "]");
        }
        if (this.container.getKindOfConflict() == 0) {
            this.fireParserGUIEvent(new CPAEventData(rule1, rule2, CPAEventData.SHOW_RELATION, "C", vis));
        } else {
            this.fireParserGUIEvent(new CPAEventData(rule1, rule2, CPAEventData.SHOW_RELATION, "D", vis));
        }
        this.container.setEntryRelationVisible(rule1, rule2, vis, true);
    }

    public void addParserGUIListener(ParserGUIListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeParserGUIListener(ParserGUIListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireParserGUIEvent(Object data) {
        ParserGUIEvent event = new ParserGUIEvent(this, data);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ParserGUIListener l = (ParserGUIListener)this.listeners.elementAt(i);
            l.occured(event);
        }
    }

    void addButton(Rule r1, Rule r2, JButton button) {
        Hashtable<Rule, JButton> hash1 = (Hashtable<Rule, JButton>)this.buttons.get(r1);
        if (hash1 == null) {
            hash1 = new Hashtable<Rule, JButton>();
            this.buttons.put(r1, hash1);
        }
        hash1.put(r2, button);
        this.firstRules.put(button, r1);
        this.secondRules.put(button, r2);
    }

    JButton getButton(Rule r1, Rule r2) {
        Hashtable hash1 = (Hashtable)this.buttons.get(r1);
        if (hash1 == null) {
            return null;
        }
        return (JButton)hash1.get(r2);
    }

    public void refreshView() {
        Enumeration en1 = this.buttons.keys();
        while (en1.hasMoreElements()) {
            Rule r1 = (Rule)en1.nextElement();
            Enumeration en2 = ((Hashtable)this.buttons.get(r1)).keys();
            while (en2.hasMoreElements()) {
                Rule r2 = (Rule)en2.nextElement();
                this.refreshView(r1, r2, -1);
            }
        }
    }

    void refreshView(Rule r1, Rule r2, int key) {
        this.refreshView(r1, r2, this.getButton(r1, r2), key);
    }

    void refreshView(Rule r1, Rule r2, JButton button, int key) {
        if (button == null) {
            return;
        }
        ExcludePairContainer.Entry entry = this.container.getEntry(r1, r2);
        ExcludePairContainer.Entry entry1 = this.container.getEntry(r1, r1);
        ExcludePairContainer.Entry entry2 = this.container.getEntry(r2, r2);
        if (entry.getState() == 0) {
            button.setBackground(NOT_SET);
            button.setText("?");
            button.setForeground(Color.black);
        } else if (entry.getState() == 1) {
            button.setBackground(NOT_SET);
            button.setText("?");
        } else if (entry.getState() == 2) {
            button.setBackground(COMPUTING);
            button.setText("C");
        } else if (entry.getState() == 3) {
            if (entry.isCritical()) {
                if (this.container.getKindOfConflict() == 1) {
                    button.setBackground(DEPEND);
                } else if (this.container.getKindOfConflict() == 0) {
                    button.setBackground(CRITIC);
                }
                if (entry.getOverlapping() != null) {
                    button.setText("" + entry.getOverlapping().size());
                } else {
                    button.setText("!");
                }
                if (!entry.isRuleVisible() || !entry.isRelationVisible()) {
                    button.setForeground(Color.white);
                    if (button.getToolTipText().indexOf("HIDDEN") == -1) {
                        button.setToolTipText(button.getToolTipText() + ":HIDDEN");
                    }
                } else if (!entry1.isRuleVisible() || !entry2.isRuleVisible()) {
                    button.setForeground(Color.white);
                    if (button.getToolTipText().indexOf("HIDDEN") == -1) {
                        button.setToolTipText(button.getToolTipText() + ":HIDDEN");
                    }
                } else {
                    button.setForeground(Color.black);
                    button.setToolTipText("[" + r1.getName() + ", " + r2.getName() + "]");
                }
                if (key == 0) {
                    button.setEnabled(false);
                } else if (entry.getState() != 5) {
                    button.setEnabled(true);
                }
            } else {
                button.setBackground(NOT_CRITIC);
                button.setText("0");
                if (!entry.isRuleVisible() || !entry.isRelationVisible()) {
                    button.setForeground(Color.white);
                    if (button.getToolTipText().indexOf("HIDDEN") == -1) {
                        button.setToolTipText(button.getToolTipText() + ":HIDDEN");
                    }
                } else if (!entry1.isRuleVisible() || !entry2.isRuleVisible()) {
                    button.setForeground(Color.white);
                    if (button.getToolTipText().indexOf("HIDDEN") == -1) {
                        button.setToolTipText(button.getToolTipText() + ":HIDDEN");
                    }
                } else {
                    button.setForeground(Color.black);
                    button.setToolTipText("[" + r1.getName() + ", " + r2.getName() + "]");
                }
            }
            if (key == 2) {
                button.setEnabled(false);
            } else if (entry.getState() != 5) {
                button.setEnabled(true);
            }
        } else if (entry.getState() == 5) {
            if (!r1.isEnabled() || !r2.isEnabled()) {
                String s = r1.getName() + ": DISABLED";
                if (!r1.isEnabled() && !r2.isEnabled()) {
                    s = "DISABLED";
                } else if (!r2.isEnabled()) {
                    s = r2.getName() + ": DISABLED";
                }
                button.setBackground(DISABLED);
                button.setText("");
                button.setToolTipText(s);
            } else {
                entry.setState(0);
                this.container.clearEntry(r1, r2);
                button.setBackground(NOT_SET);
                button.setText("?");
                button.setForeground(Color.black);
            }
        } else if (entry.getState() == 4) {
            button.setBackground(NOT_RELATED);
            button.setText("");
        }
    }

    public void parserEventOccured(ParserEvent p) {
        if (p instanceof CriticalPairEvent) {
            if (((CriticalPairEvent)p).getFirstRule() == null || ((CriticalPairEvent)p).getSecondRule() == null) {
                return;
            }
            Rule r1 = ((CriticalPairEvent)p).getFirstRule();
            Rule r2 = ((CriticalPairEvent)p).getSecondRule();
            this.refreshView(r1, r2, ((CriticalPairEvent)p).getKey());
        }
    }
}

