/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdMorphism;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.gui.GraphEditor;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.xt_basis.Graph;
import com.objectspace.jgl.HashMap;
import java.awt.Component;
import javax.swing.JSplitPane;

public class GraphBrowser
implements ParserGUIListener {
    JSplitPane graphPane;
    GraphEditor geLeft;
    GraphEditor geRight;
    EdGraGra layout;
    private boolean attrsVisible = true;

    public GraphBrowser(EdGraGra layout) {
        this.setLayout(layout);
        this.geLeft = new GraphEditor();
        this.geLeft.setEditMode(13);
        this.geLeft.setGraph(null);
        this.geRight = new GraphEditor();
        this.geRight.setEditMode(13);
        this.geRight.setGraph(null);
        this.graphPane = new JSplitPane(1, this.geLeft, this.geRight);
        this.graphPane.setOneTouchExpandable(true);
        this.graphPane.setContinuousLayout(true);
        this.graphPane.setDividerLocation(250);
    }

    public void setLayout(EdGraGra layout) {
        this.layout = layout;
    }

    public Component getComponent() {
        return this.getGraphPane();
    }

    public Component getLeftComponent() {
        return this.geLeft.getGraphPanel().getCanvas();
    }

    public Component getRightComponent() {
        return this.geRight.getGraphPanel().getCanvas();
    }

    public JSplitPane getGraphPane() {
        return this.graphPane;
    }

    public void setLeftGraph(Graph left) {
        if (left == null) {
            this.geLeft.setGraph(null);
            this.geLeft.updateGraphics();
        } else if (this.layout != null) {
            EdGraph eg = new EdGraph(left, this.layout.getTypeSet(), this.attrsVisible);
            this.copyLayout(this.layout, eg);
            eg.updateGraph(this.attrsVisible);
            this.geLeft.setGraph(eg);
            this.geLeft.setTitle(left.getName());
        }
    }

    public void setLeftGraph(Graph left, String title) {
        this.setLeftGraph(left);
        if (this.layout != null) {
            this.geLeft.setTitle(title);
        }
    }

    public void setRightGraph(Graph right) {
        if (right == null) {
            this.geRight.setGraph(null);
            this.geRight.updateGraphics();
        } else if (this.layout != null) {
            EdGraph eg = new EdGraph(right, this.layout.getTypeSet(), this.attrsVisible);
            eg.updateGraph(this.attrsVisible);
            this.copyLayout(this.layout, eg);
            this.geRight.setGraph(eg);
            this.geRight.setTitle(right.getName());
        }
    }

    public void setRightGraph(Graph right, String title) {
        this.setRightGraph(right);
        if (this.layout != null) {
            this.geRight.setTitle(title);
        }
    }

    public void occured(ParserGUIEvent pguie) {
        if (pguie.getData() instanceof EdMorphism) {
            EdMorphism numbers = (EdMorphism)pguie.getData();
            HashMap mapL = numbers.getTargetOfMorphism(1);
            GraphEditor linksGege = (GraphEditor)this.getGraphPane().getLeftComponent();
            linksGege.getGraph().setMorphismMarks(mapL, true);
            HashMap mapR = numbers.getTargetOfMorphism(2);
            GraphEditor rechtsGege = (GraphEditor)this.getGraphPane().getRightComponent();
            rechtsGege.getGraph().setMorphismMarks(mapR, true);
            linksGege.updateGraphics();
            rechtsGege.updateGraphics();
        }
    }

    public void refresh() {
        this.geLeft.updateGraphics();
        this.geRight.updateGraphics();
    }

    private void copyLayout(EdGraGra from, EdGraph to) {
        EdRule r = null;
        for (int i = 0; i < from.getRules().size() && !(r = (EdRule)from.getRules().elementAt(i)).getLeft().getBasisGraph().equals(to.getBasisGraph()); ++i) {
        }
        if (r == null) {
            return;
        }
        EdGraph g = r.getLeft();
        block1: for (int k = 0; k < to.getNodes().size(); ++k) {
            EdNode n = (EdNode)to.getNodes().elementAt(k);
            for (int j = 0; j < g.getNodes().size(); ++j) {
                EdNode en = (EdNode)g.getNodes().elementAt(j);
                if (!en.getBasisNode().equals(n.getBasisNode())) continue;
                n.setXY(en.getX(), en.getY());
                continue block1;
            }
        }
    }
}

