/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdMorphism;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.editor.impl.GraphCanvas;
import agg.editor.impl.GraphPanel;
import agg.gui.GraphEditor;
import agg.gui.GraphicsExportJPEG;
import agg.gui.IconResource;
import agg.gui.RuleEditor;
import agg.gui.icons.ColorDashLineIcon;
import agg.gui.icons.ColorDotLineIcon;
import agg.gui.icons.ColorSolidLineIcon;
import agg.gui.parser.CriticalPairPanel;
import agg.gui.parser.ParserGUIOption;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.parser.PairContainer;
import agg.parser.Report;
import agg.xt_basis.Graph;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import com.objectspace.jgl.HashMap;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class GraphDesktop
implements InternalFrameListener {
    JDesktopPane desktop;
    JScrollPane jsp;
    ImageIcon internalFrameIcon;
    int nextX;
    int nextY;
    EdGraGra layout;
    Hashtable overlappings;
    Hashtable internalLayoutGraphs;
    Hashtable internalGraphFrames;
    Dimension internalFrameSize;
    ParserGUIOption option;
    Vector listener;
    JInternalFrame cpaGraphFrame;
    JInternalFrame conflictFrame;
    JInternalFrame dependFrame;
    JInternalFrame activeGraphFrame;
    MouseListener ml;
    JPopupMenu cpaGraphMenu;
    JPopupMenu graphMenu;
    JMenu miShapeC;
    JMenu miShapeD;
    JMenuItem miC;
    JMenuItem miD;
    JMenuItem miAll;
    JMenuItem miStraightEdges;
    JMenuItem miHide;
    CriticalPairPanel conflictPanel;
    CriticalPairPanel dependPanel;
    int myW;
    int myH;
    RuleEditor ruleEdit1;
    RuleEditor ruleEdit2;
    JInternalFrame ruleFrame1;
    JInternalFrame ruleFrame2;
    EdRule layoutRule1;
    EdRule layoutRule2;
    GraphPanel activeGraphPanel;
    GraphicsExportJPEG exportJPEG;

    public GraphDesktop(EdGraGra layout, ParserGUIOption option) {
        this.setLayout(layout);
        this.listener = new Vector();
        this.overlappings = new Hashtable();
        this.internalGraphFrames = new Hashtable();
        this.internalLayoutGraphs = new Hashtable();
        this.desktop = new JDesktopPane();
        this.myW = 500;
        this.myH = 500;
        this.desktop.setPreferredSize(new Dimension(this.myW, this.myH));
        this.jsp = new JScrollPane(22, 32);
        this.jsp.setViewportView(this.desktop);
        this.jsp.setBackground(Color.white);
        this.jsp.getHorizontalScrollBar().getModel().setValueIsAdjusting(true);
        this.jsp.getVerticalScrollBar().getModel().setValueIsAdjusting(true);
        this.internalFrameIcon = IconResource.getIconFromURL(IconResource.getURLOverlapGraph());
        this.internalFrameSize = new Dimension(200, 200);
        this.option = option;
        this.nextX = 5;
        this.nextY = 5;
        this.ruleEdit1 = new RuleEditor(null);
        this.ruleEdit1.setRuleDividerLocation(150);
        this.ruleEdit2 = new RuleEditor(null);
        this.ruleEdit2.setRuleDividerLocation(150);
        this.makeGraphMenu();
        this.makeCPAGraphMenu();
        this.ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && e.getSource() instanceof JPanel) {
                    if (e.getSource() instanceof GraphCanvas) {
                        GraphDesktop.this.activeGraphPanel = ((GraphCanvas)e.getSource()).getViewport();
                    }
                    if (GraphDesktop.this.activeGraphFrame == GraphDesktop.this.cpaGraphFrame) {
                        GraphDesktop.this.cpaGraphMenu.show(GraphDesktop.this.cpaGraphFrame, e.getX(), e.getY());
                        Object object = GraphDesktop.this.setPickedGraphObjectOfCPAgraph(e.getX(), e.getY());
                    } else {
                        GraphDesktop.this.graphMenu.show(GraphDesktop.this.activeGraphFrame, e.getX(), e.getY());
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && e.getSource() instanceof JPanel) {
                    if (e.getSource() instanceof GraphCanvas) {
                        GraphDesktop.this.activeGraphPanel = ((GraphCanvas)e.getSource()).getViewport();
                    }
                    if (GraphDesktop.this.activeGraphFrame == GraphDesktop.this.cpaGraphFrame) {
                        GraphDesktop.this.cpaGraphMenu.show(GraphDesktop.this.cpaGraphFrame, e.getX(), e.getY());
                        Object object = GraphDesktop.this.setPickedGraphObjectOfCPAgraph(e.getX(), e.getY());
                    } else {
                        GraphDesktop.this.graphMenu.show(GraphDesktop.this.activeGraphFrame, e.getX(), e.getY());
                    }
                }
            }
        };
    }

    private Object setPickedGraphObjectOfCPAgraph(int x, int y) {
        Component c = this.cpaGraphFrame.getContentPane().getComponent(0);
        if (c instanceof GraphEditor) {
            return ((GraphEditor)c).getGraph().select(x, y);
        }
        return null;
    }

    public void setLayout(EdGraGra layout) {
        this.layout = layout;
        this.nextX = 5;
        this.nextY = 5;
    }

    public void setGUIOption(ParserGUIOption option) {
        this.option = option;
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
        this.ruleEdit1.setExportJPEG(this.exportJPEG);
        this.ruleEdit2.setExportJPEG(this.exportJPEG);
    }

    public JInternalFrame addCriticalPairTable(CriticalPairPanel cppanel, String tableName) {
        boolean newFrame = false;
        String name = "Critical Pairs";
        if (!tableName.equals("")) {
            name = tableName;
        }
        JInternalFrame cpIFrame = null;
        if (cppanel.getPairContainer().getKindOfConflict() == 0) {
            if (this.conflictFrame == null) {
                this.conflictFrame = cpIFrame = new JInternalFrame(name, true, true, true, true);
                this.setMenuBarOfConflictTableFrame();
                this.conflictPanel = cppanel;
                newFrame = true;
                this.nextX = 50;
                this.nextY = this.dependFrame == null ? 50 : 100;
            } else {
                cpIFrame = this.conflictFrame;
            }
        } else if (cppanel.getPairContainer().getKindOfConflict() == 1) {
            if (this.dependFrame == null) {
                this.dependFrame = cpIFrame = new JInternalFrame(name, true, true, true, true);
                this.setMenuBarOfDependencyTableFrame();
                this.dependPanel = cppanel;
                newFrame = true;
                this.nextX = 50;
                this.nextY = this.conflictFrame == null ? 50 : 100;
            } else {
                cpIFrame = this.dependFrame;
            }
        }
        if (newFrame) {
            cpIFrame.addInternalFrameListener(this);
            int fw = cppanel.getTableWidth() + 110;
            int fh = cppanel.getTableHeight() + 80;
            if (fw > 600) {
                fw = 600;
            }
            if (fh > 400) {
                fh = 400;
            }
            cpIFrame.setSize(new Dimension(fw, fh));
            cpIFrame.setFrameIcon(this.internalFrameIcon);
            cpIFrame.getContentPane().add(cppanel);
            cpIFrame.setLocation(this.nextX, this.nextY);
            this.getDesktop().add(cpIFrame);
            cpIFrame.setVisible(true);
            try {
                cpIFrame.setIcon(false);
                cpIFrame.setSelected(true);
            }
            catch (PropertyVetoException pve) {}
        } else if (!cpIFrame.isVisible()) {
            this.getDesktop().add(cpIFrame);
            cpIFrame.setVisible(true);
            try {
                cpIFrame.setIcon(false);
                cpIFrame.setSelected(true);
            }
            catch (PropertyVetoException pve) {}
        } else {
            try {
                if (cpIFrame.isIcon()) {
                    cpIFrame.setIcon(false);
                }
                cpIFrame.setSelected(true);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
        return cpIFrame;
    }

    public JInternalFrame addGraph(Graph g) {
        if (this.option == null) {
            return null;
        }
        if (this.option.getNumberOfCriticalPair() <= this.desktop.getComponentCount()) {
            return null;
        }
        boolean newFrame = true;
        GraphEditor gege = null;
        JInternalFrame newGraph = new JInternalFrame(g.getName(), true, false, true, true);
        this.internalGraphFrames.put(g, newGraph);
        newGraph.addInternalFrameListener(this);
        newGraph.setSize(this.internalFrameSize);
        newGraph.setFrameIcon(this.internalFrameIcon);
        EdGraph eg = new EdGraph(g, true);
        this.internalLayoutGraphs.put(g, eg);
        eg.setTypeSet(this.layout.getTypeSet());
        eg.setRealWidthOfGraphPanel(this.internalFrameSize.width);
        eg.doDefaultGraphLayout(true);
        gege = new GraphEditor();
        gege.setExportJPEG(this.exportJPEG);
        gege.getGraphPanel().getCanvas().addMouseListener(this.ml);
        gege.setGraph(eg);
        gege.setEditMode(13);
        gege.setTitle("    ");
        newGraph.getContentPane().add(gege);
        newGraph.setVisible(false);
        this.getDesktop().add(newGraph);
        try {
            newGraph.setIcon(true);
            newGraph.setSelected(false);
            newGraph.setVisible(true);
            newGraph.getDesktopIcon().setLocation(this.nextX, this.nextY);
            if (this.nextX + newGraph.getDesktopIcon().getSize().width >= this.desktop.getSize().width) {
                int w = this.nextX + newGraph.getDesktopIcon().getSize().width;
                int h = this.desktop.getSize().height;
                this.nextX = 5;
                this.nextY += newGraph.getDesktopIcon().getSize().height;
                if (this.nextY + newGraph.getDesktopIcon().getSize().height >= h) {
                    h = this.nextY + newGraph.getDesktopIcon().getSize().height;
                    this.desktop.setPreferredSize(new Dimension(this.myW, h));
                }
            }
            this.nextX += newGraph.getDesktopIcon().getSize().width;
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
        return newGraph;
    }

    public JInternalFrame addGraph(EdGraph eg, int w1, int h1) {
        if (this.option == null) {
            return null;
        }
        if (this.option.getNumberOfCriticalPair() <= this.desktop.getComponentCount()) {
            return null;
        }
        boolean newFrame = true;
        GraphEditor gege = null;
        JInternalFrame newGraph = (JInternalFrame)this.internalGraphFrames.get(eg.getBasisGraph());
        if (newGraph == null) {
            newGraph = new JInternalFrame(eg.getBasisGraph().getName(), true, true, true, true);
            this.internalGraphFrames.put(eg.getBasisGraph(), newGraph);
            this.internalLayoutGraphs.put(eg.getBasisGraph(), eg);
            newGraph.addInternalFrameListener(this);
            newGraph.setSize(new Dimension(w1, h1));
            newGraph.setFrameIcon(this.internalFrameIcon);
            eg.setRealWidthOfGraphPanel(w1);
            if (!eg.isCPAgraph()) {
                eg.doDefaultGraphLayout(true);
            }
            gege = new GraphEditor();
            gege.setExportJPEG(this.exportJPEG);
            newGraph.getContentPane().add(gege);
            if (eg.isCPAgraph()) {
                if (!eg.getBasisGraph().isEmpty()) {
                    int fw = eg.getGraphDimension().width;
                    int fh = eg.getGraphDimension().height;
                    if (fw > 600) {
                        fw = 600;
                    } else if (fw < 400) {
                        fw = 400;
                    }
                    if (fh > 400) {
                        fh = 400;
                    } else if (fh < 300) {
                        fh = 300;
                    }
                    eg.setRealWidthOfGraphPanel(fw);
                    newGraph.setSize(new Dimension(fw, fh));
                } else {
                    newGraph.setSize(new Dimension(300, 200));
                }
                try {
                    newGraph.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
                if (this.cpaGraphFrame == null) {
                    this.cpaGraphFrame = newGraph;
                    gege.getGraphPanel().getCanvas().addMouseListener(this.ml);
                }
            } else {
                gege.getGraphPanel().getCanvas().addMouseListener(this.ml);
            }
        } else {
            newFrame = false;
            if (eg.isCPAgraph()) {
                Component c = newGraph.getContentPane().getComponent(0);
                if (c instanceof GraphEditor) {
                    gege = (GraphEditor)c;
                    gege.setExportJPEG(this.exportJPEG);
                }
                if (!eg.getBasisGraph().isEmpty()) {
                    int fw = eg.getGraphDimension().width;
                    int fh = eg.getGraphDimension().height;
                    if (fw > 600) {
                        fw = 600;
                    } else if (fw < 400) {
                        fw = 400;
                    }
                    if (fh > 400) {
                        fh = 400;
                    } else if (fh < 300) {
                        fh = 300;
                    }
                    eg.setRealWidthOfGraphPanel(fw);
                    newGraph.setSize(new Dimension(fw, fh));
                } else {
                    newGraph.setSize(new Dimension(300, 200));
                }
                try {
                    newGraph.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        }
        gege.setGraph(eg);
        gege.setEditMode(13);
        gege.setTitle("    ");
        newGraph.setVisible(false);
        this.getDesktop().add(newGraph);
        try {
            newGraph.setIcon(true);
            newGraph.setSelected(false);
            newGraph.setVisible(true);
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
        if (newFrame) {
            newGraph.getDesktopIcon().setLocation(this.nextX, this.nextY);
            this.nextX += newGraph.getDesktopIcon().getSize().width;
            if (this.nextX + newGraph.getDesktopIcon().getSize().width >= this.desktop.getSize().width) {
                int w = this.nextX + newGraph.getDesktopIcon().getSize().width;
                int h = this.desktop.getSize().height;
                this.nextX = 5;
                this.nextY += newGraph.getDesktopIcon().getSize().height;
                if (this.nextY + newGraph.getDesktopIcon().getSize().height >= h) {
                    h = this.nextY + newGraph.getDesktopIcon().getSize().height;
                    this.desktop.setPreferredSize(new Dimension(this.myW, h));
                }
            }
            this.nextX += newGraph.getDesktopIcon().getSize().width;
        }
        return newGraph;
    }

    public JInternalFrame addRule1(Rule rule, int w1, int h1) {
        if (this.option == null) {
            return null;
        }
        if (this.option.getNumberOfCriticalPair() <= this.desktop.getComponentCount()) {
            return null;
        }
        if (this.layout != null) {
            this.layoutRule1 = this.layout.getRule(rule);
            if (this.layoutRule1 == null) {
                this.layoutRule1 = new EdRule(rule);
            }
        } else {
            this.layoutRule1 = new EdRule(rule);
        }
        boolean newFrame = true;
        if (this.ruleFrame1 == null) {
            this.ruleFrame1 = new JInternalFrame("", true, true, true, true);
            this.ruleFrame1.addInternalFrameListener(this);
            this.ruleFrame1.setSize(new Dimension(w1, h1));
            this.ruleFrame1.setFrameIcon(this.internalFrameIcon);
            this.ruleFrame1.getContentPane().add(this.ruleEdit1);
            this.getDesktop().add(this.ruleFrame1);
        }
        this.ruleFrame1.setTitle("     Rule 1 ");
        this.ruleEdit1.setRule(this.layoutRule1);
        this.ruleEdit1.setNAC(null);
        this.ruleEdit1.setEditMode(13);
        this.ruleEdit1.setRuleTitle(rule.getName(), "");
        this.ruleFrame1.setVisible(false);
        try {
            this.ruleFrame1.setIcon(true);
            this.ruleFrame1.setSelected(false);
            this.ruleFrame1.setVisible(true);
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
        this.nextX = this.ruleFrame1.getDesktopIcon().getSize().width;
        this.nextY = 5;
        this.ruleFrame1.getDesktopIcon().setLocation(this.nextX, this.nextY);
        return this.ruleFrame1;
    }

    public JInternalFrame addRule2(Rule rule, int w1, int h1) {
        if (this.option == null) {
            return null;
        }
        if (this.option.getNumberOfCriticalPair() <= this.desktop.getComponentCount()) {
            return null;
        }
        boolean newFrame = true;
        if (this.layout != null) {
            this.layoutRule2 = this.layout.getRule(rule);
            if (this.layoutRule2 == null) {
                this.layoutRule2 = new EdRule(rule);
            } else if (this.layoutRule2 == this.layoutRule1) {
                this.layoutRule2 = new EdRule(rule);
                this.setRuleLayout(this.layoutRule2, this.layoutRule1);
            }
        } else {
            this.layoutRule2 = new EdRule(rule);
        }
        if (this.ruleFrame2 == null) {
            this.ruleFrame2 = new JInternalFrame("", true, true, true, true);
            this.ruleFrame2.addInternalFrameListener(this);
            this.ruleFrame2.setSize(new Dimension(w1, h1));
            this.ruleFrame2.setFrameIcon(this.internalFrameIcon);
            this.ruleFrame2.getContentPane().add(this.ruleEdit2);
            this.getDesktop().add(this.ruleFrame2);
        }
        this.ruleFrame2.setTitle("     Rule 2 ");
        this.ruleEdit2.setRule(this.layoutRule2);
        this.ruleEdit2.setNAC(null);
        this.ruleEdit2.setEditMode(13);
        this.ruleEdit2.setRuleTitle(rule.getName(), "");
        this.ruleFrame2.setVisible(false);
        try {
            this.ruleFrame2.setIcon(true);
            this.ruleFrame2.setSelected(false);
            this.ruleFrame2.setVisible(true);
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
        this.nextX = this.ruleFrame1.getDesktopIcon().getSize().width * 2;
        this.nextY = 5;
        this.ruleFrame2.getDesktopIcon().setLocation(this.nextX, this.nextY);
        return this.ruleFrame2;
    }

    private void setRuleLayout(EdRule to, EdRule from) {
        to.getLeft().setLayoutForSameBasisGraph(from.getLeft());
        to.getRight().setLayoutForSameBasisGraph(from.getRight());
        Vector nacsTo = to.getNACs();
        Vector nacsFrom = from.getNACs();
        block0: for (int i = 0; i < nacsTo.size(); ++i) {
            EdGraph nacGto = (EdGraph)nacsTo.get(i);
            for (int j = 0; j < nacsFrom.size(); ++j) {
                EdGraph nacGfrom = (EdGraph)nacsFrom.get(j);
                if (nacGto.getBasisGraph() != nacGfrom.getBasisGraph()) continue;
                nacGto.setLayoutForSameBasisGraph(nacGfrom);
                continue block0;
            }
        }
    }

    public void setIconOfRules(boolean b) {
        if (this.ruleFrame1 != null && !this.ruleFrame1.isIcon()) {
            try {
                this.ruleFrame1.setIcon(true);
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
        if (this.ruleFrame2 != null && !this.ruleFrame2.isIcon()) {
            try {
                this.ruleFrame2.setIcon(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private EdNAC resetNAC(RuleEditor edit, EdRule rule, String nacName) {
        if (rule.getNACs().isEmpty()) {
            edit.setNAC(null);
        }
        EdNAC nacGraph = null;
        for (int i = 0; i < rule.getNACs().size(); ++i) {
            nacGraph = (EdNAC)rule.getNACs().get(i);
            if (nacName == null || !nacName.equals(nacGraph.getName())) continue;
            edit.setNAC(nacGraph);
            edit.setNACTitle("NAC: " + nacGraph.getName());
            edit.getNACPanel().setBackground(new Color(255, 255, 165));
            edit.getLeftPanel().setBackground(new Color(255, 255, 165));
            return nacGraph;
        }
        return nacGraph;
    }

    public JInternalFrame getInternalGraphFrame(Graph g) {
        return (JInternalFrame)this.internalGraphFrames.get(g);
    }

    public EdGraph getInternalLayoutGraph(Graph g) {
        return (EdGraph)this.internalLayoutGraphs.get(g);
    }

    public JButton addNextButton(Graph g, String text) {
        JInternalFrame f = (JInternalFrame)this.internalGraphFrames.get(g);
        JButton next = new JButton(text);
        f.getContentPane().add((Component)next, "South");
        return next;
    }

    public void notCriticFrame(Rule left, Rule right) {
        this.resetNAC(this.ruleEdit1, this.layoutRule1, null);
        this.ruleEdit1.setDividerLocation(0, 0);
        this.resetNAC(this.ruleEdit2, this.layoutRule2, null);
        this.ruleEdit2.setDividerLocation(0, 0);
        Report.trace("starte notCriticFrame", 1);
        JInternalFrame newGraph = new JInternalFrame("not critic", false, false, false, false);
        newGraph.setVisible(true);
        newGraph.setSize(200, 100);
        newGraph.setFrameIcon(this.internalFrameIcon);
        newGraph.getContentPane().setLayout(new BorderLayout());
        ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/ok2.gif"));
        Image image = icon.getImage();
        Image scaledImage = image.getScaledInstance(50, 50, 4);
        ImageIcon scaledIcon = new ImageIcon(scaledImage);
        JLabel l = new JLabel(scaledIcon);
        newGraph.getContentPane().add((Component)l, "West");
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new GridBagLayout());
        JLabel message1 = new JLabel("Rule " + left.getName());
        JLabel message2 = new JLabel("doesn't exclude");
        JLabel message3 = new JLabel("rule " + right.getName() + ".");
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        messagePanel.add((Component)message1, c);
        messagePanel.add((Component)message2, c);
        messagePanel.add((Component)message3, c);
        newGraph.getContentPane().add((Component)messagePanel, "Center");
        Report.println("DesktopSize " + this.getDesktop().getSize(), Report.TRACE);
        int posX = (int)this.getDesktop().getSize().getWidth();
        int posY = (int)this.getDesktop().getSize().getHeight();
        int width = (int)newGraph.getSize().getWidth();
        int height = (int)newGraph.getSize().getHeight();
        newGraph.setLocation((posX /= 2) - (width /= 2), (posY /= 2) - (height /= 2));
        this.desktop.add(newGraph);
        Report.trace("beende notCriticFrame", -1);
    }

    public void setOverlappingGraphWindowSize(Dimension size) {
        this.internalFrameSize = size;
        JInternalFrame[] allFrames = this.getDesktop().getAllFrames();
        if (allFrames != null) {
            for (int i = 0; i < allFrames.length; ++i) {
                allFrames[i].setSize(this.internalFrameSize);
            }
        }
    }

    public void addOverlapping(Graph graph, Pair pair) {
        this.overlappings.put(graph, pair);
    }

    public CriticalPairPanel getActivePairPanel() {
        JInternalFrame[] allFrames = this.getDesktop().getAllFrames();
        if (allFrames != null) {
            for (int i = 0; i < allFrames.length; ++i) {
                JInternalFrame f = allFrames[i];
                Component c = f.getContentPane().getComponent(0);
                if (c instanceof CriticalPairPanel) {
                    if (!((CriticalPairPanel)c).isActive()) continue;
                    return (CriticalPairPanel)c;
                }
                return null;
            }
        }
        return null;
    }

    public CriticalPairPanel getConflictPairPanel() {
        return this.conflictPanel;
    }

    public CriticalPairPanel getDependPairPanel() {
        return this.dependPanel;
    }

    public Component getComponent() {
        return this.jsp;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public void setIconOfPairTable(boolean b) {
        for (int i = this.desktop.getAllFrames().length - 1; i >= 0; --i) {
            JInternalFrame f = this.desktop.getAllFrames()[i];
            Component c = f.getContentPane().getComponent(0);
            if (!(c instanceof CriticalPairPanel)) continue;
            try {
                f.setIcon(true);
                continue;
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
    }

    public void setIconOfPairTable(CriticalPairPanel p, boolean b) {
        if (p == null) {
            return;
        }
        for (int i = this.desktop.getAllFrames().length - 1; i >= 0; --i) {
            JInternalFrame f = this.desktop.getAllFrames()[i];
            Component c = f.getContentPane().getComponent(0);
            if (!(c instanceof CriticalPairPanel) || (CriticalPairPanel)c != p) continue;
            try {
                f.setIcon(true);
                continue;
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
    }

    public void setIconOfCPAGraph(boolean b) {
        if (this.cpaGraphFrame == null) {
            return;
        }
        try {
            this.cpaGraphFrame.setIcon(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void removeCPAGraphFrame() {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            for (int i = 0; i < allFrames.length; ++i) {
                GraphEditor gege;
                EdGraph eg;
                JInternalFrame f = allFrames[i];
                Component c = f.getContentPane().getComponent(0);
                if (!(c instanceof GraphEditor) || !(eg = (gege = (GraphEditor)c).getGraph()).isCPAgraph()) continue;
                if (f.isIcon()) {
                    this.desktop.remove(f.getDesktopIcon());
                    continue;
                }
                this.desktop.remove(f);
            }
        }
    }

    public void removeAllFrames() {
        this.overlappings.clear();
        this.getDesktop().removeAll();
        this.nextX = 5;
        this.nextY = 5;
    }

    public void removeAllGraphFrames() {
        this.overlappings = new Hashtable();
        for (int i = this.desktop.getAllFrames().length - 1; i >= 0; --i) {
            JInternalFrame f = this.desktop.getAllFrames()[i];
            Component c = f.getContentPane().getComponent(0);
            if (c instanceof GraphEditor) {
                String gname = ((GraphEditor)c).getGraph().getBasisGraph().getName();
                if (gname.indexOf("Combined") != -1 || gname.indexOf("Conflicts") != -1 || gname.indexOf("Dependencies") != -1) continue;
                if (f.isIcon()) {
                    this.desktop.remove(f.getDesktopIcon());
                    continue;
                }
                this.desktop.remove(f);
                continue;
            }
            if (!(c instanceof JLabel)) continue;
            this.desktop.remove(f);
        }
        this.nextX = 5;
        this.nextY = 5;
        this.nextX += 480;
    }

    public void removePairPanelFrame(CriticalPairPanel p) {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            for (int i = 0; i < allFrames.length; ++i) {
                JInternalFrame f = allFrames[i];
                Component c = f.getContentPane().getComponent(0);
                if (!(c instanceof CriticalPairPanel) || p != (CriticalPairPanel)c) continue;
                this.desktop.remove(i);
                return;
            }
        }
    }

    public void removePairPanelFrame(PairContainer p) {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            for (int i = 0; i < allFrames.length; ++i) {
                JInternalFrame f = allFrames[i];
                Component c = f.getContentPane().getComponent(0);
                if (!(c instanceof CriticalPairPanel) || ((CriticalPairPanel)c).getPairContainer() != p) continue;
                this.desktop.remove(i);
                return;
            }
        }
    }

    public void removeRuleFrame(int indx) {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            for (int i = 0; i < allFrames.length; ++i) {
                JInternalFrame f = allFrames[i];
                if (indx == 1 && f == this.ruleFrame1) {
                    this.desktop.remove(i);
                    this.ruleFrame1 = null;
                    break;
                }
                if (indx != 2 || f != this.ruleFrame2) continue;
                this.desktop.remove(i);
                this.ruleFrame2 = null;
                break;
            }
        }
    }

    public void removeRuleFrames() {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            for (int i = 0; i < allFrames.length; ++i) {
                JInternalFrame f = allFrames[i];
                if (f == this.ruleFrame1) {
                    this.desktop.remove(i);
                    this.ruleFrame1 = null;
                    continue;
                }
                if (f != this.ruleFrame2) continue;
                this.desktop.remove(i);
                this.ruleFrame2 = null;
            }
        }
    }

    public void reinitComponents() {
        if (this.conflictPanel != null) {
            this.removePairPanelFrame(this.conflictPanel);
            this.conflictPanel = null;
            this.conflictFrame = null;
        }
        if (this.dependPanel != null) {
            this.removePairPanelFrame(this.dependPanel);
            this.dependPanel = null;
            this.dependFrame = null;
        }
        if (this.cpaGraphFrame != null) {
            this.removeCPAGraphFrame();
            this.cpaGraphFrame = null;
        }
        this.internalLayoutGraphs.clear();
        this.internalGraphFrames.clear();
        if (this.ruleEdit1 != null) {
            this.removeRuleFrame(1);
        }
        if (this.ruleEdit2 != null) {
            this.removeRuleFrame(2);
        }
        this.removeAllFrames();
    }

    public void refresh() {
        this.removeAllGraphFrames();
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            for (int i = 0; i < allFrames.length; ++i) {
                JInternalFrame f = allFrames[i];
                Component c = f.getContentPane().getComponent(0);
                if (!(c instanceof CriticalPairPanel)) continue;
                ((CriticalPairPanel)c).refreshView();
            }
        }
        if (this.cpaGraphFrame != null) {
            Component c = this.cpaGraphFrame.getContentPane().getComponent(0);
            ((GraphEditor)c).updateGraphics();
        }
        if (this.ruleEdit1 != null) {
            this.ruleEdit1.updateGraphics();
        }
        if (this.ruleEdit2 != null) {
            this.ruleEdit2.updateGraphics();
        }
    }

    public void refreshCPAGraph() {
        Component c = this.cpaGraphFrame.getContentPane().getComponent(0);
        if (c instanceof GraphEditor) {
            ((GraphEditor)c).updateGraphics();
        }
    }

    public boolean hasEmptyComponents() {
        if (this.conflictFrame != null && !((CriticalPairPanel)this.conflictFrame.getContentPane().getComponent(0)).isEmpty()) {
            return false;
        }
        return this.dependFrame == null || ((CriticalPairPanel)this.dependFrame.getContentPane().getComponent(0)).isEmpty();
    }

    public void addParserGUIListener(ParserGUIListener pgl) {
        this.listener.addElement(pgl);
    }

    public void removeParserGUIListener(ParserGUIListener pgl) {
        this.listener.remove(pgl);
    }

    private void fireParserGUIEvent(Object data) {
        ParserGUIEvent event = new ParserGUIEvent(this, data);
        for (int i = 0; i < this.listener.size(); ++i) {
            ParserGUIListener l = (ParserGUIListener)this.listener.elementAt(i);
            l.occured(event);
        }
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        JInternalFrame jif = (JInternalFrame)e.getSource();
        Component c = jif.getContentPane().getComponent(0);
        if (!(c instanceof RuleEditor)) {
            if (c instanceof GraphEditor) {
                int i;
                Component co;
                if (this.activeGraphFrame != null && (co = this.activeGraphFrame.getContentPane().getComponent(0)) instanceof GraphEditor) {
                    GraphEditor gege = (GraphEditor)co;
                    Color bgcolor = Color.WHITE;
                    gege.getGraphPanel().setBackground(bgcolor);
                    this.ruleEdit1.getLeftPanel().setBackground(bgcolor);
                    this.ruleEdit1.getRightPanel().setBackground(bgcolor);
                    this.ruleEdit2.getNACPanel().setBackground(bgcolor);
                    this.ruleEdit2.getLeftPanel().setBackground(bgcolor);
                    this.ruleEdit2.setNAC(null);
                    EdGraph eg = gege.getGraph();
                    eg.clearMarks();
                }
                this.activeGraphFrame = jif;
                GraphEditor gege = (GraphEditor)c;
                EdGraph eg = gege.getGraph();
                Pair morphs = (Pair)this.overlappings.get(eg.getBasisGraph());
                if (morphs == null) {
                    return;
                }
                String nacName = eg.getBasisGraph().info;
                EdNAC nac2 = this.resetNAC(this.ruleEdit2, this.layoutRule2, nacName);
                EdMorphism numbers = new EdMorphism(null);
                OrdinaryMorphism o1 = (OrdinaryMorphism)((Pair)morphs.first).first;
                OrdinaryMorphism o2 = (OrdinaryMorphism)((Pair)morphs.first).second;
                Color bgcolor = new Color(255, 255, 160);
                gege.getGraphPanel().setBackground(bgcolor);
                if (o1.getSource() == this.layoutRule1.getBasisRule().getLeft()) {
                    this.ruleEdit1.getLeftPanel().setBackground(bgcolor);
                } else if (o1.getSource() == this.layoutRule1.getBasisRule().getRight()) {
                    this.ruleEdit1.getRightPanel().setBackground(bgcolor);
                }
                if (nac2 != null) {
                    this.ruleEdit2.getNACPanel().setBackground(bgcolor);
                }
                this.ruleEdit2.getLeftPanel().setBackground(bgcolor);
                Pair morphsN2 = (Pair)morphs.second;
                numbers.makeVDiagram(this.layoutRule1.getBasisRule(), this.layoutRule2.getBasisRule(), o1, o2, morphsN2);
                eg.setMorphismMarks(numbers.getSourceOfMorphism(), true);
                this.setMorphismMarks(this.layoutRule1, null, numbers.getTargetOfMorphism(1));
                this.setMorphismMarks(this.layoutRule2, nac2, numbers.getTargetOfMorphism(2));
                this.fireParserGUIEvent(numbers);
                this.fireParserGUIEvent(eg.getBasisGraph());
                for (i = 0; i < eg.getNodes().size(); ++i) {
                    EdNode n = (EdNode)eg.getNodes().elementAt(i);
                    if (!n.getBasisNode().isCritical()) continue;
                    eg.setCritical(n);
                }
                for (i = 0; i < eg.getArcs().size(); ++i) {
                    EdArc a = (EdArc)eg.getArcs().elementAt(i);
                    if (!a.getBasisArc().isCritical()) continue;
                    eg.setCritical(a);
                }
                gege.updateGraphics();
                JInternalFrame[] allFrames = this.desktop.getAllFrames();
                if (allFrames != null) {
                    for (int i2 = 0; i2 < allFrames.length; ++i2) {
                        JInternalFrame f = allFrames[i2];
                        Component comp = f.getContentPane().getComponent(0);
                        if (!(comp instanceof CriticalPairPanel)) {
                            return;
                        }
                        ((CriticalPairPanel)comp).active = false;
                    }
                }
            } else if (c instanceof CriticalPairPanel) {
                ((CriticalPairPanel)c).active = true;
                this.fireParserGUIEvent(c);
            }
        }
    }

    private void setMorphismMarks(EdRule r, EdNAC nacGraph, HashMap map) {
        r.setMorphismMarks(map, nacGraph);
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        JInternalFrame jif = (JInternalFrame)e.getSource();
        Component c = jif.getContentPane().getComponent(0);
        if (c instanceof GraphEditor) {
            GraphEditor gege = (GraphEditor)c;
            EdGraph eg = gege.getGraph();
            if (eg.isCPAgraph()) {
                if (jif.isIcon()) {
                    this.desktop.remove(jif.getDesktopIcon());
                } else {
                    this.desktop.remove(jif);
                }
            }
        } else if (c instanceof CriticalPairPanel) {
            if (jif.isIcon()) {
                this.desktop.remove(jif.getDesktopIcon());
            } else {
                this.desktop.remove(jif);
            }
        }
        if (c instanceof RuleEditor) {
            RuleEditor re = (RuleEditor)c;
            if (jif.isIcon()) {
                this.desktop.remove(jif.getDesktopIcon());
            } else {
                this.desktop.remove(jif);
            }
            if (re == this.ruleEdit1) {
                this.ruleFrame1 = null;
            } else if (re == this.ruleEdit2) {
                this.ruleFrame2 = null;
            }
        }
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
        JInternalFrame jif = (JInternalFrame)e.getSource();
        Component c = jif.getContentPane().getComponent(0);
        if (c instanceof CriticalPairPanel) {
            if (((CriticalPairPanel)c).getPairContainer().getKindOfConflict() == 0) {
                jif.getDesktopIcon().setLocation(5, 5);
            } else {
                jif.getDesktopIcon().setLocation(5, jif.getDesktopIcon().getSize().height);
            }
        } else if (jif == this.cpaGraphFrame) {
            jif.getDesktopIcon().setLocation(5, jif.getDesktopIcon().getSize().height * 2);
        }
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }

    private void makeCPAGraphMenu() {
        this.cpaGraphMenu = new JPopupMenu("CPA Graph");
        this.miC = this.cpaGraphMenu.add(new JMenuItem("Show Conflicts"));
        this.miD = this.cpaGraphMenu.add(new JMenuItem("Show Dependencies"));
        this.miAll = this.cpaGraphMenu.add(new JMenuItem("Show All"));
        this.cpaGraphMenu.addSeparator();
        this.miHide = this.cpaGraphMenu.add(new JMenuItem("Hide Node/Edge"));
        this.cpaGraphMenu.addSeparator();
        this.miStraightEdges = this.cpaGraphMenu.add(new JMenuItem("Straight Edges"));
        this.cpaGraphMenu.addSeparator();
        this.miShapeC = this.makeCPAEdgeShapeMenu("Conflict Edge Style", "Conflict");
        this.cpaGraphMenu.add(this.miShapeC);
        this.miShapeD = this.makeCPAEdgeShapeMenu("Dependency Edge Style", "Dependency");
        this.cpaGraphMenu.add(this.miShapeD);
        this.cpaGraphMenu.addSeparator();
        JMenuItem miGraphExportJPG = this.cpaGraphMenu.add(new JMenuItem("Export JPEG"));
        miGraphExportJPG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.activeGraphPanel != null && GraphDesktop.this.activeGraphPanel.getGraph() != null && GraphDesktop.this.activeGraphPanel != null) {
                    GraphDesktop.this.exportJPEG.save(GraphDesktop.this.activeGraphPanel.getCanvas());
                }
            }
        });
        this.cpaGraphMenu.pack();
        this.cpaGraphMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    private void makeGraphMenu() {
        this.graphMenu = new JPopupMenu("Graph");
        JMenuItem miGraphExportJPG = this.graphMenu.add(new JMenuItem("Export JPEG"));
        miGraphExportJPG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.activeGraphPanel != null && GraphDesktop.this.activeGraphPanel.getGraph() != null && GraphDesktop.this.activeGraphPanel != null) {
                    GraphDesktop.this.activeGraphPanel.setBackground(Color.white);
                    GraphDesktop.this.exportJPEG.save(GraphDesktop.this.activeGraphPanel.getCanvas());
                    GraphDesktop.this.activeGraphPanel.setBackground(new Color(255, 255, 165));
                }
            }
        });
        this.graphMenu.pack();
        this.graphMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    private JMenu makeCPAEdgeShapeMenu(String title, String kind) {
        JMenu shape = new JMenu(title);
        JMenuItem miSolid = shape.add(new JMenuItem("Solid Line"));
        miSolid.setHorizontalTextPosition(4);
        miSolid.setIcon(new ColorSolidLineIcon(Color.black));
        miSolid.setActionCommand(kind + "Solid");
        JMenuItem miDot = shape.add(new JMenuItem("Dot Line"));
        miDot.setHorizontalTextPosition(4);
        miDot.setIcon(new ColorDotLineIcon(Color.black));
        miDot.setActionCommand(kind + "Dot");
        JMenuItem miDash = shape.add(new JMenuItem("Dash Line"));
        miDash.setHorizontalTextPosition(4);
        miDash.setIcon(new ColorDashLineIcon(Color.black));
        miDash.setActionCommand(kind + "Dash");
        return shape;
    }

    public void addActionListenerToCPAGraphMenu(ActionListener l) {
        int i;
        this.miC.addActionListener(l);
        this.miD.addActionListener(l);
        this.miAll.addActionListener(l);
        this.miStraightEdges.addActionListener(l);
        this.miHide.addActionListener(l);
        for (i = 0; i < this.miShapeC.getItemCount(); ++i) {
            this.miShapeC.getItem(i).addActionListener(l);
        }
        for (i = 0; i < this.miShapeD.getItemCount(); ++i) {
            this.miShapeD.getItem(i).addActionListener(l);
        }
    }

    public void removeActionListenerToCPAGraphMenu(ActionListener l) {
        int i;
        this.miC.removeActionListener(l);
        this.miD.removeActionListener(l);
        this.miAll.removeActionListener(l);
        this.miStraightEdges.removeActionListener(l);
        this.miHide.removeActionListener(l);
        for (i = 0; i < this.miShapeC.getItemCount(); ++i) {
            this.miShapeC.getItem(i).removeActionListener(l);
        }
        for (i = 0; i < this.miShapeD.getItemCount(); ++i) {
            this.miShapeD.getItem(i).removeActionListener(l);
        }
    }

    private void setMenuBarOfConflictTableFrame() {
        final JMenuBar mb = new JMenuBar();
        final JMenu m = new JMenu("Export");
        mb.add(m);
        this.conflictFrame.setJMenuBar(mb);
        m.setVisible(false);
        final JMenuItem mi = m.add(new JMenuItem(" JPEG "));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.exportJPEG != null) {
                    GraphDesktop.this.exportJPEG.save(GraphDesktop.this.conflictFrame);
                }
                m.setVisible(false);
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (e.getSource() == mb || e.getSource() == m) {
                    m.setVisible(true);
                }
            }

            public void mouseExited(MouseEvent e) {
                if (e.getSource() == m && !mi.isShowing()) {
                    m.setVisible(false);
                }
            }
        };
        mb.addMouseListener(ml);
        m.addMouseListener(ml);
    }

    private void setMenuBarOfDependencyTableFrame() {
        final JMenuBar mb = new JMenuBar();
        final JMenu m = new JMenu("Export");
        mb.add(m);
        this.dependFrame.setJMenuBar(mb);
        m.setVisible(false);
        final JMenuItem mi = m.add(new JMenuItem(" JPEG "));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.exportJPEG != null) {
                    GraphDesktop.this.exportJPEG.save(GraphDesktop.this.dependFrame);
                }
                m.setVisible(false);
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (e.getSource() == mb || e.getSource() == m) {
                    m.setVisible(true);
                }
            }

            public void mouseExited(MouseEvent e) {
                if (e.getSource() == m && !mi.isShowing()) {
                    m.setVisible(false);
                }
            }
        };
        mb.addMouseListener(ml);
        m.addMouseListener(ml);
    }
}

