/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.gui.IconResource;
import agg.parser.LayerFunction;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class LayerGUI
extends JDialog
implements ActionListener {
    private JPanel rulePanel;
    private JScrollPane ruleScrollPane;
    private JTable ruleTable;
    private JPanel creationPanel;
    private JScrollPane creationScrollPane;
    private JTable creationTable;
    private JPanel deletionPanel;
    private JScrollPane deletionScrollPane;
    private JTable deletionTable;
    private JButton checkButton;
    private JButton closeButton;
    private JButton cancelButton;
    private boolean isCancelled;
    private JPanel contentPane;
    private JLabel statusLabel;
    private LayerFunction layer;
    private static final Icon OK_ICON = IconResource.getIconFromURL(IconResource.getOkIcon());
    private static final Icon WRONG_ICON = IconResource.getIconFromURL(IconResource.getWrongIcon());

    public LayerGUI(JFrame parent, LayerFunction layer) {
        super((Frame)new JFrame(), true);
        this.setTitle("Rule Layer Editor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LayerGUI.this.exitForm(evt);
            }
        });
        this.setBackground(Color.lightGray);
        if (parent != null) {
            this.setLocationRelativeTo(parent);
            this.setLocation(100, 100);
        } else {
            this.setLocation(300, 100);
        }
        this.layer = layer;
        this.initComponents();
    }

    private void initComponents() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        JPanel rcdPanel = new JPanel(new BorderLayout());
        JPanel rcdPanel0 = new JPanel(new GridLayout(0, 1));
        this.rulePanel = new JPanel();
        this.rulePanel.setBackground(Color.orange);
        this.ruleScrollPane = new JScrollPane();
        this.ruleTable = new JTable();
        this.creationPanel = new JPanel();
        this.creationScrollPane = new JScrollPane();
        this.creationTable = new JTable();
        this.deletionPanel = new JPanel();
        this.deletionScrollPane = new JScrollPane();
        this.deletionTable = new JTable();
        this.checkButton = new JButton();
        this.closeButton = new JButton();
        this.cancelButton = new JButton();
        this.statusLabel = new JLabel();
        this.rulePanel.setLayout(new BorderLayout());
        this.rulePanel.setBorder(new TitledBorder("Rule Layer"));
        this.ruleTable.setModel(new HashTableModel(this.layer, new String[]{"Rule Name", "Layer Number"}));
        int hght = this.getHeight(this.ruleTable.getRowCount(), this.ruleTable.getRowHeight());
        this.ruleTable.doLayout();
        this.ruleScrollPane.setViewportView(this.ruleTable);
        this.ruleScrollPane.setPreferredSize(new Dimension(200, hght));
        this.rulePanel.add(this.ruleScrollPane);
        this.creationPanel.setLayout(new BorderLayout());
        this.creationPanel.setBackground(Color.orange);
        this.creationPanel.setBorder(new TitledBorder("Creation Layer"));
        this.creationTable.setModel(new HashTableModel(this.layer.getCreationLayer(), new String[]{"Type", "Layer Number"}));
        this.creationTable.doLayout();
        this.creationScrollPane.setViewportView(this.creationTable);
        this.creationScrollPane.setPreferredSize(new Dimension(200, 150));
        this.creationPanel.add(this.creationScrollPane);
        this.deletionPanel.setLayout(new BorderLayout());
        this.deletionPanel.setBackground(Color.orange);
        this.deletionPanel.setBorder(new TitledBorder("Deletion Layer"));
        this.deletionTable.setModel(new HashTableModel(this.layer.getDeletionLayer(), new String[]{"Type", "Layer Number"}));
        this.deletionTable.doLayout();
        this.deletionScrollPane.setViewportView(this.deletionTable);
        this.deletionScrollPane.setPreferredSize(new Dimension(200, 150));
        this.deletionPanel.add(this.deletionScrollPane);
        rcdPanel0.add(this.rulePanel);
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setText("Are layers correct?");
        this.statusLabel.setIcon(WRONG_ICON);
        this.statusLabel.setIconTextGap(5);
        try {
            this.statusLabel.setHorizontalTextPosition(2);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        rcdPanel.add(rcdPanel0);
        JPanel buttonPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        this.checkButton.setActionCommand("check");
        this.checkButton.setText("Check");
        this.checkButton.setToolTipText(" Check layer function ");
        this.checkButton.addActionListener(this);
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        buttonPanel.add(this.cancelButton);
        this.contentPane.add((Component)buttonPanel, "South");
        this.contentPane.add(rcdPanel);
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.checkButton || source == this.closeButton) {
            boolean result = true;
            if (result) {
                HashTableModel htm = (HashTableModel)this.ruleTable.getModel();
                for (int i = 0; i < htm.getRowCount(); ++i) {
                    Object r = htm.getRuleAt(i, 0);
                    if (!(r instanceof Rule)) continue;
                    Integer v = (Integer)htm.getValueAt(i, 1);
                    ((Rule)r).setLayer(v);
                }
            } else {
                this.statusLabel.setIcon(WRONG_ICON);
                JOptionPane.showMessageDialog(null, this.layer.getErrorMessage(), "Layer Function", 0);
            }
        }
        if (source == this.closeButton) {
            this.isCancelled = false;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCheckButtonEnabled(boolean val) {
        this.checkButton.setEnabled(val);
        if (!val) {
            this.statusLabel.setIcon(OK_ICON);
        } else {
            this.statusLabel.setIcon(WRONG_ICON);
        }
    }

    public void setCreationTableEnabled(boolean val) {
        this.creationTable.setEnabled(val);
    }

    public void setDeletionTableEnabled(boolean val) {
        this.deletionTable.setEnabled(val);
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 1) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable table;
        LayerFunction ruleLayer;

        public HashTableModel(Hashtable table, String[] columnNames) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.addColumn(columnNames[i]);
            }
            this.table = table;
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = table.get(key);
                Vector<Object> tmpVector = new Vector<Object>();
                tmpVector.addElement(key);
                tmpVector.addElement(value);
                this.addRow(tmpVector);
            }
        }

        public HashTableModel(LayerFunction layer, String[] columnNames) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.addColumn(columnNames[i]);
            }
            this.table = layer.getRuleLayer();
            this.ruleLayer = layer;
            Integer startLayer = layer.getStartLayer();
            Hashtable invertedRuleLayer = layer.invertLayer(layer.getRuleLayer());
            OrderedSet ruleLayerSet = new OrderedSet();
            Enumeration en = invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                ruleLayerSet.add(en.nextElement());
            }
            Integer currentLayer = startLayer;
            boolean nextLayerExists = true;
            while (nextLayerExists && currentLayer != null) {
                HashSet rulesForLayer = (HashSet)invertedRuleLayer.get(currentLayer);
                Enumeration en2 = rulesForLayer.elements();
                while (en2.hasMoreElements()) {
                    Rule rule = (Rule)en2.nextElement();
                    Vector<Object> tmpVector = new Vector<Object>();
                    tmpVector.addElement(rule);
                    tmpVector.addElement(new Integer(rule.getLayer()));
                    this.addRow(tmpVector);
                }
                OrderedSetIterator osi = ruleLayerSet.find(currentLayer);
                if (osi == null || osi.atEnd()) {
                    nextLayerExists = false;
                    continue;
                }
                osi.advance();
                currentLayer = (Integer)osi.get();
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                result = ((Rule)result).getName();
            } else if (result instanceof Type) {
                result = !((Type)result).getStringRepr().equals("") ? ((Type)result).getStringRepr() : ((Type)result).getAdditionalRepr();
            }
            return result;
        }

        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                Integer i = new Integer((String)aValue);
                super.setValueAt(i, row, column);
                this.table.put(key, i);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }

        public Object getRuleAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                return result;
            }
            return null;
        }
    }
}

