/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.gui.ExtensionFileFilter;
import agg.gui.parser.PairFileFilter;
import agg.parser.ConflictsDependenciesContainer;
import agg.parser.PairContainer;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class PairIOGUI {
    private JFrame frame;
    private JFileChooser chooser;
    private PairContainer pc;
    private ConflictsDependenciesContainer pc2;
    private String directory = "";
    private String currentDir = "";
    private String fileName = "";
    private PairFileFilter filter;
    private boolean isSaved;
    private boolean combined = false;

    public PairIOGUI(JFrame parent) {
        this.frame = parent;
        this.pc = null;
        this.pc2 = null;
        this.combined = false;
        this.chooser = new JFileChooser(System.getProperty("user.dir"));
        this.filter = new PairFileFilter();
        this.chooser.addChoosableFileFilter(this.filter);
        this.chooser.setFileFilter(this.filter);
    }

    public PairIOGUI(JFrame parent, PairContainer pairs) {
        this.frame = parent;
        this.pc = pairs;
        this.pc2 = null;
        this.combined = false;
        this.chooser = new JFileChooser(System.getProperty("user.dir"));
        this.filter = new PairFileFilter();
        this.chooser.addChoosableFileFilter(this.filter);
        this.chooser.setFileFilter(this.filter);
    }

    public PairIOGUI(JFrame parent, PairContainer pairs, String dname, String fname) {
        this.frame = parent;
        this.pc = pairs;
        this.pc2 = null;
        this.combined = false;
        this.directory = dname;
        this.fileName = fname;
        this.chooser = !this.directory.equals("") ? new JFileChooser(this.directory) : new JFileChooser(System.getProperty("user.dir"));
        this.filter = new PairFileFilter();
        this.chooser.addChoosableFileFilter(this.filter);
        this.chooser.setFileFilter(this.filter);
    }

    public PairIOGUI(JFrame parent, ConflictsDependenciesContainer pairs) {
        this.frame = parent;
        this.pc2 = pairs;
        this.pc = null;
        this.combined = true;
        this.chooser = new JFileChooser(System.getProperty("user.dir"));
        this.filter = new PairFileFilter();
        this.chooser.addChoosableFileFilter(this.filter);
        this.chooser.setFileFilter(this.filter);
    }

    public PairIOGUI(JFrame parent, ConflictsDependenciesContainer pairs, String dname, String fname) {
        this.frame = parent;
        this.pc2 = pairs;
        this.pc = null;
        this.combined = true;
        this.directory = dname;
        this.fileName = fname;
        this.chooser = !this.directory.equals("") ? new JFileChooser(this.directory) : new JFileChooser(System.getProperty("user.dir"));
        this.filter = new PairFileFilter();
        this.chooser.addChoosableFileFilter(this.filter);
        this.chooser.setFileFilter(this.filter);
    }

    private Vector getFileFilter(PairContainer pairs) {
        Vector<String> ff = new Vector<String>(2);
        ff.add(".cpx");
        ff.add("Conflict Pairs XML (.cpx)");
        if (pairs == null) {
            return ff;
        }
        if (pairs.getKindOfConflict() == 1) {
            ff.removeAllElements();
            ff.add(".dpx");
            ff.add("Dependency Pairs XML (.dpx)");
        }
        return ff;
    }

    private void resetFileFilter(PairContainer pairs) {
        this.chooser.removeChoosableFileFilter(this.filter);
        Vector ff = this.getFileFilter(pairs);
        this.filter = new PairFileFilter((String)ff.get(0), (String)ff.get(1));
        this.chooser.addChoosableFileFilter(this.filter);
        this.chooser.setFileFilter(this.filter);
    }

    public String getFileFilter() {
        return this.filter.getExtension();
    }

    public void setFileFilter(String ff) {
        if (!ff.equals(this.filter.getExtension())) {
            this.chooser.removeChoosableFileFilter(this.filter);
            String descr = "Conflicts Pairs XML (.cpx)";
            if (ff.equals(".dpx")) {
                descr = "Dependency Pairs XML (.dpx)";
            }
            this.filter = new PairFileFilter(ff, descr);
            this.chooser.addChoosableFileFilter(this.filter);
            this.chooser.setFileFilter(this.filter);
        }
    }

    public void setCriticalPairContainer(PairContainer pairs) {
        this.pc = pairs;
        this.combined = false;
        this.resetFileFilter(this.pc);
    }

    public void setCriticalPairContainer(ConflictsDependenciesContainer pairs) {
        this.pc = null;
        this.pc2 = pairs;
        this.combined = true;
        if (this.pc != null) {
            this.resetFileFilter(this.pc);
        } else {
            this.setFileFilter(".cpx");
        }
    }

    public void save() {
        this.isSaved = false;
        if (this.pc == null && this.pc2 == null) {
            return;
        }
        int returnVal = this.chooser.showSaveDialog(this.frame);
        this.directory = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0 && this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
            this.directory = this.chooser.getCurrentDirectory().toString();
            this.fileName = this.chooser.getSelectedFile().getName();
            if (!this.directory.endsWith(File.separator)) {
                this.directory = this.directory + File.separator;
            }
            File f = new File(this.directory + this.fileName);
            if (!this.chooser.getFileFilter().accept(f)) {
                this.fileName = this.fileName + ((ExtensionFileFilter)this.chooser.getFileFilter()).getExtension();
            }
            this.save(this.directory, this.fileName);
            if (this.isSaved) {
                this.currentDir = this.directory;
            }
        }
    }

    public void save(String directory, String file) {
        XMLHelper xmlh = new XMLHelper();
        if (!this.combined && this.pc != null) {
            xmlh.addTopObject(this.pc);
            xmlh.save_to_xml(directory + file);
            this.isSaved = true;
        } else if (this.combined && this.pc2 != null) {
            xmlh.addTopObject(this.pc2);
            xmlh.save_to_xml(directory + file);
            this.isSaved = true;
        }
    }

    public boolean fileIsSaved() {
        return this.isSaved;
    }

    public Object load() {
        if (this.pc == null) {
            return null;
        }
        Object result = null;
        int returnVal = this.chooser.showOpenDialog(this.frame);
        this.directory = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0 && this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
            this.directory = this.chooser.getCurrentDirectory().toString();
            this.fileName = this.chooser.getSelectedFile().getName();
            if (!this.directory.endsWith(File.separator)) {
                this.directory = this.directory + File.separator;
            }
            File f = new File(this.directory + this.fileName);
            if (!this.chooser.getFileFilter().accept(f)) {
                this.fileName = this.fileName + ((ExtensionFileFilter)this.chooser.getFileFilter()).getExtension();
            }
            result = this.load(this.directory, this.fileName);
            this.currentDir = this.directory;
        }
        return result;
    }

    public Object load(boolean combined) {
        if (!combined) {
            return this.load();
        }
        this.pc2 = new ConflictsDependenciesContainer();
        Object result = null;
        int returnVal = this.chooser.showOpenDialog(this.frame);
        this.directory = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0 && this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
            this.directory = this.chooser.getCurrentDirectory().toString();
            this.fileName = this.chooser.getSelectedFile().getName();
            if (!this.directory.endsWith(File.separator)) {
                this.directory = this.directory + File.separator;
            }
            File f = new File(this.directory + this.fileName);
            if (!this.chooser.getFileFilter().accept(f)) {
                this.fileName = this.fileName + ((ExtensionFileFilter)this.chooser.getFileFilter()).getExtension();
            }
            result = this.load(this.directory, this.fileName);
            this.currentDir = this.directory;
        }
        return result;
    }

    public Object load(String directory, String file) {
        if (this.pc == null && this.pc2 == null) {
            return null;
        }
        XMLObject result = null;
        this.directory = directory;
        this.fileName = file;
        XMLHelper h = new XMLHelper();
        h.read_from_xml(this.directory + this.fileName);
        if (this.pc2 != null) {
            this.combined = true;
            result = h.getTopObject(this.pc2);
        } else if (this.pc != null) {
            this.combined = false;
            result = h.getTopObject(this.pc);
        }
        return result;
    }

    public Object reload(String fullFileName) {
        if (this.pc == null && this.pc2 == null) {
            return null;
        }
        XMLObject result = null;
        XMLHelper h = new XMLHelper();
        h.read_from_xml(fullFileName);
        if (this.pc2 != null) {
            this.combined = true;
            result = h.getTopObject(this.pc2);
        } else if (this.pc != null) {
            this.combined = false;
            result = h.getTopObject(this.pc);
        }
        return result;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setDirectoryName(String dir) {
        this.directory = dir;
        this.chooser.setCurrentDirectory(new File(this.directory));
    }

    public void setDirectoryName(String dir, String file) {
        this.directory = dir;
        this.fileName = file;
        this.chooser.setCurrentDirectory(new File(this.directory));
        if (this.fileName.equals("")) {
            this.chooser.setSelectedFile(null);
        }
    }

    public String getDirectoryName() {
        return this.directory;
    }

    public boolean isCombined() {
        return this.combined;
    }
}

