/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.gui.AGGParser;
import agg.gui.GraphEditor;
import agg.gui.IconResource;
import agg.gui.parser.ParserGUIOption;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.parser.Parser;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserMessageEvent;
import agg.xt_basis.Graph;
import agg.xt_basis.OrdinaryMorphism;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class ParserDesktop
implements InternalFrameListener,
ParserEventListener {
    private static final int STOP_GRAPH = 2;
    private static final int HOST_GRAPH = 1;
    private AGGParser aggparser;
    private JDesktopPane desktop;
    private ImageIcon hostIcon;
    private ImageIcon stopIcon;
    private EdGraGra layout;
    private Dimension internalFrameSize;
    ParserGUIOption option;
    Graph hostGraph;
    Graph stopGraph;
    Parser parser;
    JInternalFrame hostFrame;
    GraphEditor hostgege;
    EdGraph hostEdGraph;
    JInternalFrame stopFrame;
    GraphEditor stopgege;
    EdGraph stopEdGraph;
    Vector listener;
    private KeyAdapter keyAdapter;
    private String typedKey;
    private MouseListener ml;

    public ParserDesktop(AGGParser aggparser, ParserGUIOption option) {
        this(aggparser, option, null, null, null);
    }

    public ParserDesktop(AGGParser aggparser, ParserGUIOption option, EdGraGra layout, Graph hostGraph, Graph stopGraph) {
        this.aggparser = aggparser;
        this.desktop = new JDesktopPane();
        this.setInternalFrameSize(new Dimension(200, 200));
        this.hostEdGraph = null;
        this.stopEdGraph = null;
        this.option = option;
        this.setLayout(layout);
        this.setHostGraph(hostGraph);
        this.setStopGraph(stopGraph);
        this.listener = new Vector();
        this.keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ParserDesktop.this.performShortKeyEvent(e);
            }
        };
        this.desktop.addKeyListener(this.keyAdapter);
        this.ml = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                ParserDesktop.this.desktop.requestFocusInWindow();
            }
        };
        this.desktop.addMouseListener(this.ml);
    }

    private boolean performShortKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (e.isShiftDown() && e.isAltDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (this.typedKey.equals("S")) {
                this.aggparser.startParser();
            } else if (this.typedKey.equals("Q")) {
                this.aggparser.stopParser();
            } else if (this.typedKey.equals("Z")) {
                this.aggparser.backToGUI();
            } else {
                return false;
            }
        }
        return true;
    }

    public Component getComponent() {
        return this.getDesktop();
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public void setLayout(EdGraGra layout) {
        this.layout = layout;
        this.hostEdGraph = null;
        this.stopEdGraph = null;
    }

    public void setInternalFrameSize(Dimension internalFrameSize) {
        this.internalFrameSize = internalFrameSize;
    }

    private void setGraph(Graph graph, int graphType) {
        if (graphType != 1 && graphType != 2) {
            return;
        }
        String frameName = "No Graph";
        if (graph == null) {
            return;
        }
        frameName = graph.getName();
        JInternalFrame hostFrame = new JInternalFrame(frameName, true, false, true, true);
        hostFrame.addInternalFrameListener(this);
        hostFrame.addMouseListener(this.ml);
        hostFrame.addKeyListener(this.keyAdapter);
        hostFrame.setVisible(true);
        hostFrame.setSize(this.internalFrameSize);
        EdGraph eg = new EdGraph(graph, true);
        eg.setTypeSet(this.layout.getTypeSet());
        EdGraph oldLayout = null;
        switch (graphType) {
            case 2: {
                if (this.stopFrame != null) {
                    if (!this.stopFrame.isMaximum()) {
                        try {
                            this.stopFrame.setMaximum(true);
                        }
                        catch (PropertyVetoException ex) {
                            // empty catch block
                        }
                    }
                    this.getDesktop().remove(this.stopFrame);
                }
                this.stopFrame = hostFrame;
                this.stopFrame.setTitle("Stop Graph");
                this.stopgege = new GraphEditor(null);
                this.stopFrame.getContentPane().add(this.stopgege);
                this.stopFrame.validate();
                oldLayout = this.stopEdGraph;
                if (oldLayout != null) {
                    eg.setLayout(oldLayout);
                } else {
                    eg.setLayout(this.layout.getGraph());
                }
                this.stopEdGraph = eg;
                if (this.option.getParserDisplay() == 3) {
                    this.stopFrame.setVisible(true);
                } else {
                    this.stopFrame.setVisible(false);
                }
                this.stopFrame.setFrameIcon(IconResource.getIconFromURL(IconResource.getStopIcon()));
                break;
            }
            case 1: {
                if (this.hostFrame != null) {
                    if (!this.hostFrame.isMaximum()) {
                        try {
                            this.hostFrame.setMaximum(true);
                        }
                        catch (PropertyVetoException ex) {
                            // empty catch block
                        }
                    }
                    this.getDesktop().remove(this.hostFrame);
                }
                this.hostFrame = hostFrame;
                hostFrame.setSize(450, 400);
                hostFrame.setTitle("Host Graph");
                this.hostgege = new GraphEditor(null);
                hostFrame.getContentPane().add(this.hostgege);
                hostFrame.validate();
                oldLayout = this.hostEdGraph;
                if (oldLayout != null) {
                    eg.setLayout(oldLayout);
                } else {
                    eg.setLayout(this.layout.getGraph());
                }
                this.hostEdGraph = eg;
                hostFrame.setLocation(200, 0);
                if (this.option.getParserDisplay() >= 1) {
                    hostFrame.setVisible(true);
                } else {
                    hostFrame.setVisible(false);
                }
                hostFrame.setFrameIcon(IconResource.getIconFromURL(IconResource.getWorkerIcon()));
                break;
            }
        }
        this.getDesktop().add((Component)hostFrame, new Integer(graphType));
        this.updateFrame(hostFrame, eg);
    }

    protected void updateFrame(OrdinaryMorphism om, int graphType) {
        if (graphType != 1 && graphType != 2) {
            return;
        }
        EdGraph graphLayout = new EdGraph(om.getImage(), true);
        graphLayout.getBasisGraph().setName("");
        graphLayout.setTypeSet(this.layout.getTypeSet());
        JInternalFrame theFrame = null;
        EdGraph oldLayout = null;
        switch (graphType) {
            case 2: {
                theFrame = this.stopFrame;
                oldLayout = this.stopEdGraph;
                if (oldLayout != null) {
                    graphLayout.setLayout(oldLayout);
                } else {
                    graphLayout.setLayout(this.layout.getGraph());
                }
                this.stopEdGraph = graphLayout;
                break;
            }
            case 1: {
                theFrame = this.hostFrame;
                oldLayout = this.hostEdGraph;
                if (oldLayout != null) {
                    graphLayout.setLayout(oldLayout);
                } else {
                    graphLayout.setLayout(this.layout.getGraph());
                }
                this.hostEdGraph = graphLayout;
                break;
            }
            default: {
                return;
            }
        }
        if (oldLayout != null && om != null) {
            graphLayout.updateLayout(om, oldLayout);
        }
        this.updateFrame(theFrame, graphLayout);
    }

    protected void updateFrame(JInternalFrame theFrame, EdGraph graphLayout) {
        graphLayout.update();
        GraphEditor gege = null;
        for (int i = 0; i < theFrame.getContentPane().getComponentCount(); ++i) {
            if (!(theFrame.getContentPane().getComponent(i) instanceof GraphEditor)) continue;
            gege = (GraphEditor)theFrame.getContentPane().getComponent(i);
            gege.setGraph(graphLayout);
            gege.setEditMode(9);
            gege.setTitle(graphLayout.getBasisGraph().getName());
        }
    }

    protected void updateFrame(Graph graph, int graphType) {
        if (graphType != 1 && graphType != 2) {
            return;
        }
        EdGraph eg = new EdGraph(graph, true);
        eg.setTypeSet(this.layout.getTypeSet());
        this.updateFrame(graph, graphType, eg);
    }

    protected void updateFrame(Graph graph, int graphType, EdGraph graphLayout) {
        EdGraph oldLayout = null;
        JInternalFrame theFrame = null;
        switch (graphType) {
            case 2: {
                theFrame = this.stopFrame;
                oldLayout = this.stopEdGraph;
                if (oldLayout != null) {
                    graphLayout.setLayout(oldLayout);
                } else {
                    graphLayout.setLayout(this.layout.getGraph());
                }
                this.stopEdGraph = graphLayout;
                break;
            }
            case 1: {
                theFrame = this.hostFrame;
                oldLayout = this.hostEdGraph;
                if (oldLayout != null) {
                    graphLayout.setLayout(oldLayout);
                } else {
                    graphLayout.setLayout(this.layout.getGraph());
                }
                this.hostEdGraph = graphLayout;
                break;
            }
            default: {
                return;
            }
        }
        this.updateFrame(theFrame, graphLayout);
    }

    public void setHostGraph(Graph graph) {
        this.hostGraph = graph;
        this.setGraph(graph, 1);
    }

    public void setStopGraph(Graph graph) {
        this.stopGraph = graph;
        this.setGraph(graph, 2);
    }

    public void setParser(Parser parser) {
        this.parser = parser;
        this.setHostGraph(parser.getHostGraph());
        this.setStopGraph(parser.getStopGraph());
        parser.addParserEventListener(this);
    }

    public void setParser(Parser parser, OrdinaryMorphism om) {
        this.parser = parser;
        this.setHostGraph(om.getOriginal());
        this.setStopGraph(parser.getStopGraph());
        parser.addParserEventListener(this);
        this.updateFrame(om, 1);
    }

    public void internalFrameActivated(InternalFrameEvent e) {
    }

    public void internalFrameClosed(InternalFrameEvent e) {
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }

    public void parserEventOccured(ParserEvent p) {
        if (this.hostFrame != null) {
            this.hostFrame.repaint();
        }
        if (p instanceof ParserMessageEvent) {
            String message = ((ParserMessageEvent)p).getMessage();
            this.fireStatusMessageEvent(new StatusMessageEvent(this, "", message));
            Object source = p.getSource();
            if (source instanceof Parser) {
                this.updateFrame(((Parser)source).getHostGraph(), 1);
            } else if (source instanceof OrdinaryMorphism) {
                this.updateFrame((OrdinaryMorphism)source, 1);
            }
        } else if (p instanceof ParserErrorEvent) {
            String message = ((ParserErrorEvent)p).getMessage();
            this.fireStatusMessageEvent(new StatusMessageEvent(this, "ERROR", "Error: " + message));
        }
    }

    public void hostFrameSetAnimationIcon() {
        this.hostFrame.setFrameIcon(IconResource.getIconFromURL(IconResource.getWorkingIcon()));
    }

    public void hostFrameResetIcon() {
        this.hostFrame.setFrameIcon(IconResource.getIconFromURL(IconResource.getWorkerIcon()));
    }

    public void addStatusMessageListener(StatusMessageListener l) {
        this.listener.addElement(l);
    }

    private void fireStatusMessageEvent(StatusMessageEvent sme) {
        for (int i = 0; i < this.listener.size(); ++i) {
            ((StatusMessageListener)this.listener.elementAt(i)).newMessage(sme);
        }
    }
}

