/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.editor.impl.EdGraGra;
import agg.gui.GraGraLoad;
import agg.gui.GraGraTreeView;
import agg.gui.parser.PairIOGUI;
import agg.parser.CriticalPairOption;
import agg.parser.Layer;
import agg.parser.LayerFunction;
import agg.parser.LayerOption;
import agg.parser.PairContainer;
import agg.parser.ParserFactory;
import agg.parser.ParserOption;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ParserDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    GraGraTreeView treeView;
    EdGraGra hostGraph;
    EdGraGra stopGraph;
    EdGraGra criticalPairGraGra;
    PairContainer criticalPairs;
    Frame parent;
    JList gragraNames;
    private Vector gragraNamesVector;
    JScrollPane scrollPane;
    JButton loadButton;
    JButton cancel;
    JButton nextButton;
    StepPanel stepPanel;
    boolean readyToParse;
    ParserOption pOption;
    CriticalPairOption cpOption;
    LayerOption lOption;
    private Frame frame;

    public ParserDialog(Frame parent, GraGraTreeView treeView, ParserOption pOption, CriticalPairOption cpOption, LayerOption lOption) {
        super(parent, "Starting Parser", true);
        this.treeView = treeView;
        this.hostGraph = null;
        this.stopGraph = null;
        this.criticalPairs = null;
        this.criticalPairGraGra = null;
        this.readyToParse = false;
        this.parent = parent;
        this.pOption = pOption;
        this.cpOption = cpOption;
        this.lOption = lOption;
        this.frame = parent;
        this.setLocation(200, 200);
        this.setSize(new Dimension(450, 300));
        this.setDefaultCloseOperation(2);
        GridBagConstraints constraint = new GridBagConstraints();
        JPanel c = new JPanel();
        c.setLayout(new GridBagLayout());
        c.setBackground(Color.lightGray);
        c.setSize(new Dimension(450, 300));
        JPanel warningPanel = new JPanel(new GridLayout(0, 1));
        warningPanel.setBackground(Color.lightGray);
        warningPanel.setPreferredSize(new Dimension(300, 60));
        JLabel leer = new JLabel("  ");
        warningPanel.add(leer);
        JLabel warning = new JLabel("Parsing rules and stop graph have ");
        warning.setForeground(Color.red);
        warning.setFont(new Font("Times New Roman", 1, 14));
        warningPanel.add(warning);
        warning = new JLabel("to be located in the same grammar.");
        warning.setForeground(Color.red);
        warning.setFont(new Font("Times New Roman", 1, 14));
        warningPanel.add(warning);
        constraint.fill = 0;
        constraint.anchor = 10;
        constraint.weighty = 0.0;
        constraint.weightx = 0.0;
        constraint.gridwidth = 0;
        constraint.gridheight = 2;
        constraint.weighty = 0.0;
        constraint.weightx = 1.0;
        c.add((Component)warningPanel, constraint);
        this.stepPanel = new StepPanel();
        this.stepPanel.setStep(1);
        this.stepPanel.setPreferredSize(new Dimension(170, 90));
        constraint.fill = 0;
        constraint.anchor = 13;
        constraint.weighty = 0.0;
        constraint.weightx = 0.0;
        constraint.gridwidth = 1;
        constraint.gridheight = 1;
        constraint.insets = new Insets(10, 10, 0, 0);
        c.add((Component)this.stepPanel, constraint);
        JPanel listPanel = new JPanel();
        listPanel.setPreferredSize(new Dimension(150, 150));
        listPanel.setBackground(Color.lightGray);
        listPanel.setLayout(new GridBagLayout());
        listPanel.setSize(100, 200);
        constraint.fill = 1;
        constraint.weighty = 0.1;
        constraint.weightx = 0.0;
        constraint.gridwidth = 0;
        constraint.gridheight = 1;
        constraint.insets = new Insets(0, 0, 0, 0);
        c.add((Component)listPanel, constraint);
        JPanel spaceDummy = new JPanel();
        spaceDummy.setBackground(Color.lightGray);
        spaceDummy.setSize(100, 1);
        constraint.weighty = 1.0;
        constraint.weightx = 1.0;
        c.add((Component)spaceDummy, constraint);
        JSeparator js = new JSeparator();
        constraint.weighty = 0.0;
        constraint.weightx = 1.0;
        constraint.insets = new Insets(0, 0, 5, 0);
        c.add((Component)js, constraint);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setPreferredSize(new Dimension(350, 30));
        buttonPanel.setBackground(Color.lightGray);
        buttonPanel.setLayout(new GridBagLayout());
        constraint.insets = new Insets(0, 0, 0, 0);
        constraint.weighty = 0.0;
        constraint.weightx = 0.0;
        c.add((Component)buttonPanel, constraint);
        this.gragraNamesVector = treeView.getGraGraNames();
        this.gragraNames = new JList(this.gragraNamesVector);
        this.gragraNames.setSelectionMode(0);
        this.gragraNames.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.gragraNames, 20, 30);
        this.scrollPane.setPreferredSize(new Dimension(150, 150));
        constraint.fill = 0;
        constraint.anchor = 10;
        constraint.weighty = 0.0;
        constraint.weightx = 0.0;
        constraint.gridwidth = 0;
        constraint.gridheight = 1;
        constraint.insets = new Insets(10, 0, 0, 10);
        JLabel topic = new JLabel("from GraGra...");
        topic.setForeground(Color.black);
        topic.setFont(new Font("Times New Roman", 1, 14));
        listPanel.add((Component)topic, constraint);
        constraint.fill = 1;
        constraint.weighty = 1.0;
        constraint.weightx = 1.0;
        listPanel.add((Component)this.scrollPane, constraint);
        this.loadButton = new JButton("Load...");
        this.loadButton.addActionListener(this);
        constraint.fill = 0;
        constraint.weighty = 0.0;
        constraint.weightx = 0.0;
        constraint.anchor = 10;
        constraint.gridwidth = 0;
        listPanel.add((Component)this.loadButton, constraint);
        constraint.insets = new Insets(0, 0, 0, 0);
        constraint.fill = 1;
        constraint.weighty = 0.0;
        constraint.weightx = 0.0;
        constraint.gridwidth = 0;
        constraint.gridheight = 1;
        this.nextButton = new JButton();
        this.nextButton.setText("Next");
        this.nextButton.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel dragPanel = new JPanel();
        dragPanel.setBackground(Color.lightGray);
        dragPanel.setPreferredSize(new Dimension(100, 1));
        constraint.fill = 1;
        constraint.weighty = 1.0;
        constraint.weightx = 1.0;
        constraint.gridwidth = 1;
        constraint.gridheight = 1;
        buttonPanel.add((Component)dragPanel, constraint);
        constraint.fill = 0;
        constraint.weighty = 0.0;
        constraint.weightx = 0.0;
        constraint.gridwidth = 1;
        constraint.gridheight = 1;
        buttonPanel.add((Component)this.nextButton, constraint);
        JPanel spaceDummy2 = new JPanel();
        spaceDummy2.setBackground(Color.lightGray);
        spaceDummy2.setPreferredSize(new Dimension(50, 1));
        constraint.weighty = 1.0;
        constraint.weightx = 0.0;
        buttonPanel.add((Component)spaceDummy2, constraint);
        constraint.weighty = 0.0;
        constraint.weightx = 0.0;
        constraint.gridwidth = 1;
        constraint.gridheight = 1;
        buttonPanel.add((Component)this.cancel, constraint);
        JPanel spaceDummy3 = new JPanel();
        spaceDummy3.setBackground(Color.lightGray);
        spaceDummy3.setPreferredSize(new Dimension(20, 1));
        constraint.weighty = 1.0;
        constraint.weightx = 0.0;
        constraint.gridwidth = 0;
        buttonPanel.add((Component)spaceDummy3, constraint);
        c.revalidate();
        this.getContentPane().add((Component)c, "Center");
    }

    public void showDialog() {
        this.setLocationRelativeTo(this.frame);
        super.setVisible(true);
    }

    public void checkHostGraphAndNextStep() {
        if (this.hostGraph != null) {
            this.stepPanel.setStep(3);
            this.gragraNames.setSelectedIndex(-1);
        }
    }

    public void checkStopGraphAndNextStep() {
        if (this.stopGraph != null) {
            this.stepPanel.setStep(7);
        }
    }

    public void checkPairsAndNextStep() {
        this.setPairs();
        if (this.criticalPairs != null || this.criticalPairGraGra != null) {
            this.stepPanel.setStep(15);
            this.nextButton.setText("Finish");
            if (this.criticalPairs != null) {
                this.criticalPairGraGra = null;
            }
        }
    }

    private void setGraph(int step) {
        if (this.gragraNames.getSelectedValue() == null) {
            return;
        }
        if (step == 1 || step == 3) {
            String name = (String)this.gragraNames.getSelectedValue();
            boolean found = false;
            block4: for (int i = 0; i < this.treeView.getGraGras().size() && !found; ++i) {
                EdGraGra gragra = (EdGraGra)this.treeView.getGraGras().elementAt(i);
                if (!name.equals(gragra.getName())) continue;
                found = true;
                switch (step) {
                    case 1: {
                        this.hostGraph = gragra;
                        continue block4;
                    }
                    case 3: {
                        this.stopGraph = gragra;
                        continue block4;
                    }
                }
            }
        }
    }

    private void setPairs() {
        if (this.gragraNames.getSelectedValue() != null) {
            String nameStr = (String)this.gragraNames.getSelectedValue();
            boolean found = false;
            for (int i = 0; i < this.treeView.getGraGras().size() && !found; ++i) {
                EdGraGra gragra = (EdGraGra)this.treeView.getGraGras().elementAt(i);
                String name = nameStr;
                int indx = nameStr.indexOf("(");
                if (indx != -1) {
                    name = nameStr.substring(0, indx);
                }
                if (!name.equals(gragra.getName())) continue;
                this.criticalPairGraGra = gragra;
            }
            if (this.criticalPairGraGra == null && this.stopGraph != null) {
                this.criticalPairGraGra = this.stopGraph;
            }
        } else if (this.stopGraph != null) {
            this.criticalPairGraGra = this.stopGraph;
        }
    }

    private void checkIfReadyToParse() {
        if (this.hostGraph != null && this.stopGraph != null && (this.criticalPairs != null || this.criticalPairGraGra != null)) {
            this.readyToParse = true;
        }
    }

    public boolean isReadyToParse() {
        return this.readyToParse;
    }

    private void quitDialog() {
        this.dispose();
    }

    private void checkState() {
        switch (this.stepPanel.getStep()) {
            case 1: {
                this.checkHostGraphAndNextStep();
                break;
            }
            case 3: {
                this.checkStopGraphAndNextStep();
                break;
            }
            case 7: {
                this.checkPairsAndNextStep();
                break;
            }
            case 15: {
                this.checkIfReadyToParse();
                this.quitDialog();
                break;
            }
        }
    }

    private void loadGraph(int step) {
        if (step == 1 || step == 3) {
            String fileName = "";
            String dirName = "";
            GraGraLoad gragraLoad = new GraGraLoad((JFrame)this.parent);
            gragraLoad.setDirName(this.treeView.getFileDirectory());
            EdGraGra loadedGraGra = null;
            gragraLoad.load();
            if (gragraLoad.getGraGra() != null) {
                dirName = gragraLoad.getDirName();
                fileName = gragraLoad.getFileName();
                loadedGraGra = gragraLoad.getGraGra();
                BaseFactory.theFactory().notify(loadedGraGra.getBasisGraGra());
                String str = loadedGraGra.getName() + "(" + loadedGraGra.getFileName() + ")";
                this.gragraNamesVector.addElement(str);
                this.gragraNames.setListData(this.gragraNamesVector);
                this.gragraNames.setSelectedIndex(this.gragraNamesVector.size() - 1);
            }
            switch (step) {
                case 1: {
                    this.hostGraph = loadedGraGra;
                    break;
                }
                case 3: {
                    this.stopGraph = loadedGraGra;
                    break;
                }
            }
        }
    }

    private void loadPairs() {
        this.criticalPairs = null;
        PairContainer excludePairContainer = null;
        GraGra nullGraGra = BaseFactory.theFactory().createGraGra();
        LayerFunction lf = ParserFactory.createLayerFunction(nullGraGra, this.lOption);
        this.cpOption.enableLayered(true);
        excludePairContainer = ParserFactory.createEmptyCriticalPairs(nullGraGra, lf, this.cpOption);
        PairIOGUI pairIOgui = new PairIOGUI((JFrame)this.parent, excludePairContainer);
        pairIOgui.setDirectoryName(this.treeView.getFileDirectory());
        Object o = pairIOgui.load();
        if (o == null) {
            return;
        }
        String fileName = pairIOgui.getFileName();
        if ((Layer)((Object)excludePairContainer) != null) {
            lf = ((Layer)((Object)excludePairContainer)).getLayer();
        }
        if (lf == null) {
            this.cpOption.enableLayered(false);
        }
        String str = excludePairContainer.getGrammar().getName() + "(" + fileName + ")";
        this.gragraNamesVector.addElement(str);
        this.gragraNames.setListData(this.gragraNamesVector);
        this.gragraNames.setSelectedIndex(this.gragraNamesVector.size() - 1);
        this.criticalPairs = excludePairContainer;
    }

    private void load() {
        switch (this.stepPanel.getStep()) {
            case 1: {
                this.loadGraph(1);
                break;
            }
            case 3: {
                this.loadGraph(3);
                break;
            }
            case 7: {
                this.loadPairs();
                break;
            }
            case 15: {
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.nextButton) {
            this.checkState();
        } else if (source == this.cancel) {
            this.quitDialog();
        } else if (source == this.loadButton) {
            this.load();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Object source = e.getSource();
        if (source == this.gragraNames) {
            switch (this.stepPanel.getStep()) {
                case 1: {
                    this.setGraph(1);
                    break;
                }
                case 3: {
                    this.setGraph(3);
                    break;
                }
                case 7: {
                    this.setPairs();
                    break;
                }
                case 15: {
                    break;
                }
            }
        }
    }

    public EdGraGra getHostGraphGrammar() {
        return this.hostGraph;
    }

    public EdGraGra getStopGraphGrammar() {
        return this.stopGraph;
    }

    public EdGraGra getCriticalPairGraGra() {
        return this.criticalPairGraGra;
    }

    public PairContainer getCriticalPairs() {
        return this.criticalPairs;
    }

    public static void main(String[] args) {
        ParserDialog theFrame = new ParserDialog(null, null, null, null, null);
        theFrame.show();
    }

    public class StepPanel
    extends JPanel
    implements Runnable {
        public static final int STEP_HOST_GRAPH = 1;
        public static final int STEP_STOP_GRAPH = 3;
        public static final int STEP_CRITICAL_PAIRS = 7;
        public static final int STEP_FINISH = 15;
        String[] steps = new String[]{"Select Host Graph", "Select Stop Graph", "Select Critical Pairs"};
        int enabled = 0;

        public StepPanel() {
            this.setPreferredSize(new Dimension(100, 100));
        }

        private void paintSteps(Graphics2D g2d, int startX, int startY, int stepNumber) {
            Color text;
            Color bullit;
            if (this.enabled > (int)Math.pow(2.0, stepNumber + 1) - 1) {
                bullit = Color.green;
                text = Color.darkGray;
            } else if (this.enabled == (int)Math.pow(2.0, stepNumber + 1) - 1) {
                bullit = Color.red;
                text = Color.black;
            } else {
                bullit = Color.gray;
                text = Color.gray;
            }
            this.paintSteps(g2d, startX, startY, stepNumber, bullit, text);
        }

        private void paintSteps(Graphics2D g2d, int startX, int startY, int stepNumber, Color bullit, Color text) {
            int x = startX;
            int y = startY;
            int ellipseSize = 5;
            g2d.setColor(bullit);
            Ellipse2D.Float e = new Ellipse2D.Float(x, y += stepNumber * 15, ellipseSize, ellipseSize);
            g2d.fillOval(x, y, ellipseSize, ellipseSize);
            g2d.draw(e);
            g2d.setColor(text);
            g2d.drawString(this.steps[stepNumber], x + 12, y + 7);
        }

        public void paint(Graphics g) {
            Dimension d = this.getSize();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.lightGray);
            g2d.fillRect(0, 0, d.width, d.height);
            g2d.setColor(Color.black);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setFont(new Font("Times New Roman", 1, 14));
            int x = 5;
            int y = 5;
            int[] xs = new int[]{2, 5, 5, 2};
            int[] ys = new int[]{5, 5, 69, 69};
            g2d.drawPolyline(xs, ys, 4);
            g2d.setColor(Color.blue);
            g2d.drawString("Start", xs[1] + 10, ys[1] + 7);
            g2d.setColor(Color.black);
            if (this.enabled == (int)Math.pow(2.0, 4.0) - 1) {
                g2d.setColor(new Color(0, 127, 0));
            }
            g2d.setColor(Color.blue);
            g2d.drawString("Finish", xs[2] + 10, ys[2] + 3);
            g2d.setColor(Color.black);
            for (int i = 0; i < 3; ++i) {
                this.paintSteps(g2d, xs[1] - 2, ys[1] + 15, i);
            }
        }

        public void setStep(int step) {
            this.enabled = step;
            this.repaint();
        }

        public int getStep() {
            return this.enabled;
        }

        public void run() {
            for (int k = 0; k < 5; ++k) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j < 1000000; ++j) {
                }
                this.setStep((int)Math.pow(2.0, i) - 1);
                this.repaint();
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

