/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.gui.AbstractOptionGUI;
import agg.gui.IconResource;
import agg.gui.parser.ParserGUIOption;
import agg.parser.CriticalPairOption;
import agg.parser.OptionEventListener;
import agg.parser.ParserOption;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ParserOptionGUI
extends AbstractOptionGUI
implements ItemListener,
ActionListener,
OptionEventListener {
    JComboBox algorithms;
    JComboBox parserAlgorithms;
    JCheckBox stopGraphButton;
    JCheckBox invisibleButton;
    JCheckBox hostGraphButton;
    JCheckBox layered;
    JPanel firstPriorityOption;
    JButton displaySwitch;
    protected static final String EXCLUDEONLY = "  conflicts  ";
    protected static final String EXCLUDEANDBEFORE = "exclude and befor";
    protected static final String DEPENDEONLY = "  dependencies  ";
    protected static final String INDEPENDING = "before independing on exclude";
    protected static final String DISPLAYSETTINGS = "Display Settings...";
    protected static final String GENERALSETTINGS = " General Settings...";
    private static final String EXCLUDEPARSER = " Critical Pair Analysis";
    private static final String SIMPLEEXCLUDEPARSER = " Semi optimized backtracking";
    private static final String SIMPLEPARSER = " Backtracking without optimization";
    private ParserGUIOption guiOption;
    private ParserOption pOption;
    CriticalPairOption cpOption;

    public ParserOptionGUI(ParserGUIOption guiOption, ParserOption option, CriticalPairOption cpOption) {
        this.pOption = option;
        this.guiOption = guiOption;
        this.cpOption = cpOption;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        this.firstPriorityOption = this.makeFirstPriorityOption();
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)this.firstPriorityOption, c);
        this.validate();
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 400);
    }

    public void setCriticalPairOption(CriticalPairOption cpOption) {
        this.cpOption = cpOption;
    }

    private void addIcon(JPanel optionPanel) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 1, 1, 1);
        ImageIcon optionImage = IconResource.getIconFromURL(IconResource.getOptionIcon());
        JLabel optionLabel = new JLabel(optionImage);
        optionLabel.setHorizontalAlignment(0);
        optionLabel.setVerticalAlignment(0);
        optionLabel.setHorizontalTextPosition(0);
        optionLabel.setVerticalTextPosition(0);
        optionPanel.add((Component)optionLabel, c);
    }

    private JPanel makeFirstPriorityOption() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 18;
        JPanel optionPanel = this.makeInitialOptionPanel(" General Settings", c);
        optionPanel.setBorder(new TitledBorder(""));
        this.addIcon(optionPanel);
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.insets = new Insets(5, 0, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel placeHolder3 = new JPanel();
        placeHolder3.setPreferredSize(new Dimension(200, 2));
        optionPanel.add((Component)placeHolder3, c);
        c.weighty = 0.0;
        JPanel parserOptionPanel = this.makeParserPanelOption();
        optionPanel.add((Component)parserOptionPanel, c);
        c.weighty = 0.0;
        JPanel algorithmParser = this.makeParserAlgorithm();
        optionPanel.add((Component)algorithmParser, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel placeHolder1 = new JPanel();
        placeHolder1.setPreferredSize(new Dimension(200, 200));
        optionPanel.add((Component)placeHolder1, c);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JPanel placeHolder = new JPanel();
        placeHolder.setPreferredSize(new Dimension(200, 200));
        optionPanel.add((Component)placeHolder, c);
        c.weightx = 1.0;
        c.gridwidth = -1;
        JPanel placeHolder2 = new JPanel();
        placeHolder2.setPreferredSize(new Dimension(200, 200));
        optionPanel.add((Component)placeHolder2, c);
        return optionPanel;
    }

    private JPanel makeParserPanelOption() {
        JPanel optionPanel = this.makeInitialOptionPanel(" Parser Display Option");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        JLabel show = new JLabel(" show...");
        optionPanel.add((Component)show, c);
        optionPanel.setBorder(new TitledBorder(""));
        this.stopGraphButton = new JCheckBox("Stop Graph");
        this.stopGraphButton.setFocusPainted(false);
        this.stopGraphButton.addActionListener(this);
        this.stopGraphButton.setSelected(this.guiOption.getParserDisplay() - 1 == 2);
        this.invisibleButton = new JCheckBox("Invisible");
        this.invisibleButton.setFocusPainted(false);
        this.invisibleButton.addActionListener(this);
        this.invisibleButton.setSelected(this.guiOption.getParserDisplay() == 0);
        this.hostGraphButton = new JCheckBox("Host Graph");
        this.hostGraphButton.setFocusPainted(false);
        this.hostGraphButton.addActionListener(this);
        this.hostGraphButton.setSelected(this.guiOption.getParserDisplay() - 2 == 1);
        ButtonGroup group = new ButtonGroup();
        group.add(this.invisibleButton);
        group.add(this.hostGraphButton);
        optionPanel.add((Component)this.invisibleButton, c);
        c.gridwidth = -1;
        optionPanel.add((Component)this.hostGraphButton, c);
        c.weightx = 1.0;
        optionPanel.add((Component)this.stopGraphButton, c);
        return optionPanel;
    }

    private JPanel makeParserAlgorithm() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(" Select algorithm for parser", c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        optionPanel.setBorder(new TitledBorder(""));
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        this.parserAlgorithms = new JComboBox();
        this.parserAlgorithms.addItem(EXCLUDEPARSER);
        this.parserAlgorithms.addItem(SIMPLEEXCLUDEPARSER);
        this.parserAlgorithms.addItem(SIMPLEPARSER);
        this.parserAlgorithms.addItemListener(this);
        optionPanel.add((Component)this.parserAlgorithms, c);
        this.layered = new JCheckBox("layered", false);
        this.layered.setFocusPainted(false);
        this.layered.addActionListener(this);
        c.insets = new Insets(0, 20, 0, 0);
        optionPanel.add((Component)this.layered, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        return optionPanel;
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.parserAlgorithms) {
            if (this.parserAlgorithms.getSelectedItem().equals(EXCLUDEPARSER)) {
                this.pOption.setSelectedParser(1);
            } else if (this.parserAlgorithms.getSelectedItem().equals(SIMPLEEXCLUDEPARSER)) {
                this.pOption.setSelectedParser(2);
            } else if (this.parserAlgorithms.getSelectedItem().equals(SIMPLEPARSER)) {
                this.pOption.setSelectedParser(0);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (!source.equals(this.displaySwitch)) {
            if (source.equals(this.invisibleButton) || source.equals(this.hostGraphButton)) {
                if (source.equals(this.invisibleButton)) {
                    this.stopGraphButton.setEnabled(false);
                    this.guiOption.setParserDisplay(0);
                } else if (source.equals(this.hostGraphButton)) {
                    this.stopGraphButton.setEnabled(true);
                    int op = 1;
                    if (this.stopGraphButton.isSelected()) {
                        op += 2;
                    }
                    this.guiOption.setParserDisplay(op);
                }
            } else if (source.equals(this.stopGraphButton)) {
                if (this.stopGraphButton.isSelected()) {
                    this.guiOption.setParserDisplay(3);
                } else {
                    this.guiOption.setParserDisplay(1);
                }
            } else if (source.equals(this.layered)) {
                this.pOption.enableLayer(this.layered.isSelected());
                this.cpOption.enableLayered(this.layered.isSelected());
            }
        }
        this.update();
    }

    public void optionEventOccurred(EventObject e) {
        if (e.getSource() instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)e.getSource();
            if (cb.getText().equals("layered")) {
                this.pOption.enableLayer(cb.isSelected());
                this.layered.doClick();
            }
        } else if (e.getSource() instanceof CriticalPairOption) {
            boolean b = ((CriticalPairOption)e.getSource()).layeredEnabled();
            this.pOption.enableLayer(b);
            if (b && !this.layered.isSelected()) {
                this.layered.doClick();
            } else if (!b && this.layered.isSelected()) {
                this.layered.doClick();
            }
        }
    }

    public Icon getIcon() {
        return new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/pacman.gif"));
    }

    public String getTabTitle() {
        return "Parser";
    }

    public String getTabTip() {
        return "Parser Options";
    }

    public void update() {
        if (this.pOption.getSelectedParser() == 0) {
            this.parserAlgorithms.setSelectedItem(SIMPLEPARSER);
        } else if (this.pOption.getSelectedParser() == 1) {
            this.parserAlgorithms.setSelectedItem(EXCLUDEPARSER);
        } else if (this.pOption.getSelectedParser() == 2) {
            this.parserAlgorithms.setSelectedItem(SIMPLEEXCLUDEPARSER);
        }
        if (this.guiOption.getParserDisplay() == 0) {
            this.stopGraphButton.setEnabled(false);
            this.stopGraphButton.setSelected(false);
            this.invisibleButton.setSelected(true);
            this.hostGraphButton.setSelected(false);
        } else if (this.guiOption.getParserDisplay() == 1) {
            this.stopGraphButton.setEnabled(true);
            this.stopGraphButton.setSelected(false);
            this.invisibleButton.setSelected(false);
            this.hostGraphButton.setSelected(true);
        } else if (this.guiOption.getParserDisplay() == 3) {
            this.stopGraphButton.setEnabled(true);
            this.stopGraphButton.setSelected(true);
            this.invisibleButton.setSelected(false);
            this.hostGraphButton.setSelected(true);
        }
        this.layered.setSelected(this.pOption.layerEnabled());
    }
}

