/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.cons.AtomConstraint;
import agg.xt_basis.GraGra;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RuleModel
implements TreeModel {
    private Vector treeModelListeners = new Vector();
    private TreeData rootNode;
    private GraGra grammar;
    private boolean showAtomics;
    private boolean withNACs;

    public RuleModel(GraGra gragra, boolean atomics, boolean nacs) {
        this.rootNode = gragra != null ? new TreeData((atomics ? "Atomics of" : "Rules of ") + gragra.getName()) : new TreeData("--EMPTY--");
        this.grammar = gragra;
        this.showAtomics = atomics;
        this.withNACs = nacs;
    }

    private Vector getAtomics() {
        Vector<TreeData> tmpVector = new Vector<TreeData>();
        if (this.grammar != null) {
            Enumeration en = this.grammar.getAtomics();
            while (en.hasMoreElements()) {
                tmpVector.addElement(new TreeData((AtomConstraint)en.nextElement()));
            }
        }
        return tmpVector;
    }

    private Vector getRules() {
        Vector<TreeData> tmpVector = new Vector<TreeData>();
        if (this.grammar != null) {
            Enumeration en = this.grammar.getRules();
            while (en.hasMoreElements()) {
                tmpVector.addElement(new TreeData((Rule)en.nextElement()));
            }
        }
        return tmpVector;
    }

    private Vector getTops() {
        return this.showAtomics ? this.getAtomics() : this.getRules();
    }

    private Vector getNACs(Rule r) {
        Vector<TreeData> tmpVector = new Vector<TreeData>();
        Enumeration en = r.getNACs();
        while (en.hasMoreElements()) {
            tmpVector.addElement(new TreeData((OrdinaryMorphism)en.nextElement()));
        }
        return tmpVector;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.getRoot()) {
            return this.getRules().elementAt(index);
        }
        TreeData td = (TreeData)parent;
        OrdinaryMorphism morph = td.getData();
        if (morph != null && this.withNACs && morph instanceof Rule) {
            return this.getNACs((Rule)morph).elementAt(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent == this.getRoot()) {
            return this.getRules().size();
        }
        TreeData td = (TreeData)parent;
        OrdinaryMorphism morph = td.getData();
        if (morph != null && this.withNACs && morph instanceof Rule) {
            int result = this.getNACs((Rule)morph).size();
            return result;
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.getRoot()) {
            return this.getRules().indexOf(child);
        }
        TreeData td = (TreeData)parent;
        OrdinaryMorphism morph = td.getData();
        if (morph != null && this.withNACs && morph instanceof Rule) {
            return this.getNACs((Rule)morph).indexOf(child);
        }
        return 0;
    }

    public Object getRoot() {
        return this.rootNode;
    }

    public boolean isLeaf(Object node) {
        if (node == this.getRoot()) {
            return false;
        }
        return this.getChildCount(node) == 0;
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        System.out.println("*** valueForPathChanged : " + path + " --> " + newValue);
    }

    public class TreeData
    extends DefaultMutableTreeNode {
        boolean atomic;
        boolean rule;
        boolean nac;
        boolean root;

        TreeData(Object o) {
            super(o);
            this.rule = false;
            this.nac = false;
            this.root = false;
            if (o instanceof String) {
                this.root = true;
            } else if (o instanceof AtomConstraint) {
                this.atomic = true;
            } else if (o instanceof Rule) {
                this.rule = true;
            } else if (o instanceof OrdinaryMorphism) {
                this.nac = true;
            }
        }

        public OrdinaryMorphism getData() {
            Object tmpObj = this.getUserObject();
            if (this.isRule() || this.isNAC() || this.isAtomic()) {
                return (OrdinaryMorphism)tmpObj;
            }
            return null;
        }

        public String toString() {
            Object tmpObj = this.getUserObject();
            if (this.isRule() || this.isNAC() || this.isAtomic()) {
                return ((OrdinaryMorphism)tmpObj).getName();
            }
            return tmpObj.toString();
        }

        public boolean isAtomic() {
            return this.atomic;
        }

        public boolean isNAC() {
            return this.nac;
        }

        public boolean isRule() {
            return this.rule;
        }

        public boolean isRoot() {
            return this.root;
        }
    }
}

