/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.gui.parser.RuleModel;
import agg.gui.parser.RuleTreeCellRenderer;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.xt_basis.GraGra;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RuleTree
implements TreeSelectionListener {
    JTree treeView;
    Vector listeners;
    boolean showAtomics;
    boolean withNACs;

    public RuleTree(GraGra grammar) {
        this(grammar, false, true);
    }

    public RuleTree(GraGra grammar, boolean atomics, boolean nacs) {
        this.treeView = new JTree(new RuleModel(grammar, atomics, nacs));
        this.treeView.addTreeSelectionListener(this);
        this.treeView.getSelectionModel().setSelectionMode(1);
        this.treeView.setEditable(false);
        this.treeView.setShowsRootHandles(false);
        this.treeView.setMinimumSize(new Dimension(100, 100));
        this.treeView.setCellRenderer(new RuleTreeCellRenderer());
        this.listeners = new Vector();
        this.showAtomics = atomics;
        this.withNACs = nacs;
    }

    public void setGrammar(GraGra gragra) {
        this.treeView.setModel(new RuleModel(gragra, this.showAtomics, this.withNACs));
    }

    public JTree getTree() {
        return this.treeView;
    }

    public void addParserGUIListener(ParserGUIListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeParserGUIListener(ParserGUIListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireParserGUIEvent(Object data) {
        ParserGUIEvent event = new ParserGUIEvent(this, data);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ParserGUIListener l = (ParserGUIListener)this.listeners.elementAt(i);
            l.occured(event);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        RuleModel.TreeData node = (RuleModel.TreeData)this.getTree().getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.fireParserGUIEvent(node);
    }
}

