/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.termination;

import agg.gui.termination.RuleTable;
import agg.gui.termination.TypeTable;
import agg.termination.TerminationLGTS;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class LayerTerminationCondTable
extends JDialog
implements ActionListener {
    static final Color NOT_VALID = Color.red;
    static final Color VALID = Color.green;
    private Hashtable buttons = new Hashtable();
    private TerminationLGTS termination;
    private Hashtable firstLayers = new Hashtable();
    private Hashtable secondConds = new Hashtable();
    private JPanel panel;
    private JPanel tablePanel;
    private JScrollPane scrLayer;
    private JScrollPane scrInfo;
    private RuleTable tableRule;
    private TypeTable tableTypeDeletion;
    private TypeTable tableTypeCreation;
    private JButton lastButton;
    private Vector conds;
    private int w;
    private int h;

    private static Vector createVector(Enumeration en) {
        Vector result = new Vector();
        while (en.hasMoreElements()) {
            result.add(en.nextElement());
        }
        return result;
    }

    private static Vector getConditionsName() {
        Vector<Pair> names = new Vector<Pair>(3);
        names.add(new Pair("Deletion_1", "Type Deletion Layer  Condition"));
        names.add(new Pair("Deletion_2", "Deletion Layer Conditions"));
        names.add(new Pair("Nondeletion", "Nondeletion Layer Conditions"));
        return names;
    }

    public LayerTerminationCondTable(TerminationLGTS termination) {
        super((Frame)new JFrame(), false);
        this.setTitle("Termination of LGTS");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LayerTerminationCondTable.this.setVisible(false);
                LayerTerminationCondTable.this.dispose();
            }
        });
        this.termination = termination;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel main = new JPanel(new BorderLayout());
        main.setBackground(Color.lightGray);
        this.panel = new JPanel(gridbag);
        this.scrLayer = new JScrollPane();
        this.scrLayer.setBackground(Color.orange);
        this.scrLayer.setBorder(new TitledBorder(" Termination Conditions of LGTS "));
        JPanel rowHead = new JPanel();
        rowHead.setLayout(new GridLayout(termination.getOrderedRuleLayer().size(), 1));
        Enumeration en = termination.getOrderedRuleLayer().elements();
        while (en.hasMoreElements()) {
            String text = ((Integer)en.nextElement()).toString();
            JLabel act = new JLabel(" Layer " + text + " ");
            act.setToolTipText("");
            rowHead.add(act);
        }
        JPanel colHead = new JPanel();
        colHead.setLayout(new GridLayout(1, 3));
        this.conds = LayerTerminationCondTable.getConditionsName();
        en = this.conds.elements();
        while (en.hasMoreElements()) {
            String text = (String)((Pair)en.nextElement()).first;
            JLabel act = new JLabel(" " + text);
            act.setToolTipText("");
            colHead.add(act);
        }
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new GridLayout(termination.getOrderedRuleLayer().size(), 3));
        for (int i = 0; i < termination.getOrderedRuleLayer().size(); ++i) {
            for (int ii = 0; ii < 3; ++ii) {
                JButton act = new JButton("   ");
                act.setToolTipText((String)((Pair)this.conds.elementAt((int)ii)).first);
                act.setMinimumSize(new Dimension(act.getHeight(), act.getHeight()));
                act.addActionListener(this);
                this.addButton((Integer)termination.getOrderedRuleLayer().elementAt(i), (String)((Pair)this.conds.elementAt((int)ii)).first, act);
                this.tablePanel.add(act);
                this.refreshView((Integer)termination.getOrderedRuleLayer().elementAt(i), (String)((Pair)this.conds.elementAt((int)ii)).first, act);
            }
        }
        Dimension dim = this.tablePanel.getPreferredSize();
        Dimension dim1 = new Dimension();
        dim1.setSize(dim.getWidth() + 50.0, dim.getHeight() + 20.0);
        Dimension dim2 = new Dimension();
        dim2.setSize(dim1.getWidth(), colHead.getPreferredSize().getHeight());
        colHead.setMinimumSize(dim2);
        colHead.setPreferredSize(dim2);
        dim2 = new Dimension();
        dim2.setSize(rowHead.getPreferredSize().getWidth(), dim1.getHeight());
        rowHead.setPreferredSize(dim2);
        rowHead.setMinimumSize(dim2);
        this.tablePanel.setPreferredSize(dim1);
        this.tablePanel.setMinimumSize(dim1);
        this.scrLayer.setRowHeaderView(rowHead);
        this.scrLayer.setColumnHeaderView(colHead);
        this.scrLayer.setViewportView(this.tablePanel);
        this.scrLayer.setCorner("UPPER_LEFT_CORNER", new JLabel(""));
        this.constrainBuild(this.panel, this.scrLayer, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LayerTerminationCondTable.this.setVisible(false);
                LayerTerminationCondTable.this.dispose();
            }
        });
        main.add((Component)this.panel, "Center");
        main.add((Component)closeButton, "South");
        main.revalidate();
        this.setContentPane(main);
        this.validate();
        this.pack();
        this.setLocation(200, 100);
    }

    public void showGUI() {
        this.setVisible(true);
        this.w = this.getWidth();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Integer layer = (Integer)this.firstLayers.get(source);
        String second = (String)this.secondConds.get(source);
        if (this.lastButton != null) {
            this.lastButton.setText("");
        }
        if (layer != null && second != null) {
            if (this.scrLayer != null) {
                this.panel.remove(this.scrLayer);
            }
            if (this.tableRule != null) {
                this.panel.remove(this.tableRule);
            }
            if (this.tableTypeDeletion != null) {
                this.panel.remove(this.tableTypeDeletion);
            }
            if (this.tableTypeCreation != null) {
                this.panel.remove(this.tableTypeCreation);
            }
            ((JButton)source).setText("X");
            this.h = (int)this.scrLayer.getPreferredSize().getHeight();
            this.constrainBuild(this.panel, this.scrLayer, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
            Vector rules = this.getRules(layer, second);
            if (rules.size() != 0) {
                this.tableRule = new RuleTable(rules, " Rules of the Layer  " + layer);
                this.tableRule.setPreferredSize(new Dimension(this.w, this.tableRule.getTableHeight()));
                this.h += (int)this.tableRule.getPreferredSize().getHeight();
                this.constrainBuild(this.panel, this.tableRule, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                if (second.equals("Deletion_1")) {
                    Vector deletionTypeTypes = this.getTypes(layer, "Deletion_1");
                    this.tableTypeDeletion = new TypeTable(deletionTypeTypes, " Type - Deletion ");
                    this.tableTypeDeletion.setPreferredSize(new Dimension(this.w, this.tableTypeDeletion.getTableHeight()));
                    this.h += (int)this.tableTypeDeletion.getPreferredSize().getHeight();
                    this.constrainBuild(this.panel, this.tableTypeDeletion, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                } else if (second.equals("Deletion_2")) {
                    Vector deletionTypes = this.getTypes(layer, "Deletion_2");
                    this.tableTypeDeletion = new TypeTable(deletionTypes, " Type  Deletion of the Layer  " + layer);
                    this.tableTypeDeletion.setPreferredSize(new Dimension(this.w, this.tableTypeDeletion.getTableHeight()));
                    this.h += (int)this.tableTypeDeletion.getPreferredSize().getHeight();
                    this.constrainBuild(this.panel, this.tableTypeDeletion, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    Vector creationTypes = this.getCreatedTypesOnDeletionLayer(layer);
                    if (creationTypes.size() != 0) {
                        this.tableTypeCreation = new TypeTable(creationTypes, " Type  Creation of the Layer  " + layer);
                        this.tableTypeCreation.setPreferredSize(new Dimension(this.w, this.tableTypeCreation.getTableHeight()));
                        this.h += (int)this.tableTypeCreation.getPreferredSize().getHeight();
                        this.constrainBuild(this.panel, this.tableTypeCreation, 0, 3, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    }
                } else if (second.equals("Nondeletion")) {
                    Vector creationTypes = this.getTypes(layer, "Nondeletion");
                    this.tableTypeCreation = new TypeTable(creationTypes, " Type  Creation of the Layer  " + layer);
                    this.tableTypeCreation.setPreferredSize(new Dimension(this.w, this.tableTypeCreation.getTableHeight()));
                    this.constrainBuild(this.panel, this.tableTypeCreation, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    this.h += (int)this.tableTypeCreation.getPreferredSize().getHeight();
                }
            }
            this.h += 50;
            this.panel.setPreferredSize(new Dimension(this.w, this.h));
            this.panel.revalidate();
            this.setSize(this.w + 50, this.h + 80);
            this.validate();
            this.lastButton = (JButton)source;
        }
    }

    void addButton(Integer layer, String condName, JButton button) {
        Hashtable<String, JButton> hash1 = (Hashtable<String, JButton>)this.buttons.get(layer);
        if (hash1 == null) {
            hash1 = new Hashtable<String, JButton>();
            this.buttons.put(layer, hash1);
        }
        hash1.put(condName, button);
        this.firstLayers.put(button, layer);
        this.secondConds.put(button, condName);
    }

    JButton getButton(Integer layer, String condName) {
        Hashtable hash1 = (Hashtable)this.buttons.get(layer);
        if (hash1 == null) {
            return null;
        }
        return (JButton)hash1.get(condName);
    }

    public void refreshView() {
        Enumeration en1 = this.buttons.keys();
        while (en1.hasMoreElements()) {
            Integer first = (Integer)en1.nextElement();
            Enumeration en2 = ((Hashtable)this.buttons.get(first)).keys();
            while (en2.hasMoreElements()) {
                String second = (String)en2.nextElement();
                this.refreshView(first, second);
            }
        }
    }

    void refreshView(Integer first, String second) {
        this.refreshView(first, second, this.getButton(first, second));
    }

    void refreshView(Integer layer, String cond, JButton button) {
        boolean value = this.getValue(layer, cond);
        if (value) {
            button.setBackground(VALID);
            button.setText(" ");
        } else {
            button.setBackground(NOT_VALID);
            button.setText(" ");
        }
    }

    private boolean getValue(Integer layer, String condName) {
        if (condName.equals("Deletion_1")) {
            Pair value = (Pair)this.termination.getResultTypeDeletion().get(layer);
            return (Boolean)value.first;
        }
        if (condName.equals("Deletion_2")) {
            Pair value = (Pair)this.termination.getResultDeletion().get(layer);
            return (Boolean)value.first;
        }
        if (condName.equals("Nondeletion")) {
            Pair value = (Pair)this.termination.getResultNondeletion().get(layer);
            return (Boolean)value.first;
        }
        return false;
    }

    private Vector getRules(Integer layer, String condName) {
        Pair p;
        Vector<String> names = new Vector<String>();
        boolean result = false;
        if (condName.equals("Deletion_1")) {
            p = (Pair)this.termination.getResultTypeDeletion().get(layer);
            result = (Boolean)p.first;
        } else if (condName.equals("Deletion_2")) {
            p = (Pair)this.termination.getResultDeletion().get(layer);
            result = (Boolean)p.first;
        } else if (condName.equals("Nondeletion")) {
            p = (Pair)this.termination.getResultNondeletion().get(layer);
            result = (Boolean)p.first;
        }
        if (result) {
            HashSet rulesForLayer = (HashSet)this.termination.getInvertedRuleLayer().get(layer);
            Enumeration en = rulesForLayer.elements();
            while (en.hasMoreElements()) {
                Rule rule = (Rule)en.nextElement();
                names.addElement(rule.getName());
            }
        }
        return names;
    }

    private Vector getTypes(Integer layer, String condName) {
        Vector<String> names = new Vector<String>();
        HashSet typesForLayer = null;
        if (condName.equals("Deletion_1")) {
            Vector types;
            if (this.termination.getDeletionType() != null && this.termination.getDeletionType().containsKey(layer) && (types = (Vector)this.termination.getDeletionType().get(layer)) != null) {
                Enumeration en = types.elements();
                while (en.hasMoreElements()) {
                    Type t = (Type)en.nextElement();
                    if (t.getStringRepr().equals("")) {
                        names.addElement("(unnamed)");
                        continue;
                    }
                    names.addElement(t.getStringRepr());
                }
            }
            return names;
        }
        if (condName.equals("Deletion_2")) {
            if (this.termination.getInvertedTypeDeletionLayer() != null && this.termination.getInvertedTypeDeletionLayer().containsKey(layer)) {
                typesForLayer = (HashSet)this.termination.getInvertedTypeDeletionLayer().get(layer);
            }
        } else if (condName.equals("Nondeletion") && this.termination.getInvertedTypeCreationLayer() != null && this.termination.getInvertedTypeCreationLayer().containsKey(layer)) {
            typesForLayer = (HashSet)this.termination.getInvertedTypeCreationLayer().get(layer);
        }
        if (typesForLayer != null) {
            Enumeration en = typesForLayer.elements();
            while (en.hasMoreElements()) {
                Type t = (Type)en.nextElement();
                if (t.getStringRepr().equals("")) {
                    names.addElement("(unnamed)");
                    continue;
                }
                names.addElement(t.getStringRepr());
            }
        }
        return names;
    }

    private Vector getCreatedTypesOnDeletionLayer(Integer layer) {
        Vector<String> names = new Vector<String>();
        Vector types = this.termination.getCreatedTypesOnDeletionLayer(layer);
        Enumeration en = types.elements();
        while (en.hasMoreElements()) {
            Type t = (Type)en.nextElement();
            if (t.getStringRepr().equals("")) {
                names.addElement("(unnamed)");
                continue;
            }
            names.addElement(t.getStringRepr());
        }
        return names;
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }
}

