/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.termination;

import agg.gui.HtmlBrowser;
import agg.gui.IconResource;
import agg.gui.termination.LayerTerminationCondTable;
import agg.termination.TerminationLGTS;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.Type;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class TerminationGUI
extends JDialog
implements ActionListener {
    private JPanel rulePanel;
    private JScrollPane ruleScrollPane;
    private JTable ruleTable;
    private JPanel creationPanel;
    private JScrollPane creationScrollPane;
    private JTable creationTable;
    private JPanel deletionPanel;
    private JScrollPane deletionScrollPane;
    private JTable deletionTable;
    private JButton checkButton;
    private JCheckBox generateCB;
    private JButton helpButton;
    private JButton closeButton;
    private JButton resetButton;
    private JButton acceptButton;
    private JButton moreButton;
    private JPanel contentPane;
    private JLabel statusLabel;
    private TerminationLGTS termination;
    private boolean generateRuleLayer;
    private boolean showCDLayer;
    private JPanel rcdPanel0;
    private boolean all;
    private Hashtable oldRuleLayer;
    private boolean result;
    private LayerTerminationCondTable tableLTC;
    private HtmlBrowser helpBrowser;
    private static final Icon OK_ICON = IconResource.getIconFromURL(IconResource.getOkIcon());
    private static final Icon WRONG_ICON = IconResource.getIconFromURL(IconResource.getWrongIcon());

    public TerminationGUI(JFrame parent, TerminationLGTS termination) {
        super((Frame)parent, false);
        this.setTitle("Termination of LGTS");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TerminationGUI.this.exitForm(evt);
            }
        });
        this.setBackground(Color.lightGray);
        if (parent != null) {
            this.setLocationRelativeTo(parent);
            this.setLocation(50, 50);
        } else {
            this.setLocation(50, 50);
        }
        this.oldRuleLayer = new Hashtable();
        this.termination = termination;
        Enumeration e = termination.getGrammar().getRules();
        while (e.hasMoreElements()) {
            Rule r = (Rule)e.nextElement();
            this.oldRuleLayer.put(r, new Integer(r.getLayer()));
        }
        this.initComponents();
        this.result = false;
    }

    public void init(TerminationLGTS termination) {
        this.termination = termination;
        this.oldRuleLayer = new Hashtable();
        Enumeration e = termination.getGrammar().getRules();
        while (e.hasMoreElements()) {
            Rule r = (Rule)e.nextElement();
            this.oldRuleLayer.put(r, new Integer(r.getLayer()));
        }
        this.initComponents();
        this.result = false;
    }

    private void initComponents() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        JPanel rcdPanel = new JPanel(new BorderLayout());
        this.rcdPanel0 = new JPanel(gridbag);
        this.rulePanel = new JPanel();
        this.rulePanel.setBackground(Color.orange);
        this.ruleScrollPane = new JScrollPane();
        this.rulePanel.setVisible(true);
        this.creationPanel = new JPanel();
        this.creationScrollPane = new JScrollPane();
        this.creationTable = new JTable();
        this.deletionPanel = new JPanel();
        this.deletionScrollPane = new JScrollPane();
        this.deletionTable = new JTable();
        this.checkButton = new JButton();
        this.closeButton = new JButton();
        this.resetButton = new JButton();
        this.acceptButton = new JButton();
        this.moreButton = new JButton();
        this.moreButton.setEnabled(false);
        this.helpButton = new JButton();
        this.statusLabel = new JLabel();
        this.rulePanel.setLayout(new BorderLayout());
        this.rulePanel.setBorder(new TitledBorder("Rule Layer"));
        this.ruleTable = new JTable(new HashTableModel(new RuleLayer(this.termination.getGrammar().getRules()), new String[]{"Rule Name", "Layer Number"}));
        this.ruleTable.doLayout();
        int h = this.getHeight(this.ruleTable.getRowCount(), this.ruleTable.getRowHeight());
        this.ruleScrollPane.setViewportView(this.ruleTable);
        this.ruleScrollPane.setPreferredSize(new Dimension(200, h));
        this.rulePanel.add(this.ruleScrollPane);
        this.creationPanel.setLayout(new BorderLayout());
        this.creationPanel.setBackground(Color.orange);
        this.creationPanel.setBorder(new TitledBorder("Creation Layer"));
        this.creationTable.setModel(new HashTableModel(this.termination.getCreationLayer(), new String[]{"Type", "Layer Number"}));
        this.creationTable.doLayout();
        this.creationTable.setEnabled(false);
        this.creationScrollPane.setViewportView(this.creationTable);
        this.creationScrollPane.setPreferredSize(new Dimension(200, 150));
        this.creationPanel.add(this.creationScrollPane);
        this.deletionPanel.setLayout(new BorderLayout());
        this.deletionPanel.setBackground(Color.orange);
        this.deletionPanel.setBorder(new TitledBorder("Deletion Layer"));
        this.deletionTable.setModel(new HashTableModel(this.termination.getDeletionLayer(), new String[]{"Type", "Layer Number"}));
        this.deletionTable.doLayout();
        this.deletionTable.setEnabled(false);
        this.deletionScrollPane.setViewportView(this.deletionTable);
        this.deletionScrollPane.setPreferredSize(new Dimension(200, 150));
        this.deletionPanel.add(this.deletionScrollPane);
        this.constrainBuild(this.rcdPanel0, this.rulePanel, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.all = false;
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setText("Are termination criteria satisfied?");
        this.statusLabel.setIcon(WRONG_ICON);
        this.statusLabel.setIconTextGap(5);
        try {
            this.statusLabel.setHorizontalTextPosition(2);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        rcdPanel.add((Component)this.statusLabel, "South");
        rcdPanel.add(this.rcdPanel0);
        JPanel checkPanel = new JPanel(new BorderLayout());
        JPanel checkBoxPanel = new JPanel(new GridLayout(0, 1));
        this.generateCB = new JCheckBox("generate rule layer", null, false);
        checkBoxPanel.add(this.generateCB);
        this.generateCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (TerminationGUI.this.generateCB.isSelected()) {
                    TerminationGUI.this.generateRuleLayer = true;
                } else {
                    TerminationGUI.this.generateRuleLayer = false;
                }
            }
        });
        JLabel layerLabel = new JLabel("  Creation / Deletion type layer will be generated automatically  ");
        checkBoxPanel.add(layerLabel);
        JLabel emptyLabel = new JLabel("               ");
        checkBoxPanel.add(emptyLabel);
        checkPanel.add(checkBoxPanel);
        JPanel buttonPanel = new JPanel(new GridLayout(0, 4, 5, 5));
        this.checkButton.setActionCommand("check");
        this.checkButton.setText("Check");
        this.checkButton.setToolTipText(" Check layer function ");
        this.checkButton.addActionListener(this);
        this.resetButton.setActionCommand("reset");
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(this);
        this.acceptButton.setActionCommand("accept");
        this.acceptButton.setText("Accept");
        this.acceptButton.addActionListener(this);
        this.moreButton.setActionCommand("more");
        this.moreButton.setText("More Info");
        this.moreButton.addActionListener(this);
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(this);
        this.helpButton.setActionCommand("help");
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(this);
        buttonPanel.add(this.checkButton);
        buttonPanel.add(this.moreButton);
        buttonPanel.add(this.resetButton);
        buttonPanel.add(this.acceptButton);
        buttonPanel.add(this.closeButton);
        buttonPanel.add(this.helpButton);
        checkPanel.add((Component)buttonPanel, "South");
        this.contentPane.add(rcdPanel);
        this.contentPane.add((Component)checkPanel, "South");
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object r;
        int i;
        HashTableModel htm;
        Object source = e.getSource();
        if (source == this.checkButton) {
            if (this.tableLTC != null) {
                this.tableLTC.setVisible(false);
            }
            this.termination.initRuleLayer(((HashTableModel)this.ruleTable.getModel()).getTable());
            if (!this.result) {
                this.termination.setGenerateRuleLayer(this.generateRuleLayer);
                this.termination.checkTermination();
                this.result = this.termination.isValid();
            }
            if (this.result) {
                Object t;
                int l;
                if (!this.all) {
                    this.ruleTable.doLayout();
                    int h = this.getHeight(this.creationTable.getRowCount(), this.creationTable.getRowHeight());
                    this.creationPanel.setPreferredSize(new Dimension(200, h));
                    this.creationTable.doLayout();
                    h = this.getHeight(this.deletionTable.getRowCount(), this.deletionTable.getRowHeight());
                    this.deletionPanel.setPreferredSize(new Dimension(200, h));
                    this.deletionTable.doLayout();
                    this.constrainBuild(this.rcdPanel0, this.creationPanel, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    this.constrainBuild(this.rcdPanel0, this.deletionPanel, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 10, 5);
                    this.setSize(this.getWidth(), this.getHeight() + 2 * h + 50);
                    this.validate();
                    this.all = true;
                }
                htm = (HashTableModel)this.ruleTable.getModel();
                for (i = 0; i < htm.getRowCount(); ++i) {
                    r = htm.getRuleAt(i, 0);
                    if (!(r instanceof Rule) || !this.generateRuleLayer) continue;
                    l = this.termination.getRuleLayer((Rule)r);
                    htm.setValueAt(String.valueOf(l), i, 1);
                }
                htm = (HashTableModel)this.creationTable.getModel();
                for (i = 0; i < htm.getRowCount(); ++i) {
                    t = htm.getTypeAt(i, 0);
                    l = this.termination.getCreationLayer((Type)t);
                    htm.setValueAt(String.valueOf(l), i, 1);
                }
                htm = (HashTableModel)this.deletionTable.getModel();
                for (i = 0; i < htm.getRowCount(); ++i) {
                    t = htm.getTypeAt(i, 0);
                    l = this.termination.getDeletionLayer((Type)t);
                    htm.setValueAt(String.valueOf(l), i, 1);
                }
                this.statusLabel.setIcon(OK_ICON);
            } else {
                this.statusLabel.setIcon(WRONG_ICON);
                JOptionPane.showMessageDialog(null, this.termination.getErrorMessage(), "Termination", 0);
            }
            this.moreButton.setEnabled(true);
        }
        if (source == this.closeButton) {
            if (this.termination.isValid()) {
                htm = (HashTableModel)this.ruleTable.getModel();
                for (i = 0; i < htm.getRowCount(); ++i) {
                    r = htm.getRuleAt(i, 0);
                    if (!(r instanceof Rule)) continue;
                    Integer v = (Integer)htm.getValueAt(i, 1);
                    ((Rule)r).setLayer(v);
                }
            }
            if (this.tableLTC != null) {
                this.tableLTC.setVisible(false);
                this.tableLTC.dispose();
            }
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.dispose();
            }
            this.setVisible(false);
            this.dispose();
        } else if (source == this.resetButton) {
            if (this.generateRuleLayer) {
                this.termination.initAll(this.generateRuleLayer);
            } else {
                this.termination.resetLayer();
            }
            this.resetLayer();
            this.result = false;
            this.statusLabel.setIcon(WRONG_ICON);
            if (this.tableLTC != null) {
                this.tableLTC.setVisible(false);
                this.tableLTC.dispose();
            }
            this.moreButton.setEnabled(false);
        } else if (source == this.acceptButton) {
            this.termination.saveRuleLayer();
        } else if (source == this.moreButton) {
            if (this.tableLTC != null) {
                this.tableLTC.refreshView();
                this.tableLTC.setVisible(true);
            } else {
                this.tableLTC = new LayerTerminationCondTable(this.termination);
                this.tableLTC.setLocation(this.getLocation().x + this.getWidth(), this.getLocation().y);
                this.tableLTC.showGUI();
            }
        } else if (source == this.helpButton) {
            if (this.helpBrowser != null) {
                this.helpBrowser.dispose();
                this.helpBrowser = null;
            }
            if (this.helpBrowser == null) {
                this.helpBrowser = new HtmlBrowser("TerminationHelp.html");
                this.helpBrowser.toFront();
            }
        }
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 3) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    private void resetLayer() {
        Object t;
        int l;
        int i;
        HashTableModel htm = (HashTableModel)this.ruleTable.getModel();
        for (i = 0; i < htm.getRowCount(); ++i) {
            Object r = htm.getRuleAt(i, 0);
            l = this.termination.getRuleLayer((Rule)r);
            htm.setValueAt(String.valueOf(l), i, 1);
        }
        htm = (HashTableModel)this.creationTable.getModel();
        for (i = 0; i < htm.getRowCount(); ++i) {
            t = htm.getTypeAt(i, 0);
            l = this.termination.getCreationLayer((Type)t);
            htm.setValueAt(String.valueOf(l), i, 1);
        }
        htm = (HashTableModel)this.deletionTable.getModel();
        for (i = 0; i < htm.getRowCount(); ++i) {
            t = htm.getTypeAt(i, 0);
            l = this.termination.getDeletionLayer((Type)t);
            htm.setValueAt(String.valueOf(l), i, 1);
        }
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable table;

        public HashTableModel(Hashtable table, String[] columnNames) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.addColumn(columnNames[i]);
            }
            this.table = table;
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = table.get(key);
                Vector<Object> tmpVector = new Vector<Object>();
                tmpVector.addElement(key);
                tmpVector.addElement(value);
                this.addRow(tmpVector);
            }
        }

        public HashTableModel(RuleLayer layer, String[] columnNames) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.addColumn(columnNames[i]);
            }
            this.table = layer.getRuleLayer();
            Integer startLayer = layer.getStartLayer();
            Hashtable invertedRuleLayer = layer.invertLayer();
            OrderedSet ruleLayer = new OrderedSet();
            Enumeration en = invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                ruleLayer.add(en.nextElement());
            }
            Integer currentLayer = startLayer;
            boolean nextLayerExists = true;
            while (nextLayerExists && currentLayer != null) {
                HashSet rulesForLayer = (HashSet)invertedRuleLayer.get(currentLayer);
                Enumeration en2 = rulesForLayer.elements();
                while (en2.hasMoreElements()) {
                    Rule rule = (Rule)en2.nextElement();
                    Vector<Object> tmpVector = new Vector<Object>();
                    tmpVector.addElement(rule);
                    tmpVector.addElement(new Integer(rule.getLayer()));
                    this.addRow(tmpVector);
                }
                OrderedSetIterator osi = ruleLayer.find(currentLayer);
                if (osi == null || osi.atEnd()) {
                    nextLayerExists = false;
                    continue;
                }
                osi.advance();
                currentLayer = (Integer)osi.get();
            }
        }

        public Hashtable getTable() {
            return this.table;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                result = ((Rule)result).getName();
            } else if (result instanceof Type) {
                result = !((Type)result).getStringRepr().equals("") ? ((Type)result).getStringRepr() : ((Type)result).getAdditionalRepr();
            }
            return result;
        }

        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                Integer i = new Integer((String)aValue);
                super.setValueAt(i, row, column);
                this.table.put(key, i);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }

        public Object getRuleAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                return result;
            }
            return null;
        }

        public Object getTypeAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Type) {
                return result;
            }
            return null;
        }
    }
}

