/*
 * Decompiled with CFR 0.152.
 */
package agg.layout;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdNode;
import agg.layout.LayoutNode;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import java.awt.Point;

public class LayoutArc
implements XMLObject {
    private EdArc eArc;
    private int prefLength;
    private int aktLength;
    private int xlength;
    private int ylength;
    private int force;
    private Point sourcepos;
    private Point targetpos;
    private int used;

    public LayoutArc(EdArc e) {
        this.eArc = e;
        this.prefLength = 200;
        this.aktLength = 200;
        this.force = 10;
        this.used = 0;
    }

    public LayoutArc(EdArc e, int prefL, int aktL, int f) {
        this.eArc = e;
        this.prefLength = prefL;
        this.aktLength = aktL;
        this.force = f;
    }

    public EdArc getEdArc() {
        return this.eArc;
    }

    public void setPrefLength(int p) {
        this.prefLength = p;
    }

    public void setAktLength(int a) {
        this.aktLength = a;
    }

    public void setForce(int f) {
        this.force = f;
    }

    public int getPrefLength() {
        return this.prefLength;
    }

    public int getAktLength() {
        return this.aktLength;
    }

    public int getForce() {
        return this.force;
    }

    public void setSourcepos(Point p) {
        this.sourcepos = new Point(p);
    }

    public void setTargetpos(Point p) {
        this.targetpos = new Point(p);
    }

    public Point getSourcepos() {
        return this.sourcepos;
    }

    public Point getTargetpos() {
        return this.targetpos;
    }

    public int getXLength() {
        return this.xlength;
    }

    public int getYLength() {
        return this.ylength;
    }

    public void calcSourceTargetpos() {
        LayoutNode snode = ((EdNode)this.getEdArc().getSource()).getLNode();
        LayoutNode tnode = ((EdNode)this.getEdArc().getTarget()).getLNode();
        this.setSourcepos(new Point(snode.getAkt().x + snode.getEdNode().getWidth() / 2, snode.getAkt().y + snode.getEdNode().getHeight() / 2));
        this.setTargetpos(new Point(tnode.getAkt().x + tnode.getEdNode().getWidth() / 2, tnode.getAkt().y + tnode.getEdNode().getHeight() / 2));
    }

    public void calcAktLength() {
        this.calcSourceTargetpos();
        this.xlength = Math.abs(this.sourcepos.x - this.targetpos.x);
        this.ylength = Math.abs(this.sourcepos.y - this.targetpos.y);
        this.aktLength = (int)Math.sqrt(this.xlength * this.xlength + this.ylength * this.ylength);
    }

    public int getUsed() {
        return this.used;
    }

    public void incUsed() {
        ++this.used;
    }

    public void resetUsed() {
        this.used = 0;
    }

    public void XwriteObject(XMLHelper h) {
        if (h.openObject(this.eArc.getBasisArc(), this)) {
            h.openSubTag("additionalLayout");
            h.addAttr("preflength", this.prefLength);
            h.addAttr("aktlength", this.aktLength);
            h.addAttr("force", this.force);
            h.close();
            h.close();
        }
    }

    public void XreadObject(XMLHelper h) {
        h.peekObject(this.eArc.getBasisArc(), this);
        if (h.readSubTag("additionalLayout")) {
            String s = h.readAttr("preflength");
            this.prefLength = s.length() == 0 || s == null ? 200 : Integer.parseInt(s);
            s = h.readAttr("aktlength");
            this.aktLength = s.length() == 0 || s == null ? 200 : Integer.parseInt(s);
            s = h.readAttr("force");
            this.force = s.length() == 0 || s == null ? 10 : Integer.parseInt(s);
            h.close();
        }
        h.close();
    }
}

