/*
 * Decompiled with CFR 0.152.
 */
package agg.layout;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.layout.LayoutArc;
import agg.layout.LayoutNode;
import agg.layout.LayoutPattern;
import java.awt.Dimension;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutMetrics {
    private int epsilon = 300;
    private int clusterplus = 0;
    private int clusterminus = 0;

    public int getArcArcIntersect(EdGraph eg) {
        int i;
        int ret = 0;
        Vector arcs = eg.getArcs();
        for (i = 0; i < arcs.size(); ++i) {
            ((EdArc)arcs.get(i)).getLArc().calcSourceTargetpos();
        }
        for (i = 0; i < arcs.size() - 1; ++i) {
            EdArc arc1 = (EdArc)arcs.get(i);
            if (!arc1.isLine()) continue;
            for (int j = i + 1; j < arcs.size(); ++j) {
                Line2D.Double line2;
                Line2D.Double line1;
                EdArc arc2 = (EdArc)arcs.get(j);
                if (!arc2.isLine() || arc1.getSource().equals(arc2.getSource()) || arc1.getSource().equals(arc2.getTarget()) || arc1.getTarget().equals(arc2.getSource()) || arc1.getTarget().equals(arc2.getTarget()) || !(line1 = new Line2D.Double(arc1.getLArc().getSourcepos(), arc1.getLArc().getTargetpos())).intersectsLine(line2 = new Line2D.Double(arc2.getLArc().getSourcepos(), arc2.getLArc().getTargetpos()))) continue;
                ++ret;
            }
        }
        return ret;
    }

    public int getArcNodeIntersect(EdGraph eg) {
        int ret = 0;
        Vector arcs = eg.getArcs();
        Vector nodes = eg.getNodes();
        for (int i = 0; i < arcs.size(); ++i) {
            EdArc arc = (EdArc)arcs.get(i);
            if (!arc.isLine()) continue;
            arc.getLArc().calcSourceTargetpos();
            for (int j = 0; j < nodes.size(); ++j) {
                Rectangle2D.Double rect;
                Line2D.Double line;
                EdNode node = (EdNode)nodes.get(j);
                if (arc.getSource().equals(node) || arc.getTarget().equals(node) || !(line = new Line2D.Double(arc.getLArc().getSourcepos(), arc.getLArc().getTargetpos())).intersects(rect = new Rectangle2D.Double(node.getX(), node.getY(), node.getWidth(), node.getHeight()))) continue;
                ++ret;
            }
        }
        return ret;
    }

    public int getNodeIntersect(EdGraph eg, boolean mark) {
        int ret = 0;
        Vector nodes = eg.getNodes();
        for (int i = 0; i < nodes.size() - 1; ++i) {
            EdNode node1 = (EdNode)nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                EdNode node2 = (EdNode)nodes.get(j);
                if (!this.nodesIntersect(node1, node2)) continue;
                ++ret;
                if (!mark) continue;
                node1.getLNode().setOverlap();
                node2.getLNode().setOverlap();
            }
        }
        return ret;
    }

    private boolean nodesIntersect(EdNode n1, EdNode n2) {
        Rectangle2D.Double rect2;
        boolean ret = false;
        Rectangle2D.Double rect1 = new Rectangle2D.Double(n1.getLNode().getAkt().x, n1.getLNode().getAkt().y, n1.getWidth(), n1.getHeight());
        if (rect1.intersects(rect2 = new Rectangle2D.Double(n2.getLNode().getAkt().x, n2.getLNode().getAkt().y, n2.getWidth(), n2.getHeight()))) {
            ret = true;
        }
        return ret;
    }

    public int getOverlappingNode(Vector<LayoutNode> lnodes, int index) {
        int ret = -1;
        LayoutNode node1 = lnodes.get(index);
        for (int i = 0; i < lnodes.size(); ++i) {
            if (i == index) continue;
            LayoutNode node2 = lnodes.get(i);
            if (!this.nodesIntersect(node1.getEdNode(), node2.getEdNode())) continue;
            ret = i;
            break;
        }
        return ret;
    }

    public int getOverallIntersect(EdGraph eg) {
        int ret = 0;
        ret += this.getArcArcIntersect(eg);
        ret += this.getArcNodeIntersect(eg) * 2;
        return ret += this.getNodeIntersect(eg, false) * 3;
    }

    private int getspaceusage(EdGraph eg) {
        Dimension dim = eg.getGraphDim();
        int ret = 0;
        Vector nodes = eg.getNodes();
        int parts = (int)Math.floor(Math.sqrt(nodes.size()));
        System.out.println("Parts: " + parts + "    dim x: " + dim.width + "    dim y: " + dim.height);
        ret = parts * parts;
        for (int i = 0; i < parts; ++i) {
            block1: for (int j = 0; j < parts; ++j) {
                Rectangle2D.Double partrect = new Rectangle2D.Double(i * (dim.width / parts), j * (dim.height / parts), dim.width / parts, dim.height / parts);
                for (int n = 0; n < nodes.size(); ++n) {
                    EdNode node = (EdNode)nodes.get(n);
                    if (!partrect.contains(node.getLNode().getAkt())) continue;
                    --ret;
                    continue block1;
                }
            }
        }
        return ret;
    }

    public int getAverageArcLengthDeviation(EdGraph eg) {
        int ret = 0;
        Vector arcs = eg.getArcs();
        int sum = 0;
        for (int i = 0; i < arcs.size(); ++i) {
            LayoutArc larc = ((EdArc)arcs.get(i)).getLArc();
            larc.calcAktLength();
            sum += Math.abs(larc.getPrefLength() - larc.getAktLength());
        }
        if (arcs.size() != 0) {
            ret = sum / arcs.size();
        }
        return ret;
    }

    public int getAverageNodeMove(EdGraph oldedgraph, EdGraph newedgraph) {
        int ret = 0;
        Vector oldednodes = oldedgraph.getNodes();
        Vector newednodes = newedgraph.getNodes();
        int sum = 0;
        for (int i = 0; i < newednodes.size(); ++i) {
            EdNode newednode = (EdNode)newednodes.get(i);
            LayoutNode newlnode = newednode.getLNode();
            int oldindex = newednode.isInVectorByBasisNode(oldednodes);
            if (oldindex == -1) continue;
            EdNode oldednode = (EdNode)oldednodes.get(oldindex);
            sum += Math.abs(newlnode.getAkt().x - oldednode.getX());
            sum += Math.abs(newlnode.getAkt().y - oldednode.getY());
        }
        ret = sum / newednodes.size();
        return ret;
    }

    public float getSingleDistance(int nodes, int arcs, int nodeOverlapping, int arcNodeOverlapping, int arcArcOverlapping) {
        float B = nodes;
        float C = arcs;
        float D = nodeOverlapping;
        float E = arcNodeOverlapping;
        float F = arcArcOverlapping;
        float singleDistance = B / (D + 1.0f) + (B + C) / (E + 1.0f) + C / (F + 1.0f);
        return singleDistance;
    }

    public float getMentalDistance(int nodes, int arcs, int movementsOfNodes, int movementsOfArcs) {
        float B = nodes;
        float C = arcs;
        float H = movementsOfNodes;
        float G = movementsOfArcs;
        float mentalDistance = H / B + G / C;
        return mentalDistance;
    }

    public float getLayoutQuality(float singleDistance, float mentalDistance) {
        float lquality = singleDistance - mentalDistance;
        return lquality;
    }

    public void calcClusterDiffs(EdGraph eg) {
        Vector nodes = eg.getNodes();
        int sumplus = 0;
        int summinus = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            int j;
            EdNode node = (EdNode)nodes.get(i);
            Vector<Integer> oldcluster = node.getOldCluster();
            Vector<Integer> newcluster = node.getCluster();
            if (oldcluster == null) {
                sumplus += newcluster.size();
                continue;
            }
            for (j = 0; j < oldcluster.size(); ++j) {
                if (newcluster.indexOf(oldcluster.get(j)) != -1) continue;
                ++summinus;
            }
            for (j = 0; j < newcluster.size(); ++j) {
                if (oldcluster.indexOf(newcluster.get(j)) != -1) continue;
                ++sumplus;
            }
        }
        this.clusterminus = summinus / nodes.size();
        this.clusterplus = sumplus / nodes.size();
    }

    public int getClusterMinus() {
        return this.clusterminus;
    }

    public int getClusterPlus() {
        return this.clusterplus;
    }

    public int getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(int e) {
        this.epsilon = e;
    }

    public int getPatternMistakes(EdGraph eg) {
        int ret = 0;
        EdGraGra edgra = eg.getGraGra();
        Vector arcs = eg.getArcs();
        int sum = 0;
        int diff = 0;
        for (int i = 0; i < arcs.size(); ++i) {
            EdArc arc = (EdArc)arcs.get(i);
            Vector<LayoutPattern> paterns = edgra.getLayoutPatternsForType(arc.getType().getBasisType());
            for (int j = 0; j < paterns.size(); ++j) {
                LayoutPattern lp = paterns.get(j);
                if (lp == null || !lp.isEdgePattern()) continue;
                EdNode source = (EdNode)arc.getSource();
                EdNode target = (EdNode)arc.getTarget();
                if (lp.isXOffset()) {
                    diff = target.getLNode().getAkt().x - source.getLNode().getAkt().x;
                    if (lp.getOffset() > 0) {
                        if (diff > 0) continue;
                        ++sum;
                        continue;
                    }
                    if (diff <= 0) continue;
                    ++sum;
                    continue;
                }
                diff = target.getLNode().getAkt().y - source.getLNode().getAkt().y;
                if (lp.getOffset() > 0) {
                    if (diff > 0) continue;
                    ++sum;
                    continue;
                }
                if (diff <= 0) continue;
                ++sum;
            }
        }
        ret = sum;
        return ret;
    }
}

