/*
 * Decompiled with CFR 0.152.
 */
package agg.layout;

import agg.editor.impl.EdNode;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import java.awt.Point;

public class LayoutNode
implements XMLObject {
    private EdNode enode;
    private Point akt;
    private Point opt;
    private Point sim;
    private Point kom;
    private int age;
    private int realage;
    private int force;
    private int zone;
    private int distx;
    private int disty;
    private int dist;
    private boolean overlap;
    private boolean frozen;

    public LayoutNode(EdNode e) {
        this.enode = e;
        this.akt = new Point(e.getX(), e.getY());
        this.opt = new Point(0, 0);
        this.sim = new Point(0, 0);
        this.kom = new Point(0, 0);
        this.age = 0;
        this.realage = 0;
        this.force = 10;
        this.zone = Math.max(Math.max(e.getHeight(), e.getWidth()) * 2, 50);
        this.dist = 0;
        this.distx = 0;
        this.disty = 0;
        this.overlap = false;
    }

    public LayoutNode(EdNode e, int x, int y, int a, int f, int zone) {
        this.enode = e;
        this.akt = new Point(x, y);
        this.age = a;
        this.realage = a;
        this.force = f;
        this.opt = new Point(0, 0);
        this.sim = new Point(0, 0);
        this.kom = new Point(0, 0);
        this.zone = Math.max(zone, 50);
        this.dist = 0;
        this.distx = 0;
        this.disty = 0;
    }

    public EdNode getEdNode() {
        return this.enode;
    }

    public void setAkt(Point a) {
        this.akt = a;
    }

    public Point getAkt() {
        return this.akt;
    }

    public void setOpt(Point o) {
        this.opt = o;
    }

    public Point getOpt() {
        return this.opt;
    }

    public void setSim(Point s) {
        this.sim = s;
    }

    public Point getSim() {
        return this.sim;
    }

    public void setKom(Point k) {
        this.kom = k;
    }

    public Point getKom() {
        return this.kom;
    }

    public void setForce(int f) {
        this.force = f;
    }

    public int getForce() {
        return this.force;
    }

    public void setFrozen(boolean b) {
        this.frozen = b;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setAge(int a) {
        this.age = a;
    }

    public int getAge() {
        return this.age;
    }

    public void incAge() {
        if (this.age == this.realage) {
            ++this.age;
            ++this.realage;
        } else if (this.age > this.realage) {
            ++this.realage;
        } else {
            ++this.realage;
            this.age = this.realage;
        }
    }

    public void setZone(int z) {
        this.zone = z;
    }

    public int getZone() {
        return this.zone;
    }

    public void setDist(int d) {
        this.dist = d;
    }

    public int getDist() {
        return this.dist;
    }

    public void setDistX(int d) {
        this.distx = d;
    }

    public int getDistX() {
        return this.distx;
    }

    public void setDistY(int d) {
        this.disty = d;
    }

    public int getDistY() {
        return this.disty;
    }

    public boolean isOverlapping() {
        return this.overlap;
    }

    public void setOverlap() {
        this.overlap = true;
    }

    public void unsetOverlap() {
        this.overlap = false;
    }

    public void XwriteObject(XMLHelper h) {
        if (h.openObject(this.enode.getBasisNode(), this)) {
            h.openSubTag("additionalLayout");
            if (this.frozen) {
                h.addAttr("frozen", "true");
            } else {
                h.addAttr("frozen", "false");
            }
            h.addAttr("age", this.age);
            h.addAttr("force", this.force);
            h.addAttr("zone", this.zone);
            h.close();
            h.close();
        }
    }

    public void XreadObject(XMLHelper h) {
        h.peekObject(this.enode.getBasisNode(), this);
        if (h.readSubTag("additionalLayout")) {
            String s = h.readAttr("frozen");
            this.frozen = s.equals("true");
            s = h.readAttr("age");
            this.age = s == null || s.length() == 0 ? 0 : Integer.parseInt(s);
            s = h.readAttr("force");
            this.force = s == null || s.length() == 0 ? 0 : Integer.parseInt(s);
            s = h.readAttr("zone");
            this.zone = s == null || s.length() == 0 ? 50 : Integer.parseInt(s);
            s = h.readAttr("akt_x");
            this.akt.x = s == null || s.length() == 0 ? this.enode.getX() : Integer.parseInt(s);
            s = h.readAttr("akt_y");
            this.akt.y = s == null || s.length() == 0 ? this.enode.getY() : Integer.parseInt(s);
            s = h.readAttr("opt_x");
            this.opt.x = s == null || s.length() == 0 ? 0 : Integer.parseInt(s);
            s = h.readAttr("opt_y");
            this.opt.y = s == null || s.length() == 0 ? 0 : Integer.parseInt(s);
            s = h.readAttr("sim_x");
            this.sim.x = s == null || s.length() == 0 ? 0 : Integer.parseInt(s);
            s = h.readAttr("sim_y");
            this.sim.y = s == null || s.length() == 0 ? 0 : Integer.parseInt(s);
            s = h.readAttr("kom_x");
            this.kom.x = s == null || s.length() == 0 ? 0 : Integer.parseInt(s);
            s = h.readAttr("kom_y");
            this.kom.y = s == null || s.length() == 0 ? 0 : Integer.parseInt(s);
            h.close();
        }
        h.close();
    }
}

