/*
 * Decompiled with CFR 0.152.
 */
package agg.layout;

import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Type;

public class LayoutPattern
implements XMLObject {
    String name;
    String patternType;
    Type type;
    int edgeLength;
    char offsetType;
    int xOffset;
    int yOffset;
    boolean freezing;

    public LayoutPattern(Type t) {
        this.type = t;
    }

    public LayoutPattern(String name, String pType, Type t, char offsetType, int offset) {
        this.name = name;
        this.patternType = pType;
        this.type = t;
        this.offsetType = offsetType;
        if (offsetType == 'x') {
            this.xOffset = offset;
            this.yOffset = 0;
        } else {
            this.xOffset = 0;
            this.yOffset = offset;
        }
        this.edgeLength = 0;
    }

    public LayoutPattern(String name, String pType, Type t, int edgelength) {
        if (pType.equals("edge")) {
            this.name = name;
            this.patternType = pType;
            this.type = t;
            this.offsetType = (char)108;
            this.edgeLength = edgelength;
        }
    }

    public LayoutPattern(String name, String pType, Type t, boolean freezing) {
        if (pType.equals("node")) {
            this.name = name;
            this.patternType = pType;
            this.type = t;
            this.freezing = freezing;
            this.offsetType = (char)102;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isEdgePattern() {
        boolean ret = false;
        if (this.patternType.compareTo("edge") == 0) {
            ret = true;
        }
        return ret;
    }

    public boolean isNodePattern() {
        boolean ret = false;
        if (this.patternType.equals("node")) {
            ret = true;
        }
        return ret;
    }

    public boolean isFreezingPattern() {
        return this.name.equals("freezing_node");
    }

    public boolean isLengthPattern() {
        boolean ret = false;
        if (this.offsetType == 'l') {
            ret = true;
        }
        return ret;
    }

    public int getLength() {
        return this.edgeLength;
    }

    public boolean isXOffset() {
        boolean ret = false;
        if (this.offsetType == 'x') {
            ret = true;
        }
        return ret;
    }

    public boolean isYOffset() {
        boolean ret = false;
        if (this.offsetType == 'y') {
            ret = true;
        }
        return ret;
    }

    public int getOffset() {
        int ret = 0;
        if (this.offsetType == 'x') {
            ret = this.xOffset;
        } else if (this.offsetType == 'y') {
            ret = this.yOffset;
        } else if (this.offsetType == 'l') {
            ret = this.edgeLength;
        }
        return ret;
    }

    public Type getEffectedType() {
        return this.type;
    }

    public boolean isSimilarTo(LayoutPattern lp) {
        if (this.name.equals(lp.getName()) && (this.isEdgePattern() && lp.isEdgePattern() || this.isNodePattern() && lp.isNodePattern()) && this.getEffectedType() != null && lp.getEffectedType() != null && this.getEffectedType().compareTo(lp.getEffectedType())) {
            if (this.isLengthPattern() && lp.isLengthPattern()) {
                return true;
            }
            if (this.isXOffset() && lp.isXOffset()) {
                return true;
            }
            if (this.isYOffset() && lp.isYOffset()) {
                return true;
            }
            if (this.isFreezingPattern() && lp.isFreezingPattern()) {
                return true;
            }
        }
        return false;
    }

    public void XwriteObject(XMLHelper h) {
        h.openNewElem("LayoutPattern", this);
        h.addAttr("name", this.name);
        h.addAttr("patterntype", this.patternType);
        h.addAttr("kind", String.valueOf(this.offsetType));
        if (this.offsetType == 'x') {
            h.addAttr("value", String.valueOf(this.xOffset));
        } else if (this.offsetType == 'y') {
            h.addAttr("value", String.valueOf(this.yOffset));
        } else if (this.offsetType == 'l') {
            h.addAttr("value", String.valueOf(this.edgeLength));
        } else if (this.offsetType == 'f') {
            h.addAttr("value", String.valueOf("true"));
        }
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("LayoutPattern", this)) {
            this.name = h.readAttr("name");
            this.patternType = h.readAttr("patterntype");
            this.offsetType = h.readAttr("kind").charAt(0);
            if (this.offsetType == 'x') {
                this.xOffset = Integer.parseInt(h.readAttr("value"));
            } else if (this.offsetType == 'y') {
                this.yOffset = Integer.parseInt(h.readAttr("value"));
            } else if (this.offsetType == 'l') {
                this.edgeLength = Integer.parseInt(h.readAttr("value"));
            } else if (this.offsetType == 'f') {
                this.freezing = Boolean.parseBoolean(h.readAttr("value"));
            }
            h.close();
        }
    }
}

