/*
 * Decompiled with CFR 0.152.
 */
package agg.layout;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.layout.LayoutArc;
import agg.layout.LayoutMetrics;
import agg.layout.LayoutNode;
import agg.layout.LayoutPattern;
import agg.xt_basis.Arc;
import agg.xt_basis.Type;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layouter {
    boolean jpgOutput;
    boolean enabled;
    Dimension panel;
    LayoutMetrics lmetric;
    EdGraph oldedgraph;
    int generalEdgeLength;
    int temperature;
    boolean usepattern;
    boolean docenter;
    boolean writemetricvalues;
    int iterations;
    int nodeIntersectionIterations;
    int edgeIntersectionIterations;
    private Hashtable<Type, Vector<LayoutPattern>> layoutPatterns;
    private Hashtable<LayoutNode, Type> layoutNode2Type;
    private Random random = new Random();

    public Layouter(int temp, Dimension panel) {
        this.temperature = temp;
        this.panel = panel;
        this.lmetric = new LayoutMetrics();
        this.oldedgraph = null;
        this.jpgOutput = true;
        this.enabled = false;
        this.usepattern = true;
        this.docenter = false;
        this.writemetricvalues = true;
        this.iterations = 100;
        this.nodeIntersectionIterations = 1;
        this.edgeIntersectionIterations = 50;
        this.generalEdgeLength = 200;
        this.layoutPatterns = new Hashtable();
        this.layoutNode2Type = new Hashtable();
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private int getAttrForce(int d, int z) {
        return d * d / z;
    }

    private int getRepulseForce(int d, int z) {
        return z * z / Math.abs(d);
    }

    private int cool(int temp, int it) {
        int ret = temp - temp / (it + 2);
        return ret;
    }

    private int reduceTempByAge(int temp, int age, int gage) {
        int ret = gage == 0 ? temp : temp - temp / (gage - age + 1);
        return ret;
    }

    public void createInheritancePattern(Vector<Arc> inheritanceArcs) {
        for (int i = 0; i < inheritanceArcs.size(); ++i) {
            Arc inharc = inheritanceArcs.get(i);
            String inhTypeName = inharc.getSource().getType().getName() + "-INHERITS-" + inharc.getTarget().getType().getName();
            Vector<LayoutPattern> v = this.getLayoutPatternsForType(inharc.getType());
            if (!v.isEmpty()) {
                v.clear();
            }
            this.createLayoutPattern("ver_tree", "edge", inharc.getType(), 'y', -1);
            this.createLayoutPattern("edge_length", "edge", inharc.getType(), 150);
        }
    }

    private Vector<LayoutPattern> getInheritancePattern(EdArc edge) {
        Object v = null;
        if (edge.getBasisArc().isInheritance()) {
            String inhTypeName = edge.getBasisArc().getSource().getType().getName() + "-INHERITS-" + edge.getBasisArc().getTarget().getType().getName();
            return this.getLayoutPatternsForType(edge.getBasisArc().getType());
        }
        return null;
    }

    public void layout(EdGraph egraph) {
        this.layout(egraph, this.nodeIntersectionIterations);
    }

    public void layout(EdGraph egraph, int it) {
        Vector<LayoutNode> lnodes = this.getLayoutNodes(egraph);
        Vector<LayoutArc> larcs = this.getLayoutArcs(egraph);
        Dimension neededpanelsize = this.panel;
        int iters = it;
        iters = this.iterations;
        int deltax = 0;
        int deltay = 0;
        int temp = this.temperature;
        for (int i = 0; i < iters; ++i) {
            this.calcNodeRepulse(lnodes);
            for (int j = 0; j < larcs.size(); ++j) {
                LayoutArc larc = larcs.get(j);
                if (!larc.getEdArc().isLine()) continue;
                LayoutNode lnodev = ((EdNode)larc.getEdArc().getSource()).getLNode();
                LayoutNode lnodeu = ((EdNode)larc.getEdArc().getTarget()).getLNode();
                deltax = lnodev.getAkt().x - lnodeu.getAkt().x;
                deltay = lnodev.getAkt().y - lnodeu.getAkt().y;
                if (deltax != 0) {
                    lnodev.setDistX(lnodev.getDistX() - deltax / Math.abs(deltax) * this.getAttrForce(deltax, lnodev.getZone()));
                    lnodeu.setDistX(lnodeu.getDistX() + deltax / Math.abs(deltax) * this.getAttrForce(deltax, lnodeu.getZone()));
                }
                if (deltay == 0) continue;
                lnodev.setDistY(lnodev.getDistY() - deltay / Math.abs(deltay) * this.getAttrForce(deltay, lnodev.getZone()));
                lnodeu.setDistY(lnodeu.getDistY() + deltay / Math.abs(deltay) * this.getAttrForce(deltay, lnodeu.getZone()));
            }
            this.calcDistToPos(egraph, lnodes, temp, egraph.getGraphGen());
            temp = this.cool(temp, i);
            if (temp == 0) break;
        }
        egraph.updateNodePosLtoE();
        egraph.setGraphDim(neededpanelsize);
    }

    private void calcNodeRepulse(Vector<LayoutNode> lnodes) {
        for (int j = 0; j < lnodes.size(); ++j) {
            LayoutNode lnodev = lnodes.get(j);
            if (this.isFrozen(lnodev)) continue;
            lnodev.setDistX(0);
            lnodev.setDistY(0);
            for (int k = 0; k < lnodes.size(); ++k) {
                LayoutNode lnodeu = lnodes.get(k);
                if (lnodev.equals(lnodeu)) continue;
                int deltax = lnodev.getAkt().x - lnodeu.getAkt().x;
                int deltay = lnodev.getAkt().y - lnodeu.getAkt().y;
                if (deltax != 0) {
                    lnodev.setDistX(lnodev.getDistX() + deltax / Math.abs(deltax) * this.getRepulseForce(deltax, lnodev.getZone()));
                }
                if (deltay != 0) {
                    lnodev.setDistY(lnodev.getDistY() + deltay / Math.abs(deltay) * this.getRepulseForce(deltay, lnodev.getZone()));
                }
                if (deltax != 0 || deltay != 0) continue;
                int r = this.random.nextInt() % 200;
                lnodev.setDistX(lnodev.getDistX() + r);
                lnodev.setDistY(lnodev.getDistY() - r);
            }
        }
    }

    private void calcDistToPos(EdGraph eg, Vector<LayoutNode> lnodes, int temp, int gage) {
        int newy;
        int newx;
        for (int j = 0; j < lnodes.size(); ++j) {
            LayoutNode lnodev = lnodes.get(j);
            if (this.isFrozen(lnodev)) continue;
            newx = lnodev.getAkt().x;
            newy = lnodev.getAkt().y;
            int minx = 0;
            int miny = 0;
            int age = lnodev.getAge();
            int akttemp = this.reduceTempByAge(temp, age, gage);
            if (lnodev.getDistX() != 0) {
                minx = Math.min(Math.abs(lnodev.getDistX()), akttemp);
                newx = lnodev.getDistX() >= 0 ? (newx += minx) : (newx -= minx);
            }
            if (lnodev.getDistY() != 0) {
                miny = Math.min(Math.abs(lnodev.getDistY()), akttemp);
                newy = lnodev.getDistY() >= 0 ? (newy += miny) : (newy -= miny);
            }
            Point newp = this.getRandomPosIfNeeded(newx, newy, lnodev);
            lnodev.setOpt(newp);
            lnodev.setAkt(newp);
        }
        if (this.usepattern) {
            Vector arcs = eg.getArcs();
            for (int i = 0; i < arcs.size(); ++i) {
                EdArc arc = (EdArc)arcs.get(i);
                Vector<LayoutPattern> patterns = null;
                if (arc.isElementOfTypeGraph()) {
                    patterns = this.getInheritancePattern(arc);
                }
                if (patterns == null) {
                    patterns = this.getLayoutPatternsForType(arc.getType().getBasisType());
                }
                for (int p = 0; p < patterns.size(); ++p) {
                    LayoutPattern lp = patterns.get(p);
                    if (lp == null || !lp.isEdgePattern()) continue;
                    LayoutNode source = ((EdNode)arc.getSource()).getLNode();
                    LayoutNode target = ((EdNode)arc.getTarget()).getLNode();
                    if (lp.isXOffset()) {
                        if (lp.getOffset() > 0) {
                            if (!this.isFrozen(target)) {
                                newx = Math.max(target.getAkt().x, source.getAkt().x + 4);
                                newy = target.getAkt().y;
                                target.setAkt(new Point(newx, newy));
                            } else if (!this.isFrozen(source)) {
                                newx = Math.min(target.getAkt().x - 1, source.getAkt().x);
                                newy = source.getAkt().y;
                                source.setAkt(new Point(newx, newy));
                            }
                        } else if (!this.isFrozen(source)) {
                            newx = Math.max(target.getAkt().x + 1, source.getAkt().x);
                            newy = source.getAkt().y;
                            source.setAkt(new Point(newx, newy));
                        } else if (!this.isFrozen(target)) {
                            newx = Math.min(target.getAkt().x, source.getAkt().x - 4);
                            newy = target.getAkt().y;
                            target.setAkt(new Point(newx, newy));
                        }
                    }
                    if (!lp.isYOffset()) continue;
                    if (lp.getOffset() > 0) {
                        if (!this.isFrozen(target)) {
                            newy = Math.max(target.getAkt().y, source.getAkt().y + 4);
                            newx = target.getAkt().x;
                            target.setAkt(new Point(newx, newy));
                            continue;
                        }
                        if (this.isFrozen(source)) continue;
                        newy = Math.min(target.getAkt().y - 1, source.getAkt().y);
                        newx = source.getAkt().x;
                        source.setAkt(new Point(newx, newy));
                        continue;
                    }
                    if (!this.isFrozen(source)) {
                        newy = Math.max(target.getAkt().y + 1, source.getAkt().y);
                        newx = source.getAkt().x;
                        source.setAkt(new Point(newx, newy));
                        continue;
                    }
                    if (this.isFrozen(target)) continue;
                    newy = Math.min(target.getAkt().y, source.getAkt().y - 4);
                    newx = target.getAkt().x;
                    target.setAkt(new Point(newx, newy));
                }
            }
        }
    }

    public void layoutByArcLength(EdGraph eg) {
        this.layoutByArcLength(eg, this.edgeIntersectionIterations, this.temperature);
    }

    public boolean layoutByArcLength(EdGraph eg, int it, int temp) {
        EdArc arc;
        Vector arcs = eg.getArcs();
        int gage = eg.getGraphGen();
        int iters = it;
        if (arcs.size() == 0) {
            return false;
        }
        for (int i = 0; i < arcs.size(); ++i) {
            arc = (EdArc)arcs.get(i);
            arc.getLArc().calcAktLength();
            arc.getLArc().resetUsed();
        }
        boolean layoutDone = false;
        for (int i = 0; i < iters; ++i) {
            int tynew;
            int synew;
            int txnew;
            int sxnew;
            int ychange;
            int xchange;
            int abw;
            LayoutArc larc;
            layoutDone = false;
            int max = 0;
            int index = -1;
            for (int j = 0; j < arcs.size(); ++j) {
                EdArc edarc = (EdArc)arcs.get(j);
                larc = edarc.getLArc();
                int prefLength = larc.getPrefLength();
                LayoutPattern lpat = this.getLayoutPatternForType(edarc.getBasisArc().getType(), "edge_length");
                if (lpat != null && lpat.getLength() > 0) {
                    prefLength = lpat.getLength();
                }
                if ((abw = Math.abs(prefLength - larc.getAktLength())) / (larc.getUsed() + 1) <= max) continue;
                max = abw;
                index = j;
            }
            if (index == -1) continue;
            arc = (EdArc)arcs.get(index);
            larc = arc.getLArc();
            larc.incUsed();
            if (max < 20) break;
            LayoutNode source = ((EdNode)arc.getSource()).getLNode();
            LayoutNode target = ((EdNode)arc.getTarget()).getLNode();
            int prefLength = larc.getPrefLength();
            LayoutPattern lpat = this.getLayoutPatternForType(arc.getBasisArc().getType(), "edge_length");
            if (lpat != null && lpat.getLength() > 0) {
                prefLength = lpat.getLength();
            }
            abw = larc.getAktLength() - prefLength;
            if (larc.getXLength() != 0 && larc.getYLength() != 0) {
                xchange = Math.abs(abw / 2 * larc.getXLength() / larc.getAktLength());
                ychange = Math.abs(abw / 2 * larc.getYLength() / larc.getAktLength());
            } else if (larc.getXLength() == 0) {
                xchange = 0;
                ychange = Math.abs(abw / 2);
            } else {
                xchange = Math.abs(abw / 2);
                ychange = 0;
            }
            int age = source.getAge();
            int akttemp = this.reduceTempByAge(temp, age, gage);
            int sxchange = Math.min(xchange, akttemp) * (abw / Math.abs(abw));
            int sychange = Math.min(ychange, akttemp) * (abw / Math.abs(abw));
            age = target.getAge();
            akttemp = this.reduceTempByAge(temp, age, gage);
            int txchange = Math.min(xchange, akttemp) * (abw / Math.abs(abw));
            int tychange = Math.min(ychange, akttemp) * (abw / Math.abs(abw));
            if (source.getAkt().x <= target.getAkt().x) {
                sxnew = source.getAkt().x + sxchange;
                txnew = target.getAkt().x - txchange;
            } else {
                sxnew = source.getAkt().x - sxchange;
                txnew = target.getAkt().x + txchange;
            }
            if (source.getAkt().y <= target.getAkt().y) {
                synew = source.getAkt().y + sychange;
                tynew = target.getAkt().y - tychange;
            } else {
                synew = source.getAkt().y - sychange;
                tynew = target.getAkt().y + tychange;
            }
            Point newsp = this.getRandomPosIfNeeded(sxnew, synew, source);
            sxnew = newsp.x;
            synew = newsp.y;
            Point newtp = this.getRandomPosIfNeeded(txnew, tynew, target);
            txnew = newtp.x;
            tynew = newtp.y;
            if (this.usepattern) {
                Vector<LayoutPattern> patterns = null;
                if (arc.isElementOfTypeGraph()) {
                    patterns = this.getInheritancePattern(arc);
                }
                if (patterns == null) {
                    patterns = this.getLayoutPatternsForType(arc.getType().getBasisType());
                }
                for (int p = 0; p < patterns.size(); ++p) {
                    LayoutPattern lp = patterns.get(p);
                    if (lp == null || !lp.isEdgePattern()) continue;
                    if (lp.isXOffset()) {
                        if (lp.getOffset() > 0) {
                            if (!this.isFrozen(target)) {
                                txnew = Math.max(txnew, sxnew + 4);
                            } else if (!this.isFrozen(source)) {
                                sxnew = Math.min(sxnew, txnew - 4);
                            }
                        } else if (!this.isFrozen(source)) {
                            sxnew = Math.max(sxnew, txnew + 4);
                        } else if (!this.isFrozen(target)) {
                            txnew = Math.min(txnew, sxnew - 4);
                        }
                    }
                    if (!lp.isYOffset()) continue;
                    if (lp.getOffset() > 0) {
                        if (!this.isFrozen(target)) {
                            tynew = Math.max(tynew, synew + 4);
                            continue;
                        }
                        if (this.isFrozen(source)) continue;
                        synew = Math.min(synew, tynew - 4);
                        continue;
                    }
                    if (!this.isFrozen(source)) {
                        synew = Math.max(synew, tynew + 4);
                        continue;
                    }
                    if (this.isFrozen(target)) continue;
                    tynew = Math.min(tynew, synew - 4);
                }
            }
            if (!this.isFrozen(source)) {
                source.getAkt().setLocation(sxnew, synew);
                source.getOpt().setLocation(source.getAkt());
            }
            if (!this.isFrozen(target)) {
                target.getAkt().setLocation(txnew, tynew);
                target.getOpt().setLocation(target.getAkt());
            }
            for (int k = 0; k < arcs.size(); ++k) {
                arc = (EdArc)arcs.get(k);
                arc.getLArc().calcAktLength();
            }
            layoutDone = true;
        }
        eg.updateNodePosLtoE();
        return layoutDone;
    }

    public void combinedLayout(EdGraph eg) {
        this.combinedLayout(eg, this.iterations, this.nodeIntersectionIterations, this.edgeIntersectionIterations);
    }

    public void combinedLayout(EdGraph eg, int iters, int nodeit, int arcit) {
        int it = iters;
        it = this.iterations;
        for (int i = 0; i < it; ++i) {
            this.layout(eg, nodeit);
            this.layoutByArcLength(eg, arcit, 100);
        }
    }

    public void layoutGraph(EdGraph eg) {
        this.layoutGraph(eg, this.iterations, this.nodeIntersectionIterations, this.edgeIntersectionIterations);
    }

    public void layoutGraph(EdGraph eg, int iters, int nodeit, int arcit) {
        int i;
        Vector<LayoutNode> lnodes = this.getLayoutNodes(eg);
        int temp = this.temperature;
        int it = iters;
        Vector larcs = eg.getArcs();
        for (i = 0; i < larcs.size(); ++i) {
            ((EdArc)larcs.get(i)).setAnchor(null);
        }
        for (i = 0; i < it; ++i) {
            int temp2 = temp;
            for (int j = 0; j < nodeit; ++j) {
                this.calcNodeRepulse(lnodes);
                this.calcDistToPos(eg, lnodes, temp2, eg.getGraphGen());
                this.cool(temp2, j);
            }
            boolean done = this.layoutByArcLength(eg, arcit, temp);
            this.cool(temp, i);
        }
        int overlapscount = this.lmetric.getNodeIntersect(eg, true);
        for (int stop = 10; overlapscount > 0 && stop > 0; --stop) {
            for (int i2 = 0; i2 < lnodes.size(); ++i2) {
                int y2;
                int y1;
                int x2;
                int x1;
                LayoutNode lnode1 = lnodes.get(i2);
                if (this.isFrozen(lnode1) || !lnode1.isOverlapping()) continue;
                int ovl = this.lmetric.getOverlappingNode(lnodes, i2);
                if (ovl < 0) {
                    lnode1.unsetOverlap();
                    continue;
                }
                LayoutNode lnode2 = lnodes.get(ovl);
                if (this.isFrozen(lnode2)) continue;
                if (lnode1.getAkt().x < lnode2.getAkt().x) {
                    x1 = lnode1.getAkt().x - lnode1.getEdNode().getWidth();
                    x2 = lnode2.getAkt().x + lnode2.getEdNode().getWidth();
                } else {
                    x1 = lnode1.getAkt().x + lnode1.getEdNode().getWidth();
                    x2 = lnode2.getAkt().x - lnode2.getEdNode().getWidth();
                }
                if (lnode1.getAkt().y < lnode2.getAkt().y) {
                    y1 = lnode1.getAkt().y - lnode1.getEdNode().getHeight();
                    y2 = lnode2.getAkt().y + lnode2.getEdNode().getHeight();
                } else {
                    y1 = lnode1.getAkt().y + lnode1.getEdNode().getHeight();
                    y2 = lnode2.getAkt().y - lnode2.getEdNode().getHeight();
                }
                Point p1 = this.getRandomPosIfNeeded(x1, y1, lnode1);
                Point p2 = this.getRandomPosIfNeeded(x2, y2, lnode2);
                x1 = p1.x;
                y1 = p1.y;
                x2 = p2.x;
                y2 = p2.y;
                lnode1.setAkt(new Point(x1, y1));
                lnode1.setOpt(lnode1.getAkt());
                lnode2.setAkt(new Point(x2, y2));
                lnode2.setOpt(lnode2.getAkt());
                lnode1.unsetOverlap();
                lnode2.unsetOverlap();
            }
            overlapscount = this.lmetric.getNodeIntersect(eg, true);
        }
        eg.updateNodePosLtoE();
    }

    private boolean hasFreezingPattern(Type t) {
        boolean res = false;
        LayoutPattern lp = this.getLayoutPatternForType(t, "Freezing");
        if (lp != null) {
            res = true;
        }
        return res;
    }

    private boolean isFrozen(LayoutNode ln) {
        if (this.layoutNode2Type != null) {
            Type t = this.layoutNode2Type.get(ln);
            if (this.getLayoutPatternForType(t, "Freezing") != null) {
                return true;
            }
            return ln.isFrozen();
        }
        return ln.isFrozen();
    }

    public boolean graphContainsNewNodes(EdGraph eg) {
        Vector nodes = eg.getNodes();
        Vector oldnodes = this.oldedgraph.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            EdNode ni = (EdNode)nodes.get(i);
            boolean found = false;
            for (int j = 0; j < oldnodes.size(); ++j) {
                EdNode nj = (EdNode)oldnodes.get(j);
                if (!ni.getBasisNode().compareTo(nj.getBasisNode())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private Vector<LayoutNode> getLayoutNodes(EdGraph e) {
        this.layoutNode2Type.clear();
        Vector<LayoutNode> ret = new Vector<LayoutNode>();
        Vector enodes = e.getNodes();
        for (int i = 0; i < enodes.size(); ++i) {
            EdNode n = (EdNode)enodes.get(i);
            this.layoutNode2Type.put(n.getLNode(), n.getBasisNode().getType());
            ret.addElement(n.getLNode());
        }
        return ret;
    }

    private Vector<LayoutArc> getLayoutArcs(EdGraph e) {
        Vector<LayoutArc> ret = new Vector<LayoutArc>();
        Vector earcs = e.getArcs();
        for (int i = 0; i < earcs.size(); ++i) {
            ret.addElement(((EdArc)earcs.get(i)).getLArc());
        }
        return ret;
    }

    private Point getRandomPosIfNeeded(int xpos, int ypos, LayoutNode lnode) {
        int r;
        int x;
        int y = Math.max(ypos, lnode.getEdNode().getHeight());
        Point p = new Point(x, y);
        for (x = Math.max(xpos, lnode.getEdNode().getWidth()); x > this.panel.width - lnode.getEdNode().getWidth() * 2; x -= Math.abs(r)) {
            r = this.random.nextInt() % 200;
        }
        while (y > this.panel.height - lnode.getEdNode().getHeight() * 2) {
            r = this.random.nextInt() % 200;
            y -= Math.abs(r);
        }
        p.x = x;
        p.y = y;
        return p;
    }

    public void randomLayout(EdGraph eg) {
        Vector<LayoutNode> lnodes = this.getLayoutNodes(eg);
        int xdim = this.panel.width;
        int ydim = this.panel.height;
        Random r = new Random();
        for (int i = 0; i < lnodes.size(); ++i) {
            LayoutNode lnode = lnodes.get(i);
            if (this.isFrozen(lnode)) continue;
            int x = Math.abs(r.nextInt()) % xdim;
            int y = Math.abs(r.nextInt()) % ydim;
            lnode.setAkt(new Point(x, y));
            lnode.setOpt(new Point(x, y));
        }
        eg.updateNodePosLtoE();
    }

    public void newNodesRandomLayout(EdGraph eg) {
        Vector<LayoutNode> lnodes = this.getLayoutNodes(eg);
        int xdim = this.panel.width;
        int ydim = this.panel.height;
        for (int i = 0; i < lnodes.size(); ++i) {
            LayoutNode lnode = lnodes.get(i);
            if (this.isFrozen(lnode) || lnode.getAge() != 0) continue;
            int rdx = Math.abs(this.random.nextInt(xdim));
            int rdy = Math.abs(this.random.nextInt(ydim));
            int x = rdx % xdim;
            int y = rdy % ydim;
            if (this.usepattern) {
                EdNode node = lnode.getEdNode();
                Vector arcs = eg.getArcs();
                for (int j = 0; j < arcs.size(); ++j) {
                    EdArc arc = (EdArc)arcs.get(j);
                    if (!arc.getSource().equals(node) && !arc.getTarget().equals(node)) continue;
                    Vector<LayoutPattern> patterns = null;
                    if (arc.isElementOfTypeGraph()) {
                        patterns = this.getInheritancePattern(arc);
                    }
                    if (patterns == null) {
                        patterns = this.getLayoutPatternsForType(arc.getType().getBasisType());
                    }
                    for (int p = 0; p < patterns.size(); ++p) {
                        LayoutPattern lp = patterns.get(p);
                        if (lp == null || !lp.isEdgePattern()) continue;
                        if (arc.getSource().equals(node)) {
                            if (lp.isXOffset()) {
                                x = arc.getTarget().getX() - lp.getOffset() * rdx % 200;
                                x = Math.max(x, node.getWidth());
                                x = Math.min(x, this.panel.width - node.getWidth() * 2);
                            }
                            if (!lp.isYOffset()) continue;
                            y = arc.getTarget().getY() - lp.getOffset() * rdy % 200;
                            y = Math.max(y, node.getHeight());
                            y = Math.max(y, this.panel.height - node.getHeight() * 2);
                            continue;
                        }
                        if (lp.isXOffset()) {
                            x = arc.getSource().getX() + lp.getOffset() * rdx % 200;
                            x = Math.max(x, node.getWidth());
                            x = Math.min(x, this.panel.width - node.getWidth() * 2);
                        }
                        if (!lp.isYOffset()) continue;
                        y = arc.getSource().getY() + lp.getOffset() * rdy % 200;
                        y = Math.max(y, node.getHeight());
                        y = Math.max(y, this.panel.height - node.getHeight() * 2);
                    }
                }
            }
            lnode.setAkt(new Point(x, y));
            lnode.setOpt(new Point(x, y));
        }
        eg.updateNodePosEtoL();
    }

    public void centerLayout(EdGraph eg) {
        LayoutNode lnode;
        System.out.println("Layout.centerLayout ... ");
        Vector<LayoutNode> lnodes = this.getLayoutNodes(eg);
        int left = 0;
        int right = 0;
        int up = 0;
        int down = 0;
        int xmin = this.panel.width;
        int xmax = 0;
        int ymin = this.panel.height;
        int ymax = 0;
        for (int i = 0; i < lnodes.size(); ++i) {
            lnode = lnodes.get(i);
            if (lnode.getAkt().x < xmin) {
                xmin = lnode.getAkt().x;
                left = i;
            } else if (lnode.getAkt().x > xmax) {
                xmax = lnode.getAkt().x;
                right = i;
            }
            if (lnode.getAkt().y < ymin) {
                ymin = lnode.getAkt().y;
                up = i;
                continue;
            }
            if (lnode.getAkt().y >= ymax) continue;
            ymax = lnode.getAkt().y;
            down = i;
        }
        LayoutNode lnodeleft = lnodes.get(left);
        LayoutNode lnoderight = lnodes.get(right);
        LayoutNode lnodeup = lnodes.get(up);
        LayoutNode lnodedown = lnodes.get(down);
        int center = this.panel.width / 2;
        int leftdif = center - lnodeleft.getAkt().x;
        int rightdif = lnoderight.getAkt().x - center;
        center = this.panel.height / 2;
        int updif = center - lnodeup.getAkt().y;
        int downdif = lnodedown.getAkt().y - center;
        int x_change = (leftdif - rightdif) / 2;
        int y_change = (updif - downdif) / 2;
        for (int i = 0; i < lnodes.size(); ++i) {
            lnode = lnodes.get(i);
            lnode.getAkt().x += x_change;
            lnode.getAkt().y += y_change;
            lnode.setOpt(new Point(lnode.getAkt()));
        }
        eg.updateNodePosLtoE();
    }

    public void setPanelSize(Dimension dim) {
        this.panel = dim;
    }

    public Dimension getNeededPanelSize(EdGraph eg) {
        Dimension maxnodesize = eg.getMaxNodeDim();
        Dimension averagenodesize = eg.getAverageNodeDim();
        Dimension neededpanelsize = new Dimension(averagenodesize.width * eg.getNodes().size(), averagenodesize.height * eg.getNodes().size());
        return neededpanelsize;
    }

    public void setOldEdGraph(EdGraph eg) {
        this.oldedgraph = eg;
    }

    public EdGraph getOldEdGraph() {
        return this.oldedgraph;
    }

    public void shockAging(EdGraph eg) {
        Vector nodes = eg.getNodes();
        Vector oldnodes = this.oldedgraph.getNodes();
        Vector oldarcs = this.oldedgraph.getArcs();
        for (int i = 0; i < oldnodes.size(); ++i) {
            EdNode node;
            int index;
            EdNode oldnode2;
            int j;
            EdNode oldnode = (EdNode)oldnodes.get(i);
            if (oldnode.isInVectorByBasisNode(nodes) == -1) continue;
            Vector arcs = this.oldedgraph.getIncomingArcs(oldnode);
            for (j = 0; j < arcs.size(); ++j) {
                oldnode2 = (EdNode)((EdArc)arcs.get(j)).getSource();
                index = oldnode2.isInVectorByBasisNode(nodes);
                if (index == -1) continue;
                node = (EdNode)nodes.get(index);
                node.getLNode().setAge(Math.max(oldnode.getLNode().getAge(), node.getLNode().getAge()));
            }
            arcs = this.oldedgraph.getOutgoingArcs(oldnode);
            for (j = 0; j < arcs.size(); ++j) {
                oldnode2 = (EdNode)((EdArc)arcs.get(j)).getTarget();
                index = oldnode2.isInVectorByBasisNode(nodes);
                if (index == -1) continue;
                node = (EdNode)nodes.get(index);
                node.getLNode().setAge(Math.max(oldnode.getLNode().getAge(), node.getLNode().getAge()));
            }
        }
    }

    public void setGeneralEdgeLength(int l) {
        this.generalEdgeLength = l;
    }

    public int getGeneralEdgeLength() {
        return this.generalEdgeLength;
    }

    public void setBeginTemperature(int t) {
        this.temperature = t;
    }

    public int getBeginTemperature() {
        return this.temperature;
    }

    public void setIterationCount(int count) {
        this.iterations = count;
    }

    public int getIterationCount() {
        return this.iterations;
    }

    public void setNodeIntersectionIterationCount(int count) {
        this.nodeIntersectionIterations = count;
    }

    public void setEdgeIntersectionIterationCount(int count) {
        this.edgeIntersectionIterations = count;
    }

    public boolean getJpgOutput() {
        return this.jpgOutput;
    }

    public void setJpgOutput(boolean b) {
        this.jpgOutput = b;
    }

    public boolean usePattern() {
        return this.usepattern;
    }

    public void setUsePattern(boolean b) {
        this.usepattern = b;
    }

    public boolean doCenter() {
        return this.docenter;
    }

    public void setDoCenter(boolean b) {
        this.docenter = b;
    }

    public boolean getWriteMetricValues() {
        return this.writemetricvalues;
    }

    public void setWriteMetricValues(boolean b) {
        this.writemetricvalues = b;
    }

    public LayoutMetrics getLayoutMetrics() {
        return this.lmetric;
    }

    public void createLayoutPattern(String name, String pType, Type type, char offsetType, int offset) {
        LayoutPattern lp = new LayoutPattern(name, pType, type, offsetType, offset);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void createLayoutPattern(String name, String pType, Type type, int length) {
        LayoutPattern lp = new LayoutPattern(name, pType, type, length);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void createLayoutPattern(String name, String pType, Type type, boolean frozen) {
        LayoutPattern lp = new LayoutPattern(name, pType, type, frozen);
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
        }
        v.add(lp);
        this.layoutPatterns.put(type, v);
    }

    public void removeLayoutPattern(Type type) {
        this.layoutPatterns.remove(type);
    }

    public void removeLayoutPattern(Type type, String patternName) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null || v.isEmpty()) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            LayoutPattern lp = v.get(i);
            if (!lp.getName().equals(patternName)) continue;
            v.remove(lp);
            --i;
        }
        this.layoutPatterns.put(type, v);
    }

    public Hashtable<Type, Vector<LayoutPattern>> getLayoutPatterns() {
        return this.layoutPatterns;
    }

    public void clearLayoutPatterns() {
        this.layoutPatterns.clear();
    }

    public Vector<LayoutPattern> getLayoutPatternsForType(Type type) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            v = new Vector();
            this.layoutPatterns.put(type, v);
        }
        return v;
    }

    public LayoutPattern getLayoutPatternForType(Type type, String patternName) {
        Vector<LayoutPattern> v = this.layoutPatterns.get(type);
        if (v == null) {
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            LayoutPattern lp = v.get(i);
            if (!lp.getName().equals(patternName)) continue;
            return lp;
        }
        return null;
    }

    public void setLayoutPatterns(Hashtable<Type, Vector<LayoutPattern>> table) {
        this.layoutPatterns = table;
    }
}

