/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.PairContainer;
import agg.parser.Parser;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserMessageEvent;
import agg.parser.RuleInstances;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Morphism;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Step;
import agg.xt_basis.TypeException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractParser
implements Parser {
    protected GraGra grammar;
    protected Graph graph;
    protected Graph stopGraph;
    protected PairContainer pairContainer;
    protected Vector listener = new Vector();

    public AbstractParser(GraGra grammar, Graph hostGraph, Graph stopGraph, PairContainer pairContainer) {
        this.setHostGraph(hostGraph);
        this.setStopGraph(stopGraph);
        this.setGrammar(grammar);
        this.setCriticalPairs(pairContainer);
    }

    public void setHostGraph(Graph hostGraph) {
        this.graph = hostGraph;
    }

    public void setStopGraph(Graph stopGraph) {
        this.stopGraph = stopGraph;
    }

    public void setCriticalPairs(PairContainer pairs) {
        this.pairContainer = pairs;
    }

    public void setGrammar(GraGra grammar) {
        this.grammar = grammar;
    }

    public Graph getHostGraph() {
        return this.graph;
    }

    public Graph getGraph() {
        return this.getHostGraph();
    }

    public Graph getStopGraph() {
        return this.stopGraph;
    }

    public abstract boolean parse();

    protected void applyRule(Match m) {
        Morphism comatch = null;
        if (m.isValid()) {
            Step s = new Step();
            try {
                comatch = s.execute(m);
            }
            catch (TypeException e) {
                this.fireParserEvent(new ParserErrorEvent(this, "Rule  <" + m.getRule().getName() + ">  cannot applied"));
                return;
            }
            BaseFactory.theFactory().destroyMatch(m);
            BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)comatch);
            this.fireParserEvent(new ParserMessageEvent(this, "Rule  <" + m.getRule().getName() + ">  applied"));
        } else {
            this.fireParserEvent(new ParserErrorEvent(this, "Rule  <" + m.getRule().getName() + ">  cannot applied"));
        }
    }

    protected Match findMatch(Graph g, Enumeration rules, RuleInstances eri) {
        boolean found = false;
        Match resultMatch = null;
        while (rules.hasMoreElements() && !found) {
            Rule rule = (Rule)rules.nextElement();
            resultMatch = BaseFactory.theFactory().createMatch(rule, g);
            while (!found && resultMatch.nextCompletion()) {
                if (!resultMatch.isValid()) continue;
                if (eri != null) {
                    if (eri.isIn(resultMatch)) continue;
                    found = true;
                    continue;
                }
                found = true;
            }
            if (found) continue;
            BaseFactory.theFactory().destroyMatch(resultMatch);
            resultMatch = null;
        }
        return resultMatch;
    }

    protected Match findMatch(Graph g, Enumeration rules) {
        return this.findMatch(g, rules, null);
    }

    protected void finalize() {
        this.getHostGraph().dispose();
    }

    public void parseString() {
    }

    public void addParserEventListener(ParserEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.addElement(l);
        }
    }

    public void removeParserEventListener(ParserEventListener l) {
        if (this.listener.contains(l)) {
            this.listener.removeElement(l);
        }
    }

    protected synchronized void fireParserEvent(ParserEvent event) {
        for (int i = 0; i < this.listener.size(); ++i) {
            ((ParserEventListener)this.listener.elementAt(i)).parserEventOccured(event);
        }
    }

    protected void printImageGraph(Morphism m) {
        Graph left = m.getOriginal();
        Enumeration e = left.getElements();
        System.out.println("Image graph of match:  " + m);
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            GraphObject i = m.getImage(o);
            if (i == null) continue;
            System.out.print(i);
        }
        System.out.println();
    }

    protected void printGraph(Graph g) {
        Enumeration e = g.getElements();
        System.out.println("Graph of match:  ");
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            System.out.print(o);
        }
        System.out.println();
    }
}

