/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.ConflictsDependenciesBasisGraph;
import agg.parser.ConflictsDependenciesContainer;
import agg.parser.CriticalPairOption;
import agg.parser.ExcludePairContainer;
import agg.parser.PairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserFactory;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;

public class ComputeCriticalPairs
implements ParserEventListener {
    public String anOptionStr;
    public CriticalPairOption cpOption = new CriticalPairOption();
    public ConflictsDependenciesContainer cdc;
    public PairContainer excludePairContainer;
    public PairContainer dependPairContainer;
    public String fname;
    public String outfname;
    public boolean computeConflict = true;
    public boolean computeDependency = true;
    public GraGra gragra;

    public ComputeCriticalPairs() {
        this.cpOption.setCriticalPairAlgorithm(0);
        this.cpOption.enableLayered(false);
    }

    public void parserEventOccured(ParserEvent e) {
        if (e.getMessage().indexOf("Critical") != -1 && e.getMessage().indexOf("finished") != -1) {
            this.computeConflict = false;
            System.out.println("Computing critical pairs  -  finished.");
            if (this.computeDependency) {
                this.cpOption.setCriticalPairAlgorithm(1);
                if (this.dependPairContainer == null) {
                    this.dependPairContainer = ParserFactory.createEmptyCriticalPairs(this.gragra, this.cpOption.getCriticalPairAlgorithm(), this.cpOption.layeredEnabled());
                }
                ((ExcludePairContainer)this.dependPairContainer).enableComplete(this.cpOption.completeEnabled());
                ((ExcludePairContainer)this.dependPairContainer).enableNACs(this.cpOption.nacsEnabled());
                ((ExcludePairContainer)this.dependPairContainer).enableReduce(this.cpOption.reduceEnabled());
                ((ExcludePairContainer)this.dependPairContainer).enableConsistent(this.cpOption.consistentEnabled());
                System.out.println("Generating dependencies of rules ... ");
                this.dependPairContainer.addPairEventListener(this);
                ParserFactory.generateCriticalPairs(this.dependPairContainer);
                this.computeDependency = false;
            } else {
                this.save();
            }
        } else {
            System.out.println(e.getMessage());
        }
    }

    private void save() {
        System.out.println("Generate CPA graph ...");
        Graph cpaGraph = this.generateCPAgraph();
        System.out.println("Save critical pairs and CPA graph ... ");
        if (this.outfname.equals("")) {
            String s = "";
            if (this.fname.indexOf(".ggx") != -1) {
                s = this.fname.substring(0, this.fname.indexOf(".ggx"));
            } else if (this.fname.indexOf(".cpx") != -1) {
                s = this.fname.substring(0, this.fname.indexOf(".cpx"));
            }
            this.outfname = s + "_out.cpx";
        } else if (!this.outfname.endsWith(".cpx")) {
            this.outfname = this.outfname + ".cpx";
        }
        ConflictsDependenciesContainer cdPC = new ConflictsDependenciesContainer(this.excludePairContainer, this.dependPairContainer, cpaGraph);
        XMLHelper h = new XMLHelper();
        h.addTopObject(cdPC);
        h.save_to_xml(this.outfname);
        System.out.println("\nComputed critical pairs are saved in : " + this.outfname);
        System.out.println();
    }

    private void helpText() {
        System.out.println("Usage: java -Xmx1000m agg.parser.ComputeCriticalPairs [C | D] [nc] [ncc] [o outfile] file");
        System.out.println("Where:");
        String str = "\tC           - compute parallel conflicts of rules\n\tD           - compute sequential dependencies of rules\n\tnc          - not complete critical pairs \n\tncc         - critical pairs without respect \n\t\t\tto graph consistency constraints \n\to outfile   - output file \n\tdefaults:   - complete, consistent critical pairs, \n\t              the name of output file - inputfilename_out.cpx \n\tfile        - *.ggx  or  *.cpx  file. ";
        System.out.println(str);
        System.out.println("Without algorithm parameter conflicts and dependencies will be computed.");
        System.out.println("The input file  *.ggx  should contain a grammar with a rule set. This grammar can be layered or not. ");
        System.out.println("The output file  *_out.cpx  will contain computed critical pairs.");
        System.out.println("The input file  *.cpx  can contain partly computed critical pairs of one or of both algorithms.");
        System.out.println("The output file  *_out.cpx  will be completed with new computed critical pairs.");
        System.out.println("The output file  *_out.cpx  will also contain CPA graph generated from critical rule pairs.");
        System.out.println("");
    }

    private Graph generateCPAgraph() {
        ConflictsDependenciesBasisGraph conflictDependGraph = new ConflictsDependenciesBasisGraph((ExcludePairContainer)this.excludePairContainer, (ExcludePairContainer)this.dependPairContainer);
        Graph cpaGraph = conflictDependGraph.getConflictsDependenciesGraph();
        return cpaGraph;
    }

    public void run(String[] args) {
        if (args.length == 0) {
            this.helpText();
            return;
        }
        this.fname = "";
        this.outfname = "";
        this.gragra = BaseFactory.theFactory().createGraGra();
        XMLHelper h = new XMLHelper();
        Object cpxObject = null;
        if (args.length == 1) {
            this.fname = args[0];
            this.computeConflict = true;
            this.computeDependency = true;
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("C")) {
                    this.cpOption.setCriticalPairAlgorithm(0);
                    this.computeDependency = false;
                    continue;
                }
                if (args[i].equals("D")) {
                    this.cpOption.setCriticalPairAlgorithm(1);
                    this.computeConflict = false;
                    continue;
                }
                if (args[i].equals("e")) {
                    this.cpOption.enableReduce(true);
                    continue;
                }
                if (args[i].equals("nc")) {
                    this.cpOption.enableComplete(false);
                    continue;
                }
                if (args[i].equals("ncc")) {
                    this.cpOption.enableConsistent(false);
                    continue;
                }
                if (args[i].equals("o")) {
                    if (i + 1 >= args.length) continue;
                    this.outfname = args[++i];
                    if (i + 1 < args.length) continue;
                    break;
                }
                this.fname = args[i];
            }
        }
        if (this.fname.indexOf(".ggx") != -1) {
            System.out.println("File to load:  " + this.fname);
            this.gragra.load(this.fname);
            this.cpOption.enableLayered(this.gragra.isLayered());
        } else if (this.fname.indexOf(".cpx") != -1) {
            System.out.println("File to load:  " + this.fname);
            ConflictsDependenciesContainer cdc = new ConflictsDependenciesContainer();
            h.read_from_xml(this.fname);
            if (cdc != null) {
                XMLObject o = h.getTopObject(cdc);
                if (o == null) {
                    System.out.println("Loading file is failed.");
                    return;
                }
                cdc = (ConflictsDependenciesContainer)o;
                if (cdc.getExcludePairContainer() != null) {
                    this.excludePairContainer = cdc.getExcludePairContainer();
                    this.dependPairContainer = cdc.getDependencyPairContainer();
                    this.cpOption.enableLayered(false);
                    this.gragra = this.excludePairContainer.getGrammar();
                } else if (cdc.getDependencyPairContainer() != null) {
                    this.excludePairContainer = cdc.getExcludePairContainer();
                    this.dependPairContainer = cdc.getDependencyPairContainer();
                    this.cpOption.enableLayered(false);
                    this.gragra = this.dependPairContainer.getGrammar();
                } else if (cdc.getLayeredExcludePairContainer() != null) {
                    this.excludePairContainer = cdc.getLayeredExcludePairContainer();
                    this.dependPairContainer = cdc.getLayeredDependencyPairContainer();
                    this.cpOption.enableLayered(true);
                    this.gragra = this.excludePairContainer.getGrammar();
                } else if (cdc.getLayeredDependencyPairContainer() != null) {
                    this.excludePairContainer = cdc.getLayeredExcludePairContainer();
                    this.dependPairContainer = cdc.getLayeredDependencyPairContainer();
                    this.cpOption.enableLayered(true);
                    this.gragra = this.dependPairContainer.getGrammar();
                }
            }
        } else {
            System.out.println("Input file name failed.");
            return;
        }
        if (this.computeConflict) {
            this.cpOption.setCriticalPairAlgorithm(0);
            if (this.excludePairContainer == null) {
                this.excludePairContainer = ParserFactory.createEmptyCriticalPairs(this.gragra, this.cpOption.getCriticalPairAlgorithm(), this.cpOption.layeredEnabled());
            }
            ((ExcludePairContainer)this.excludePairContainer).enableComplete(this.cpOption.completeEnabled());
            ((ExcludePairContainer)this.excludePairContainer).enableNACs(this.cpOption.nacsEnabled());
            ((ExcludePairContainer)this.excludePairContainer).enableReduce(this.cpOption.reduceEnabled());
            ((ExcludePairContainer)this.excludePairContainer).enableConsistent(this.cpOption.consistentEnabled());
            System.out.println("Generating conflicts of rules ... ");
            this.excludePairContainer.addPairEventListener(this);
            ParserFactory.generateCriticalPairs(this.excludePairContainer);
        } else if (this.computeDependency) {
            this.cpOption.setCriticalPairAlgorithm(1);
            if (this.dependPairContainer == null) {
                this.dependPairContainer = ParserFactory.createEmptyCriticalPairs(this.gragra, this.cpOption.getCriticalPairAlgorithm(), this.cpOption.layeredEnabled());
            }
            ((ExcludePairContainer)this.dependPairContainer).enableComplete(this.cpOption.completeEnabled());
            ((ExcludePairContainer)this.dependPairContainer).enableNACs(this.cpOption.nacsEnabled());
            ((ExcludePairContainer)this.dependPairContainer).enableReduce(this.cpOption.reduceEnabled());
            ((ExcludePairContainer)this.dependPairContainer).enableConsistent(this.cpOption.consistentEnabled());
            System.out.println("Generating dependencies of rules ... ");
            this.dependPairContainer.addPairEventListener(this);
            ParserFactory.generateCriticalPairs(this.dependPairContainer);
        }
    }

    public static void main(String[] args) {
        ComputeCriticalPairs ccp = new ComputeCriticalPairs();
        ccp.run(args);
    }
}

