/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.attribute.AttrType;
import agg.attribute.facade.InformationFacade;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.impl.ValueTuple;
import agg.parser.ExcludePairContainer;
import agg.xt_basis.Arc;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Node;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConflictsDependenciesBasisGraph {
    ExcludePairContainer conflictCont;
    ExcludePairContainer dependCont;
    GraGra grammar;
    Hashtable conflicts;
    Hashtable dependencies;
    Graph conflictGraph;
    Graph dependGraph;
    Graph combiGraph;

    public ConflictsDependenciesBasisGraph(ExcludePairContainer conflictsContainer, ExcludePairContainer dependenciesContainer) {
        this.conflictCont = conflictsContainer;
        this.dependCont = dependenciesContainer;
        this.initTables();
        this.createGraphs();
        if (this.combiGraph != null) {
            this.optimizeLayout(this.combiGraph);
        } else if (this.conflictGraph != null) {
            this.optimizeLayout(this.conflictGraph);
        } else if (this.dependGraph != null) {
            this.optimizeLayout(this.dependGraph);
        }
    }

    public Graph getConflictsGraph() {
        return this.conflictGraph;
    }

    public Graph getDependenciesGraph() {
        return this.dependGraph;
    }

    public Graph getConflictsDependenciesGraph() {
        return this.combiGraph;
    }

    private void initTables() {
        if (this.conflictCont != null) {
            this.conflicts = this.conflictCont.getExcludeContainer();
            this.grammar = this.conflictCont.getGrammar();
        }
        if (this.dependCont != null) {
            this.dependencies = this.dependCont.getExcludeContainer();
            if (this.grammar == null) {
                this.grammar = this.dependCont.getGrammar();
            }
        }
    }

    private void createGraphs() {
        Arc a;
        Node nr;
        Node nr2;
        boolean rel;
        Pair p;
        Node nr3;
        Node nr1;
        ExcludePairContainer.Entry entry;
        Rule r2;
        Enumeration keys2;
        Hashtable table;
        Rule r1;
        Enumeration keys1;
        if (this.conflicts == null && this.dependencies == null) {
            return;
        }
        Hashtable<String, Node> common = new Hashtable<String, Node>();
        Hashtable<String, Node> local = new Hashtable<String, Node>();
        Graph g = null;
        TypeSet types = null;
        if (this.conflicts != null) {
            this.conflictGraph = new Graph();
            this.conflictGraph.setName("Conflicts of Rules");
            g = this.conflictGraph;
            types = this.conflictGraph.getTypeSet();
        }
        if (this.dependencies != null) {
            this.dependGraph = types != null ? new Graph(types) : new Graph();
            this.dependGraph.setName("Dependencies of Rules");
            if (g == null) {
                g = this.dependGraph;
                types = this.dependGraph.getTypeSet();
            }
        }
        if (this.conflictGraph != null && this.dependGraph != null) {
            this.combiGraph = new Graph(types);
            this.combiGraph.setName("CPA Graph: Conflicts (red) - Dependencies (blue) of Rules");
        }
        Type nodeType = types.createType();
        Type arcTypeConflict = types.createType();
        Type arcTypeDepend = types.createType();
        nodeType.setStringRepr("Rule");
        nodeType.setAdditionalRepr("[NODE]");
        arcTypeConflict.setStringRepr("c");
        arcTypeConflict.setAdditionalRepr(":SOLID_LINE:java.awt.Color[r=255,g=0,b=0]::[EDGE]:");
        arcTypeDepend.setStringRepr("d");
        arcTypeDepend.setAdditionalRepr(":DOT_LINE:java.awt.Color[r=0,g=0,b=255]::[EDGE]:");
        InformationFacade info = DefaultInformationFacade.self();
        AttrHandler javaHandler = info.getJavaHandler();
        AttrType attrType = nodeType.getAttrType();
        attrType.addMember(javaHandler, "String", "name");
        if (this.conflicts != null) {
            keys1 = this.conflicts.keys();
            while (keys1.hasMoreElements()) {
                r1 = (Rule)keys1.nextElement();
                if (!r1.isEnabled()) continue;
                table = (Hashtable)this.conflicts.get(r1);
                keys2 = table.keys();
                while (keys2.hasMoreElements()) {
                    r2 = (Rule)keys2.nextElement();
                    if (!r2.isEnabled()) continue;
                    entry = this.conflictCont.getEntry(r1, r2);
                    nr1 = (Node)local.get(r1.getName());
                    if (nr1 == null) {
                        nr1 = this.createNode(this.conflictGraph, nodeType, r1);
                        local.put(r1.getName(), nr1);
                        if (r1 == r2) {
                            nr1.setVisible(entry.isRuleVisible());
                        }
                    }
                    if (this.combiGraph != null && (nr3 = (Node)common.get(r1.getName())) == null) {
                        nr3 = this.createNode(this.combiGraph, nodeType, r1);
                        common.put(r1.getName(), nr3);
                        if (r1 == r2) {
                            nr3.setVisible(entry.isRuleVisible());
                        }
                    }
                    p = (Pair)table.get(r2);
                    rel = (Boolean)p.first;
                    nr2 = (Node)local.get(r2.getName());
                    if (nr2 == null) {
                        nr2 = this.createNode(this.conflictGraph, nodeType, r2);
                        local.put(r2.getName(), nr2);
                    }
                    if (this.combiGraph != null && (nr = (Node)common.get(r2.getName())) == null) {
                        nr = this.createNode(this.combiGraph, nodeType, r2);
                        common.put(r2.getName(), nr);
                    }
                    if (!rel) continue;
                    a = this.createEdge(this.conflictGraph, arcTypeConflict, r1, r2);
                    if (this.combiGraph == null) continue;
                    Arc a1 = this.createEdge(this.combiGraph, arcTypeConflict, r1, r2);
                }
            }
        }
        if (this.dependencies != null) {
            local.clear();
            keys1 = this.dependencies.keys();
            while (keys1.hasMoreElements()) {
                r1 = (Rule)keys1.nextElement();
                if (!r1.isEnabled()) continue;
                table = (Hashtable)this.dependencies.get(r1);
                keys2 = table.keys();
                while (keys2.hasMoreElements()) {
                    r2 = (Rule)keys2.nextElement();
                    if (!r2.isEnabled()) continue;
                    entry = this.dependCont.getEntry(r1, r2);
                    nr1 = (Node)local.get(r1.getName());
                    if (nr1 == null) {
                        nr1 = this.createNode(this.dependGraph, nodeType, r1);
                        local.put(r1.getName(), nr1);
                        if (r1 == r2) {
                            nr1.setVisible(entry.isRuleVisible());
                        }
                    }
                    if (this.combiGraph != null && (nr3 = (Node)common.get(r1.getName())) == null) {
                        nr3 = this.createNode(this.combiGraph, nodeType, r1);
                        common.put(r1.getName(), nr3);
                        if (r1 == r2) {
                            nr3.setVisible(entry.isRuleVisible());
                        }
                    }
                    p = (Pair)table.get(r2);
                    rel = (Boolean)p.first;
                    nr2 = (Node)local.get(r2.getName());
                    if (nr2 == null) {
                        nr2 = this.createNode(this.dependGraph, nodeType, r2);
                        local.put(r2.getName(), nr2);
                    }
                    if (this.combiGraph != null && (nr = (Node)common.get(r2.getName())) == null) {
                        nr = this.createNode(this.combiGraph, nodeType, r2);
                        common.put(r2.getName(), nr);
                    }
                    if (!rel) continue;
                    a = this.createEdge(this.dependGraph, arcTypeDepend, r1, r2);
                    if (this.combiGraph == null) continue;
                    a = this.createEdge(this.combiGraph, arcTypeDepend, r1, r2);
                }
            }
        }
        common.clear();
        common = null;
        local.clear();
        local = null;
    }

    private void optimizeLayout(Graph g) {
        Enumeration e = g.getArcs();
        block0: while (e.hasMoreElements()) {
            Arc a = (Arc)e.nextElement();
            if (a.getSource() == a.getTarget() || !a.isDirected()) continue;
            Enumeration e1 = g.getArcs();
            while (e1.hasMoreElements()) {
                Arc a1 = (Arc)e1.nextElement();
                if (a1.getSource() == a1.getTarget() || !a1.isDirected() || a == a1 || !a.getType().getName().equals(a1.getType().getName()) || a.getSource() != a1.getTarget() || a.getTarget() != a1.getSource()) continue;
                a.setVisible(false);
                a1.setDirected(false);
                continue block0;
            }
        }
    }

    private Node createNode(Graph g, Type t, Rule r) {
        Node n = this.getNode(g, r);
        if (n == null) {
            try {
                n = g.createNode(t);
                ValueTuple vt = (ValueTuple)n.getAttribute();
                String rname = r.getName();
                vt.getValueMemberAt("name").setExprAsObject(rname);
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        return n;
    }

    private Node getNode(Graph g, Rule r) {
        Enumeration e = g.getNodes();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!((String)n.getAttribute().getValueAt("name")).equals(r.getName())) continue;
            return n;
        }
        return null;
    }

    private Arc createEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        Arc a = this.getEdge(g, t, n1, n2);
        if (a == null) {
            try {
                Arc a1;
                a = g.createArc(t, n1, n2);
                if (n1 != n2 && (a1 = this.getEdge(g, t, n2, n1)) != null) {
                    a.setDirected(false);
                    a1.setVisible(false);
                }
            }
            catch (TypeException e) {
                // empty catch block
            }
        }
        return a;
    }

    private Arc createEdge(Graph g, Type t, Rule r1, Rule r2) {
        if (t == null || r1 == null || r2 == null) {
            return null;
        }
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.createEdge(g, t, n1, n2);
    }

    private Arc getEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        Enumeration e = g.getArcs();
        while (e.hasMoreElements()) {
            Arc a = (Arc)e.nextElement();
            if (!a.getType().getName().equals(t.getName())) continue;
            Object src = a.getSource().getAttribute().getValueAt("name");
            Object tar = a.getTarget().getAttribute().getValueAt("name");
            Object name1 = n1.getAttribute().getValueAt("name");
            Object name2 = n2.getAttribute().getValueAt("name");
            if (src == null || !((String)src).equals(name1) || tar == null || !((String)tar).equals(name2)) continue;
            return a;
        }
        return null;
    }
}

