/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.editor.impl.EdGraph;
import agg.editor.impl.EdType;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.LayeredDependencyPairContainer;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.PairContainer;
import agg.parser.ParserFactory;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import com.objectspace.jgl.Pair;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConflictsDependenciesContainer
implements XMLObject {
    ExcludePairContainer epc;
    LayeredExcludePairContainer lepc;
    DependencyPairContainer dpc;
    LayeredDependencyPairContainer ldpc;
    Graph cpaBasisGraph;
    EdGraph cpaGraph;
    boolean layered;
    int count;

    public ConflictsDependenciesContainer() {
        this.cpaBasisGraph = null;
        this.cpaGraph = null;
    }

    public ConflictsDependenciesContainer(PairContainer conflict, PairContainer dependency, Graph conflictDependencyGraph) {
        this.count = 0;
        if (dependency instanceof LayeredDependencyPairContainer) {
            this.ldpc = (LayeredDependencyPairContainer)dependency;
            ++this.count;
            this.dpc = null;
            this.layered = true;
        } else if (dependency instanceof DependencyPairContainer) {
            this.dpc = (DependencyPairContainer)dependency;
            ++this.count;
            this.ldpc = null;
            this.layered = false;
        }
        if (conflict instanceof LayeredExcludePairContainer) {
            this.lepc = (LayeredExcludePairContainer)conflict;
            ++this.count;
            this.epc = null;
            this.layered = true;
        } else if (conflict instanceof ExcludePairContainer) {
            this.epc = (ExcludePairContainer)conflict;
            ++this.count;
            this.lepc = null;
            this.layered = false;
        }
        this.cpaBasisGraph = conflictDependencyGraph;
    }

    public ConflictsDependenciesContainer(PairContainer conflict, PairContainer dependency, EdGraph conflictDependencyGraph) {
        this.count = 0;
        if (dependency instanceof LayeredDependencyPairContainer) {
            this.ldpc = (LayeredDependencyPairContainer)dependency;
            ++this.count;
            this.dpc = null;
            this.layered = true;
        } else if (dependency instanceof DependencyPairContainer) {
            this.dpc = (DependencyPairContainer)dependency;
            ++this.count;
            this.ldpc = null;
            this.layered = false;
        }
        if (conflict instanceof LayeredExcludePairContainer) {
            this.lepc = (LayeredExcludePairContainer)conflict;
            ++this.count;
            this.epc = null;
            this.layered = true;
        } else if (conflict instanceof ExcludePairContainer) {
            this.epc = (ExcludePairContainer)conflict;
            ++this.count;
            this.lepc = null;
            this.layered = false;
        }
        this.cpaGraph = conflictDependencyGraph;
        if (this.cpaGraph != null) {
            this.cpaBasisGraph = conflictDependencyGraph.getBasisGraph();
        }
    }

    public ExcludePairContainer getExcludePairContainer() {
        return this.epc;
    }

    public LayeredExcludePairContainer getLayeredExcludePairContainer() {
        return this.lepc;
    }

    public DependencyPairContainer getDependencyPairContainer() {
        return this.dpc;
    }

    public LayeredDependencyPairContainer getLayeredDependencyPairContainer() {
        return this.ldpc;
    }

    public EdGraph getCPAGraph() {
        return this.cpaGraph;
    }

    public Graph getCPABasisGraph() {
        return this.cpaBasisGraph;
    }

    public boolean isLayered() {
        return this.layered;
    }

    public int getContainerCount() {
        return this.count;
    }

    public void XwriteObject(XMLHelper h) {
        if (this.epc != null || this.dpc != null) {
            this.criticalPairsWriteXML(h, this.epc, this.dpc, false);
        } else if (this.lepc != null || this.ldpc != null) {
            this.criticalPairsWriteXML(h, this.lepc, this.ldpc, true);
        } else {
            System.out.println("ConflictsDependenciesContainer.XwriteObject  FAILED");
        }
    }

    private void criticalPairsWriteXML(XMLHelper h, PairContainer pc1, PairContainer pc2, boolean layer) {
        GraphObject o;
        Enumeration e;
        Graph overlapping;
        OrdinaryMorphism first;
        Pair p2;
        Pair p2i;
        int i;
        Vector v;
        Boolean b;
        Pair p;
        Rule r2;
        Enumeration k2;
        Hashtable secondPart;
        Rule r1;
        Enumeration keys;
        h.openNewElem("CriticalPairs", this);
        if (pc1 != null) {
            h.addObject("GraGra", pc1.getGrammar(), true);
        } else if (pc2 != null) {
            h.addObject("GraGra", pc2.getGrammar(), true);
        }
        Hashtable excludeContainer = null;
        Hashtable conflictFreeContainer = null;
        if (pc1 != null) {
            excludeContainer = ((ExcludePairContainer)pc1).getExcludeContainer();
        }
        if (excludeContainer != null) {
            h.openSubTag("conflictContainer");
            keys = excludeContainer.keys();
            while (keys.hasMoreElements()) {
                r1 = (Rule)keys.nextElement();
                h.openSubTag("Rule");
                h.addObject("R1", r1, false);
                secondPart = (Hashtable)excludeContainer.get(r1);
                k2 = secondPart.keys();
                while (k2.hasMoreElements()) {
                    r2 = (Rule)k2.nextElement();
                    h.openSubTag("Rule");
                    h.addObject("R2", r2, false);
                    p = (Pair)secondPart.get(r2);
                    b = (Boolean)p.first;
                    h.addAttr("bool", b.toString());
                    if (b.booleanValue()) {
                        v = (Vector)p.second;
                        for (i = 0; i < v.size(); ++i) {
                            p2i = (Pair)v.elementAt(i);
                            p2 = (Pair)p2i.first;
                            h.openSubTag("Overlapping_Pair");
                            first = (OrdinaryMorphism)p2.first;
                            overlapping = first.getImage();
                            h.addObject("", overlapping, true);
                            e = overlapping.getElements();
                            while (e.hasMoreElements()) {
                                o = (GraphObject)e.nextElement();
                                if (!o.isCritical()) continue;
                                h.openSubTag("Critical");
                                h.addObject("object", o, false);
                                h.close();
                            }
                            this.writeOverlapMorphisms(h, r1, r2, p2i);
                            h.close();
                        }
                    }
                    h.close();
                }
                h.close();
            }
            h.close();
            conflictFreeContainer = ((ExcludePairContainer)pc1).getConflictFreeContainer();
            if (conflictFreeContainer != null) {
                h.openSubTag("conflictFreeContainer");
                keys = excludeContainer.keys();
                while (keys.hasMoreElements()) {
                    r1 = (Rule)keys.nextElement();
                    h.openSubTag("Rule");
                    h.addObject("R1", r1, false);
                    secondPart = (Hashtable)conflictFreeContainer.get(r1);
                    k2 = secondPart.keys();
                    while (k2.hasMoreElements()) {
                        r2 = (Rule)k2.nextElement();
                        h.openSubTag("Rule");
                        h.addObject("R2", r2, false);
                        p = (Pair)secondPart.get(r2);
                        b = (Boolean)p.first;
                        h.addAttr("bool", b.toString());
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
        }
        excludeContainer = null;
        if (pc2 != null) {
            excludeContainer = ((ExcludePairContainer)pc2).getExcludeContainer();
        }
        if (excludeContainer != null) {
            h.openSubTag("dependencyContainer");
            keys = excludeContainer.keys();
            while (keys.hasMoreElements()) {
                r1 = (Rule)keys.nextElement();
                h.openSubTag("Rule");
                h.addObject("R1", r1, false);
                secondPart = (Hashtable)excludeContainer.get(r1);
                k2 = secondPart.keys();
                while (k2.hasMoreElements()) {
                    r2 = (Rule)k2.nextElement();
                    h.openSubTag("Rule");
                    h.addObject("R2", r2, false);
                    p = (Pair)secondPart.get(r2);
                    b = (Boolean)p.first;
                    h.addAttr("bool", b.toString());
                    if (b.booleanValue()) {
                        v = (Vector)p.second;
                        for (i = 0; i < v.size(); ++i) {
                            p2i = (Pair)v.elementAt(i);
                            p2 = (Pair)p2i.first;
                            h.openSubTag("Overlapping_Pair");
                            first = (OrdinaryMorphism)p2.first;
                            overlapping = first.getImage();
                            h.addObject("", overlapping, true);
                            e = overlapping.getElements();
                            while (e.hasMoreElements()) {
                                o = (GraphObject)e.nextElement();
                                if (!o.isCritical()) continue;
                                h.openSubTag("Critical");
                                h.addObject("object", o, false);
                                h.close();
                            }
                            this.writeOverlapMorphisms(h, r1, r2, p2i);
                            h.close();
                        }
                    }
                    h.close();
                }
                h.close();
            }
            h.close();
            conflictFreeContainer = ((ExcludePairContainer)pc2).getConflictFreeContainer();
            if (conflictFreeContainer != null) {
                h.openSubTag("dependencyFreeContainer");
                keys = excludeContainer.keys();
                while (keys.hasMoreElements()) {
                    r1 = (Rule)keys.nextElement();
                    h.openSubTag("Rule");
                    h.addObject("R1", r1, false);
                    secondPart = (Hashtable)conflictFreeContainer.get(r1);
                    k2 = secondPart.keys();
                    while (k2.hasMoreElements()) {
                        r2 = (Rule)k2.nextElement();
                        h.openSubTag("Rule");
                        h.addObject("R2", r2, false);
                        p = (Pair)secondPart.get(r2);
                        b = (Boolean)p.first;
                        h.addAttr("bool", b.toString());
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
        }
        if (this.cpaBasisGraph != null) {
            h.openSubTag("ConflictDependencyGraph");
            h.openSubTag("Types");
            h.addEnumeration("", this.cpaBasisGraph.getTypeSet().getTypes(), true);
            h.close();
            h.addObject("", this.cpaBasisGraph, true);
            if (this.cpaGraph != null) {
                this.cpaGraph.XwriteObject(h);
            }
            h.close();
        }
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        this.count = 0;
        if (h.isTag("CriticalPairs", this)) {
            Pair p;
            GraphObject o;
            Graph g;
            Enumeration overlappings;
            String bool;
            Enumeration r2s;
            Enumeration r1s;
            Rule r1 = null;
            Rule r2 = null;
            boolean conflictKind = false;
            this.layered = false;
            boolean b = false;
            boolean depsRead = false;
            Vector<String> tagnames = new Vector<String>(1);
            Vector<Pair> allOverlappings = null;
            GraGra grammar = BaseFactory.theFactory().createGraGra();
            h.getObject("", grammar, true);
            if (grammar.isLayered()) {
                this.layered = true;
            }
            tagnames.add("conflictContainer");
            tagnames.add("conflictsContainer");
            tagnames.add("excludeContainer");
            if (h.readSubTag(tagnames)) {
                conflictKind = false;
                if (!this.layered) {
                    this.epc = (ExcludePairContainer)ParserFactory.createEmptyCriticalPairs(grammar, 0, false);
                } else {
                    this.lepc = (LayeredExcludePairContainer)ParserFactory.createEmptyCriticalPairs(grammar, 0, true);
                }
                ++this.count;
            } else {
                tagnames.clear();
                tagnames.add("dependenciesContainer");
                tagnames.add("dependencyContainer");
                if (h.readSubTag(tagnames)) {
                    conflictKind = true;
                    if (!this.layered) {
                        this.dpc = (DependencyPairContainer)ParserFactory.createEmptyCriticalPairs(grammar, 1, false);
                    } else {
                        this.ldpc = (LayeredDependencyPairContainer)ParserFactory.createEmptyCriticalPairs(grammar, 1, true);
                    }
                    ++this.count;
                }
            }
            if (!conflictKind || conflictKind) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        allOverlappings = null;
                        if (bool.equals("true")) {
                            b = true;
                            allOverlappings = new Vector<Pair>();
                            overlappings = h.getEnumeration("", null, true, "Overlapping_Pair");
                            while (overlappings.hasMoreElements()) {
                                h.peekElement(overlappings.nextElement());
                                g = (Graph)h.getObject("", new Graph(), true);
                                while (h.readSubTag("Critical")) {
                                    o = (GraphObject)h.getObject("object", null, false);
                                    if (o != null) {
                                        o.setCritical(true);
                                    }
                                    h.close();
                                }
                                if (!conflictKind) {
                                    p = this.readOverlappingMorphisms(h, r1, r2, g, 0);
                                    allOverlappings.addElement(p);
                                } else if (conflictKind) {
                                    p = this.readOverlappingMorphisms(h, r1, r2, g, 1);
                                    allOverlappings.addElement(p);
                                }
                                h.close();
                            }
                        }
                        if (!conflictKind) {
                            if (!this.layered) {
                                this.epc.addQuadruple(this.epc.getExcludeContainer(), r1, r2, b, allOverlappings);
                            } else {
                                this.lepc.addQuadruple(this.lepc.getExcludeContainer(), r1, r2, b, allOverlappings);
                            }
                        } else if (conflictKind) {
                            if (!this.layered) {
                                this.dpc.addQuadruple(this.dpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                            } else {
                                this.ldpc.addQuadruple(this.ldpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                            }
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            tagnames.clear();
            tagnames.add("conflictFreeContainer");
            tagnames.add("dependencyFreeContainer");
            if (h.readSubTag(tagnames)) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        if (bool.equals("true")) {
                            b = true;
                        }
                        if (!conflictKind) {
                            if (!this.layered) {
                                this.epc.addQuadruple(this.epc.getConflictFreeContainer(), r1, r2, b, null);
                            } else {
                                this.lepc.addQuadruple(this.lepc.getConflictFreeContainer(), r1, r2, b, null);
                            }
                        } else if (conflictKind) {
                            if (!this.layered) {
                                this.dpc.addQuadruple(this.dpc.getConflictFreeContainer(), r1, r2, b, null);
                            } else {
                                this.ldpc.addQuadruple(this.ldpc.getConflictFreeContainer(), r1, r2, b, null);
                            }
                        }
                        if (!r1.isEnabled() || !r2.isEnabled()) {
                            if (!conflictKind) {
                                if (!this.layered) {
                                    this.epc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                } else {
                                    this.lepc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                }
                            } else if (conflictKind) {
                                if (!this.layered) {
                                    this.dpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                } else {
                                    this.ldpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                }
                            }
                        } else if (r1.getLayer() != r2.getLayer() && this.layered) {
                            if (!conflictKind) {
                                this.lepc.getEntry((Rule)r1, (Rule)r2).state = 4;
                            } else if (conflictKind) {
                                this.ldpc.getEntry((Rule)r1, (Rule)r2).state = 4;
                            }
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            tagnames.clear();
            tagnames.add("dependencyContainer");
            tagnames.add("dependenciesContainer");
            if (h.readSubTag(tagnames)) {
                if (!depsRead) {
                    conflictKind = true;
                    if (!this.layered) {
                        this.dpc = (DependencyPairContainer)ParserFactory.createEmptyCriticalPairs(grammar, 1, this.layered);
                    } else {
                        this.ldpc = (LayeredDependencyPairContainer)ParserFactory.createEmptyCriticalPairs(grammar, 1, this.layered);
                    }
                    ++this.count;
                    r1s = h.getEnumeration("", null, true, "Rule");
                    if (!r1s.hasMoreElements()) {
                        r1s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r1s.hasMoreElements()) {
                        h.peekElement(r1s.nextElement());
                        r1 = (Rule)h.getObject("R1", null, false);
                        r2s = h.getEnumeration("", null, true, "Rule");
                        if (!r2s.hasMoreElements()) {
                            r2s = h.getEnumeration("", null, true, "Regel");
                        }
                        while (r2s.hasMoreElements()) {
                            h.peekElement(r2s.nextElement());
                            r2 = (Rule)h.getObject("R2", null, false);
                            bool = h.readAttr("bool");
                            b = false;
                            allOverlappings = null;
                            if (bool.equals("true")) {
                                b = true;
                                allOverlappings = new Vector();
                                overlappings = h.getEnumeration("", null, true, "Overlapping_Pair");
                                while (overlappings.hasMoreElements()) {
                                    h.peekElement(overlappings.nextElement());
                                    g = (Graph)h.getObject("", new Graph(), true);
                                    while (h.readSubTag("Critical")) {
                                        o = (GraphObject)h.getObject("object", null, false);
                                        if (o != null) {
                                            o.setCritical(true);
                                        }
                                        h.close();
                                    }
                                    p = this.readOverlappingMorphisms(h, r1, r2, g, 1);
                                    allOverlappings.addElement(p);
                                    h.close();
                                }
                            }
                            if (!this.layered) {
                                this.dpc.addQuadruple(this.dpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                            } else {
                                this.ldpc.addQuadruple(this.ldpc.getExcludeContainer(), r1, r2, b, allOverlappings);
                            }
                            h.close();
                        }
                        h.close();
                    }
                }
                h.close();
                tagnames.clear();
                tagnames.add("conflictFreeContainer");
                tagnames.add("dependencyFreeContainer");
                if (h.readSubTag(tagnames)) {
                    if (!depsRead) {
                        Enumeration r1s1 = h.getEnumeration("", null, true, "Rule");
                        if (!r1s1.hasMoreElements()) {
                            r1s1 = h.getEnumeration("", null, true, "Regel");
                        }
                        while (r1s1.hasMoreElements()) {
                            h.peekElement(r1s1.nextElement());
                            r1 = (Rule)h.getObject("R1", null, false);
                            r2s = h.getEnumeration("", null, true, "Rule");
                            if (!r2s.hasMoreElements()) {
                                r2s = h.getEnumeration("", null, true, "Regel");
                            }
                            while (r2s.hasMoreElements()) {
                                h.peekElement(r2s.nextElement());
                                r2 = (Rule)h.getObject("R2", null, false);
                                bool = h.readAttr("bool");
                                b = false;
                                if (bool.equals("true")) {
                                    b = true;
                                }
                                if (!this.layered) {
                                    this.dpc.addQuadruple(this.dpc.getConflictFreeContainer(), r1, r2, b, null);
                                } else {
                                    this.ldpc.addQuadruple(this.ldpc.getConflictFreeContainer(), r1, r2, b, null);
                                }
                                if (!r1.isEnabled() || !r2.isEnabled()) {
                                    if (!this.layered) {
                                        this.dpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                    } else {
                                        this.ldpc.getEntry((Rule)r1, (Rule)r2).state = 5;
                                    }
                                } else if (r1.getLayer() != r2.getLayer() && this.layered) {
                                    this.ldpc.getEntry((Rule)r1, (Rule)r2).state = 4;
                                }
                                h.close();
                            }
                            h.close();
                        }
                    }
                    h.close();
                }
            }
            this.cpaBasisGraph = new Graph();
            if (h.readSubTag("ConflictDependencyGraph")) {
                if (h.readSubTag("Types")) {
                    Type t;
                    Enumeration en = h.getEnumeration("", null, true, "NodeType");
                    while (en.hasMoreElements()) {
                        h.peekElement(en.nextElement());
                        t = this.cpaBasisGraph.getTypeSet().createType();
                        h.loadObject(t);
                        h.close();
                        if (!t.getAdditionalRepr().equals("")) continue;
                        t.setAdditionalRepr("[NODE]");
                    }
                    en = h.getEnumeration("", null, true, "EdgeType");
                    while (en.hasMoreElements()) {
                        h.peekElement(en.nextElement());
                        t = this.cpaBasisGraph.getTypeSet().createType();
                        h.loadObject(t);
                        h.close();
                        if (!t.getAdditionalRepr().equals("")) continue;
                        t.setAdditionalRepr("[EDGE]");
                    }
                    h.close();
                }
                h.getObject("", this.cpaBasisGraph, true);
                this.cpaGraph = new EdGraph(this.cpaBasisGraph);
                this.cpaGraph.setCPAgraph(true);
                h.enrichObject(this.cpaGraph);
                h.close();
                Vector cpaEdgeTypes = this.cpaGraph.getTypeSet().getArcTypes();
                for (int i = 0; i < cpaEdgeTypes.size(); ++i) {
                    EdType t = (EdType)cpaEdgeTypes.get(i);
                    if (t.getBasisType().getName().equals("c")) {
                        t.setColor(Color.RED);
                    } else if (t.getBasisType().getName().equals("d")) {
                        t.setColor(Color.BLUE);
                    }
                    t.setAdditionalReprOfBasisType();
                }
            }
        }
    }

    protected void writeOverlapMorphisms(XMLHelper h, Rule r1, Rule r2, Pair overlapping) {
        Pair p1 = (Pair)overlapping.first;
        OrdinaryMorphism first = (OrdinaryMorphism)p1.first;
        h.openSubTag("Morphism");
        h.addAttr("name", first.getName());
        if (first.getSource() == r1.getLeft()) {
            h.addAttr("source", "LHS");
        } else if (first.getSource() == r1.getRight()) {
            h.addAttr("source", "RHS");
        }
        Enumeration e = first.getDomain();
        while (e.hasMoreElements()) {
            GraphObject s = (GraphObject)e.nextElement();
            h.openSubTag("Mapping");
            h.addObject("orig", s, false);
            h.addObject("image", first.getImage(s), false);
            h.close();
        }
        h.close();
        OrdinaryMorphism second = (OrdinaryMorphism)p1.second;
        Pair p2 = (Pair)overlapping.second;
        if (p2 == null) {
            if (second.getSource() == r2.getLeft()) {
                h.openSubTag("Morphism");
                h.addAttr("name", second.getName());
                h.addAttr("source", "LHS");
                e = second.getDomain();
                while (e.hasMoreElements()) {
                    GraphObject s = (GraphObject)e.nextElement();
                    h.openSubTag("Mapping");
                    h.addObject("orig", s, false);
                    h.addObject("image", second.getImage(s), false);
                    h.close();
                }
            }
        } else {
            OrdinaryMorphism morphL2iso = (OrdinaryMorphism)p2.first;
            OrdinaryMorphism morphNAC2iso = (OrdinaryMorphism)p2.second;
            h.openSubTag("Morphism");
            h.addAttr("name", second.getName());
            h.addAttr("source", "NAC+LHS");
            e = second.getDomain();
            while (e.hasMoreElements()) {
                GraphObject src = (GraphObject)e.nextElement();
                GraphObject t = second.getImage(src);
                GraphObject s = null;
                if (morphL2iso.getInverseImage(src).hasMoreElements()) {
                    s = (GraphObject)morphL2iso.getInverseImage(src).nextElement();
                } else if (morphNAC2iso.getInverseImage(src).hasMoreElements()) {
                    s = (GraphObject)morphNAC2iso.getInverseImage(src).nextElement();
                }
                if (s == null) continue;
                h.openSubTag("Mapping");
                h.addObject("orig", s, false);
                h.addObject("image", t, false);
                h.close();
            }
        }
        h.close();
    }

    protected Pair readOldOverlappingMorphisms(XMLHelper h, Rule r1, Rule r2, String firstName, Graph overlapGraph, int conflictKind) {
        OrdinaryMorphism first = null;
        if (conflictKind == 0) {
            first = BaseFactory.theFactory().createMorphism(r1.getLeft(), overlapGraph);
        } else if (conflictKind == 1) {
            first = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
        }
        OrdinaryMorphism second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
        first.setName(firstName.replaceAll(" ", ""));
        while (h.readSubTag("Mapping")) {
            GraphObject o = (GraphObject)h.getObject("orig", null, false);
            GraphObject i = (GraphObject)h.getObject("image", null, false);
            if (o != null && i != null) {
                first.addMapping(o, i);
            }
            h.close();
        }
        h.close();
        if (h.readSubTag("Morphism")) {
            String name = h.readAttr("name");
            second.setName(name.replaceAll(" ", ""));
            while (h.readSubTag("Mapping")) {
                GraphObject o = (GraphObject)h.getObject("orig", null, false);
                GraphObject i = (GraphObject)h.getObject("image", null, false);
                if (o != null && i != null) {
                    second.addMapping(o, i);
                }
                h.close();
            }
            h.close();
        }
        return new Pair(first, second);
    }

    protected Pair readOverlappingMorphisms(XMLHelper h, Rule r1, Rule r2, Graph overlapGraph, int conflictKind) {
        OrdinaryMorphism first = null;
        OrdinaryMorphism second = null;
        Pair p = null;
        Pair p1 = null;
        Pair p2 = null;
        if (h.readSubTag("Morphism")) {
            String name = h.readAttr("name");
            String source = h.readAttr("source");
            if (source.equals("")) {
                p = this.readOldOverlappingMorphisms(h, r1, r2, name, overlapGraph, conflictKind);
                return new Pair(p, null);
            }
            if (source.equals("LHS")) {
                first = BaseFactory.theFactory().createMorphism(r1.getLeft(), overlapGraph);
            } else if (source.equals("RHS")) {
                first = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
            }
            first.setName(name.replaceAll(" ", ""));
            while (h.readSubTag("Mapping")) {
                GraphObject o = (GraphObject)h.getObject("orig", null, false);
                GraphObject i = (GraphObject)h.getObject("image", null, false);
                if (o != null && i != null) {
                    first.addMapping(o, i);
                }
                h.close();
            }
            h.close();
        }
        if (h.readSubTag("Morphism")) {
            OrdinaryMorphism morphL2iso = null;
            OrdinaryMorphism morphNAC2iso = null;
            String name = h.readAttr("name");
            String source = h.readAttr("source");
            if (source.equals("LHS")) {
                second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
            } else if (source.equals("NAC+LHS")) {
                OrdinaryMorphism nac = null;
                Enumeration e = r2.getNACs();
                while (e.hasMoreElements()) {
                    OrdinaryMorphism n = (OrdinaryMorphism)e.nextElement();
                    if (!overlapGraph.info.equals(n.getName())) continue;
                    nac = n;
                    break;
                }
                morphL2iso = r2.getLeft().isomorphicCopy();
                morphNAC2iso = this.extendLeftGraph(morphL2iso, nac);
                Graph N2 = morphL2iso.getTarget();
                second = BaseFactory.theFactory().createMorphism(N2, overlapGraph);
            }
            if (second != null) {
                second.setName(name.replaceAll(" ", ""));
                while (h.readSubTag("Mapping")) {
                    GraphObject o = (GraphObject)h.getObject("orig", null, false);
                    GraphObject i = (GraphObject)h.getObject("image", null, false);
                    if (o != null && i != null) {
                        if (source.equals("LHS")) {
                            second.addMapping(o, i);
                        } else if (source.equals("NAC+LHS")) {
                            GraphObject s = morphL2iso.getImage(o);
                            if (s == null && morphNAC2iso != null) {
                                s = morphNAC2iso.getImage(o);
                            }
                            if (s != null) {
                                second.addMapping(s, i);
                            }
                        }
                    }
                    h.close();
                }
                if (source.equals("NAC+LHS")) {
                    p2 = new Pair(morphL2iso, morphNAC2iso);
                }
            }
            h.close();
        }
        if (first != null && second != null) {
            p1 = new Pair(first, second);
            p = new Pair(p1, p2);
        }
        return p;
    }

    private OrdinaryMorphism extendLeftGraph(OrdinaryMorphism isoLeft, OrdinaryMorphism nac) {
        GraphObject o;
        if (isoLeft == null || nac == null) {
            return null;
        }
        Graph extLeft = isoLeft.getTarget();
        OrdinaryMorphism isoNAC = BaseFactory.theFactory().createMorphism(nac.getTarget(), extLeft);
        Hashtable<Node, Node> tmp = new Hashtable<Node, Node>(5);
        Enumeration e = nac.getTarget().getNodes();
        while (e.hasMoreElements()) {
            o = (GraphObject)e.nextElement();
            if (!nac.getInverseImage(o).hasMoreElements()) {
                try {
                    Node n = extLeft.createNode((Node)o);
                    tmp.put((Node)o, n);
                    isoNAC.addMapping(o, n);
                }
                catch (TypeException ex) {}
                continue;
            }
            isoNAC.addMapping(o, isoLeft.getImage((GraphObject)nac.getInverseImage(o).nextElement()));
        }
        e = nac.getTarget().getArcs();
        while (e.hasMoreElements()) {
            o = (GraphObject)e.nextElement();
            if (!nac.getInverseImage(o).hasMoreElements()) {
                Node tar;
                Node src = (Node)tmp.get((Node)((Arc)o).getSource());
                if (src == null) {
                    src = (Node)isoLeft.getImage((Node)nac.getInverseImage((Node)((Arc)o).getSource()).nextElement());
                }
                if ((tar = (Node)tmp.get((Node)((Arc)o).getTarget())) == null) {
                    tar = (Node)isoLeft.getImage((Node)nac.getInverseImage((Node)((Arc)o).getTarget()).nextElement());
                }
                try {
                    Arc a = extLeft.createArc((Arc)o, src, tar);
                    isoNAC.addMapping(o, a);
                }
                catch (TypeException ex) {}
                continue;
            }
            isoNAC.addMapping(o, isoLeft.getImage((GraphObject)nac.getInverseImage(o).nextElement()));
        }
        return isoNAC;
    }
}

