/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.ExcludePairContainer;
import agg.parser.InvalidAlgorithmException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Consistency
implements Runnable {
    ExcludePairContainer excludeContainer;
    Rule rule1;
    Rule rule2;

    public Consistency(ExcludePairContainer excludeContainer) {
        this.excludeContainer = excludeContainer;
        this.rule1 = null;
        this.rule2 = null;
    }

    public Consistency(ExcludePairContainer excludeContainer, Rule r1, Rule r2) {
        this(excludeContainer);
        this.rule1 = r1;
        this.rule2 = r2;
    }

    public void run() {
        if (this.rule1 != null && this.rule2 != null) {
            this.checkRulePair();
        } else {
            this.check();
        }
    }

    public void check() {
        try {
            Hashtable excludeCont = this.excludeContainer.getContainer(0);
            GraGra gra = this.excludeContainer.getGrammar();
            Enumeration keys = excludeCont.keys();
            while (keys.hasMoreElements()) {
                Rule r1 = (Rule)keys.nextElement();
                Hashtable secondPart = (Hashtable)excludeCont.get(r1);
                Enumeration k2 = secondPart.keys();
                while (k2.hasMoreElements()) {
                    Rule r2 = (Rule)k2.nextElement();
                    Pair pair = (Pair)secondPart.get(r2);
                    Boolean b = (Boolean)pair.first;
                    if (!b.booleanValue()) continue;
                    Vector v = (Vector)pair.second;
                    int size = v.size();
                    boolean inconsistent = false;
                    for (int i = 0; i < size; ++i) {
                        inconsistent = false;
                        Pair p = (Pair)v.elementAt(i);
                        Graph g = ((OrdinaryMorphism)p.first).getImage();
                        if (gra.checkGraphConsistency(g)) continue;
                        inconsistent = true;
                        v.removeElement(p);
                        BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.first);
                        BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.second);
                        --i;
                        size = v.size();
                    }
                    if (v.size() != 0) continue;
                    this.excludeContainer.moveEntryFromExcludeToConflictFreeContainer(r1, r2);
                }
            }
        }
        catch (InvalidAlgorithmException invalidAlgorithmException) {
            // empty catch block
        }
    }

    public void checkRulePair() {
        try {
            Hashtable excludeCont = this.excludeContainer.getContainer(0);
            GraGra gra = this.excludeContainer.getGrammar();
            Enumeration keys = excludeCont.keys();
            while (keys.hasMoreElements()) {
                Rule r1 = (Rule)keys.nextElement();
                if (r1 != this.rule1) continue;
                Hashtable secondPart = (Hashtable)excludeCont.get(r1);
                Enumeration k2 = secondPart.keys();
                while (k2.hasMoreElements()) {
                    Rule r2 = (Rule)k2.nextElement();
                    if (r2 != this.rule2) continue;
                    Pair pair = (Pair)secondPart.get(r2);
                    Boolean b = (Boolean)pair.first;
                    if (!b.booleanValue()) continue;
                    Vector v = (Vector)pair.second;
                    int size = v.size();
                    for (int i = 0; i < size; ++i) {
                        boolean inconsistent = false;
                        Pair p = (Pair)v.elementAt(i);
                        Graph g = ((OrdinaryMorphism)p.first).getImage();
                        if (g.isEmpty() || gra.checkGraphConsistency(g)) continue;
                        v.removeElement(p);
                        BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.first);
                        BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.second);
                        --i;
                        size = v.size();
                    }
                    if (v.size() != 0) continue;
                    this.excludeContainer.moveEntryFromExcludeToConflictFreeContainer(r1, r2);
                }
            }
        }
        catch (InvalidAlgorithmException invalidAlgorithmException) {
            // empty catch block
        }
    }
}

