/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.attribute.impl.ContextView;
import agg.attribute.impl.VarTuple;
import agg.parser.ComputingThread;
import agg.parser.CriticalPairEvent;
import agg.parser.ExcludePair;
import agg.parser.InvalidAlgorithmException;
import agg.parser.LayerFunction;
import agg.parser.PairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserMessageEvent;
import agg.parser.Report;
import agg.parser.SimpleExcludePair;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Step;
import agg.xt_basis.TypeException;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExcludePairContainer
implements PairContainer,
Runnable {
    protected Hashtable excludeContainer = null;
    protected Hashtable criticalMatchContainer = null;
    protected boolean calculateParallel = false;
    protected Hashtable conflictFreeContainer = null;
    public Hashtable commonContainer = new Hashtable();
    protected int conflictKind = 0;
    protected GraGra grammar;
    protected boolean isComputed;
    protected boolean isComputedLocal;
    protected Vector listener;
    protected boolean stop;
    protected boolean isAlive;
    protected ExcludePair excludePair;
    protected boolean complete;
    protected boolean reduce;
    protected boolean withNACs;
    protected boolean consistent;
    protected boolean useHostGraph;
    protected Hashtable excludeContainerForTestGraph;
    protected Graph testGraph;
    protected MorphCompletionStrategy strategy;
    protected boolean isEmpty = true;

    public ExcludePairContainer(GraGra gragra) {
        this.grammar = gragra;
        this.isComputed = false;
        this.initAllContainer();
        this.listener = new Vector(2);
        this.stop = false;
        this.isAlive = false;
        this.complete = true;
        this.reduce = true;
        this.withNACs = true;
        this.consistent = true;
        if (this.grammar != null) {
            this.calculateParallel = this.grammar.getGraTraOptions().contains("PARALLEL");
        }
    }

    public void run() {
        long time0 = System.currentTimeMillis();
        Runtime.getRuntime().gc();
        long maxMem = Runtime.getRuntime().maxMemory() / 1024L;
        long freem0 = Runtime.getRuntime().freeMemory() / 1024L;
        System.out.println("Free memory: " + freem0 + "k");
        this.stop = false;
        this.isAlive = true;
        this.firePairEvent(new ParserMessageEvent(this, "Thread  - Critical pairs -  runs ..."));
        this.fillContainers();
        if (this.stop) {
            this.firePairEvent(new ParserMessageEvent(this, "Thread  -  Critical pairs  -  was stopped."));
            this.stop = false;
        } else {
            long time1 = System.currentTimeMillis();
            long timeMillis = time1 - time0;
            long time_sec = timeMillis / 1000L;
            long msec = timeMillis - time_sec * 1000L;
            long time_min = time_sec / 60L;
            long sec = time_sec - time_min * 60L;
            long hour = time_min / 60L;
            long min = time_min - hour * 60L;
            System.out.println("Used time: " + hour + "h " + min + "m " + sec + "s " + msec + "ms");
            maxMem = Runtime.getRuntime().maxMemory() / 1024L;
            long freem1 = Runtime.getRuntime().freeMemory() / 1024L;
            System.out.println("Free memory: " + freem1 + "k");
            long usedm = freem0 - freem1;
            System.out.println("CPA:  Used memory: " + usedm + "k");
            Runtime.getRuntime().gc();
            this.firePairEvent(new ParserMessageEvent(this, "Thread  -  Critical pairs  -  finished."));
        }
        this.isAlive = false;
    }

    public void stop() {
        this.stop = true;
        if (this.excludePair != null) {
            this.excludePair.stop = true;
        }
        Report.println("ExcludePairContainer.stop   called");
    }

    public void setStop(boolean b) {
        this.stop = b;
        if (this.stop) {
            this.stop();
        }
    }

    public boolean wasStopped() {
        return this.stop;
    }

    public Object getCritical(Rule r1, Rule r2, int kind) throws InvalidAlgorithmException {
        return this.getCritical(r1, r2, this.getContainer(kind));
    }

    public Object getCritical(Rule r1, Rule r2, int kind, boolean local) throws InvalidAlgorithmException {
        if (local) {
            return this.getCritical(r1, r2, this.getContainer(kind, r1, r2));
        }
        return this.getCritical(r1, r2, this.getContainer(kind));
    }

    protected synchronized Vector getCritical(Rule r1, Rule r2, Hashtable container) {
        if (this.stop) {
            return null;
        }
        Hashtable secondPart = (Hashtable)container.get(r1);
        if (secondPart != null) {
            Pair p = (Pair)secondPart.get(r2);
            if (p != null) {
                if (((Boolean)p.first).booleanValue()) {
                    this.firePairEvent(new CriticalPairEvent(this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
                    return (Vector)p.second;
                }
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
                return null;
            }
            if (this.stop) {
                return null;
            }
            this.computeCritical(r1, r2);
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
            return this.getCritical(r1, r2, container);
        }
        if (this.stop) {
            return null;
        }
        this.computeCritical(r1, r2);
        this.firePairEvent(new CriticalPairEvent(this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
        return this.getCritical(r1, r2, container);
    }

    public synchronized Vector getLHSoverlappings(Rule r1, Rule r2, Vector criticalPairs) {
        Vector<Pair> matches = new Vector<Pair>(5);
        Vector cps = criticalPairs;
        if (cps == null || cps.isEmpty()) {
            cps = this.getCritical(r1, r2, this.excludeContainer);
        }
        if (cps != null && !cps.isEmpty()) {
            for (int i = 0; i < cps.size(); ++i) {
                Pair overlapPair;
                Pair isoPair;
                Pair pi = (Pair)cps.get(i);
                Vector triple = this.getValidMatch1Match2(r1, r2, pi);
                if (triple == null || triple.isEmpty() || (isoPair = this.isIsomorphicOverlapping(matches, overlapPair = new Pair((OrdinaryMorphism)triple.get(0), (OrdinaryMorphism)triple.get(1)))) != null) continue;
                matches.add(new Pair((OrdinaryMorphism)triple.get(0), (OrdinaryMorphism)triple.get(1)));
            }
        }
        return matches;
    }

    public synchronized Vector getLHSoverlappings(Rule r1, Rule r2, Vector criticalPairs, Vector overlapGraphIso) {
        Vector<Pair> matches = new Vector<Pair>(5);
        Vector cps = criticalPairs;
        if (cps == null || cps.isEmpty()) {
            cps = this.getCritical(r1, r2, this.excludeContainer);
        }
        if (cps != null && !cps.isEmpty()) {
            for (int i = 0; i < cps.size(); ++i) {
                Pair overlapPair;
                Pair isoPair;
                Pair pi = (Pair)cps.get(i);
                Vector triple = this.getValidMatch1Match2(r1, r2, pi);
                if (triple == null || triple.isEmpty() || (isoPair = this.isIsomorphicOverlapping(matches, overlapPair = new Pair((OrdinaryMorphism)triple.get(0), (OrdinaryMorphism)triple.get(1)))) != null) continue;
                matches.add(new Pair((OrdinaryMorphism)triple.get(0), (OrdinaryMorphism)triple.get(1)));
                if (overlapGraphIso == null) continue;
                overlapGraphIso.add((OrdinaryMorphism)triple.get(2));
            }
        }
        return matches;
    }

    private Vector getValidMatch1Match2(Rule r1, Rule r2, Pair criticalPair) {
        BaseFactory bf = BaseFactory.theFactory();
        Vector<Object> result = new Vector<Object>(3);
        Pair p1 = (Pair)criticalPair.first;
        Pair p2 = (Pair)criticalPair.second;
        if (p2 == null) {
            result.add(p1.first);
            result.add(p1.second);
            result.add(null);
            return result;
        }
        OrdinaryMorphism overlapMorph1prime = (OrdinaryMorphism)p1.first;
        OrdinaryMorphism overlapMorph2prime = (OrdinaryMorphism)p1.second;
        OrdinaryMorphism L2iso = (OrdinaryMorphism)p2.first;
        if (overlapMorph1prime.getSource() == r1.getRight()) {
            Pair inverseR1pair = bf.makeAbstractInverseRule(r1);
            Rule inverseR1 = (Rule)inverseR1pair.first;
            OrdinaryMorphism isoLeftR1 = (OrdinaryMorphism)((Pair)inverseR1pair.second).first;
            OrdinaryMorphism isoRightR1 = (OrdinaryMorphism)((Pair)inverseR1pair.second).second;
            OrdinaryMorphism morph1prime = overlapMorph1prime.completeDiagram(isoRightR1);
            OrdinaryMorphism targetIso = morph1prime.getTarget().isomorphicCopy();
            OrdinaryMorphism morph1primeTest = morph1prime.compose(targetIso);
            ((ContextView)morph1primeTest.getAttrContext()).setVariableContext(true);
            Match m1primeTest = bf.makeMatch(inverseR1, morph1primeTest);
            m1primeTest.setCompletionStrategy(new Completion_InjCSP());
            Step s = new Step();
            OrdinaryMorphism ms = null;
            try {
                ms = (OrdinaryMorphism)s.execute(m1primeTest, true);
            }
            catch (TypeException e) {
                // empty catch block
            }
            if (ms == null) {
                bf.destroyMorphism(m1primeTest);
                m1primeTest = null;
                bf.destroyMorphism(morph1primeTest);
                morph1primeTest = null;
                return null;
            }
            OrdinaryMorphism morph1test = isoLeftR1.compose(ms);
            Match m1test = bf.makeMatch(r1, morph1test);
            OrdinaryMorphism morph2primeTest = overlapMorph2prime.compose(targetIso);
            OrdinaryMorphism morph2test = L2iso.compose(morph2primeTest);
            Match m2test = bf.makeMatch(r2, morph2test);
            overlapMorph2prime.getTarget().unsetTransientAttrValues();
            result.add(m1test);
            result.add(m2test);
            result.add(targetIso);
            return result;
        }
        OrdinaryMorphism morph2primeTest = L2iso.compose(overlapMorph2prime);
        Match m2test = bf.makeMatch(r2, morph2primeTest);
        overlapMorph2prime.getTarget().unsetTransientAttrValues();
        result.add(overlapMorph1prime);
        result.add(m2test);
        result.add(null);
        return result;
    }

    public Pair isIsomorphicOverlapping(Vector overlapPairs, Pair overlapPair) {
        Graph overlapGraph = ((OrdinaryMorphism)overlapPair.first).getTarget();
        for (int j = 0; j < overlapPairs.size() && !this.stop; ++j) {
            Hashtable map;
            Pair p1 = (Pair)overlapPairs.elementAt(j);
            Graph g = ((OrdinaryMorphism)p1.first).getTarget();
            Vector overlapIsos = g.getIsomorphicWith(overlapGraph, map = this.getMorphismMap((OrdinaryMorphism)p1.first, (OrdinaryMorphism)overlapPair.first));
            if (overlapIsos == null) continue;
            for (int i = 0; i < overlapIsos.size(); ++i) {
                OrdinaryMorphism overlapIso = (OrdinaryMorphism)overlapIsos.get(i);
                if (overlapIso == null || !((OrdinaryMorphism)p1.first).isIsomorphicTo((OrdinaryMorphism)overlapPair.first, overlapIso) || !((OrdinaryMorphism)p1.second).isIsomorphicTo((OrdinaryMorphism)overlapPair.second, overlapIso)) continue;
                return p1;
            }
        }
        return null;
    }

    private Hashtable getMorphismMap(OrdinaryMorphism m1, OrdinaryMorphism m2) {
        Hashtable<GraphObject, GraphObject> map = new Hashtable<GraphObject, GraphObject>(m1.getSize());
        Enumeration e = m1.getDomain();
        while (e.hasMoreElements()) {
            GraphObject o1 = (GraphObject)e.nextElement();
            GraphObject o = m1.getImage(o1);
            GraphObject i = m2.getImage(o1);
            map.put(o, i);
        }
        return map;
    }

    private Hashtable getMorphismMap(OrdinaryMorphism m1, OrdinaryMorphism m2, Hashtable map) {
        if (map == null) {
            map = new Hashtable<GraphObject, GraphObject>();
        }
        Enumeration e = m1.getDomain();
        while (e.hasMoreElements()) {
            GraphObject o1 = (GraphObject)e.nextElement();
            GraphObject o = m1.getImage(o1);
            GraphObject i = m2.getImage(o1);
            GraphObject v = (GraphObject)map.get(o);
            if (v == null) {
                map.put(o, i);
            }
            if (v == i) continue;
            return null;
        }
        return map;
    }

    public int getNumberOfContainers() {
        return 2;
    }

    public Hashtable getExcludeContainer() {
        return this.excludeContainer;
    }

    public Hashtable getConflictFreeContainer() {
        return this.conflictFreeContainer;
    }

    public Hashtable getContainer(int kind) throws InvalidAlgorithmException {
        if (!this.isComputed && !this.stop) {
            this.fillContainers();
        }
        if (kind == 0) {
            return this.excludeContainer;
        }
        if (kind == 2) {
            return this.conflictFreeContainer;
        }
        throw new InvalidAlgorithmException("No such algorithm", kind);
    }

    public Hashtable getContainer(int kind, Rule r1, Rule r2) throws InvalidAlgorithmException {
        this.isComputedLocal = this.isComputed;
        if (!this.isComputedLocal) {
            if (kind == 2 && this.conflictFreeContainer != null && this.conflictFreeContainer.containsKey(r1)) {
                this.isComputedLocal = true;
            } else if (kind == 0 && this.excludeContainer != null && this.excludeContainer.containsKey(r1)) {
                this.isComputedLocal = true;
            }
        }
        if (!this.isComputedLocal && !this.stop) {
            this.fillContainers(r1, r2);
        }
        if (kind == 0) {
            return this.excludeContainer;
        }
        if (kind == 2) {
            return this.conflictFreeContainer;
        }
        throw new InvalidAlgorithmException("No such algorithm", kind);
    }

    public Vector getCriticalSet(int kind, Rule rule) throws InvalidAlgorithmException {
        return this.getCriticalSet(this.getContainer(kind), rule);
    }

    private Vector getCriticalSet(Hashtable container, Rule rule) {
        Vector resultVector = new Vector();
        Vector<Object> tmpVector = new Vector<Object>();
        Hashtable value = (Hashtable)container.get(rule);
        Enumeration keys = value.keys();
        while (keys.hasMoreElements()) {
            Rule key = (Rule)keys.nextElement();
            Pair p = (Pair)value.get(key);
            if (!((Boolean)p.first).booleanValue()) continue;
            tmpVector.addElement(p.second);
        }
        for (int i = 0; i < tmpVector.size(); ++i) {
            Vector element = (Vector)tmpVector.elementAt(i);
            for (int j = 0; j < element.size(); ++j) {
                resultVector.addElement(element.elementAt(j));
            }
        }
        return resultVector;
    }

    public void setGrammar(GraGra gragra) {
        this.grammar = gragra;
        if (this.grammar != null) {
            this.calculateParallel = this.grammar.getGraTraOptions().contains("PARALLEL");
        }
    }

    public GraGra getGrammar() {
        return this.grammar;
    }

    public void initAllContainer() {
        this.conflictFreeContainer = new Hashtable();
        this.excludeContainer = new Hashtable();
        this.criticalMatchContainer = new Hashtable();
        this.commonContainer = new Hashtable();
    }

    protected void fillContainers() {
        if (this.useHostGraph) {
            this.grammar.getApplicableRules(this.testGraph, this.strategy);
        }
        if (!this.useHostGraph) {
            this.isComputed = false;
        }
        Vector rules2 = new Vector();
        Enumeration r = this.grammar.getRules();
        while (r.hasMoreElements()) {
            rules2.addElement(r.nextElement());
        }
        if (this.stop) {
            return;
        }
        Enumeration rules1 = this.grammar.getRules();
        while (rules1.hasMoreElements()) {
            Rule r1 = (Rule)rules1.nextElement();
            if (this.stop) {
                return;
            }
            for (int i = 0; i < rules2.size(); ++i) {
                if (this.stop) {
                    return;
                }
                Rule r2 = (Rule)rules2.elementAt(i);
                if (this.stop) {
                    return;
                }
                this.scheduleForComputing(r1, r2);
                if (!this.stop) continue;
                return;
            }
        }
        if (!this.useHostGraph) {
            this.isComputed = true;
        }
    }

    protected void scheduleForComputing(Rule r1, Rule r2) {
        if (this.useHostGraph) {
            if (this.getEntry((Rule)r1, (Rule)r2).state == 3) {
                if (r1.isApplicable() && r2.isApplicable()) {
                    if (this.computeCritical(r1, r2, this.testGraph)) {
                        this.firePairEvent(new CriticalPairEvent(this, r1, r2, 1));
                    } else {
                        this.firePairEvent(new CriticalPairEvent(this, r1, r2, 0));
                    }
                } else {
                    this.firePairEvent(new CriticalPairEvent(this, r1, r2, 2));
                }
            } else {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, 2));
            }
            return;
        }
        if (this.getEntry((Rule)r1, (Rule)r2).state == 0) {
            this.getEntry((Rule)r1, (Rule)r2).state = 1;
        }
        if (this.calculateParallel) {
            new ComputingThread(this, r1, r2);
        } else {
            this.computeCritical(r1, r2);
        }
    }

    protected void fillContainers(Rule r1, Rule r2) {
        this.isComputedLocal = false;
        if (this.getEntry((Rule)r1, (Rule)r2).state == 0) {
            this.getEntry((Rule)r1, (Rule)r2).state = 1;
        }
        this.computeCritical(r1, r2);
        this.isComputedLocal = true;
    }

    protected synchronized void computeCritical(Rule r1, Rule r2) {
        Report.trace("ExcludePairContainer: start computeCritical" + this.getEntry((Rule)r1, (Rule)r2).state + "   " + r1.getName() + "    " + r2.getName(), 2);
        if (!r1.isEnabled() || !r2.isEnabled()) {
            this.getEntry((Rule)r1, (Rule)r2).state = 5;
            this.addEntry(r1, r2, false, null);
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, false, null);
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  should not be computed."));
            return;
        }
        if (this.getEntry((Rule)r1, (Rule)r2).state == 1 || this.getEntry((Rule)r1, (Rule)r2).state == 0) {
            boolean critic;
            this.getEntry((Rule)r1, (Rule)r2).state = 2;
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "Computing critical rule pair  [  " + r1.getName() + "  ,  " + r2.getName() + "  ]"));
            this.excludePair = !this.complete ? new SimpleExcludePair() : new ExcludePair();
            this.excludePair.enableNACs(this.withNACs);
            this.excludePair.enableReduce(this.reduce);
            this.excludePair.enableConsistent(this.consistent, this.grammar);
            this.excludePair.setMorphismCompletionStrategy(this.grammar.getMorphismCompletionStrategy());
            Vector overlapping = null;
            try {
                overlapping = (Vector)this.excludePair.isCritical(0, r1, r2);
                if (this.stop) {
                    this.getEntry((Rule)r1, (Rule)r2).state = 0;
                    if (overlapping != null && !overlapping.isEmpty()) {
                        overlapping.clear();
                        overlapping = null;
                    }
                }
            }
            catch (InvalidAlgorithmException iae) {
                // empty catch block
            }
            this.excludePair.dispose();
            this.excludePair = null;
            System.gc();
            boolean bl = critic = overlapping != null;
            if (this.stop && this.getEntry((Rule)r1, (Rule)r2).state == 0) {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, "Computing critical stopped."));
                return;
            }
            this.addEntry(r1, r2, critic, overlapping);
            this.addQuadruple(this.excludeContainer, r1, r2, critic, overlapping);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, !critic, null);
            if (overlapping != null) {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have critical pairs"));
            } else {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have no critical pairs"));
            }
        }
        Report.trace("ExcludePairContainer: beende computeCritical", -2);
    }

    protected synchronized boolean computeCritical(Rule r1, Rule r2, Graph g) {
        Report.trace("ExcludePairContainer: starte computeCritical" + this.getEntry((Rule)r1, (Rule)r2).state + "   " + r1.getName() + "    " + r2.getName(), 2);
        if (this.getEntry((Rule)r1, (Rule)r2).state == 3) {
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "Computing critical rule pair  [  " + r1.getName() + "  ,  " + r2.getName() + "  ]"));
            boolean critic = this.checkCritical(r1, r2, g);
            if (critic) {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + "> are critical on the host graph"));
                return true;
            }
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + "> are not critical on the host graph"));
            return false;
        }
        return false;
    }

    protected synchronized void addQuadruple(Hashtable container, Rule r1, Rule r2, boolean critic, Vector overlapping) {
        Hashtable secondPart;
        if (container.containsKey(r1)) {
            secondPart = (Hashtable)container.get(r1);
            secondPart.put(r2, new Pair(new Boolean(critic), overlapping));
        } else {
            secondPart = new Hashtable();
            secondPart.put(r2, new Pair(new Boolean(critic), overlapping));
            container.put(r1, secondPart);
        }
        Entry entry = this.getEntry(r1, r2, true);
        if (entry == null) {
            this.addEntry(r1, r2, critic, overlapping);
        }
    }

    protected synchronized void addEntry(Rule r1, Rule r2, boolean critical, Vector overlapping) {
        Entry entry = this.getEntry(r1, r2);
        if (entry.state != 5 && entry.state != 4) {
            entry.state = 3;
        }
        entry.isCritical = critical;
        entry.overlapping = overlapping;
        this.isEmpty = false;
    }

    public synchronized Entry getEntry(Rule r1, Rule r2) {
        Entry entry;
        Hashtable<Rule, Entry> secondPart = (Hashtable<Rule, Entry>)this.commonContainer.get(r1);
        if (secondPart == null) {
            secondPart = new Hashtable<Rule, Entry>();
            this.commonContainer.put(r1, secondPart);
        }
        if ((entry = (Entry)secondPart.get(r2)) == null) {
            entry = new Entry();
            secondPart.put(r2, entry);
        }
        return entry;
    }

    public synchronized Entry getEntry(Rule r1, Rule r2, boolean alreadyExistent) {
        Hashtable secondPart = (Hashtable)this.commonContainer.get(r1);
        if (secondPart == null) {
            return null;
        }
        Entry entry = (Entry)secondPart.get(r2);
        return entry;
    }

    public synchronized void clearEntry(Rule r1, Rule r2) {
        Entry entry = this.getEntry(r1, r2, true);
        if (entry != null) {
            Hashtable part2 = (Hashtable)this.excludeContainer.get(r1);
            if (part2 != null) {
                Pair p = (Pair)part2.get(r2);
                if (((Boolean)p.first).booleanValue() && p.second instanceof Vector) {
                    Vector v = (Vector)p.second;
                    for (int i = 0; i < v.size(); ++i) {
                        Pair cpi = (Pair)v.elementAt(i);
                        Pair cp = (Pair)cpi.first;
                        OrdinaryMorphism m1 = (OrdinaryMorphism)cp.first;
                        OrdinaryMorphism m2 = (OrdinaryMorphism)cp.second;
                        Graph g = m1.getTarget();
                        m1.dispose();
                        m2.dispose();
                        m1 = null;
                        m2 = null;
                        cp = null;
                        v.removeElementAt(i);
                        --i;
                    }
                }
                part2.remove(r2);
            }
            if ((part2 = (Hashtable)this.conflictFreeContainer.get(r1)) != null) {
                part2.remove(r2);
            }
            if ((part2 = (Hashtable)this.commonContainer.get(r1)) != null) {
                part2.remove(r2);
            }
            entry.isCritical = false;
            entry.overlapping = null;
            entry.state = 0;
        }
    }

    public synchronized void setEntryRelationVisible(Rule rule1, Rule rule2, boolean vis, boolean local) {
        Entry entry = this.getEntry(rule1, rule2, true);
        if (entry != null && entry.isCritical()) {
            entry.isRelationVisible = vis;
            if (!local) {
                if (vis) {
                    this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 3));
                } else {
                    this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 4));
                }
            }
        }
    }

    public synchronized void setEntryRuleVisible(Rule rule1, Rule rule2, boolean vis, boolean local, boolean context) {
        if (rule1 != rule2) {
            return;
        }
        Entry entry = this.getEntry(rule1, rule2, true);
        if (entry != null) {
            entry.isRuleVisible = vis;
            if (context) {
                Enumeration keys = this.excludeContainer.keys();
                while (keys.hasMoreElements()) {
                    Entry entry1;
                    Rule r2;
                    Rule r1 = (Rule)keys.nextElement();
                    if (r1 != rule1) continue;
                    Hashtable secondPart = (Hashtable)this.excludeContainer.get(r1);
                    Enumeration k2 = secondPart.keys();
                    while (k2.hasMoreElements()) {
                        r2 = (Rule)k2.nextElement();
                        entry1 = this.getEntry(r1, r2);
                        entry1.isRelationVisible = vis;
                        if (vis) {
                            this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 3));
                            continue;
                        }
                        this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 4));
                    }
                    k2 = secondPart.keys();
                    while (k2.hasMoreElements()) {
                        r2 = (Rule)k2.nextElement();
                        if (r2 == rule1) continue;
                        entry1 = this.getEntry(r2, r1);
                        entry1.isRelationVisible = vis;
                        if (vis) {
                            this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 3));
                            continue;
                        }
                        this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 4));
                    }
                    break block0;
                }
            }
            if (!local) {
                if (vis) {
                    this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 3));
                } else {
                    this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 4));
                }
            }
        }
    }

    public int getState(Rule r1, Rule r2) {
        return this.getEntry((Rule)r1, (Rule)r2).state;
    }

    public boolean reduceCriticalPairs() {
        boolean reduced = false;
        Enumeration keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            Rule r1 = (Rule)keys.nextElement();
            Hashtable secondPart = (Hashtable)this.excludeContainer.get(r1);
            Enumeration k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                Rule r2 = (Rule)k2.nextElement();
                Pair pair = (Pair)secondPart.get(r2);
                Boolean b = (Boolean)pair.first;
                if (!b.booleanValue()) continue;
                Vector v = (Vector)pair.second;
                int size = v.size();
                boolean found = true;
                while (size > 0 && found) {
                    found = false;
                    block3: for (int i = 0; i < size; ++i) {
                        Pair p1i = (Pair)v.elementAt(i);
                        Pair p1 = (Pair)p1i.first;
                        for (int j = i + 1; j < size; ++j) {
                            Pair p2i = (Pair)v.elementAt(j);
                            Pair p2 = (Pair)p2i.first;
                            Pair p = this.checkIfSimilar(p1, p2);
                            if (p == null) continue;
                            boolean first = false;
                            if (p == p1) {
                                first = true;
                                --i;
                            }
                            --j;
                            found = true;
                            v.removeElement(p2i);
                            BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.first);
                            p.first = null;
                            BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.second);
                            Graph tmp = ((OrdinaryMorphism)p.second).getTarget();
                            tmp = null;
                            p.second = null;
                            p = null;
                            p2i = null;
                            reduced = true;
                            size = v.size();
                            if (first) continue block3;
                        }
                    }
                }
            }
        }
        if (reduced) {
            this.firePairEvent(new ParserMessageEvent(this, "Reduction of critical pairs is done.  Please select a rule pair to see results."));
        } else {
            this.firePairEvent(new ParserMessageEvent(this, "Nothings to reduce."));
        }
        return reduced;
    }

    private Pair checkIfSimilar(Pair p1, Pair p2) {
        Pair p = null;
        OrdinaryMorphism first1 = null;
        OrdinaryMorphism second1 = null;
        OrdinaryMorphism first2 = null;
        OrdinaryMorphism second2 = null;
        OrdinaryMorphism morph1 = null;
        OrdinaryMorphism morph2 = null;
        Graph overlap1 = ((OrdinaryMorphism)p1.first).getImage();
        int n1 = 0;
        Enumeration e = overlap1.getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            if (!((OrdinaryMorphism)p1.first).getInverseImage(o).hasMoreElements() && !((OrdinaryMorphism)p1.second).getInverseImage(o).hasMoreElements()) continue;
            ++n1;
        }
        Graph overlap2 = ((OrdinaryMorphism)p2.first).getImage();
        int n2 = 0;
        e = overlap2.getElements();
        while (e.hasMoreElements()) {
            GraphObject o = (GraphObject)e.nextElement();
            if (!((OrdinaryMorphism)p2.first).getInverseImage(o).hasMoreElements() && !((OrdinaryMorphism)p2.second).getInverseImage(o).hasMoreElements()) continue;
            ++n2;
        }
        if (n1 != n2) {
            return null;
        }
        if (overlap1.getSize() <= overlap2.getSize()) {
            morph1 = BaseFactory.theFactory().createMorphism(overlap1, overlap2);
            morph2 = BaseFactory.theFactory().createMorphism(overlap1, overlap2);
            first1 = (OrdinaryMorphism)p1.first;
            first2 = (OrdinaryMorphism)p2.first;
            second1 = (OrdinaryMorphism)p1.second;
            second2 = (OrdinaryMorphism)p2.second;
            if (morph1.makeDiagram(first1, first2) && morph2.makeDiagram(second1, second2) && morph1.isPartialIsomorphicTo(morph2)) {
                p = p2;
            }
        } else {
            morph1 = BaseFactory.theFactory().createMorphism(overlap2, overlap1);
            morph2 = BaseFactory.theFactory().createMorphism(overlap2, overlap1);
            first2 = (OrdinaryMorphism)p2.first;
            first1 = (OrdinaryMorphism)p1.first;
            second2 = (OrdinaryMorphism)p2.second;
            second1 = (OrdinaryMorphism)p1.second;
            if (morph1.makeDiagram(first2, first1) && morph2.makeDiagram(second2, second1) && morph1.isPartialIsomorphicTo(morph2)) {
                p = p1;
            }
        }
        return p;
    }

    public void checkConsistency() {
        boolean inconsistent = false;
        boolean cpExists = false;
        Enumeration keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            Rule r1 = (Rule)keys.nextElement();
            Hashtable secondPart = (Hashtable)this.excludeContainer.get(r1);
            Enumeration k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                Rule r2 = (Rule)k2.nextElement();
                Pair pair = (Pair)secondPart.get(r2);
                Boolean b = (Boolean)pair.first;
                if (!b.booleanValue()) continue;
                cpExists = true;
                Vector v = (Vector)pair.second;
                int size = v.size();
                for (int i = 0; i < size; ++i) {
                    Pair pi = (Pair)v.elementAt(i);
                    Pair p = (Pair)pi.first;
                    Graph g = ((OrdinaryMorphism)p.first).getImage();
                    if (this.grammar.checkGraphConsistency(g)) continue;
                    inconsistent = true;
                    v.removeElement(pi);
                    BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.first);
                    p.first = null;
                    BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.second);
                    Graph tmp = ((OrdinaryMorphism)p.second).getTarget();
                    tmp = null;
                    p.second = null;
                    p = null;
                    pi = null;
                    --i;
                    size = v.size();
                }
                if (v.size() != 0) continue;
                this.moveEntryFromExcludeToConflictFreeContainer(r1, r2);
            }
        }
        if (inconsistent) {
            this.firePairEvent(new ParserMessageEvent(this, "Consistency check of critical pairs is done.  Please select a rule pair to see results."));
        } else if (cpExists) {
            this.firePairEvent(new ParserMessageEvent(this, "All critical pairs were consistent."));
        } else {
            this.firePairEvent(new ParserMessageEvent(this, "There are no critical pairs."));
        }
    }

    protected void moveEntryFromExcludeToConflictFreeContainer(Rule r1, Rule r2) {
        Entry entry = this.getEntry(r1, r2, true);
        entry.isCritical = false;
        entry.overlapping = null;
        Hashtable secondPart = (Hashtable)this.excludeContainer.get(r1);
        if (secondPart != null) {
            Pair pair = (Pair)secondPart.get(r2);
            pair.first = new Boolean(false);
            pair.second = null;
            this.conflictFreeContainer.put(r1, secondPart);
        }
    }

    protected boolean checkCriticalOLD(Rule r1, Rule r2, Graph g) {
        if (this.strategy == null) {
            this.strategy = (MorphCompletionStrategy)CompletionStrategySelector.getDefault().clone();
        }
        Hashtable secondPart = (Hashtable)this.excludeContainer.get(r1);
        Pair pair = (Pair)secondPart.get(r2);
        Boolean b = (Boolean)pair.first;
        if (b.booleanValue()) {
            Vector v = (Vector)((Vector)pair.second).clone();
            boolean critical = false;
            Vector mvec = null;
            Vector<Pair> objs = null;
            for (int i = 0; i < v.size(); ++i) {
                mvec = new Vector(v.size());
                Pair pi = (Pair)v.elementAt(i);
                Pair p = (Pair)pi.first;
                Graph g12 = ((OrdinaryMorphism)p.first).getImage();
                OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(g12, g);
                m.addToAttrContext((VarTuple)r1.getAttrContext().getVariables());
                m.addToAttrContext((VarTuple)r2.getAttrContext().getVariables());
                mvec.clear();
                boolean hasCompletion = false;
                m.setCompletionStrategy(this.strategy);
                while (m.nextCompletion()) {
                    hasCompletion = true;
                    critical = true;
                    objs = new Vector<Pair>(m.getSize());
                    Enumeration e = m.getDomain();
                    while (e.hasMoreElements()) {
                        GraphObject o = (GraphObject)e.nextElement();
                        objs.add(new Pair(o, m.getImage(o)));
                    }
                    mvec.add(objs);
                    this.excludeContainerForTestGraph.put(g12, mvec);
                }
                if (hasCompletion) continue;
                BaseFactory.theFactory().destroyMorphism(m);
                m = null;
                v.remove(pi);
                --i;
            }
            if (critical) {
                return true;
            }
        }
        return false;
    }

    protected boolean checkCritical(Rule r1, Rule r2, Graph testGraph) {
        if (this.strategy == null) {
            this.strategy = (MorphCompletionStrategy)CompletionStrategySelector.getDefault().clone();
        }
        boolean critical = false;
        Vector overlapGraphIsoms = new Vector(5);
        Vector criticalOverlappings = this.getCritical(r1, r2, this.excludeContainer);
        Vector criticalMatches = this.getLHSoverlappings(r1, r2, criticalOverlappings, overlapGraphIsoms);
        for (int i = 0; i < criticalMatches.size(); ++i) {
            Pair criticalOverlap = (Pair)criticalOverlappings.elementAt(i);
            Pair p1 = (Pair)criticalOverlap.first;
            Pair p = (Pair)criticalMatches.elementAt(i);
            Vector mvec = new Vector(5);
            Graph g = ((OrdinaryMorphism)p.first).getImage();
            OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(g, testGraph);
            m.addToAttrContext((VarTuple)r1.getAttrContext().getVariables());
            m.addToAttrContext((VarTuple)r2.getAttrContext().getVariables());
            mvec.clear();
            OrdinaryMorphism overlapGraphIsom = (OrdinaryMorphism)overlapGraphIsoms.get(i);
            boolean hasCompletion = false;
            m.setCompletionStrategy(this.strategy);
            while (m.nextCompletion()) {
                hasCompletion = true;
                critical = true;
                Vector<Pair> objs = new Vector<Pair>(m.getSize());
                Enumeration e = m.getDomain();
                while (e.hasMoreElements()) {
                    GraphObject o = (GraphObject)e.nextElement();
                    GraphObject img = m.getImage(o);
                    if (overlapGraphIsom != null) {
                        GraphObject objN2;
                        Enumeration lhs2;
                        GraphObject or1;
                        Enumeration lhs1;
                        GraphObject orig;
                        Enumeration invs = overlapGraphIsom.getInverseImage(o);
                        if (!invs.hasMoreElements() || (orig = (GraphObject)invs.nextElement()) == null || img == null || ((OrdinaryMorphism)p1.first).getSource() != r1.getRight()) continue;
                        boolean added = false;
                        Enumeration rhs1 = ((OrdinaryMorphism)p1.first).getInverseImage(orig);
                        if (rhs1.hasMoreElements() && (lhs1 = r1.getInverseImage(or1 = (GraphObject)rhs1.nextElement())).hasMoreElements()) {
                            objs.add(new Pair(orig, img));
                            added = true;
                        }
                        Pair p2 = (Pair)criticalOverlap.second;
                        if (added || p2 == null || p2.first == null) continue;
                        OrdinaryMorphism isoL2 = (OrdinaryMorphism)p2.first;
                        Enumeration objsN2 = ((OrdinaryMorphism)p1.second).getInverseImage(orig);
                        if (!objsN2.hasMoreElements() || !(lhs2 = isoL2.getInverseImage(objN2 = (GraphObject)objsN2.nextElement())).hasMoreElements()) continue;
                        objs.add(new Pair(orig, img));
                        continue;
                    }
                    if (o == null || img == null) continue;
                    objs.add(new Pair(o, img));
                }
                if (objs.isEmpty()) continue;
                mvec.add(objs);
                Graph overlapG = ((OrdinaryMorphism)p1.first).getTarget();
                this.excludeContainerForTestGraph.put(overlapG, mvec);
            }
            if (hasCompletion) continue;
            BaseFactory.theFactory().destroyMorphism(m);
            m = null;
            criticalMatches.remove(p);
            --i;
        }
        return critical;
    }

    public Hashtable getExcludeContainerForTestGraph() {
        return this.excludeContainerForTestGraph;
    }

    public void clear() {
        Rule r1 = null;
        Enumeration keys1 = this.excludeContainer.keys();
        while (keys1.hasMoreElements()) {
            r1 = (Rule)keys1.nextElement();
            Hashtable table2 = (Hashtable)this.excludeContainer.get(r1);
            Enumeration keys2 = table2.keys();
            while (keys2.hasMoreElements()) {
                Rule r2 = (Rule)keys2.nextElement();
                this.clearEntry(r1, r2);
            }
        }
        if (this.excludeContainerForTestGraph != null) {
            this.excludeContainerForTestGraph.clear();
        }
        this.isComputed = false;
        this.isComputedLocal = false;
        this.isEmpty = true;
        this.firePairEvent(new CriticalPairEvent(this, null, null, 7));
    }

    protected void writeOverlapMorphisms(XMLHelper h, Rule r1, Rule r2, Pair overlapping) {
        Pair p1 = (Pair)overlapping.first;
        OrdinaryMorphism first = (OrdinaryMorphism)p1.first;
        h.openSubTag("Morphism");
        h.addAttr("name", first.getName());
        if (first.getSource() == r1.getLeft()) {
            h.addAttr("source", "LHS");
        } else if (first.getSource() == r1.getRight()) {
            h.addAttr("source", "RHS");
        }
        Enumeration e = first.getDomain();
        while (e.hasMoreElements()) {
            GraphObject s = (GraphObject)e.nextElement();
            h.openSubTag("Mapping");
            h.addObject("orig", s, false);
            h.addObject("image", first.getImage(s), false);
            h.close();
        }
        h.close();
        OrdinaryMorphism second = (OrdinaryMorphism)p1.second;
        Pair p2 = (Pair)overlapping.second;
        if (p2 == null) {
            if (second.getSource() == r2.getLeft()) {
                h.openSubTag("Morphism");
                h.addAttr("name", second.getName());
                h.addAttr("source", "LHS");
                e = second.getDomain();
                while (e.hasMoreElements()) {
                    GraphObject s = (GraphObject)e.nextElement();
                    h.openSubTag("Mapping");
                    h.addObject("orig", s, false);
                    h.addObject("image", second.getImage(s), false);
                    h.close();
                }
            }
        } else {
            OrdinaryMorphism morphL2iso = (OrdinaryMorphism)p2.first;
            OrdinaryMorphism morphNAC2iso = (OrdinaryMorphism)p2.second;
            h.openSubTag("Morphism");
            h.addAttr("name", second.getName());
            h.addAttr("source", "NAC+LHS");
            e = second.getDomain();
            while (e.hasMoreElements()) {
                GraphObject src = (GraphObject)e.nextElement();
                GraphObject t = second.getImage(src);
                GraphObject s = null;
                if (morphL2iso.getInverseImage(src).hasMoreElements()) {
                    s = (GraphObject)morphL2iso.getInverseImage(src).nextElement();
                } else if (morphNAC2iso.getInverseImage(src).hasMoreElements()) {
                    s = (GraphObject)morphNAC2iso.getInverseImage(src).nextElement();
                }
                if (s == null) continue;
                h.openSubTag("Mapping");
                h.addObject("orig", s, false);
                h.addObject("image", t, false);
                h.close();
            }
        }
        h.close();
    }

    protected Pair readOldOverlappingMorphisms(XMLHelper h, Rule r1, Rule r2, String firstName, Graph overlapGraph) {
        OrdinaryMorphism first = BaseFactory.theFactory().createMorphism(r1.getLeft(), overlapGraph);
        OrdinaryMorphism second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
        first.setName(firstName.replaceAll(" ", ""));
        while (h.readSubTag("Mapping")) {
            GraphObject o = (GraphObject)h.getObject("orig", null, false);
            GraphObject i = (GraphObject)h.getObject("image", null, false);
            if (o != null && i != null) {
                first.addMapping(o, i);
            }
            h.close();
        }
        h.close();
        if (h.readSubTag("Morphism")) {
            String name = h.readAttr("name");
            second.setName(name.replaceAll(" ", ""));
            while (h.readSubTag("Mapping")) {
                GraphObject o = (GraphObject)h.getObject("orig", null, false);
                GraphObject i = (GraphObject)h.getObject("image", null, false);
                if (o != null && i != null) {
                    second.addMapping(o, i);
                }
                h.close();
            }
            h.close();
        }
        return new Pair(first, second);
    }

    protected Pair readOverlappingMorphisms(XMLHelper h, Rule r1, Rule r2, Graph overlapGraph) {
        OrdinaryMorphism first = null;
        OrdinaryMorphism second = null;
        Pair p = null;
        Pair p1 = null;
        Pair p2 = null;
        if (h.readSubTag("Morphism")) {
            String name = h.readAttr("name");
            String source = h.readAttr("source");
            if (source.equals("")) {
                p = this.readOldOverlappingMorphisms(h, r1, r2, name, overlapGraph);
                return new Pair(p, null);
            }
            if (source.equals("LHS")) {
                first = BaseFactory.theFactory().createMorphism(r1.getLeft(), overlapGraph);
            } else if (source.equals("RHS")) {
                first = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
            }
            first.setName(name.replaceAll(" ", ""));
            while (h.readSubTag("Mapping")) {
                GraphObject o = (GraphObject)h.getObject("orig", null, false);
                GraphObject i = (GraphObject)h.getObject("image", null, false);
                if (o != null && i != null) {
                    first.addMapping(o, i);
                }
                h.close();
            }
            h.close();
        }
        if (h.readSubTag("Morphism")) {
            OrdinaryMorphism morphL2iso = null;
            OrdinaryMorphism morphNAC2iso = null;
            String name = h.readAttr("name");
            String source = h.readAttr("source");
            if (source.equals("LHS")) {
                second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
            } else if (source.equals("NAC+LHS")) {
                OrdinaryMorphism nac = null;
                Enumeration e = r2.getNACs();
                while (e.hasMoreElements()) {
                    OrdinaryMorphism n = (OrdinaryMorphism)e.nextElement();
                    if (!overlapGraph.info.equals(n.getName())) continue;
                    nac = n;
                    break;
                }
                morphL2iso = r2.getLeft().isomorphicCopy();
                morphNAC2iso = this.extendLeftGraph(morphL2iso, nac);
                Graph N2 = morphL2iso.getTarget();
                second = BaseFactory.theFactory().createMorphism(N2, overlapGraph);
            }
            if (second != null) {
                second.setName(name.replaceAll(" ", ""));
                while (h.readSubTag("Mapping")) {
                    GraphObject o = (GraphObject)h.getObject("orig", null, false);
                    GraphObject i = (GraphObject)h.getObject("image", null, false);
                    if (o != null && i != null) {
                        if (source.equals("LHS")) {
                            second.addMapping(o, i);
                        } else if (source.equals("NAC+LHS")) {
                            GraphObject s = morphL2iso.getImage(o);
                            if (s == null && morphNAC2iso != null) {
                                s = morphNAC2iso.getImage(o);
                            }
                            if (s != null) {
                                second.addMapping(s, i);
                            }
                        }
                    }
                    h.close();
                }
                if (source.equals("NAC+LHS")) {
                    p2 = new Pair(morphL2iso, morphNAC2iso);
                }
            }
            h.close();
        }
        if (first != null && second != null) {
            p1 = new Pair(first, second);
            p = new Pair(p1, p2);
        }
        return p;
    }

    private OrdinaryMorphism extendLeftGraph(OrdinaryMorphism isoLeft, OrdinaryMorphism nac) {
        GraphObject o;
        if (isoLeft == null || nac == null) {
            return null;
        }
        Graph extLeft = isoLeft.getTarget();
        OrdinaryMorphism isoNAC = BaseFactory.theFactory().createMorphism(nac.getTarget(), extLeft);
        Hashtable<Node, Node> tmp = new Hashtable<Node, Node>(5);
        Enumeration e = nac.getTarget().getNodes();
        while (e.hasMoreElements()) {
            o = (GraphObject)e.nextElement();
            if (!nac.getInverseImage(o).hasMoreElements()) {
                try {
                    Node n = extLeft.createNode((Node)o);
                    tmp.put((Node)o, n);
                    isoNAC.addMapping(o, n);
                }
                catch (TypeException ex) {}
                continue;
            }
            isoNAC.addMapping(o, isoLeft.getImage((GraphObject)nac.getInverseImage(o).nextElement()));
        }
        e = nac.getTarget().getArcs();
        while (e.hasMoreElements()) {
            o = (GraphObject)e.nextElement();
            if (!nac.getInverseImage(o).hasMoreElements()) {
                Node tar;
                Node src = (Node)tmp.get((Node)((Arc)o).getSource());
                if (src == null) {
                    src = (Node)isoLeft.getImage((Node)nac.getInverseImage((Node)((Arc)o).getSource()).nextElement());
                }
                if ((tar = (Node)tmp.get((Node)((Arc)o).getTarget())) == null) {
                    tar = (Node)isoLeft.getImage((Node)nac.getInverseImage((Node)((Arc)o).getTarget()).nextElement());
                }
                try {
                    Arc a = extLeft.createArc((Arc)o, src, tar);
                    isoNAC.addMapping(o, a);
                }
                catch (TypeException ex) {}
                continue;
            }
            isoNAC.addMapping(o, isoLeft.getImage((GraphObject)nac.getInverseImage(o).nextElement()));
        }
        return isoNAC;
    }

    public void XwriteObject(XMLHelper h) {
        Boolean b;
        Pair p;
        Rule r2;
        Enumeration k2;
        Hashtable secondPart;
        Rule r1;
        h.openNewElem("CriticalPairs", this);
        h.addObject("GraGra", this.getGrammar(), true);
        h.openSubTag("conflictsContainer");
        Enumeration keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            r1 = (Rule)keys.nextElement();
            h.openSubTag("Rule");
            h.addObject("R1", r1, false);
            secondPart = (Hashtable)this.excludeContainer.get(r1);
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = (Rule)k2.nextElement();
                h.openSubTag("Rule");
                h.addObject("R2", r2, false);
                p = (Pair)secondPart.get(r2);
                b = (Boolean)p.first;
                h.addAttr("bool", b.toString());
                if (b.booleanValue()) {
                    Vector v = (Vector)p.second;
                    for (int i = 0; i < v.size(); ++i) {
                        h.openSubTag("Overlapping_Pair");
                        Pair p2i = (Pair)v.elementAt(i);
                        Pair p2 = (Pair)p2i.first;
                        OrdinaryMorphism first = (OrdinaryMorphism)p2.first;
                        Graph overlapping = first.getImage();
                        h.addObject("", overlapping, true);
                        Enumeration e = overlapping.getElements();
                        while (e.hasMoreElements()) {
                            GraphObject o = (GraphObject)e.nextElement();
                            if (!o.isCritical()) continue;
                            h.openSubTag("Critical");
                            h.addObject("object", o, false);
                            h.close();
                        }
                        this.writeOverlapMorphisms(h, r1, r2, p2i);
                        h.close();
                    }
                }
                h.close();
            }
            h.close();
        }
        h.close();
        h.openSubTag("conflictFreeContainer");
        keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            r1 = (Rule)keys.nextElement();
            h.openSubTag("Rule");
            h.addObject("R1", r1, false);
            secondPart = (Hashtable)this.conflictFreeContainer.get(r1);
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = (Rule)k2.nextElement();
                h.openSubTag("Rule");
                h.addObject("R2", r2, false);
                p = (Pair)secondPart.get(r2);
                b = (Boolean)p.first;
                h.addAttr("bool", b.toString());
                h.close();
            }
            h.close();
        }
        h.close();
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("CriticalPairs", this)) {
            String bool;
            Enumeration r2s;
            Enumeration r1s;
            Rule r1 = null;
            Rule r2 = null;
            boolean b = false;
            Vector<Pair> allOverlappings = null;
            Vector<String> tagnames = new Vector<String>(1);
            Vector<String> tagnames2 = new Vector<String>(1);
            this.grammar = BaseFactory.theFactory().createGraGra();
            h.getObject("", this.grammar, true);
            tagnames.add("conflictContainer");
            tagnames.add("conflictsContainer");
            tagnames.add("excludeContainer");
            tagnames2.add("dependencyContainer");
            tagnames2.add("dependenciesContainer");
            if (h.readSubTag(tagnames)) {
                this.conflictKind = 0;
            } else if (h.readSubTag(tagnames2)) {
                this.conflictKind = 1;
            }
            if (this.conflictKind == 0 || this.conflictKind == 1) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        allOverlappings = null;
                        if (bool.equals("true")) {
                            b = true;
                            allOverlappings = new Vector<Pair>();
                            Enumeration overlappings = h.getEnumeration("", null, true, "Overlapping_Pair");
                            while (overlappings.hasMoreElements()) {
                                h.peekElement(overlappings.nextElement());
                                Graph g = (Graph)h.getObject("", new Graph(), true);
                                while (h.readSubTag("Critical")) {
                                    GraphObject o = (GraphObject)h.getObject("object", null, false);
                                    if (o != null) {
                                        o.setCritical(true);
                                    }
                                    h.close();
                                }
                                Pair p = this.readOverlappingMorphisms(h, r1, r2, g);
                                allOverlappings.addElement(p);
                                h.close();
                            }
                        }
                        this.addQuadruple(this.excludeContainer, r1, r2, b, allOverlappings);
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            if (h.readSubTag("conflictFreeContainer")) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        if (bool.equals("true")) {
                            b = true;
                        }
                        this.addQuadruple(this.conflictFreeContainer, r1, r2, b, null);
                        if (!r1.isEnabled()) {
                            this.getEntry((Rule)r1, (Rule)r2).state = 5;
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
        }
        h.close();
    }

    public String toString() {
        String result = super.toString() + "\n" + this.getGrammar().toString() + "\n";
        result = result + "ConflictsContainer " + this.excludeContainer + "\n\n";
        result = result + "conflictFreeContainer " + this.conflictFreeContainer + "\n";
        return result;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isComputed() {
        return this.isComputed;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void addPairEventListener(ParserEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.addElement(l);
        }
    }

    public void removePairEventListener(ParserEventListener l) {
        if (this.listener.contains(l)) {
            this.listener.removeElement(l);
        }
    }

    protected synchronized void firePairEvent(ParserEvent event) {
        for (int i = 0; i < this.listener.size(); ++i) {
            ((ParserEventListener)this.listener.elementAt(i)).parserEventOccured(event);
        }
    }

    public void enableComplete(boolean enable) {
        this.complete = enable;
    }

    public void enableReduce(boolean enable) {
        this.reduce = enable;
    }

    public void enableNACs(boolean enable) {
        this.withNACs = enable;
    }

    public void enableConsistent(boolean enable) {
        this.consistent = enable;
    }

    public void enableUseHostGraph(boolean enable, Graph g, MorphCompletionStrategy strat) {
        this.useHostGraph = enable;
        if (this.useHostGraph) {
            this.excludeContainerForTestGraph = new Hashtable();
            this.testGraph = g;
            this.strategy = (MorphCompletionStrategy)strat.clone();
        } else {
            this.excludeContainerForTestGraph = null;
            this.testGraph = null;
        }
    }

    public int getKindOfConflict() {
        return this.conflictKind;
    }

    public LayerFunction getLayer() {
        return null;
    }

    public class Entry {
        public static final int NOT_SET = 0;
        public static final int SCHEDULED_FOR_COMPUTING = 1;
        public static final int COMPUTING_IS_RUNNING = 2;
        public static final int COMPUTED = 3;
        public static final int NOT_RELATED = 4;
        public static final int DISABLED = 5;
        boolean isCritical = false;
        boolean isRelationVisible = true;
        boolean isRuleVisible = true;
        int state = 0;
        Vector overlapping;

        public boolean isCritical() {
            return this.isCritical;
        }

        public void setState(int s) {
            this.state = s == 1 || s == 2 || s == 3 ? s : 0;
        }

        public int getState() {
            return this.state;
        }

        public Vector getOverlapping() {
            return this.overlapping;
        }

        public boolean isRuleVisible() {
            return this.isRuleVisible;
        }

        public boolean isRelationVisible() {
            return this.isRelationVisible;
        }
    }
}

