/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.AbstractParser;
import agg.parser.ExcludePairContainer;
import agg.parser.InvalidAlgorithmException;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.Report;
import agg.parser.RuleInstances;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Stack;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExcludeParser
extends AbstractParser
implements Runnable {
    protected Stack stack = new Stack();
    protected boolean stop = false;
    protected boolean correct;

    public ExcludeParser(GraGra grammar, Graph hostGraph, Graph stopGraph, ExcludePairContainer excludeContainer) {
        super(grammar, hostGraph, stopGraph, excludeContainer);
    }

    public boolean parse() {
        System.out.println("Starting exclude parser with CPA ... ");
        this.correct = true;
        this.fireParserEvent(new ParserMessageEvent(this, "Starting exclude parser ..."));
        if (this.stop) {
            return false;
        }
        Hashtable conflictFree = null;
        try {
            this.fireParserEvent(new ParserMessageEvent(this, "Computting conflict free pairs. Please wait ..."));
            conflictFree = this.pairContainer.getContainer(2);
            this.fireParserEvent(new ParserMessageEvent(this, "Computting conflict free pairs done"));
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        if (this.stop) {
            return false;
        }
        Hashtable exclude = null;
        try {
            this.fireParserEvent(new ParserMessageEvent(this, "Computting exclude pairs. Please wait ..."));
            exclude = this.pairContainer.getContainer(0);
            this.fireParserEvent(new ParserMessageEvent(this, "Computting exclude pairs done"));
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        if (this.stop) {
            return false;
        }
        Hashtable conflictFreeLight = new Hashtable();
        Hashtable excludeLight = new Hashtable();
        if (this.stop) {
            return false;
        }
        this.makeLightContainer(exclude, excludeLight);
        if (this.stop) {
            return false;
        }
        this.makeLightContainer(conflictFree, conflictFreeLight);
        if (this.stop) {
            return false;
        }
        Enumeration keys = conflictFreeLight.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!excludeLight.containsKey(key)) continue;
            conflictFreeLight.remove(key);
        }
        Report.println("conflictFreeLight----------------------------------------", Report.CONTAINER);
        Report.println("conflictFreeLight" + conflictFreeLight, Report.CONTAINER);
        Report.println("conflictFree----------------------------------------", Report.CONTAINER);
        Report.println("conflictFree" + conflictFree, Report.CONTAINER);
        Report.println("excludeLight----------------------------------------", Report.CONTAINER);
        Report.println("excludeLight" + excludeLight, Report.CONTAINER);
        Report.println("exclude----------------------------------------", Report.CONTAINER);
        Report.println("exclude" + exclude, Report.CONTAINER);
        if (this.stop) {
            return false;
        }
        RuleInstances eri = new RuleInstances();
        Report.println("Parser ist initialisiert", Report.PARSER);
        this.fireParserEvent(new ParserMessageEvent(this, "Parser initialized"));
        while (!this.graph.isIsomorphicWith(this.stopGraph) && this.correct && !this.stop) {
            boolean ruleApplied = false;
            Enumeration keys2 = conflictFreeLight.keys();
            while (keys2.hasMoreElements() && !ruleApplied) {
                Rule r = (Rule)keys2.nextElement();
                Report.println("versuche konfliktfreie Regel " + r.getName(), Report.PARSER);
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for simple match"));
                Match m = BaseFactory.theFactory().createMatch(r, this.getHostGraph());
                while (!ruleApplied && m.nextCompletion() && !this.stop) {
                    if (!m.isValid()) continue;
                    Report.println("wende konfliktfreie Regel " + r.getName() + " an", Report.PARSER);
                    this.applyRule(m);
                    ruleApplied = true;
                    this.fireParserEvent(new ParserMessageEvent(this, m.getRule().getName() + "  was applied."));
                }
            }
            if (ruleApplied || this.stop) continue;
            Report.println("Es konnte keine konfliktfreie Regel angewendet werden", Report.PARSER);
            OrdinaryMorphism savedMatch = null;
            Enumeration keys3 = excludeLight.keys();
            while (keys3.hasMoreElements() && !ruleApplied) {
                if (this.stop) {
                    return false;
                }
                Rule r = (Rule)keys3.nextElement();
                Report.println("versuche exclude Regel " + r.getName(), Report.PARSER);
                Vector inclusions = this.findInclusions(r, 0);
                Report.println("Habe alle Inklusionen gefunden", Report.PARSER);
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for difficult match"));
                Match m = BaseFactory.theFactory().createMatch(r, this.getHostGraph());
                boolean validMatch = false;
                while (!ruleApplied && m.nextCompletion() && !this.stop) {
                    if (!m.isValid()) continue;
                    System.out.println("valid match FOUND...    isMatchCritic");
                    if (!this.isMatchCritic(m, inclusions)) {
                        Report.println("wende exclude Regel " + r.getName() + " an, im Fall 3a", Report.PARSER);
                        this.applyRule(m);
                        ruleApplied = true;
                        Report.println(r.getName() + "  was applied.", Report.PARSER);
                        this.fireParserEvent(new ParserMessageEvent(this, m.getRule().getName() + "  was applied."));
                        continue;
                    }
                    Report.println("It's critical Match. ", Report.PARSER);
                    if (this.stop || validMatch || savedMatch != null || eri.isIn(m)) continue;
                    Report.println("Match is savedMatch ", Report.PARSER);
                    validMatch = true;
                    savedMatch = m;
                }
                if (validMatch) continue;
                BaseFactory.theFactory().destroyMatch(m);
            }
            if (!ruleApplied && savedMatch != null && !this.stop) {
                Report.println("Es gibt keinen 3a Fall, sondern eine Sackgasse Ableitung", Report.PARSER);
                OrdinaryMorphism copyMorph = this.getHostGraph().isomorphicCopy();
                this.fireParserEvent(new ParserMessageEvent(copyMorph, ""));
                eri.add((Match)savedMatch);
                Pair tmpPair = new Pair(this.getHostGraph(), eri);
                Report.println("push Sackgasse Ableitung on stack", Report.PARSER);
                this.stack.push(tmpPair);
                eri = new RuleInstances();
                this.setHostGraph(copyMorph.getImage());
                OrdinaryMorphism tmpMorph = savedMatch.compose(copyMorph);
                Match n = tmpMorph.makeMatch(((Match)savedMatch).getRule());
                boolean notFound = false;
                while (!(n.isValid() || notFound || this.stop)) {
                    if (n.nextCompletion()) continue;
                    notFound = true;
                }
                if (!this.stop && !notFound) {
                    Report.println("wende exclude Regel " + n.getRule().getName() + " an, im Fall 3b", Report.PARSER);
                    this.applyRule(n);
                    ruleApplied = true;
                    this.fireParserEvent(new ParserMessageEvent(this, n.getRule().getName() + "  was applied."));
                }
            }
            if (ruleApplied || this.stop) continue;
            try {
                Report.println("Konnte keine Regel anweden und versuche backtrack", Report.PARSER);
                Pair tmpPair = (Pair)this.stack.pop();
                this.setHostGraph((Graph)tmpPair.first);
                eri = (RuleInstances)tmpPair.second;
            }
            catch (InvalidOperationException ioe) {
                System.out.println("ExcludeParser... Stack ist leer");
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                this.correct = false;
            }
        }
        while (!this.stack.isEmpty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                Pair tmpPair = (Pair)this.stack.pop();
                Graph g = (Graph)tmpPair.first;
                g.dispose();
                tmpPair.second = null;
            }
            catch (InvalidOperationException ioe) {}
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + this.correct + "."));
        return this.correct;
    }

    protected void finalize() {
        this.getHostGraph().dispose();
    }

    protected void makeLightContainer(Hashtable in, Hashtable out) {
        Enumeration keys = in.keys();
        while (keys.hasMoreElements()) {
            Rule key = (Rule)keys.nextElement();
            if (key == null) continue;
            Hashtable value = (Hashtable)in.get(key);
            boolean allTrue = true;
            Enumeration keys2 = value.keys();
            while (keys2.hasMoreElements() && allTrue) {
                Hashtable secondPart;
                Rule key2 = (Rule)keys2.nextElement();
                if (key == key2) continue;
                Pair p = (Pair)value.get(key2);
                Boolean first = (Boolean)p.first;
                if (!first.booleanValue()) continue;
                if (out.containsKey(key)) {
                    secondPart = (Hashtable)out.get(key);
                    secondPart.put(key2, p);
                    continue;
                }
                secondPart = new Hashtable();
                secondPart.put(key2, p);
                out.put(key, secondPart);
            }
        }
    }

    protected Vector findInclusions(Rule r1, int kind) {
        Vector<Pair> resultVector = new Vector<Pair>();
        Vector criticVector = null;
        try {
            criticVector = this.pairContainer.getCriticalSet(kind, r1);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(this, "Cannot get Container"));
            return resultVector;
        }
        for (int i = 0; i < criticVector.size(); ++i) {
            Pair p = (Pair)criticVector.elementAt(i);
            Pair morphisms = (Pair)p.first;
            if (p.second != null && ((OrdinaryMorphism)morphisms.first).getSource() == r1.getRight()) {
                GraphObject img;
                GraphObject obj;
                Graph overlap = ((OrdinaryMorphism)morphisms.first).getImage();
                OrdinaryMorphism overlapIso = overlap.isomorphicCopy();
                Enumeration e = ((OrdinaryMorphism)morphisms.first).getSource().getArcs();
                while (e.hasMoreElements()) {
                    obj = (Arc)e.nextElement();
                    if (r1.getInverseImage(obj).hasMoreElements()) continue;
                    img = overlapIso.getImage(((OrdinaryMorphism)morphisms.first).getImage(obj));
                    try {
                        overlapIso.getTarget().destroyObject(img);
                    }
                    catch (TypeException exc) {}
                }
                e = ((OrdinaryMorphism)morphisms.first).getSource().getNodes();
                while (e.hasMoreElements()) {
                    obj = (Node)e.nextElement();
                    if (r1.getInverseImage(obj).hasMoreElements()) continue;
                    img = overlapIso.getImage(((OrdinaryMorphism)morphisms.first).getImage(obj));
                    try {
                        overlapIso.getTarget().destroyObject(img);
                    }
                    catch (TypeException exc) {}
                }
                OrdinaryMorphism matchMorph1 = r1.compose(((OrdinaryMorphism)morphisms.first).compose(overlapIso));
                Match match1 = BaseFactory.theFactory().makeMatch(r1, matchMorph1);
                morphisms.first = match1;
            }
            Graph overlapGraph = ((OrdinaryMorphism)morphisms.first).getImage();
            OrdinaryMorphism inclusion = BaseFactory.theFactory().createMorphism(overlapGraph, this.getHostGraph());
            boolean graphOk = false;
            while (inclusion.nextCompletion() && !graphOk) {
                if (!inclusion.isTotal() || !inclusion.isInjective()) continue;
                graphOk = true;
                resultVector.addElement(morphisms);
            }
            BaseFactory.theFactory().destroyMorphism(inclusion);
        }
        return resultVector;
    }

    protected boolean isMatchCritic(Match m, Vector inclusions) {
        boolean critic = false;
        OrdinaryMorphism o = null;
        OrdinaryMorphism composed = null;
        for (int i = 0; i < inclusions.size(); ++i) {
            Report.println("ExcludeParser.isMatchCritic:: checke Inklusion #" + i + " von " + inclusions.size(), Report.PARSER);
            Pair morphisms = (Pair)inclusions.elementAt(i);
            Graph overlapGraph = ((OrdinaryMorphism)morphisms.first).getImage();
            o = BaseFactory.theFactory().createMorphism(overlapGraph, this.getHostGraph());
            OrdinaryMorphism overlapMorph = (OrdinaryMorphism)morphisms.first;
            OrdinaryMorphism inverted = overlapMorph.invert();
            composed = inverted.compose(m);
            while (composed.nextCompletion() && !critic) {
                Vector<GraphObject> leftNodes = new Vector<GraphObject>();
                Enumeration en = m.getDomain();
                while (en.hasMoreElements()) {
                    GraphObject grob = (GraphObject)en.nextElement();
                    if (!grob.isNode()) continue;
                    leftNodes.addElement(grob);
                }
                for (int k = 0; k < leftNodes.size(); ++k) {
                    Node n = (Node)leftNodes.elementAt(k);
                    try {
                        o.addMapping(overlapMorph.getImage(n), m.getImage(n));
                        continue;
                    }
                    catch (BadMappingException bme) {
                        // empty catch block
                    }
                }
                boolean j = false;
                while (o.nextCompletion() && !critic) {
                    if (!o.isIsomorphicTo(composed)) continue;
                    critic = true;
                }
            }
            BaseFactory.theFactory().destroyMorphism(composed);
            BaseFactory.theFactory().destroyMorphism(o);
        }
        Report.trace("isMatchCritic: Ende " + critic, -2);
        return critic;
    }

    public void run() {
        this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  runs ..."));
        this.parse();
        if (this.stop) {
            this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
            this.stop = false;
        } else {
            this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  finished. Result is " + this.correct + "."));
        }
    }

    public void stop() {
        this.stop = true;
    }

    public boolean wasStopped() {
        return this.stop;
    }
}

