/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.Report;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import com.objectspace.jgl.HashSet;
import java.util.Enumeration;
import java.util.Hashtable;

public class LayerFunction
implements XMLObject {
    protected GraGra grammar;
    protected Hashtable ruleLayer;
    protected Hashtable creationLayer;
    protected Hashtable deletionLayer;
    protected String errMsg;
    protected boolean valid;
    protected String option;

    public LayerFunction(GraGra gragra) {
        this.grammar = gragra;
        this.initRuleLayer(this.grammar);
        this.initCreationLayer(this.grammar);
        this.initDeletionLayer(this.grammar);
        this.valid = true;
        this.errMsg = "";
    }

    private void initRuleLayer(GraGra gragra) {
        this.ruleLayer = new Hashtable();
        for (int i = 0; i < gragra.getRulesVec().size(); ++i) {
            Object rule = gragra.getRulesVec().elementAt(i);
            this.ruleLayer.put(rule, new Integer(((Rule)rule).getLayer()));
        }
    }

    private void initCreationLayer(GraGra gragra) {
        this.creationLayer = new Hashtable();
        Enumeration types = gragra.getTypes();
        while (types.hasMoreElements()) {
            Object type = types.nextElement();
            this.creationLayer.put(type, new Integer(0));
        }
    }

    private void initDeletionLayer(GraGra gragra) {
        this.deletionLayer = new Hashtable();
        Enumeration types = gragra.getTypes();
        while (types.hasMoreElements()) {
            Object type = types.nextElement();
            this.deletionLayer.put(type, new Integer(0));
        }
    }

    public boolean checkLayer() {
        return true;
    }

    private boolean checkLayer_OLD() {
        Report.trace("starte ckeckLayer()", 2);
        boolean result = true;
        Enumeration en = this.getDeletionLayer().keys();
        while (en.hasMoreElements() && result) {
            Object key = en.nextElement();
            Integer dl = (Integer)this.getDeletionLayer().get(key);
            Integer cl = (Integer)this.getCreationLayer().get(key);
            if (cl == null || dl == null) {
                result = false;
                this.errMsg = "Type name :  " + ((Type)key).getStringRepr() + "\n" + " The condition that\n " + " cl, dl are total functions \n " + " is not satisfied.";
                break;
            }
            if (0 <= cl && cl <= dl) continue;
            result = false;
            this.errMsg = "Type name :  " + ((Type)key).getStringRepr() + "\n" + " Condition \n " + " 0 <= cl(l) <= dl(l) <= n \n " + " is not satisfied.";
        }
        HashSet deletionSet = new HashSet();
        HashSet creationSet = new HashSet();
        Enumeration rules = this.getRuleLayer().keys();
        while (result && rules.hasMoreElements()) {
            Type t;
            GraphObject grob;
            deletionSet.clear();
            creationSet.clear();
            Rule rule = (Rule)rules.nextElement();
            Integer layerRule = (Integer)this.getRuleLayer().get(rule);
            if (layerRule == null) {
                result = false;
                this.errMsg = "Rule name :  " + rule.getName() + "\n" + " The condition that\n" + " rl  is a total function \n" + " is not satisfied.";
                break;
            }
            Graph leftGraph = rule.getLeft();
            Graph rightGraph = rule.getRight();
            Enumeration en2 = leftGraph.getElements();
            while (en2.hasMoreElements()) {
                grob = (GraphObject)en2.nextElement();
                if (rule.getImage(grob) != null) continue;
                deletionSet.add(grob);
            }
            Report.println("deletionSet ist " + deletionSet, Report.LAYER);
            if (deletionSet.isEmpty()) {
                result = false;
                this.errMsg = "Rule name :  " + rule.getName() + "\n" + " The condition that\n " + " r  deletes at least one node or edge \n" + " is not satisfied.";
                break;
            }
            en2 = deletionSet.elements();
            while (en2.hasMoreElements() && result) {
                grob = (GraphObject)en2.nextElement();
                t = grob.getType();
                Integer dl = (Integer)this.getDeletionLayer().get(t);
                Report.println("dl(" + t + ") = " + dl + "  <=  rl(" + rule + ") = " + layerRule, Report.LAYER);
                if (dl <= layerRule) continue;
                result = false;
                this.errMsg = "Rule name :  " + rule.getName() + "\n" + "Type name :  " + t.getStringRepr() + "\n" + " The condition that \n" + " r  deletes only nodes and edges with labels \n" + " l  such that  dl(l) <= rl(r) \n" + " is not satisfied.";
            }
            if (!result) break;
            en2 = rightGraph.getElements();
            while (en2.hasMoreElements()) {
                creationSet.add(en2.nextElement());
            }
            Report.println("creationSet ist " + creationSet, Report.LAYER);
            en2 = leftGraph.getElements();
            while (en2.hasMoreElements()) {
                try {
                    creationSet.remove(rule.getImage((GraphObject)en2.nextElement()));
                }
                catch (NullPointerException npe) {}
            }
            Report.println("creationSet reduziert auf " + creationSet, Report.LAYER);
            en2 = creationSet.elements();
            while (en2.hasMoreElements() && result) {
                grob = (GraphObject)en2.nextElement();
                t = grob.getType();
                Integer cl = (Integer)this.getCreationLayer().get(t);
                Report.println("cl(" + t + ") = " + cl + "  >  rl(" + rule + ") = " + layerRule, Report.LAYER);
                if (cl > layerRule) continue;
                result = false;
                this.errMsg = "Rule name :  " + rule.getName() + "\n" + "Type name :  " + t.getStringRepr() + "\n" + " The condition that\n " + " r  creates only nodes and edges with labels \n" + " l  such that  cl(l) > rl(r) \n" + " is not satisfied.";
            }
        }
        this.valid = result;
        Report.trace("beende checkLayer mit result = " + result, -2);
        return result;
    }

    public boolean isValid() {
        return true;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public Hashtable getRuleLayer() {
        int size = 0;
        Enumeration en = this.grammar.getRules();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++size;
        }
        if (size != this.ruleLayer.size()) {
            this.initRuleLayer(this.grammar);
            return this.ruleLayer;
        }
        en = this.grammar.getRules();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (this.ruleLayer.containsKey(key)) continue;
            this.initRuleLayer(this.grammar);
            return this.ruleLayer;
        }
        return this.ruleLayer;
    }

    public Hashtable getCreationLayer() {
        int size = 0;
        Enumeration en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++size;
        }
        if (size != this.creationLayer.size()) {
            this.initCreationLayer(this.grammar);
            return this.creationLayer;
        }
        en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (this.creationLayer.containsKey(key)) continue;
            this.initCreationLayer(this.grammar);
            return this.creationLayer;
        }
        return this.creationLayer;
    }

    public Hashtable getDeletionLayer() {
        int size = 0;
        Enumeration en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++size;
        }
        if (size != this.deletionLayer.size()) {
            this.initDeletionLayer(this.grammar);
            return this.deletionLayer;
        }
        en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (this.deletionLayer.containsKey(key)) continue;
            this.initDeletionLayer(this.grammar);
            return this.deletionLayer;
        }
        return this.deletionLayer;
    }

    public Integer getStartLayer() {
        int startLayer = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration keys = this.getRuleLayer().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer layer = (Integer)this.getRuleLayer().get(key);
            if (layer >= startLayer) continue;
            startLayer = layer;
            result = layer;
        }
        return result;
    }

    public Hashtable invertLayer(Hashtable layer) {
        Hashtable<Integer, HashSet> inverted = new Hashtable<Integer, HashSet>();
        Enumeration keys = layer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer value = (Integer)layer.get(key);
            HashSet invertedValue = (HashSet)inverted.get(value);
            if (invertedValue == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(value, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String getOption() {
        return this.option;
    }

    protected void writeHashtableToXML(Hashtable xmlObjects, XMLHelper h) {
        Enumeration keys = xmlObjects.keys();
        while (keys.hasMoreElements()) {
            XMLObject r1 = (XMLObject)keys.nextElement();
            h.openSubTag("Datum");
            h.addObject("key", r1, false);
            h.addAttr("value", "" + xmlObjects.get(r1));
            h.close();
        }
    }

    public void XwriteObject(XMLHelper h) {
        h.openNewElem("LayerFunction", this);
        h.addObject("GraGra", this.grammar, false);
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("LayerFunction", this)) {
            this.grammar = (GraGra)h.getObject("GraGra", null, false);
            this.valid = true;
            this.option = "";
            this.initRuleLayer(this.grammar);
            this.initCreationLayer(this.grammar);
            this.initDeletionLayer(this.grammar);
            h.close();
        } else {
            this.option = "";
        }
    }

    public String toString() {
        String resultString = super.toString() + " LayerFunction:\n";
        resultString = resultString + "\tRuleLayer:\n";
        resultString = resultString + this.getRuleLayer().toString() + "\n";
        resultString = resultString + "\tCreationLayer:\n";
        resultString = resultString + this.getCreationLayer().toString() + "\n";
        resultString = resultString + "\tDeletionLayer:\n";
        resultString = resultString + this.getDeletionLayer().toString() + "\n";
        return resultString;
    }
}

