/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.CriticalPairEvent;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.InvalidAlgorithmException;
import agg.parser.LayerFunction;
import agg.parser.LayeredDependencyPair;
import agg.parser.LayeredPairContainer;
import agg.parser.LayeredSimpleDependencyPair;
import agg.parser.Report;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LayeredDependencyPairContainer
extends DependencyPairContainer
implements LayeredPairContainer {
    private LayerFunction layerFunc;
    private int layer = -1;
    protected LayeredDependencyPair layeredPair;
    protected LayeredSimpleDependencyPair layeredSimplePair;

    public LayeredDependencyPairContainer(GraGra gragra, LayerFunction layerFunc) {
        super(gragra);
        this.layerFunc = layerFunc;
    }

    public LayeredDependencyPairContainer(GraGra gragra) {
        this(gragra, new LayerFunction(gragra));
    }

    protected synchronized void computeCritical(Rule r1, Rule r2) {
        Report.trace("LayeredDependencyPairContainer: starte computeCritical", 2);
        if (!r1.isEnabled() || !r2.isEnabled()) {
            this.getEntry((Rule)r1, (Rule)r2).state = 5;
            this.addEntry(r1, r2, false, null);
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, false, null);
            this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  should not be computed."));
            return;
        }
        if (r1.getLayer() != r2.getLayer()) {
            this.getEntry((Rule)r1, (Rule)r2).state = 4;
            this.addEntry(r1, r2, false, null);
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, false, null);
            this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, ""));
            return;
        }
        if (this.layer > -1 && r1.getLayer() != this.layer) {
            return;
        }
        if (this.getEntry((Rule)r1, (Rule)r2).state == 1 || this.getEntry((Rule)r1, (Rule)r2).state == 0) {
            boolean critic;
            this.getEntry(r1, r2).setState(2);
            this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "Computing critical rule pair  [  " + r1.getName() + "  ,  " + r2.getName() + "  ]"));
            if (!this.complete) {
                this.layeredPair = null;
                this.layeredSimplePair = new LayeredSimpleDependencyPair(this.getLayer());
                this.layeredSimplePair.enableNACs(this.withNACs);
                this.layeredSimplePair.enableReduce(this.reduce);
                this.layeredSimplePair.enableConsistent(this.consistent, this.grammar);
                this.excludePair = this.layeredSimplePair;
            } else {
                this.layeredSimplePair = null;
                this.layeredPair = new LayeredDependencyPair(this.getLayer());
                this.layeredPair.enableNACs(this.withNACs);
                this.layeredPair.enableReduce(this.reduce);
                this.layeredPair.enableConsistent(this.consistent, this.grammar);
                this.excludePair = this.layeredPair;
            }
            Vector overlapping = null;
            if (this.stop) {
                this.getEntry(r1, r2).setState(0);
                return;
            }
            try {
                if (this.layeredPair != null) {
                    overlapping = (Vector)this.layeredPair.isCritical(0, r1, r2);
                    if (this.stop) {
                        this.getEntry((Rule)r1, (Rule)r2).state = 0;
                        if (overlapping != null && !overlapping.isEmpty()) {
                            overlapping.clear();
                            overlapping = null;
                        }
                    }
                } else if (this.layeredSimplePair != null) {
                    overlapping = (Vector)this.layeredSimplePair.isCritical(0, r1, r2);
                    if (this.stop) {
                        this.getEntry((Rule)r1, (Rule)r2).state = 0;
                        if (overlapping != null && !overlapping.isEmpty()) {
                            overlapping.clear();
                            overlapping = null;
                        }
                    }
                }
            }
            catch (InvalidAlgorithmException iae) {
                System.out.println(iae.getLocalizedMessage());
            }
            if (this.excludePair != null) {
                this.excludePair.dispose();
            }
            this.excludePair = null;
            this.layeredPair = null;
            this.layeredSimplePair = null;
            System.gc();
            boolean bl = critic = overlapping != null;
            if (this.getEntry((Rule)r1, (Rule)r2).state == 0) {
                this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "Computing critical stopped."));
                return;
            }
            this.addEntry(r1, r2, critic, overlapping);
            this.addQuadruple(this.excludeContainer, r1, r2, critic, overlapping);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, !critic, null);
            if (overlapping != null) {
                this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have critical pairs"));
            } else {
                this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have no critical pairs"));
            }
        }
        Report.trace("LayeredDependencyPairContainer: beende computeCritical", -2);
    }

    protected void fillContainers() {
        super.fillContainers();
        if (this.layer > -1) {
            this.isComputed = false;
        }
    }

    public void setLayer(LayerFunction lf) {
        this.layerFunc = lf;
    }

    public LayerFunction getLayer() {
        return this.layerFunc;
    }

    public void setLayer(int l) {
        this.layer = l;
    }

    public void XwriteObject(XMLHelper h) {
        Boolean b;
        Pair p;
        Rule r2;
        Enumeration k2;
        Hashtable secondPart;
        Rule r1;
        h.openNewElem("CriticalPairs", this);
        h.addObject("GraGra", this.getGrammar(), true);
        h.addObject("Layer", this.getLayer(), true);
        h.openSubTag("dependenciesContainer");
        Enumeration keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            r1 = (Rule)keys.nextElement();
            h.openSubTag("Rule");
            h.addObject("R1", r1, false);
            secondPart = (Hashtable)this.excludeContainer.get(r1);
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = (Rule)k2.nextElement();
                h.openSubTag("Rule");
                h.addObject("R2", r2, false);
                p = (Pair)secondPart.get(r2);
                b = (Boolean)p.first;
                h.addAttr("bool", b.toString());
                if (b.booleanValue()) {
                    Vector v = (Vector)p.second;
                    for (int i = 0; i < v.size(); ++i) {
                        Pair p2i = (Pair)v.elementAt(i);
                        Pair p2 = (Pair)p2i.first;
                        h.openSubTag("Overlapping_Pair");
                        OrdinaryMorphism first = (OrdinaryMorphism)p2.first;
                        Graph overlapping = first.getImage();
                        h.addObject("", overlapping, true);
                        Enumeration e = overlapping.getElements();
                        while (e.hasMoreElements()) {
                            GraphObject o = (GraphObject)e.nextElement();
                            if (!o.isCritical()) continue;
                            h.openSubTag("Critical");
                            h.addObject("object", o, false);
                            h.close();
                        }
                        this.writeOverlapMorphisms(h, r1, r2, p2i);
                        h.close();
                    }
                }
                h.close();
            }
            h.close();
        }
        h.close();
        h.openSubTag("conflictFreeContainer");
        keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            r1 = (Rule)keys.nextElement();
            h.openSubTag("Rule");
            h.addObject("R1", r1, false);
            secondPart = (Hashtable)this.conflictFreeContainer.get(r1);
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = (Rule)k2.nextElement();
                h.openSubTag("Rule");
                h.addObject("R2", r2, false);
                p = (Pair)secondPart.get(r2);
                b = (Boolean)p.first;
                h.addAttr("bool", b.toString());
                h.close();
            }
            h.close();
        }
        h.close();
        h.close();
    }

    public void XreadObject(XMLHelper h) {
        if (h.isTag("CriticalPairs", this)) {
            String bool;
            Enumeration r2s;
            Enumeration r1s;
            Rule r1 = null;
            Rule r2 = null;
            boolean b = false;
            Vector<Pair> allOverlappings = null;
            Vector<String> tagnames = new Vector<String>(1);
            Vector<String> tagnames2 = new Vector<String>(1);
            this.grammar = BaseFactory.theFactory().createGraGra();
            GraGra gg = (GraGra)h.getObject("", this.grammar, true);
            LayerFunction llff = (LayerFunction)h.getObject("", this.getLayer(), true);
            if (llff == null) {
                this.layerFunc = null;
            }
            tagnames.add("conflictContainer");
            tagnames.add("conflictsContainer");
            tagnames.add("excludeContainer");
            tagnames2.add("dependencyContainer");
            tagnames2.add("dependenciesContainer");
            if (h.readSubTag(tagnames2)) {
                this.conflictKind = 1;
            } else if (h.readSubTag(tagnames)) {
                this.conflictKind = 0;
            }
            if (this.conflictKind == 1 || this.conflictKind == 0) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        allOverlappings = null;
                        b = false;
                        if (bool.equals("true")) {
                            b = true;
                            allOverlappings = new Vector<Pair>();
                            Enumeration overlappings = h.getEnumeration("", null, true, "Overlapping_Pair");
                            while (overlappings.hasMoreElements()) {
                                h.peekElement(overlappings.nextElement());
                                Graph g = (Graph)h.getObject("", new Graph(), true);
                                while (h.readSubTag("Critical")) {
                                    GraphObject o = (GraphObject)h.getObject("object", null, false);
                                    if (o != null) {
                                        o.setCritical(true);
                                    }
                                    h.close();
                                }
                                Pair p = this.readOverlappingMorphisms(h, r1, r2, g);
                                allOverlappings.addElement(p);
                                h.close();
                            }
                        }
                        this.addQuadruple(this.excludeContainer, r1, r2, b, allOverlappings);
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            if (h.readSubTag("conflictFreeContainer")) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        if (bool.equals("true")) {
                            b = true;
                        }
                        this.addQuadruple(this.conflictFreeContainer, r1, r2, b, null);
                        if (!r1.isEnabled()) {
                            this.getEntry((Rule)r1, (Rule)r2).state = 5;
                        } else if (r1.getLayer() != r2.getLayer()) {
                            this.getEntry((Rule)r1, (Rule)r2).state = 4;
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
        }
        h.close();
    }
}

