/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.ExcludeParser;
import agg.parser.InvalidAlgorithmException;
import agg.parser.LayerFunction;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.Report;
import agg.parser.RuleInstances;
import agg.parser.Triple;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LayeredExcludeParser
extends ExcludeParser {
    protected LayerFunction layer;

    public LayeredExcludeParser(GraGra grammar, Graph hostGraph, Graph stopGraph, LayeredExcludePairContainer excludeContainer, LayerFunction layer) {
        super(grammar, hostGraph, stopGraph, excludeContainer);
        this.layer = layer;
    }

    public boolean parse() {
        boolean result = true;
        this.fireParserEvent(new ParserMessageEvent(this, "Starting layered exclude parser ..."));
        Integer currentLayer = this.layer.getStartLayer();
        Hashtable invertedRuleLayer = this.layer.invertLayer(this.layer.getRuleLayer());
        OrderedSet ruleLayer = new OrderedSet();
        Enumeration en = invertedRuleLayer.keys();
        while (en.hasMoreElements()) {
            ruleLayer.add(en.nextElement());
        }
        Report.println("Rule Layer " + ruleLayer, Report.LAYER);
        RuleInstances eri = new RuleInstances();
        Hashtable conflictFree = null;
        if (this.stop) {
            return false;
        }
        try {
            conflictFree = this.pairContainer.getContainer(2);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        Hashtable exclude = null;
        if (this.stop) {
            return false;
        }
        try {
            exclude = this.pairContainer.getContainer(0);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        if (this.stop) {
            return false;
        }
        Hashtable excludeLight = new Hashtable();
        Hashtable conflictFreeLight = new Hashtable();
        this.makeLightContainer(exclude, excludeLight);
        this.makeLightContainer(conflictFree, conflictFreeLight);
        if (this.stop) {
            return false;
        }
        Enumeration keys = conflictFreeLight.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key == null || !excludeLight.containsKey(key)) continue;
            conflictFreeLight.remove(key);
        }
        Hashtable layeredExcludeLight = new Hashtable();
        Hashtable layeredConflictFreeLight = new Hashtable();
        if (this.stop) {
            return false;
        }
        Enumeration en2 = ruleLayer.elements();
        while (en2.hasMoreElements()) {
            Integer l = (Integer)en2.nextElement();
            if (l == null) continue;
            HashSet lRules = (HashSet)invertedRuleLayer.get(l);
            if (this.stop) {
                return false;
            }
            Enumeration en22 = lRules.elements();
            while (en22.hasMoreElements()) {
                Hashtable hashtable;
                if (this.stop) {
                    return false;
                }
                Rule r = (Rule)en22.nextElement();
                Object value = conflictFreeLight.get(r);
                if (value != null) {
                    hashtable = (Hashtable)layeredConflictFreeLight.get(l);
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                        layeredConflictFreeLight.put(l, hashtable);
                    }
                    hashtable.put(r, value);
                    continue;
                }
                value = excludeLight.get(r);
                if (value == null) continue;
                hashtable = (Hashtable)layeredExcludeLight.get(l);
                if (hashtable == null) {
                    hashtable = new Hashtable();
                    layeredExcludeLight.put(l, hashtable);
                }
                hashtable.put(r, value);
            }
        }
        if (this.stop) {
            return false;
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Parser initialized"));
        while (!this.getHostGraph().isIsomorphicWith(this.stopGraph) && result) {
            if (this.stop) {
                return false;
            }
            Report.println("CurrentLayer = " + currentLayer, Report.LAYER);
            boolean ruleApplied = false;
            if (currentLayer != null) {
                Hashtable lFree = (Hashtable)layeredConflictFreeLight.get(currentLayer);
                Match m = null;
                if (lFree != null) {
                    m = this.findMatch(this.getHostGraph(), lFree.keys(), eri);
                }
                if (this.stop) {
                    return false;
                }
                if (m != null) {
                    this.applyRule(m);
                    ruleApplied = true;
                    this.fireParserEvent(new ParserMessageEvent(this, m.getRule().getName() + "  was applied."));
                }
                if (ruleApplied || this.stop) continue;
                Hashtable lExclude = (Hashtable)layeredExcludeLight.get(currentLayer);
                OrdinaryMorphism savedMatch = null;
                if (lExclude != null) {
                    Enumeration keys2 = lExclude.keys();
                    while (keys2.hasMoreElements() && !ruleApplied) {
                        if (this.stop) {
                            return false;
                        }
                        Rule r = (Rule)keys2.nextElement();
                        Vector inclusions = this.findInclusions(r, 0);
                        this.fireParserEvent(new ParserMessageEvent(this, "Searching for difficult match of rule  \"" + r.getName() + "\""));
                        Report.println("LayeredExclude: Searching for difficult match of rule  \"" + r.getName() + "\"", Report.LAYER);
                        m = BaseFactory.theFactory().createMatch(r, this.getHostGraph());
                        boolean validMatch = false;
                        while (!ruleApplied && m.nextCompletion()) {
                            if (this.stop) {
                                return false;
                            }
                            Report.println("LayeredExclude: critical match has next Completion", Report.LAYER);
                            if (!m.isValid()) break;
                            Report.println("LayeredExclude: critical match is valid", Report.LAYER);
                            if (!this.isMatchCritic(m, inclusions)) {
                                this.applyRule(m);
                                ruleApplied = true;
                                this.fireParserEvent(new ParserMessageEvent(this, m.getRule().getName() + "  was applied."));
                                continue;
                            }
                            if (this.stop || validMatch || savedMatch != null || eri.isIn(m)) break;
                            validMatch = true;
                            savedMatch = m;
                            Report.println("LayeredExclude: critical match has to be saved", Report.LAYER);
                            break;
                        }
                        if (validMatch) continue;
                        BaseFactory.theFactory().destroyMatch(m);
                    }
                }
                if (!this.stop && !ruleApplied && savedMatch != null) {
                    OrdinaryMorphism copyMorph = this.getHostGraph().isomorphicCopy();
                    this.fireParserEvent(new ParserMessageEvent(copyMorph, ""));
                    eri.add((Match)savedMatch);
                    Triple tmpTriple = new Triple(this.getHostGraph(), eri, currentLayer);
                    this.stack.push(tmpTriple);
                    Report.println("LayeredExclude: critical match on the stack", Report.LAYER);
                    if (this.stop) {
                        return false;
                    }
                    eri = new RuleInstances();
                    this.setHostGraph(copyMorph.getImage());
                    OrdinaryMorphism tmpMorph = savedMatch.compose(copyMorph);
                    Match n = tmpMorph.makeMatch(((Match)savedMatch).getRule());
                    boolean notFound = false;
                    while (!n.isValid() && !notFound) {
                        if (this.stop) {
                            return false;
                        }
                        if (n.nextCompletion()) continue;
                        notFound = true;
                    }
                    if (this.stop) {
                        return false;
                    }
                    if (!notFound) {
                        this.applyRule(n);
                        ruleApplied = true;
                        this.fireParserEvent(new ParserMessageEvent(this, n.getRule().getName() + "  was applied."));
                    }
                }
                if (this.stop) {
                    return false;
                }
                if (ruleApplied) continue;
                boolean nextLayerExists = true;
                OrderedSetIterator osi = ruleLayer.find(currentLayer);
                if (osi.atEnd()) {
                    nextLayerExists = false;
                } else {
                    osi.advance();
                    currentLayer = (Integer)osi.get();
                    if (currentLayer == null) {
                        nextLayerExists = false;
                    }
                }
                Report.println("Existiert naechster Layer? " + nextLayerExists, Report.LAYER);
                if (nextLayerExists) continue;
                try {
                    Report.println("Konnte keine Regel anweden und mache backtrack", Report.PARSER);
                    Triple tmpTriple = (Triple)this.stack.pop();
                    this.setHostGraph(tmpTriple.getHostGraph());
                    eri = tmpTriple.getRuleInstance();
                    currentLayer = tmpTriple.getLayer();
                }
                catch (InvalidOperationException ioe) {
                    this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                    result = false;
                }
                continue;
            }
            result = false;
        }
        while (!this.stack.isEmpty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                Triple tmpTriple = (Triple)this.stack.pop();
                Graph g = tmpTriple.getHostGraph();
                g.dispose();
            }
            catch (InvalidOperationException ioe) {}
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + result + "."));
        this.correct = result;
        return result;
    }
}

