/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.InvalidAlgorithmException;
import agg.parser.LayerFunction;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.LayeredExcludeParser;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.Report;
import agg.parser.RuleInstances;
import agg.parser.Triple;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import java.util.Enumeration;
import java.util.Hashtable;

public class LayeredSimpleExcludeParser
extends LayeredExcludeParser {
    public LayeredSimpleExcludeParser(GraGra grammar, Graph hostGraph, Graph stopGraph, LayeredExcludePairContainer excludeContainer, LayerFunction layer) {
        super(grammar, hostGraph, stopGraph, excludeContainer, layer);
    }

    public boolean parse() {
        System.out.println("Starting layered simple exclude parser ...");
        boolean result = true;
        this.fireParserEvent(new ParserMessageEvent(this, "Starting layered simple exclude parser ..."));
        Integer currentLayer = this.layer.getStartLayer();
        Hashtable invertedRuleLayer = this.layer.invertLayer(this.layer.getRuleLayer());
        OrderedSet ruleLayer = new OrderedSet();
        if (this.stop) {
            return false;
        }
        Enumeration en = invertedRuleLayer.keys();
        while (en.hasMoreElements()) {
            ruleLayer.add(en.nextElement());
        }
        Report.println("Rule Layer " + ruleLayer, Report.LAYER);
        RuleInstances eri = new RuleInstances();
        Hashtable conflictFree = null;
        if (this.stop) {
            return false;
        }
        try {
            conflictFree = this.pairContainer.getContainer(2);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        Hashtable exclude = null;
        if (this.stop) {
            return false;
        }
        try {
            exclude = this.pairContainer.getContainer(0);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        Hashtable conflictFreeLight = null;
        Hashtable excludeLight = null;
        excludeLight = new Hashtable();
        conflictFreeLight = new Hashtable();
        this.makeLightContainer(exclude, excludeLight);
        this.makeLightContainer(conflictFree, conflictFreeLight);
        if (this.stop) {
            return false;
        }
        Enumeration keys = conflictFreeLight.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!excludeLight.containsKey(key)) continue;
            conflictFreeLight.remove(key);
        }
        Hashtable layeredExcludeLight = new Hashtable();
        Hashtable layeredConflictFreeLight = new Hashtable();
        if (this.stop) {
            return false;
        }
        Enumeration en2 = ruleLayer.elements();
        while (en2.hasMoreElements()) {
            Integer l = (Integer)en2.nextElement();
            HashSet lRules = (HashSet)invertedRuleLayer.get(l);
            Enumeration en22 = lRules.elements();
            while (en22.hasMoreElements()) {
                Hashtable hashtable;
                Rule r = (Rule)en22.nextElement();
                Object value = conflictFreeLight.get(r);
                if (value != null) {
                    hashtable = (Hashtable)layeredConflictFreeLight.get(l);
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                        layeredConflictFreeLight.put(l, hashtable);
                    }
                    hashtable.put(r, value);
                    continue;
                }
                value = excludeLight.get(r);
                if (value == null) continue;
                hashtable = (Hashtable)layeredExcludeLight.get(l);
                if (hashtable == null) {
                    hashtable = new Hashtable();
                    layeredExcludeLight.put(l, hashtable);
                }
                hashtable.put(r, value);
            }
        }
        Report.println("layered confliktfree: " + layeredConflictFreeLight, Report.LAYER);
        Report.println("layered exclude: " + layeredExcludeLight, Report.LAYER);
        this.fireParserEvent(new ParserMessageEvent(this, "Layered simple parser initialized"));
        while (!this.stop && !this.getHostGraph().isIsomorphicWith(this.stopGraph) && result && currentLayer != null) {
            Report.println("CurrentLayer = " + currentLayer, Report.LAYER);
            boolean ruleApplied = false;
            Hashtable lFree = (Hashtable)layeredConflictFreeLight.get(currentLayer);
            Report.println("layeredConflictFreeLight " + layeredConflictFreeLight, Report.LAYER);
            Match m = null;
            if (lFree != null) {
                m = this.findMatch(this.getHostGraph(), lFree.keys(), eri);
            }
            if (!this.stop && m != null) {
                this.applyRule(m);
                ruleApplied = true;
                this.fireParserEvent(new ParserMessageEvent(this, m.getRule().getName() + "  was applied."));
            }
            if (this.stop || ruleApplied) continue;
            Hashtable lExclude = (Hashtable)layeredExcludeLight.get(currentLayer);
            Report.println("lExclude " + lExclude, Report.LAYER);
            Match savedMatch = null;
            if (lExclude != null) {
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for difficult match"));
                m = this.findMatch(this.getHostGraph(), lExclude.keys(), eri);
                if (m != null) {
                    savedMatch = m;
                }
            }
            if (!this.stop && !ruleApplied && savedMatch != null) {
                OrdinaryMorphism copyMorph = this.getHostGraph().isomorphicCopy();
                this.fireParserEvent(new ParserMessageEvent(copyMorph, ""));
                eri.add(savedMatch);
                Triple tmpTriple = new Triple(this.getHostGraph(), eri, currentLayer);
                this.stack.push(tmpTriple);
                eri = new RuleInstances();
                this.setHostGraph(copyMorph.getImage());
                OrdinaryMorphism tmpMorph = savedMatch.compose(copyMorph);
                Match n = tmpMorph.makeMatch(savedMatch.getRule());
                boolean notFound = false;
                while (!(this.stop || n.isValid() || notFound)) {
                    if (n.nextCompletion()) continue;
                    notFound = true;
                }
                if (!this.stop && !notFound) {
                    this.applyRule(n);
                    ruleApplied = true;
                    this.fireParserEvent(new ParserMessageEvent(this, n.getRule().getName() + "  was applied."));
                }
            }
            if (this.stop || ruleApplied) continue;
            boolean nextLayerExists = true;
            OrderedSetIterator osi = ruleLayer.find(currentLayer);
            if (osi.atEnd()) {
                nextLayerExists = false;
            } else {
                osi.advance();
                currentLayer = (Integer)osi.get();
            }
            if (currentLayer == null) {
                nextLayerExists = false;
            }
            Report.println("Existiert naechster Layer? " + nextLayerExists, Report.LAYER);
            Report.println("CurrentLayer = " + currentLayer, Report.LAYER);
            if (this.stop || nextLayerExists) continue;
            try {
                Report.println("Konnte keine Regel anweden und mache backtrack", Report.PARSER);
                Triple tmpTriple = (Triple)this.stack.pop();
                this.setHostGraph(tmpTriple.getHostGraph());
                eri = tmpTriple.getRuleInstance();
                currentLayer = tmpTriple.getLayer();
            }
            catch (InvalidOperationException ioe) {
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                result = false;
            }
        }
        while (!this.stack.isEmpty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                Triple tmpTriple = (Triple)this.stack.pop();
                Graph g = tmpTriple.getHostGraph();
                g.dispose();
            }
            catch (InvalidOperationException ioe) {}
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + result + "."));
        this.correct = result;
        return result;
    }
}

