/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.LayerFunction;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.Report;
import agg.parser.RuleInstances;
import agg.parser.SimpleParser;
import agg.parser.Triple;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.OrdinaryMorphism;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import com.objectspace.jgl.Stack;
import java.util.Enumeration;
import java.util.Hashtable;

public class LayeredSimpleParser
extends SimpleParser {
    protected LayerFunction layer;

    public LayeredSimpleParser(GraGra grammar, Graph hostGraph, Graph stopGraph, LayerFunction layer) {
        super(grammar, hostGraph, stopGraph);
        this.layer = layer;
    }

    public boolean parse() {
        System.out.println("Starting layered simple parser ...");
        Stack stack = new Stack();
        this.correct = true;
        this.fireParserEvent(new ParserMessageEvent(this, "Starting layered simple parser ..."));
        Integer currentLayer = this.layer.getStartLayer();
        Hashtable invertedRuleLayer = this.layer.invertLayer(this.layer.getRuleLayer());
        OrderedSet ruleLayer = new OrderedSet();
        if (this.stop) {
            return false;
        }
        Enumeration en = invertedRuleLayer.keys();
        while (en.hasMoreElements()) {
            ruleLayer.add(en.nextElement());
        }
        Report.println("Rule Layer " + ruleLayer, Report.LAYER);
        RuleInstances eri = new RuleInstances();
        while (!this.getHostGraph().isIsomorphicWith(this.stopGraph) && this.correct && currentLayer != null) {
            System.out.println("currentLayer:  " + currentLayer);
            boolean ruleApplied = false;
            this.fireParserEvent(new ParserMessageEvent(this, "Searching for match"));
            HashSet rulesForLayer = (HashSet)invertedRuleLayer.get(currentLayer);
            Report.println("rulesForLayer: " + rulesForLayer, Report.LAYER);
            Match m = this.findMatch(this.getHostGraph(), rulesForLayer.elements(), eri);
            System.out.println("Match:  " + m);
            if (this.stop) {
                return false;
            }
            if (m != null) {
                OrdinaryMorphism copyMorph = this.getHostGraph().isomorphicCopy();
                this.fireParserEvent(new ParserMessageEvent(copyMorph, ""));
                eri.add(m);
                Triple tmpTriple = new Triple(this.getHostGraph(), eri, currentLayer);
                stack.push(tmpTriple);
                eri = new RuleInstances();
                this.setHostGraph(copyMorph.getImage());
                if (this.stop) {
                    return false;
                }
                OrdinaryMorphism tmpMorph = m.compose(copyMorph);
                Match n = tmpMorph.makeMatch(m.getRule());
                boolean found = true;
                while (!this.stop && !n.isValid() && found) {
                    if (n.nextCompletion()) continue;
                    found = false;
                }
                if (!this.stop && found) {
                    this.applyRule(n);
                    ruleApplied = true;
                    this.fireParserEvent(new ParserMessageEvent(this, n.getRule().getName() + "  was applied."));
                }
                System.out.println("applied:  " + ruleApplied);
            }
            if (this.stop || m != null && ruleApplied) continue;
            boolean nextLayerExists = true;
            OrderedSetIterator osi = ruleLayer.find(currentLayer);
            if (osi.atEnd()) {
                nextLayerExists = false;
            } else {
                osi.advance();
                currentLayer = (Integer)osi.get();
            }
            if (currentLayer == null) {
                nextLayerExists = false;
            }
            if (nextLayerExists) continue;
            try {
                Report.println("Konnte keine Regel anwenden und mache backtrack", Report.PARSER);
                Triple tmpTriple = (Triple)stack.pop();
                this.setHostGraph(tmpTriple.getHostGraph());
                eri = tmpTriple.getRuleInstance();
                currentLayer = tmpTriple.getLayer();
            }
            catch (InvalidOperationException ioe) {
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                this.correct = false;
            }
        }
        while (!stack.isEmpty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                Triple tmpTriple = (Triple)stack.pop();
                Graph g = tmpTriple.getHostGraph();
                BaseFactory.theFactory().destroyGraph(g);
            }
            catch (InvalidOperationException ioe) {}
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + this.correct + "."));
        return this.correct;
    }
}

