/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.AbstractParser;
import agg.parser.CriticalPairOption;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.ExcludeParser;
import agg.parser.ExtendedLayerFunction;
import agg.parser.LayerFunction;
import agg.parser.LayerOption;
import agg.parser.LayeredDependencyPairContainer;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.LayeredExcludeParser;
import agg.parser.LayeredSimpleExcludeParser;
import agg.parser.LayeredSimpleParser;
import agg.parser.PairContainer;
import agg.parser.Parser;
import agg.parser.ParserOption;
import agg.parser.SimpleExcludeParser;
import agg.parser.SimpleParser;
import agg.parser.WeakExtendedLayerFunction;
import agg.parser.WeakLayerFunction;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;

public class ParserFactory {
    private ParserFactory() {
    }

    public static Parser createParser(GraGra grammar, Graph hostGraph, Graph stopGraph, PairContainer pairs, ParserOption option, LayerFunction layer) {
        AbstractParser p = null;
        if (option != null && grammar != null && hostGraph != null && stopGraph != null) {
            switch (option.getSelectedParser()) {
                case 0: {
                    if (option.layerEnabled()) {
                        p = new LayeredSimpleParser(grammar, hostGraph, stopGraph, layer);
                        break;
                    }
                    p = new SimpleParser(grammar, hostGraph, stopGraph);
                    break;
                }
                case 1: {
                    if (pairs == null || !(pairs instanceof ExcludePairContainer)) break;
                    if (option.layerEnabled()) {
                        p = new LayeredExcludeParser(grammar, hostGraph, stopGraph, (LayeredExcludePairContainer)pairs, layer);
                        break;
                    }
                    p = new ExcludeParser(grammar, hostGraph, stopGraph, (ExcludePairContainer)pairs);
                    break;
                }
                case 2: {
                    if (pairs == null || !(pairs instanceof ExcludePairContainer)) break;
                    if (option.layerEnabled()) {
                        p = new LayeredSimpleExcludeParser(grammar, hostGraph, stopGraph, (LayeredExcludePairContainer)pairs, layer);
                        break;
                    }
                    p = new SimpleExcludeParser(grammar, hostGraph, stopGraph, (ExcludePairContainer)pairs);
                    break;
                }
            }
        }
        return p;
    }

    public static PairContainer createEmptyCriticalPairs(GraGra grammar, LayerFunction layerFunc, CriticalPairOption option) {
        ExcludePairContainer pc = null;
        if (option != null && grammar != null) {
            switch (option.getCriticalPairAlgorithm()) {
                case 0: {
                    if (option.layeredEnabled()) {
                        pc = new LayeredExcludePairContainer(grammar, layerFunc);
                        ((LayeredExcludePairContainer)pc).setLayer(option.getLayer());
                    } else {
                        pc = new ExcludePairContainer(grammar);
                    }
                    pc.enableComplete(option.completeEnabled());
                    pc.enableNACs(option.nacsEnabled());
                    pc.enableReduce(option.reduceEnabled());
                    pc.enableConsistent(option.consistentEnabled());
                    break;
                }
                case 1: {
                    if (option.layeredEnabled()) {
                        pc = new LayeredDependencyPairContainer(grammar, layerFunc);
                        ((LayeredExcludePairContainer)pc).setLayer(option.getLayer());
                    } else {
                        pc = new DependencyPairContainer(grammar);
                    }
                    ((DependencyPairContainer)pc).enableComplete(option.completeEnabled());
                    ((DependencyPairContainer)pc).enableNACs(option.nacsEnabled());
                    ((DependencyPairContainer)pc).enableReduce(option.reduceEnabled());
                    ((DependencyPairContainer)pc).enableConsistent(option.consistentEnabled());
                    break;
                }
            }
        }
        return pc;
    }

    public static PairContainer createEmptyCriticalPairs(GraGra grammar, int algorithm, boolean layered) {
        ExcludePairContainer pc = null;
        if (grammar != null) {
            switch (algorithm) {
                case 0: {
                    if (layered) {
                        pc = new LayeredExcludePairContainer(grammar);
                        break;
                    }
                    pc = new ExcludePairContainer(grammar);
                    break;
                }
                case 1: {
                    if (layered) {
                        pc = new LayeredDependencyPairContainer(grammar);
                        break;
                    }
                    pc = new DependencyPairContainer(grammar);
                    break;
                }
            }
        }
        return pc;
    }

    public static PairContainer generateCriticalPairs(GraGra grammar, LayerFunction layer, CriticalPairOption option) {
        PairContainer pc = ParserFactory.createEmptyCriticalPairs(grammar, layer, option);
        ParserFactory.generateCriticalPairs(pc);
        return pc;
    }

    public static void generateCriticalPairs(PairContainer pc) {
        if (pc != null && pc instanceof Runnable) {
            Thread t = new Thread((Runnable)((Object)pc));
            t.setPriority(4);
            t.start();
        }
    }

    public static LayerFunction createLayerFunction(GraGra grammar, LayerOption option) {
        LayerFunction lf = null;
        if (option != null && grammar != null) {
            switch (option.getLayer()) {
                case 1: {
                    lf = new LayerFunction(grammar);
                    break;
                }
                case 0: {
                    lf = new ExtendedLayerFunction(grammar);
                    break;
                }
                case 3: {
                    lf = new WeakLayerFunction(grammar);
                    break;
                }
                case 2: {
                    lf = new WeakExtendedLayerFunction(grammar);
                    break;
                }
            }
        }
        return lf;
    }
}

