/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.ExcludePairContainer;
import agg.parser.ExcludeParser;
import agg.parser.InvalidAlgorithmException;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.Report;
import agg.parser.RuleInstances;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Hashtable;

public class SimpleExcludeParser
extends ExcludeParser {
    public SimpleExcludeParser(GraGra grammar, Graph hostGraph, Graph stopGraph, ExcludePairContainer excludeContainer) {
        super(grammar, hostGraph, stopGraph, excludeContainer);
    }

    public boolean parse() {
        System.out.println("Starting simple exclude parser ...");
        this.correct = true;
        this.fireParserEvent(new ParserMessageEvent(this, "Starting simple exclude parser ..."));
        Hashtable conflictFree = null;
        if (this.stop) {
            return false;
        }
        try {
            conflictFree = this.pairContainer.getContainer(2);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        Hashtable exclude = null;
        if (this.stop) {
            return false;
        }
        try {
            exclude = this.pairContainer.getContainer(0);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        if (this.stop) {
            return false;
        }
        Hashtable conflictFreeLight = null;
        Hashtable excludeLight = null;
        excludeLight = new Hashtable();
        conflictFreeLight = new Hashtable();
        if (this.stop) {
            return false;
        }
        this.makeLightContainer(exclude, excludeLight);
        if (this.stop) {
            return false;
        }
        this.makeLightContainer(conflictFree, conflictFreeLight);
        if (this.stop) {
            return false;
        }
        Enumeration keys = conflictFreeLight.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!excludeLight.containsKey(key)) continue;
            conflictFreeLight.remove(key);
        }
        RuleInstances eri = new RuleInstances();
        this.fireParserEvent(new ParserMessageEvent(this, "Parser initialized"));
        if (this.stop) {
            return false;
        }
        while (!this.stop && !this.graph.isIsomorphicWith(this.stopGraph) && this.correct) {
            Match m;
            Rule r;
            boolean ruleApplied = false;
            Enumeration keys2 = conflictFreeLight.keys();
            while (keys2.hasMoreElements() && !ruleApplied) {
                r = (Rule)keys2.nextElement();
                Report.println("versuche konfliktfreie Regel " + r.getName(), Report.PARSER);
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for easy match"));
                m = BaseFactory.theFactory().createMatch(r, this.getHostGraph());
                while (!this.stop && !ruleApplied && m.nextCompletion()) {
                    if (!m.isValid()) continue;
                    this.applyRule(m);
                    ruleApplied = true;
                    this.fireParserEvent(new ParserMessageEvent(this, m.getRule().getName() + "  was applied."));
                }
            }
            if (this.stop || ruleApplied) continue;
            keys2 = excludeLight.keys();
            while (keys2.hasMoreElements() && !ruleApplied) {
                r = (Rule)keys2.nextElement();
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for difficult match"));
                m = BaseFactory.theFactory().createMatch(r, this.getHostGraph());
                boolean found = false;
                while (!found && m.nextCompletion()) {
                    if (eri.isIn(m) || !m.isValid()) continue;
                    found = true;
                }
                if (!this.stop && found) {
                    OrdinaryMorphism copyMorph = this.getHostGraph().isomorphicCopy();
                    this.fireParserEvent(new ParserMessageEvent(copyMorph, ""));
                    eri.add(m);
                    Pair tmpPair = new Pair(this.getHostGraph(), eri);
                    this.stack.push(tmpPair);
                    eri = new RuleInstances();
                    this.setHostGraph(copyMorph.getImage());
                    OrdinaryMorphism tmpMorph = m.compose(copyMorph);
                    Match n = tmpMorph.makeMatch(m.getRule());
                    boolean notFound = false;
                    while (!(this.stop || n.isValid() || notFound)) {
                        if (n.nextCompletion()) continue;
                        notFound = true;
                    }
                    if (this.stop || notFound) continue;
                    this.applyRule(n);
                    ruleApplied = true;
                    this.fireParserEvent(new ParserMessageEvent(this, n.getRule().getName() + "  was applied."));
                    continue;
                }
                BaseFactory.theFactory().destroyMatch(m);
                m = null;
            }
            if (this.stop || ruleApplied) continue;
            try {
                Pair tmpPair = (Pair)this.stack.pop();
                this.setHostGraph((Graph)tmpPair.first);
                eri = (RuleInstances)tmpPair.second;
            }
            catch (InvalidOperationException ioe) {
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                this.correct = false;
            }
        }
        while (!this.stack.isEmpty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                Pair tmpPair = (Pair)this.stack.pop();
                Graph g = (Graph)tmpPair.first;
                BaseFactory.theFactory().destroyGraph(g);
                tmpPair.second = null;
            }
            catch (InvalidOperationException ioe) {}
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + this.correct + "."));
        return this.correct;
    }
}

