/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.AbstractParser;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.Report;
import agg.parser.RuleInstances;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.OrdinaryMorphism;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Stack;

public class SimpleParser
extends AbstractParser
implements Runnable {
    protected boolean stop = false;
    protected boolean correct;

    public SimpleParser(GraGra grammar, Graph hostGraph, Graph stopGraph) {
        super(grammar, hostGraph, stopGraph, null);
    }

    public void run() {
        this.fireParserEvent(new ParserMessageEvent(this, "Starting parser. Please wait ..."));
        this.parse();
        if (this.stop) {
            this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser."));
        } else {
            this.fireParserEvent(new ParserMessageEvent(this, "Finishing parser. Result is " + this.correct + "."));
        }
    }

    public void stop() {
        this.stop = true;
    }

    public boolean wasStopped() {
        return this.stop;
    }

    public boolean parse() {
        System.out.println("Starting simple parser ...");
        Stack stack = new Stack();
        this.correct = true;
        RuleInstances eri = new RuleInstances();
        this.fireParserEvent(new ParserMessageEvent(this, "Starting simple parser ..."));
        if (this.stop) {
            return false;
        }
        while (!this.stop && !this.getHostGraph().isIsomorphicWith(this.stopGraph) && this.correct) {
            boolean ruleApplied = false;
            this.fireParserEvent(new ParserMessageEvent(this, "Searching for match!"));
            Match m = this.findMatch(this.getHostGraph(), this.grammar.getRules(), eri);
            if (m != null) {
                OrdinaryMorphism copyMorph = this.getHostGraph().isomorphicCopy();
                this.fireParserEvent(new ParserMessageEvent(copyMorph, ""));
                eri.add(m);
                Pair tmpPair = new Pair(this.getHostGraph(), eri);
                stack.push(tmpPair);
                eri = new RuleInstances();
                this.setHostGraph(copyMorph.getImage());
                OrdinaryMorphism tmpMorph = m.compose(copyMorph);
                Match n = tmpMorph.makeMatch(m.getRule());
                boolean found = true;
                while (!this.stop && !n.isValid() && found) {
                    if (n.nextCompletion()) continue;
                    found = false;
                }
                if (!this.stop && found) {
                    this.applyRule(n);
                    ruleApplied = true;
                    this.fireParserEvent(new ParserMessageEvent(this, n.getRule().getName() + "  was applied."));
                }
            }
            if (m != null && ruleApplied) continue;
            try {
                Report.println("Konnte keine Regel anweden und mache backtrack", Report.PARSER);
                Pair tmpPair = (Pair)stack.pop();
                this.setHostGraph((Graph)tmpPair.first);
                eri = (RuleInstances)tmpPair.second;
            }
            catch (InvalidOperationException ioe) {
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                this.correct = false;
            }
        }
        while (!stack.isEmpty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                Pair tmpPair = (Pair)stack.pop();
                Graph g = (Graph)tmpPair.first;
                BaseFactory.theFactory().destroyGraph(g);
                tmpPair.second = null;
            }
            catch (InvalidOperationException invalidOperationException) {}
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + this.correct + "."));
        return this.correct;
    }
}

