/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.commonlib;

import agg.xt_basis.Rule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreHelper {
    File scoreFile = null;
    Document xmlDoc = null;

    public ScoreHelper() {
        String fSep = System.getProperty("file.separator");
        this.scoreFile = new File("scores.xml");
    }

    public ArrayList<Integer> readScores(ArrayList<Rule> scoredThings) {
        boolean status = this.readFile();
        if (!status) {
            status = this.resetAllScores();
        }
        ArrayList<Integer> retScores = new ArrayList<Integer>();
        for (Rule scoredThingRule : scoredThings) {
            if (!status) {
                retScores.add(new Integer(-3));
                continue;
            }
            String scoredThing = scoredThingRule.getName();
            String xpath = "/Scores/Score[@name='" + scoredThing + "']/Value";
            NodeList nodeList = null;
            try {
                nodeList = XPathAPI.selectNodeList((Node)this.xmlDoc, (String)xpath);
                int scoreToAdd = -1;
                if (nodeList != null && nodeList.getLength() == 1) {
                    scoreToAdd = Integer.parseInt(nodeList.item(0).getTextContent());
                }
                retScores.add(new Integer(scoreToAdd));
            }
            catch (TransformerException tE) {
                tE.printStackTrace();
                retScores.add(new Integer(-2));
            }
        }
        return retScores;
    }

    public void changeScore(String thingToScore) {
        boolean status = this.readFile();
        if (!status) {
            status = this.resetAllScores();
        }
        if (status) {
            String xpath = "/Scores/Score[@name='" + thingToScore + "']/Value";
            NodeList nodeList = null;
            try {
                nodeList = XPathAPI.selectNodeList((Node)this.xmlDoc, (String)xpath);
            }
            catch (TransformerException tE) {
                // empty catch block
            }
            boolean okChanged = false;
            if (nodeList != null && nodeList.getLength() == 1) {
                int value = Integer.parseInt(nodeList.item(0).getTextContent());
                nodeList.item(0).setTextContent(String.valueOf(++value));
                okChanged = true;
            }
            if (!okChanged) {
                Element score = this.xmlDoc.createElement("Score");
                score.setAttribute("name", thingToScore);
                Element val = this.xmlDoc.createElement("Value");
                Text node = this.xmlDoc.createTextNode(String.valueOf(1));
                val.appendChild(node);
                score.appendChild(val);
                NodeList root = this.xmlDoc.getElementsByTagName("Scores");
                root.item(0).appendChild(score);
                okChanged = true;
            }
            if (okChanged) {
                this.serializeXml();
            }
        }
    }

    public boolean resetAllScores() {
        try {
            DocumentBuilder builder = this.createXmlEmptyDoc();
            this.xmlDoc = builder.newDocument();
            Element root = this.xmlDoc.createElement("Scores");
            this.xmlDoc.appendChild(root);
        }
        catch (Exception ex) {
            return false;
        }
        return this.serializeXml();
    }

    private boolean readFile() {
        try {
            DocumentBuilder builder = this.createXmlEmptyDoc();
            this.fillDoc(builder);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private boolean fillDoc(DocumentBuilder builder) throws Exception {
        this.xmlDoc = null;
        try {
            this.xmlDoc = builder.parse(this.scoreFile);
            return true;
        }
        catch (SAXException saxE) {
            saxE.printStackTrace();
            throw new Exception("Sax Exception occured");
        }
        catch (IOException ioE) {
            throw new Exception("IO File Read Exception occured");
        }
        catch (Exception E) {
            throw new Exception("Unexpected Exception occured.\nExplanation : " + E.getMessage());
        }
    }

    private DocumentBuilder createXmlEmptyDoc() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (ParserConfigurationException pcE) {
            pcE.printStackTrace();
            throw new Exception("PCE Exception occured");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean serializeXml() {
        OutputFormat format = new OutputFormat(this.xmlDoc, "UTF-8", true);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.scoreFile);
            XMLSerializer serializer = new XMLSerializer(os, format);
            serializer.setOutputByteStream(os);
            serializer.serialize(this.xmlDoc);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {}
        }
        return true;
    }
}

