/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.dm;

import agg.plugins.dm.InconsistencyItem;
import agg.plugins.dm.TransformHistory;
import agg.xt_basis.Graph;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformStage {
    private TreeSet<InconsistencyItem> incSet = new TreeSet();
    private String statusDescription = null;
    private boolean isSuccessful = false;
    private TransformHistory historyHolder = null;

    public AbstractTransformStage(TransformHistory theHistoryHolder) {
        this.historyHolder = theHistoryHolder;
    }

    public void setTransformationResult(String aStatusDescription, boolean isASuccess) {
        this.statusDescription = aStatusDescription;
        this.isSuccessful = isASuccess;
    }

    protected void buildInconsistencySet(Graph g) throws Exception {
        this.getHistoryHolder().getImgraHolder().fillIncSet(this.getIncSet());
    }

    public TransformHistory getHistoryHolder() {
        return this.historyHolder;
    }

    protected TreeSet<InconsistencyItem> getIncSet() {
        return this.incSet;
    }

    public String toString() {
        return this.getKind() + "\n" + this.showSpecificStageString() + this.showOpStatusString() + this.showStageString();
    }

    public abstract String showSpecificStageString();

    public abstract String getKind();

    private String showStageString() {
        StringBuilder incSetString = new StringBuilder();
        for (InconsistencyItem ip : this.getIncSet()) {
            incSetString.append(">" + ip.getIdentifierString() + "\n");
        }
        return incSetString.toString();
    }

    private String showOpStatusString() {
        String opStat = this.statusDescription + (this.isSuccessful ? " (success)" : " (failure)");
        return opStat.trim() + "\n";
    }
}

