/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.dm;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrTypeMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.plugins.commonlib.ScoreHelper;
import agg.plugins.dm.Inconsistency;
import agg.plugins.dm.InconsistencyItem;
import agg.plugins.dm.InconsistencyPair;
import agg.plugins.dm.SimpleParameter;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Node;
import agg.xt_basis.Rule;
import agg.xt_basis.Step;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncManagedGraGra {
    private GraGra gra = null;
    private final String strConflictPattern = "Conflict";
    private final String strDescriptionPattern = "description";
    private ScoreHelper sh = null;

    public IncManagedGraGra(GraGra eGra) throws Exception {
        this.gra = eGra;
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra can't be constructed.");
        }
        this.build();
    }

    public void build() {
        this.sh = new ScoreHelper();
    }

    public String getGTSName() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getGTSName() Name can't be given.");
        }
        return this.gra.getName();
    }

    private Graph getTypeGraph() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getTypeGraph() TypeGraph can't be given.");
        }
        return this.gra.getTypeGraph();
    }

    public String getTypeGraphName() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getTypeGraphName() TypeGraphName can't be given.");
        }
        return this.getTypeGraph().getName();
    }

    private Graph getHostGraph() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getHostGraph() HostGraph can't be given.");
        }
        return this.gra.getGraph();
    }

    public String getHostGraphName() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getHostGraphName() HostGraph Name can't be given.");
        }
        return this.getHostGraph().getName();
    }

    public Enumeration getRulesEnum() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getRules() Rules can't be given.");
        }
        return this.gra.getRules();
    }

    public Type getInconsistentNodeType() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getInconsistentType() NodeType can't be given.");
        }
        Enumeration types = this.gra.getTypes();
        while (types.hasMoreElements()) {
            Type t = (Type)types.nextElement();
            if (!t.getAdditionalRepr().contains("[NODE]") || !t.getName().equals("Conflict")) continue;
            return t;
        }
        throw new Exception("IncManagedGraGra.getInconsistentType() NodeType can't be found.");
    }

    public ArrayList<Node> getEligibleTypeNodes() throws Exception {
        Type incNodeType = this.getInconsistentNodeType();
        ArrayList<Node> eligibleTypeNodes = new ArrayList<Node>();
        Enumeration arcs = this.getTypeGraph().getArcs();
        while (arcs.hasMoreElements()) {
            Arc a = (Arc)arcs.nextElement();
            Node sourceNode = (Node)a.getSource();
            Node targetNode = (Node)a.getTarget();
            Type arcType = a.getType();
            if (!targetNode.getType().getName().equals(incNodeType.getName())) continue;
            eligibleTypeNodes.add(sourceNode);
        }
        return eligibleTypeNodes;
    }

    public ArrayList<InconsistencyPair> getMarkedGraphNodes() throws Exception {
        return this.getMarkedGraphNodes(this.getHostGraph());
    }

    private ArrayList<InconsistencyPair> getMarkedGraphNodes(Graph g) throws Exception {
        Type incNodeType = this.getInconsistentNodeType();
        ArrayList<InconsistencyPair> incNodes = new ArrayList<InconsistencyPair>();
        Enumeration arcs = g.getArcs();
        while (arcs.hasMoreElements()) {
            Arc a = (Arc)arcs.nextElement();
            Node sourceNode = (Node)a.getSource();
            Node targetNode = (Node)a.getTarget();
            Type arcType = a.getType();
            if (!targetNode.getType().getName().equals(incNodeType.getName())) continue;
            InconsistencyPair incNode = new InconsistencyPair(sourceNode, targetNode);
            incNodes.add(incNode);
        }
        return incNodes;
    }

    public void fillIncSet(Set<InconsistencyItem> incSet) throws Exception {
        Type incNodeType = this.getInconsistentNodeType();
        Enumeration arcs = this.getHostGraph().getArcs();
        while (arcs.hasMoreElements()) {
            Arc a = (Arc)arcs.nextElement();
            Node sourceNode = (Node)a.getSource();
            Node targetNode = (Node)a.getTarget();
            Type arcType = a.getType();
            if (!targetNode.getType().getName().equals(incNodeType.getName())) continue;
            InconsistencyItem incNode = new InconsistencyItem(sourceNode, targetNode, InconsistencyItem.IncPresentationMode.showIncDetail);
            incSet.add(incNode);
        }
    }

    public RuleKind getRuleKind(Rule r) throws Exception {
        if (r == null) {
            throw new Exception("IncManagedGraGra.getRuleKind() RuleKind can't be given.");
        }
        Type incNodeType = this.getInconsistentNodeType();
        Graph leftG = this.getRuleLeftGraph(r);
        Graph rightG = this.getRuleRightGraph(r);
        ArrayList<InconsistencyPair> eligibleGraphNodes = this.getMarkedGraphNodes(leftG);
        int leftIncs = eligibleGraphNodes.size();
        eligibleGraphNodes = this.getMarkedGraphNodes(rightG);
        int rightIncs = eligibleGraphNodes.size();
        if (leftIncs == 1 && rightIncs == 0) {
            return RuleKind.resolution;
        }
        if (leftIncs == 0 && rightIncs == 1) {
            return RuleKind.detection;
        }
        if (leftIncs == 0 && rightIncs == 0) {
            return RuleKind.ordinary;
        }
        return RuleKind.unknown;
    }

    public Inconsistency getConcernedInconsistency(Rule r) throws Exception {
        if (r == null) {
            throw new Exception("IncManagedGraGra.getConcernedInconsistency() Inconsistency can't be given.");
        }
        Graph leftG = this.getRuleLeftGraph(r);
        Graph rightG = this.getRuleRightGraph(r);
        Type incNodeType = this.getInconsistentNodeType();
        ArrayList<InconsistencyPair> eligibleLGraphNodes = this.getMarkedGraphNodes(leftG);
        int leftIncs = eligibleLGraphNodes.size();
        ArrayList<InconsistencyPair> eligibleRGraphNodes = this.getMarkedGraphNodes(rightG);
        int rightIncs = eligibleRGraphNodes.size();
        if (leftIncs == 1 && rightIncs == 0) {
            InconsistencyPair incNode = eligibleLGraphNodes.get(0);
            Node inconsistentNode = incNode.getInconsistentNode();
            Node inconsistencyNode = incNode.getInconsistencyNode();
            AttrInstance attr = inconsistencyNode.getAttribute();
            String incName = (String)attr.getValueAt("description");
            return new Inconsistency(incName, inconsistentNode);
        }
        if (leftIncs == 0 && rightIncs == 1) {
            InconsistencyPair incNode = eligibleRGraphNodes.get(0);
            Node inconsistentNode = incNode.getInconsistentNode();
            Node inconsistencyNode = incNode.getInconsistencyNode();
            AttrInstance attr = inconsistencyNode.getAttribute();
            String incName = (String)attr.getValueAt("description");
            return new Inconsistency(incName, inconsistentNode);
        }
        if (leftIncs == 1 && rightIncs == 0) {
            throw new Exception("IncManagedGraGra.getConcernedInconsistency() This rule doesn't conform the established process. Rule name = " + r.getName());
        }
        return null;
    }

    private Graph getRuleLeftGraph(Rule r) throws Exception {
        if (r == null) {
            throw new Exception("IncManagedGraGra.getRuleLeftGraph() LeftGraph can't be given.");
        }
        return r.getLeft();
    }

    private Graph getRuleRightGraph(Rule r) throws Exception {
        if (r == null) {
            throw new Exception("IncManagedGraGra.getRuleRightGraph() RightGraph can't be given.");
        }
        return r.getRight();
    }

    public String getRuleLeftGraphName(Rule r) throws Exception {
        if (r == null) {
            throw new Exception("IncManagedGraGra.getRuleLeftGraphName() LeftGraphName can't be given.");
        }
        return this.getRuleLeftGraph(r).getName();
    }

    public String getRuleRightGraphName(Rule r) throws Exception {
        if (r == null) {
            throw new Exception("IncManagedGraGra.getRuleRightGraphName() RightGraphName can't be given.");
        }
        return this.getRuleRightGraph(r).getName();
    }

    public ArrayList<Rule> getDetectionRules() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getDetectionRules() DetectionRules can't be given.");
        }
        Enumeration rules = this.getRulesEnum();
        ArrayList<Rule> detRules = new ArrayList<Rule>();
        while (rules.hasMoreElements()) {
            Rule r = (Rule)rules.nextElement();
            RuleKind thisKind = this.getRuleKind(r);
            if (thisKind != RuleKind.detection) continue;
            detRules.add(r);
        }
        return detRules;
    }

    public ArrayList<Rule> getResolutionRulesBasedOn(String inconsistencyName, boolean restrictToApplicableRules) throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getResolutionRulesBaseOn(inconsistencyName) ResolutionRules can't be given.");
        }
        Enumeration rules = this.getRulesEnum();
        ArrayList<Rule> detRules = new ArrayList<Rule>();
        while (rules.hasMoreElements()) {
            Inconsistency incConcerned;
            Rule r = (Rule)rules.nextElement();
            RuleKind thisKind = this.getRuleKind(r);
            if (thisKind != RuleKind.resolution || !(incConcerned = this.getConcernedInconsistency(r)).getInconsistencyName().equals(inconsistencyName)) continue;
            boolean toGet = true;
            if (restrictToApplicableRules) {
                throw new Exception("Not implemented. Please turn off 'restrictToApplicableRules'");
            }
            if (!toGet) continue;
            detRules.add(r);
        }
        return detRules;
    }

    private boolean isResApplicable(Rule resRule) {
        Graph g = this.gra.getGraph();
        if (!g.isReadyForTransform()) {
            return false;
        }
        if (!resRule.isReadyToTransform()) {
            return false;
        }
        if (!resRule.isEnabled()) {
            return false;
        }
        boolean allowVariables = true;
        Match resRuleMatch = BaseFactory.theFactory().createMatch(resRule, g);
        if (resRuleMatch == null) {
            return false;
        }
        while (resRuleMatch.nextCompletion()) {
            if (resRuleMatch.isWeakValid(allowVariables)) continue;
            return false;
        }
        return true;
    }

    public boolean allDetRuleActive() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.doDetect() Detection can't be done.");
        }
        ArrayList<Rule> detRules = this.getDetectionRules();
        boolean allActive = true;
        for (int i = 0; i < detRules.size(); ++i) {
            Rule detRule = detRules.get(i);
            if (detRule.isEnabled()) continue;
            allActive = false;
        }
        return allActive;
    }

    public boolean doDetect(boolean withHist) throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.doDetect() Detection can't be done.");
        }
        boolean allActive = true;
        ArrayList<Rule> detRules = this.getDetectionRules();
        for (int i = 0; i < detRules.size(); ++i) {
            Rule detRule = detRules.get(i);
            if (detRule.isEnabled()) {
                Match detRuleMatch = this.gra.createMatch(detRule);
                while (detRuleMatch.nextCompletion()) {
                    if (detRuleMatch.isValid()) {
                        Step step = new Step();
                        try {
                            step.execute(detRuleMatch);
                            continue;
                        }
                        catch (TypeException ex) {
                            this.gra.destroyMatch(detRuleMatch);
                            ex.printStackTrace();
                            throw new Exception("IncManagedGraGra.doDetect() Transformation failed " + ex.getMessage() + " " + detRuleMatch.getRule().getName());
                        }
                    }
                    this.gra.destroyMatch(detRuleMatch);
                    throw new Exception("IncManagedGraGra.doDetect() Invalid match " + detRuleMatch.getRule().getName());
                }
                this.gra.destroyMatch(detRuleMatch);
                continue;
            }
            allActive = false;
        }
        return allActive;
    }

    public ArrayList<MatchOccurrence> getMatches(Node incNode, Rule resRule, HashMap<String, SimpleParameter> parms) {
        ArrayList<MatchOccurrence> moList = new ArrayList<MatchOccurrence>();
        Match resRuleMatch = this.gra.createMatch(resRule);
        boolean aRuleisApplied = false;
        while (resRuleMatch.nextCompletion()) {
            boolean thisRuleCoversTheNode = false;
            Enumeration coDo = resRuleMatch.getCodomain();
            while (coDo.hasMoreElements()) {
                GraphObject gObj = (GraphObject)coDo.nextElement();
                if (!(gObj instanceof Node)) continue;
                Type objType = gObj.getType();
                String name = objType.getName();
                if (gObj != incNode) continue;
                thisRuleCoversTheNode = true;
                break;
            }
            if (!thisRuleCoversTheNode) continue;
            MatchOccurrence moc = new MatchOccurrence();
            Enumeration coDoCo = resRuleMatch.getCodomain();
            while (coDoCo.hasMoreElements()) {
                GraphObject gObj = (GraphObject)coDoCo.nextElement();
                if (!(gObj instanceof Node)) continue;
                Type objType = gObj.getType();
                String name = objType.getName();
                String artifactName = (String)((Node)gObj).getAttribute().getValueAt("name");
                if (name.equals("Conflict")) continue;
                moc.addMatchElement(name, String.valueOf(gObj.hashCode()), artifactName);
            }
            moc.sort();
            moList.add(moc);
        }
        AttrContext ac = resRuleMatch.getAttrContext();
        VarTuple matchVariables = (VarTuple)ac.getVariables();
        if (!matchVariables.areInputParametersSet()) {
            for (int i = 0; i < matchVariables.getNumberOfEntries(); ++i) {
                ValueMember val = matchVariables.getValueMemberAt(matchVariables.getNameAsString(i));
                VarMember var = matchVariables.getVarMemberAt(matchVariables.getNameAsString(i));
                AttrTypeMember decl = var.getDeclaration();
                if (!var.isInputParameter()) continue;
                parms.put(var.getName(), new SimpleParameter(decl.getTypeName(), val.getExprAsText()));
            }
        }
        this.gra.destroyMatch(resRuleMatch);
        return moList;
    }

    public boolean doTransform(Node incNode, Rule resRule, boolean autoFillMissingParams, MatchOccurrence cMoc, HashMap<String, SimpleParameter> parms) throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.doTransform() Transformation can't be done.");
        }
        if (incNode == null) {
            throw new Exception("IncManagedGraGra.doTransform() Transformation can't be done.");
        }
        if (resRule == null) {
            throw new Exception("IncManagedGraGra.doTransform() Transformation can't be done.");
        }
        if (cMoc == null) {
            return false;
        }
        Match resRuleMatch = this.gra.createMatch(resRule);
        boolean aRuleisApplied = false;
        while (resRuleMatch.nextCompletion()) {
            boolean thisRuleCoversTheNode = false;
            Enumeration coDo = resRuleMatch.getCodomain();
            while (coDo.hasMoreElements()) {
                GraphObject gObj = (GraphObject)coDo.nextElement();
                if (!(gObj instanceof Node)) continue;
                Type objType = gObj.getType();
                String name = objType.getName();
                if (gObj != incNode) continue;
                thisRuleCoversTheNode = true;
                break;
            }
            if (!thisRuleCoversTheNode) continue;
            MatchOccurrence moc = new MatchOccurrence();
            Enumeration coDoCo = resRuleMatch.getCodomain();
            while (coDoCo.hasMoreElements()) {
                GraphObject gObj = (GraphObject)coDoCo.nextElement();
                if (!(gObj instanceof Node)) continue;
                Type objType = gObj.getType();
                String name = objType.getName();
                String artifactName = (String)((Node)gObj).getAttribute().getValueAt("name");
                if (name.equals("Conflict")) continue;
                moc.addMatchElement(name, String.valueOf(gObj.hashCode()), artifactName);
            }
            moc.sort();
            if (moc.equals(cMoc)) {
                AttrContext ac = resRuleMatch.getAttrContext();
                VarTuple matchVariables = (VarTuple)ac.getVariables();
                if (!matchVariables.areInputParametersSet()) {
                    for (int i = 0; i < matchVariables.getNumberOfEntries(); ++i) {
                        ValueMember val = matchVariables.getValueMemberAt(matchVariables.getNameAsString(i));
                        VarMember var = matchVariables.getVarMemberAt(matchVariables.getNameAsString(i));
                        AttrTypeMember decl = var.getDeclaration();
                        if (var.isInputParameter()) {
                            SimpleParameter par;
                            if (decl.getTypeName().equals("String")) {
                                par = parms.get(var.getName());
                                if (par != null && par.getValue() != null && par.getValue().length() > 0) {
                                    val.setExprAsText(par.getValue());
                                } else if (autoFillMissingParams) {
                                    val.setExprAsText("\"var_" + var.getName() + "\"");
                                }
                            }
                            if (decl.getTypeName().equals("boolean")) {
                                par = parms.get(var.getName());
                                if (par != null && par.getValue() != null && par.getValue().length() > 0) {
                                    val.setExprAsEvaluatedText(par.getValue());
                                } else if (autoFillMissingParams) {
                                    val.setExprAsEvaluatedText("false");
                                }
                            }
                            if (decl.getTypeName().equals("int")) {
                                par = parms.get(var.getName());
                                if (par != null && par.getValue() != null && par.getValue().length() > 0) {
                                    val.setExprAsEvaluatedText(par.getValue());
                                } else if (autoFillMissingParams) {
                                    val.setExprAsEvaluatedText("0");
                                }
                            }
                        }
                        val.checkValidity();
                    }
                }
                Step step = new Step();
                try {
                    step.execute(resRuleMatch);
                    aRuleisApplied = true;
                }
                catch (TypeException ex) {
                    this.gra.destroyMatch(resRuleMatch);
                    ex.printStackTrace();
                    throw new Exception("IncManagedGraGra.doTransform() Transformation failed " + ex.getMessage() + " " + resRuleMatch.getRule().getName());
                }
            }
            if (!aRuleisApplied) continue;
            break;
        }
        this.gra.destroyMatch(resRuleMatch);
        if (aRuleisApplied) {
            this.getScoreHelper().changeScore(resRule.getName());
        }
        return aRuleisApplied;
    }

    public void doClean() throws Exception {
        Enumeration nodes = this.getHostGraph().getNodes();
        while (nodes.hasMoreElements()) {
            Node n = (Node)nodes.nextElement();
            if (!this.isInconsistencyNode(n)) continue;
            this.gra.getGraph().destroyNode(n);
        }
    }

    public boolean isInconsistencyNode(Node n) throws Exception {
        if (n == null) {
            throw new Exception("IncManagedGraGra.isInconsistencyNode() Answer can't be given.");
        }
        Type incNodeType = this.getInconsistentNodeType();
        return n.getType().getName().equals(incNodeType.getName());
    }

    public ArrayList<String> getInconsistencyTypedNames() throws Exception {
        if (this.gra == null) {
            throw new Exception("IncManagedGraGra.getInconsistencyTypedNames() List can't be built.");
        }
        ArrayList<String> names = new ArrayList<String>();
        Enumeration cTypedNodes = this.gra.getTypeGraph().getElementsOfType("Conflict");
        while (cTypedNodes.hasMoreElements()) {
            Node inconsistencyNode = (Node)cTypedNodes.nextElement();
            AttrInstance attr = inconsistencyNode.getAttribute();
            String incName = (String)attr.getValueAt("description");
            names.add(incName);
        }
        return names;
    }

    public ScoreHelper getScoreHelper() {
        return this.sh;
    }

    public String getRulePopularity(Rule r) {
        return null;
    }

    public class MatchOccurrence {
        public ArrayList<MatchItem> matchElements = new ArrayList();

        public void addMatchElement(String artifactKind, String hashString, String artifactName) {
            this.matchElements.add(new MatchItem(artifactKind, hashString, artifactName));
        }

        public boolean equals(Object o) {
            MatchOccurrence mo1 = this;
            MatchOccurrence mo2 = (MatchOccurrence)o;
            return mo1.getId().equals(mo2.getId());
        }

        private String getId() {
            StringBuffer buf = new StringBuffer();
            Iterator<MatchItem> i = this.matchElements.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                MatchItem o = i.next();
                buf.append(o.getId());
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(",");
            }
            return buf.toString();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            Iterator<MatchItem> i = this.matchElements.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                MatchItem o = i.next();
                buf.append(o.toString());
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            return buf.toString();
        }

        public void sort() {
            if (this.matchElements != null) {
                Collections.sort(this.matchElements);
            }
        }
    }

    public class MatchItem
    implements Comparable {
        private String id = null;
        private String artifactKind = null;
        private String hashString = null;
        private String artifactName = null;

        public MatchItem(String artifactKind, String hashString, String artifactName) {
            this.setId(artifactKind, hashString, artifactName);
        }

        public int compareTo(Object o) {
            String s0 = this.getId();
            String s1 = ((MatchItem)o).getId();
            return s0.compareTo(s1);
        }

        public String toString() {
            String tsAName = this.artifactName;
            if (tsAName == null || tsAName.length() == 0) {
                tsAName = "(unnamed)";
            }
            return this.artifactKind + " " + tsAName;
        }

        public String getId() {
            return this.id;
        }

        private void setId(String _artifactKind, String _hashString, String _artifactName) {
            String _id;
            this.artifactKind = _artifactKind;
            this.hashString = _hashString;
            this.artifactName = _artifactName;
            this.id = _id = this.artifactKind + "*" + this.hashString + "*" + this.artifactName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GraphState {
        initial,
        inconsistent,
        consistent;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RuleKind {
        unknown,
        ordinary,
        detection,
        resolution;

    }
}

