/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.dm;

import agg.attribute.AttrInstance;
import agg.xt_basis.Node;

public class InconsistencyItem
implements Comparable {
    IncPresentationMode iItemPresentationMode = IncPresentationMode.showDefault;
    private String inconsistentNodeName = null;
    private String inconsistencyNodeName = null;
    private String artifactName = null;
    private String inconsistentHash = null;
    private String inconsistentAttributeNames = null;

    public void choosePresentationMode(IncPresentationMode anItemPresentationMode) {
        this.iItemPresentationMode = anItemPresentationMode;
    }

    public InconsistencyItem(Node anInconsistentNode, Node anInconsistencyNode, IncPresentationMode anItemPresentationMode) {
        this.buildInconsistentNode(anInconsistentNode.getType().getName(), (String)anInconsistencyNode.getAttribute().getValueAt("description"), String.valueOf(anInconsistentNode.hashCode()), (String)anInconsistentNode.getAttribute().getValueAt("name"), this.buildInconsistentAttributeNames(anInconsistentNode));
        this.choosePresentationMode(anItemPresentationMode);
    }

    private void buildInconsistentNode(String anInconsistentNodeName, String anInconsistencyNodeName, String anInconsistentHash, String anArtifactName, String anInconsistentAttributeNames) {
        this.inconsistentNodeName = anInconsistentNodeName;
        this.inconsistencyNodeName = anInconsistencyNodeName;
        this.inconsistentHash = anInconsistentHash;
        this.artifactName = anArtifactName;
        this.inconsistentAttributeNames = anInconsistentAttributeNames;
    }

    public String getGoodlookingString() {
        return "\"" + this.getInconsistencyNodeName() + "\" on " + this.getInconsistentNodeName();
    }

    public String getInconsistentNodeName() {
        return this.inconsistentNodeName;
    }

    public String getInconsistencyNodeName() {
        return this.inconsistencyNodeName;
    }

    public String getIdentifierString() {
        return this.getInconsistentNodeName() + "*" + this.getInconsistentNodeHash() + "*" + this.getInconsistencyNodeName();
    }

    public String getInconsistentArtifactName() {
        return this.artifactName;
    }

    public String getInconsistentNodeHash() {
        return this.inconsistentHash;
    }

    public String getInconsistentNodeDesc() {
        String art = this.getInconsistentArtifactName();
        return this.getInconsistentNodeName() + (art.length() != 0 ? " name=\"" + art + "\"" : " (unnamed)");
    }

    public String buildInconsistentAttributeNames() {
        return this.inconsistentAttributeNames;
    }

    private String buildInconsistentAttributeNames(Node inconsistentNode) {
        AttrInstance ai = inconsistentNode.getAttribute();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ai.getNumberOfEntries(); ++i) {
            String name = ai.getNameAsString(i);
            String typeName = ai.getTypeAsString(i);
            String strVal = ai.getValueAsString(i);
            if (name.equals("name")) continue;
            sb.append(name);
            sb.append("=");
            sb.append(strVal);
            if (i >= ai.getNumberOfEntries() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String toString() {
        return this.iItemPresentationMode.getString(this.getInconsistencyNodeName(), this.getInconsistentNodeName(), this.getInconsistentArtifactName());
    }

    public boolean equals(Object obj) {
        InconsistencyItem itm = (InconsistencyItem)obj;
        return this.getIdentifierString().equals(itm.getIdentifierString());
    }

    public int compareTo(Object obj) {
        InconsistencyItem itm = (InconsistencyItem)obj;
        return this.strCompare(this.getIdentifierString(), itm.getIdentifierString());
    }

    private int strCompare(Object o1, Object o2) {
        if (o1 instanceof String && ((String)o1).length() == 0) {
            o1 = null;
        }
        if (o2 instanceof String && ((String)o2).length() == 0) {
            o2 = null;
        }
        boolean ascending = true;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 instanceof Comparable) {
            if (ascending) {
                return ((Comparable)o1).compareTo(o2);
            }
            return ((Comparable)o2).compareTo(o1);
        }
        if (ascending) {
            return o1.toString().compareTo(o2.toString());
        }
        return o2.toString().compareTo(o1.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncPresentationMode {
        showDefault{

            String getString(String incName, String incNodeName, String incArtName) {
                return "Node : " + incNodeName + "[" + incArtName + "] Defect : " + incName;
            }
        }
        ,
        showInconsistency{

            String getString(String incName, String incNodeName, String incArtName) {
                return incName;
            }
        }
        ,
        showInconsistentNode{

            String getString(String incName, String incNodeName, String incArtName) {
                return incNodeName + "[" + incArtName + "]";
            }
        }
        ,
        showIncPair{

            String getString(String incName, String incNodeName, String incArtName) {
                return "<" + incNodeName + ", " + incName + ">";
            }
        }
        ,
        showIncDetail{

            String getString(String incName, String incNodeName, String incArtName) {
                return "" + incName + " for " + incNodeName + " " + (incArtName.length() != 0 ? "\"" + incArtName + "\"" : "(unnamed)");
            }
        };


        abstract String getString(String var1, String var2, String var3);
    }
}

