/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.dm;

import agg.attribute.AttrInstance;
import agg.xt_basis.Node;

public class InconsistencyPair {
    ItemPresentationMode iItemPresentationMode = ItemPresentationMode.showDefault;
    private Node inconsistentNode = null;
    private Node inconsistencyNode = null;

    public void choosePresentationMode(ItemPresentationMode anItemPresentationMode) {
        this.iItemPresentationMode = anItemPresentationMode;
    }

    public InconsistencyPair(Node anInconsistentNode, Node anInconsistencyNode) {
        this.buildInconsistentNode(anInconsistentNode, anInconsistencyNode);
    }

    public InconsistencyPair(Node anInconsistentNode, Node anInconsistencyNode, ItemPresentationMode anItemPresentationMode) {
        this.buildInconsistentNode(anInconsistentNode, anInconsistencyNode);
        this.choosePresentationMode(anItemPresentationMode);
    }

    public String toString() {
        return this.iItemPresentationMode.getString(this.getInconsistencyNodeName(), this.getInconsistentNodeName(), this.getInconsistentArtifactName());
    }

    public String getIdentifierString() {
        return this.getInconsistentNodeName() + "*" + String.valueOf(this.getInconsistentNodeHash()) + "*" + this.getInconsistencyNodeName();
    }

    public String getGoodlookingString() {
        return "\"" + this.getInconsistencyNodeName() + "\" on " + this.getInconsistentNodeName();
    }

    private void buildInconsistentNode(Node anInconsistentNode, Node anInconsistencyNode) {
        this.inconsistentNode = anInconsistentNode;
        this.inconsistencyNode = anInconsistencyNode;
    }

    public Node getInconsistentNode() {
        return this.inconsistentNode;
    }

    public Node getInconsistencyNode() {
        return this.inconsistencyNode;
    }

    public String getInconsistentNodeName() {
        return this.getInconsistentNode().getType().getName();
    }

    public String getInconsistentArtifactName() {
        String artifactName = (String)this.getInconsistentNode().getAttribute().getValueAt("name");
        if (artifactName != null) {
            return artifactName;
        }
        return "";
    }

    public String getInconsistentNodeDesc() {
        String art = this.getInconsistentArtifactName();
        return this.getInconsistentNodeName() + (art.length() != 0 ? " name=\"" + art + "\"" : " (unnamed)");
    }

    public String getInconsistencyNodeName() {
        return (String)this.getInconsistencyNode().getAttribute().getValueAt("description");
    }

    public int getInconsistentNodeHash() {
        return this.getInconsistentNode().hashCode();
    }

    public String getInconsistentNodeAttributes() {
        AttrInstance ai = this.getInconsistentNode().getAttribute();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ai.getNumberOfEntries(); ++i) {
            String name = ai.getNameAsString(i);
            String typeName = ai.getTypeAsString(i);
            String strVal = ai.getValueAsString(i);
            if (name.equals("name")) continue;
            sb.append(name);
            sb.append("=");
            sb.append(strVal);
            if (i >= ai.getNumberOfEntries() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ItemPresentationMode {
        showDefault{

            String getString(String incName, String incNodeName, String incArtName) {
                return "Node : " + incNodeName + "[" + incArtName + "] Defect : " + incName;
            }
        }
        ,
        showInconsistency{

            String getString(String incName, String incNodeName, String incArtName) {
                return incName;
            }
        }
        ,
        showInconsistentNode{

            String getString(String incName, String incNodeName, String incArtName) {
                return incNodeName + "[" + incArtName + "]";
            }
        }
        ,
        showIncPair{

            String getString(String incName, String incNodeName, String incArtName) {
                return "<" + incNodeName + ", " + incName + ">";
            }
        };


        abstract String getString(String var1, String var2, String var3);
    }
}

