/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.dm;

import agg.plugins.dm.AbstractTransformStage;
import agg.plugins.dm.DetectionTransformStage;
import agg.plugins.dm.IncManagedGraGra;
import agg.plugins.dm.InconsistencyItem;
import agg.plugins.dm.ResolutionTransformStage;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TransformHistory {
    JTree tHist = null;
    JCheckBox jCB = null;
    ArrayList<AbstractTransformStage> history = new ArrayList();
    private IncManagedGraGra imgraHolder = null;

    public TransformHistory(IncManagedGraGra theIMgraHolder) {
        this.imgraHolder = theIMgraHolder;
    }

    public void attachAJTable(JTree hist, JCheckBox cb) {
        this.tHist = hist;
        this.jCB = cb;
        TreeCellRenderer cr = this.tHist.getCellRenderer();
        CustomDefaultRenderer dtcr = new CustomDefaultRenderer();
        this.tHist.setCellRenderer(dtcr);
        float[] redHsb = Color.RGBtoHSB(200, 0, 0, null);
        float[] greenHsb = Color.RGBtoHSB(0, 200, 0, null);
        float[] bgHsb = Color.RGBtoHSB(200, 200, 200, null);
        dtcr.setAddedLeafForeground(Color.getHSBColor(greenHsb[0], greenHsb[1], greenHsb[2]));
        dtcr.setRemovedLeafForeground(Color.getHSBColor(redHsb[0], redHsb[1], redHsb[2]));
        dtcr.setBackgroundSelectionColor(Color.getHSBColor(bgHsb[0], bgHsb[1], bgHsb[2]));
    }

    public void detachJTable() {
        this.tHist = null;
    }

    public DetectionTransformStage newDetStage() {
        DetectionTransformStage detStage = new DetectionTransformStage(this);
        this.history.add(detStage);
        return detStage;
    }

    public ResolutionTransformStage newResStage() {
        ResolutionTransformStage resStage = new ResolutionTransformStage(this);
        this.history.add(resStage);
        return resStage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("hist size = " + String.valueOf(this.history.size()) + "\n");
        for (int i = 0; i < this.history.size(); ++i) {
            sb.append(this.history.get(i).toString() + "\n");
        }
        return sb.toString();
    }

    public void toDisc() {
    }

    public void toJTree() {
        DefaultTreeModel model = (DefaultTreeModel)this.tHist.getModel();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Operation History");
        boolean detailedView = this.jCB == null ? false : this.jCB.isSelected();
        DefaultMutableTreeNode lastNode = null;
        if (this.tHist != null) {
            ArrayList<AbstractTransformStage> detStages = new ArrayList<AbstractTransformStage>();
            for (int i = 0; i < this.history.size(); ++i) {
                if (!(this.history.get(i) instanceof DetectionTransformStage)) continue;
                detStages.add(this.history.get(i));
            }
            for (int loop = 0; loop < detStages.size(); ++loop) {
                DetectionTransformStage lastStage = (DetectionTransformStage)detStages.get(loop);
                DetectionTransformStage prevStage = null;
                if (loop > 0) {
                    prevStage = (DetectionTransformStage)detStages.get(loop - 1);
                }
                if (loop == 0) {
                    TreeSet<InconsistencyItem> incSet = lastStage.getIncSet();
                    if (incSet.size() > 0) {
                        String idDesc = "Initialization (" + String.valueOf(incSet.size()) + " detected defects) :";
                        DefaultMutableTreeNode idNode = new DefaultMutableTreeNode(idDesc);
                        for (InconsistencyItem n : incSet) {
                            idNode.add(new DefaultMutableTreeNode(n));
                        }
                        root.add(idNode);
                        lastNode = idNode;
                        continue;
                    }
                    lastNode = new DefaultMutableTreeNode("Initial detection hasn't found any defect.");
                    root.add(lastNode);
                    continue;
                }
                ArrayList<InconsistencyItem> newlyAdded = lastStage.getDifference(prevStage);
                ArrayList<InconsistencyItem> allSolved = prevStage.getDifference(lastStage);
                ArrayList<InconsistencyItem> allUnchanged = prevStage.getIntersect(lastStage);
                TreeSet<InconsistencyItem> incSet = lastStage.getIncSet();
                String resultDesc = "Result " + String.valueOf(loop) + " : ";
                resultDesc = resultDesc + String.valueOf(allSolved.size()) + " removed / ";
                resultDesc = resultDesc + String.valueOf(newlyAdded.size()) + " added --> ";
                resultDesc = resultDesc + String.valueOf(incSet.size()) + " left defects.";
                DefaultMutableTreeNode detNode = new DefaultMutableTreeNode(resultDesc);
                for (InconsistencyItem n : allSolved) {
                    detNode.add(new DefaultMutableTreeNode("Removed : " + n));
                }
                for (InconsistencyItem n : newlyAdded) {
                    detNode.add(new DefaultMutableTreeNode("Added : " + n));
                }
                if (detailedView) {
                    for (InconsistencyItem n : allUnchanged) {
                        detNode.add(new DefaultMutableTreeNode("Unchanged : " + n));
                    }
                }
                root.add(detNode);
                lastNode = detNode;
            }
        }
        model.setRoot(root);
        this.tHist.expandPath(this.getPath(lastNode));
    }

    private TreePath getPath(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    public IncManagedGraGra getImgraHolder() {
        return this.imgraHolder;
    }

    protected static class CustomDefaultRenderer
    extends DefaultTreeCellRenderer {
        private Color addedLeafForeground;
        private Color removedLeafForeground;

        protected CustomDefaultRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (leaf) {
                DefaultMutableTreeNode lf;
                if (this.addedLeafForeground != null && value instanceof DefaultMutableTreeNode && (lf = (DefaultMutableTreeNode)value).toString().startsWith("Added")) {
                    c.setForeground(this.addedLeafForeground);
                }
                if (this.removedLeafForeground != null && value instanceof DefaultMutableTreeNode) {
                    lf = (DefaultMutableTreeNode)value;
                    if (value.toString().startsWith("Removed")) {
                        c.setForeground(this.removedLeafForeground);
                    }
                }
            }
            return c;
        }

        public void setAddedLeafForeground(Color color) {
            this.addedLeafForeground = color;
        }

        public void setRemovedLeafForeground(Color color) {
            this.removedLeafForeground = color;
        }
    }
}

