/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.dm.forms;

import agg.plugins.dm.IncManagedGraGra;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationSelection
extends JDialog {
    private ArrayList<IncManagedGraGra.MatchOccurrence> matchList = null;
    private IncManagedGraGra.MatchOccurrence chosenMatch = null;
    private JDialog parentFrame = null;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTextPane jTextPane2;

    public ApplicationSelection(JDialog parent, ArrayList<IncManagedGraGra.MatchOccurrence> mList) {
        super((Dialog)parent, true);
        this.parentFrame = parent;
        this.matchList = mList;
        this.initComponents();
        this.fillList();
    }

    public boolean queryMatch() {
        if (this.matchList != null) {
            if (this.matchList.size() > 1) {
                this.centerParent();
                this.setVisible(true);
            } else {
                this.setChosenMatch(this.matchList.get(0));
            }
            return true;
        }
        return false;
    }

    private void fillList() {
        try {
            DefaultTableModel resModel = (DefaultTableModel)this.jTable1.getModel();
            resModel.setRowCount(0);
            for (IncManagedGraGra.MatchOccurrence mo : this.matchList) {
                resModel.addRow(new Object[]{mo});
            }
            if (resModel.getRowCount() > 0) {
                this.jTable1.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doSelectAndClose() {
        DefaultTableModel resModel = (DefaultTableModel)this.jTable1.getModel();
        int sel = this.jTable1.getSelectedRow();
        this.setChosenMatch((IncManagedGraGra.MatchOccurrence)resModel.getValueAt(sel, 0));
        this.setVisible(false);
    }

    public IncManagedGraGra.MatchOccurrence getChosenMatch() {
        return this.chosenMatch;
    }

    private void setChosenMatch(IncManagedGraGra.MatchOccurrence chosenMatch) {
        this.chosenMatch = chosenMatch;
    }

    private void centerParent() {
        JDialog parent = this.getParentFrame();
        Dimension dim = parent.getSize();
        Point loc = parent.getLocationOnScreen();
        Dimension size = this.getSize();
        loc.x += (dim.width - size.width) / 2;
        loc.y += (dim.height - size.height) / 2;
        if (loc.x < 0) {
            loc.x = 0;
        }
        if (loc.y < 0) {
            loc.y = 0;
        }
        Dimension screen = this.getToolkit().getScreenSize();
        if (size.width > screen.width) {
            size.width = screen.width;
        }
        if (size.height > screen.height) {
            size.height = screen.height;
        }
        if (loc.x + size.width > screen.width) {
            loc.x = screen.width - size.width;
        }
        if (loc.y + size.height > screen.height) {
            loc.y = screen.height - size.height;
        }
        this.setBounds(loc.x, loc.y, size.width, size.height);
    }

    private JDialog getParentFrame() {
        return this.parentFrame;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane2 = new JTextPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1 = new JButton();
        this.setTitle("Application selection");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ApplicationSelection.this.formWindowClosing(evt);
            }
        });
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setOpaque(false);
        this.jTextPane2.setBorder(null);
        this.jTextPane2.setEditable(false);
        this.jTextPane2.setText("Several matches are available for applying the transformation. Please, make the appropriate choice in the list below :");
        this.jTextPane2.setFocusable(false);
        this.jTextPane2.setOpaque(false);
        this.jScrollPane2.setViewportView(this.jTextPane2);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Artifacts"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class};
                this.canEdit = new boolean[]{false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButton1.setText("Choose");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApplicationSelection.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 417, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, 417, Short.MAX_VALUE).add(2, (Component)this.jButton1)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 219, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.doSelectAndClose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doSelectAndClose();
    }
}

