/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.dm.forms;

import agg.plugins.dm.SimpleParameter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResParameters
extends JDialog {
    HashMap<String, SimpleParameter> parms;
    private JDialog parentFrame = null;
    private MyTableModelListener tableChangeListenerParm = null;
    private boolean fillResult = false;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public ResParameters(JDialog parent, HashMap<String, SimpleParameter> _parms) {
        super((Dialog)parent, true);
        this.parentFrame = parent;
        this.fillResult = false;
        this.initComponents();
        this.parms = _parms;
        this.centerParent();
        this.fillList();
        this.jTable1.setSelectionMode(0);
        this.jTable1.setColumnSelectionAllowed(false);
        this.jTable1.setRowSelectionAllowed(true);
        this.tableChangeListenerParm = new MyTableModelListener(this.jTable1);
        this.jTable1.getModel().addTableModelListener(this.tableChangeListenerParm);
    }

    private void fillList() {
        try {
            DefaultTableModel resModel = (DefaultTableModel)this.jTable1.getModel();
            resModel.setRowCount(0);
            for (String key : this.parms.keySet()) {
                SimpleParameter mo = this.parms.get(key);
                resModel.addRow(new Object[]{key, mo.getType(), mo.getValue()});
            }
            if (resModel.getRowCount() > 0) {
                this.jTable1.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void centerParent() {
        JDialog parent = this.getParentFrame();
        Dimension dim = parent.getSize();
        Point loc = parent.getLocationOnScreen();
        Dimension size = this.getSize();
        loc.x += (dim.width - size.width) / 2;
        loc.y += (dim.height - size.height) / 2;
        if (loc.x < 0) {
            loc.x = 0;
        }
        if (loc.y < 0) {
            loc.y = 0;
        }
        Dimension screen = this.getToolkit().getScreenSize();
        if (size.width > screen.width) {
            size.width = screen.width;
        }
        if (size.height > screen.height) {
            size.height = screen.height;
        }
        if (loc.x + size.width > screen.width) {
            loc.x = screen.width - size.width;
        }
        if (loc.y + size.height > screen.height) {
            loc.y = screen.height - size.height;
        }
        this.setBounds(loc.x, loc.y, size.width, size.height);
    }

    private JDialog getParentFrame() {
        return this.parentFrame;
    }

    private void doCancel() {
        this.fillResult = false;
        this.setVisible(false);
    }

    private void doValidateAndClose() {
        DefaultTableModel resModel = (DefaultTableModel)this.jTable1.getModel();
        this.fillResult = true;
        for (int i = 0; i < resModel.getRowCount(); ++i) {
            resModel.fireTableCellUpdated(i, 2);
            String newVal = (String)resModel.getValueAt(i, 2);
            if (newVal != null && newVal.length() != 0) continue;
            this.fillResult = false;
        }
        if (!this.fillResult) {
            JOptionPane.showMessageDialog(this, "The transformation can't be done. All the parameters hasn't been defined.");
        }
        this.setVisible(false);
    }

    public boolean isFillResult() {
        return this.fillResult;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1 = new JButton();
        this.setTitle("Transformation Parameters");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ResParameters.this.formWindowClosing(evt);
            }
        });
        this.jLabel1.setText("Please, introduce the required parameters below :");
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Parameter name", "Parameter type", "Parameter value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButton1.setText("Apply resolution rule with given parameters");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResParameters.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add(2, (Component)this.jButton1).add(2, (Component)this.jScrollPane1, -1, 396, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 173, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.doValidateAndClose();
    }

    private void formWindowClosing(WindowEvent evt) {
        JOptionPane.showMessageDialog(this, "You decided to Cancel the application of the Resolution Rule.");
        this.doCancel();
    }

    public class MyTableModelListener
    implements TableModelListener {
        JTable table;

        MyTableModelListener(JTable table) {
            this.table = table;
        }

        public void tableChanged(TableModelEvent e) {
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            int mColIndex = e.getColumn();
            if (e.getType() != 0) {
                return;
            }
            if (firstRow != -1) {
                if (firstRow != lastRow) {
                    return;
                }
                DefaultTableModel model = (DefaultTableModel)this.table.getModel();
                if (mColIndex == -1) {
                    return;
                }
                if (mColIndex == 2) {
                    try {
                        SimpleParameter builtVal;
                        String name = (String)model.getValueAt(firstRow, 0);
                        String type = (String)model.getValueAt(firstRow, 1);
                        String newVal = (String)model.getValueAt(firstRow, mColIndex);
                        if (type.equals("String")) {
                            if (!newVal.startsWith("\"")) {
                                newVal = "\"" + newVal;
                            }
                            if (!newVal.endsWith("\"")) {
                                newVal = newVal + "\"";
                            }
                            if (newVal.equals("\"")) {
                                newVal = newVal + "\"";
                            }
                            builtVal = new SimpleParameter(type, newVal);
                            ResParameters.this.parms.put(name, builtVal);
                            ResParameters.this.jTable1.getModel().removeTableModelListener(ResParameters.this.tableChangeListenerParm);
                            model.setValueAt(builtVal.getValue(), firstRow, mColIndex);
                            ResParameters.this.jTable1.getModel().addTableModelListener(ResParameters.this.tableChangeListenerParm);
                        }
                        if (type.equals("boolean")) {
                            boolean bVal = Boolean.parseBoolean(newVal);
                            builtVal = new SimpleParameter(type, String.valueOf(bVal));
                            ResParameters.this.parms.put(name, builtVal);
                            ResParameters.this.jTable1.getModel().removeTableModelListener(ResParameters.this.tableChangeListenerParm);
                            model.setValueAt(builtVal.getValue(), firstRow, mColIndex);
                            ResParameters.this.jTable1.getModel().addTableModelListener(ResParameters.this.tableChangeListenerParm);
                        }
                        if (type.equals("int")) {
                            int iVal = Integer.parseInt(newVal);
                            builtVal = new SimpleParameter(type, String.valueOf(iVal));
                            ResParameters.this.parms.put(name, builtVal);
                            ResParameters.this.jTable1.getModel().removeTableModelListener(ResParameters.this.tableChangeListenerParm);
                            model.setValueAt(builtVal.getValue(), firstRow, mColIndex);
                            ResParameters.this.jTable1.getModel().addTableModelListener(ResParameters.this.tableChangeListenerParm);
                        }
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(null, "Incorrect specified value. Reason : " + exc.getMessage() + "\nPlease, be carefull to always validate any introduced value with [Enter] key.");
                    }
                }
            }
        }
    }
}

