/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.dm.forms;

import agg.gui.GraGraTreeView;
import agg.plugins.dm.IncManagedGraGra;
import agg.plugins.dm.Inconsistency;
import agg.plugins.dm.InconsistencyPair;
import agg.xt_basis.Node;
import agg.xt_basis.Rule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;

public class RuleProperties
extends JDialog {
    private IncManagedGraGra ggxAna = null;
    private MyTableModelListener tableChangeListenerRes = null;
    private MyTableModelListener tableChangeListenerDet = null;
    private JDialog parentFrame = null;
    private ChangeStatus changeStatusDet;
    private ChangeStatus changeStatusRes;
    private boolean mustApplyARedetection;
    private boolean mustRefreshResolutionSet;
    private GraGraTreeView treeView;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabGGXFile1;
    private JLabel jLabGGXFile10;
    private JLabel jLabGGXFile2;
    private JLabel jLabGGXFile5;
    private JLabel jLabGGXFile9;
    private JList jListIncos;
    private JList jListTypesInco;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane6;
    private JTable jTableRes;
    private JTable jTableRules;
    private JTextField jTextGGXIMCaps;

    public RuleProperties(JDialog parent, IncManagedGraGra _ggxAna, GraGraTreeView treeView) {
        super((Dialog)parent, true);
        this.ggxAna = _ggxAna;
        this.parentFrame = parent;
        this.treeView = treeView;
        this.initComponents();
        this.jLabGGXFile5.setVisible(false);
        this.jTextGGXIMCaps.setVisible(false);
        this.jLabGGXFile2.setVisible(false);
        this.jScrollPane6.setVisible(false);
        this.customInit();
        this.centerParent();
        this.loadAndDisplay();
    }

    private void centerParent() {
        JDialog parent = this.getParentFrame();
        Dimension dim = parent.getSize();
        Point loc = parent.getLocationOnScreen();
        Dimension size = this.getSize();
        loc.x += (dim.width - size.width) / 2;
        loc.y += (dim.height - size.height) / 2;
        if (loc.x < 0) {
            loc.x = 0;
        }
        if (loc.y < 0) {
            loc.y = 0;
        }
        Dimension screen = this.getToolkit().getScreenSize();
        if (size.width > screen.width) {
            size.width = screen.width;
        }
        if (size.height > screen.height) {
            size.height = screen.height;
        }
        if (loc.x + size.width > screen.width) {
            loc.x = screen.width - size.width;
        }
        if (loc.y + size.height > screen.height) {
            loc.y = screen.height - size.height;
        }
        this.setBounds(loc.x, loc.y, size.width, size.height);
    }

    private void customInit() {
        this.jTableRules.setColumnSelectionAllowed(false);
        this.jTableRules.setRowSelectionAllowed(true);
        this.jTableRules.setSelectionMode(0);
        this.jTableRules.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.jTableRules.getColumnModel().getColumn(1).setMinWidth(70);
        this.jTableRules.getColumnModel().getColumn(1).setMaxWidth(70);
        this.jTableRules.getTableHeader().resizeAndRepaint();
        this.changeStatusDet = new ChangeStatus();
        this.tableChangeListenerDet = new MyTableModelListener(this.jTableRules, this.changeStatusDet);
        this.jTableRules.getModel().addTableModelListener(this.tableChangeListenerDet);
        this.jTableRes.setColumnSelectionAllowed(false);
        this.jTableRes.setRowSelectionAllowed(true);
        this.jTableRes.setSelectionMode(0);
        this.jTableRes.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.jTableRes.getColumnModel().getColumn(1).setMinWidth(70);
        this.jTableRes.getColumnModel().getColumn(1).setMaxWidth(70);
        this.jTableRes.getTableHeader().resizeAndRepaint();
        this.changeStatusRes = new ChangeStatus();
        this.tableChangeListenerRes = new MyTableModelListener(this.jTableRes, this.changeStatusRes);
        this.jTableRes.getModel().addTableModelListener(this.tableChangeListenerRes);
    }

    private void loadAndDisplay() {
        try {
            DefaultListModel<String> incosModel = new DefaultListModel<String>();
            this.jListTypesInco.setModel(incosModel);
            ArrayList<Node> eligNodTypes = this.ggxAna.getEligibleTypeNodes();
            for (Node n : eligNodTypes) {
                String info = n.getType().getName();
                if (info == null) continue;
                incosModel.add(incosModel.getSize(), info);
            }
            DefaultTableModel modelRules = (DefaultTableModel)this.jTableRules.getModel();
            modelRules.setRowCount(0);
            DefaultTableModel modelRes = (DefaultTableModel)this.jTableRes.getModel();
            modelRes.setRowCount(0);
            Enumeration rules = this.ggxAna.getRulesEnum();
            while (rules.hasMoreElements()) {
                Rule r = (Rule)rules.nextElement();
                Inconsistency inc = this.ggxAna.getConcernedInconsistency(r);
                if (inc == null) continue;
                String inconsistencyName = inc.getInconsistencyName();
                String treatedNodeName = inc.getInconsistencyConcernedNodeName();
                String info = "";
                info = info + "treats \"" + inconsistencyName;
                info = info + "\" on " + treatedNodeName;
                String popularity = "";
                popularity = this.ggxAna.getRulePopularity(r);
                IncManagedGraGra.RuleKind thisKind = this.ggxAna.getRuleKind(r);
                if (thisKind == IncManagedGraGra.RuleKind.detection) {
                    modelRules.addRow(new Object[]{new ListRuleItem(r, info, popularity), r.isEnabled()});
                }
                if (thisKind != IncManagedGraGra.RuleKind.resolution) continue;
                modelRes.addRow(new Object[]{new ListRuleItem(r, info, popularity), r.isEnabled()});
            }
            ArrayList<InconsistencyPair> inconsistentGraphNodes = this.ggxAna.getMarkedGraphNodes();
            DefaultListModel<String> inco1Model = new DefaultListModel<String>();
            this.jListIncos.setModel(inco1Model);
            for (InconsistencyPair n : inconsistentGraphNodes) {
                Node baseNode = n.getInconsistentNode();
                Node inconsistencyNode = n.getInconsistencyNode();
                String incNodeName = baseNode.getType().getName();
                String incName = (String)inconsistencyNode.getAttribute().getValueAt("description");
                inco1Model.add(inco1Model.getSize(), "\"" + incName + "\" supported for " + incNodeName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isMustApplyARedetection() {
        return this.mustApplyARedetection;
    }

    private void setMustApplyARedetection(boolean mustApplyARedetection) {
        this.mustApplyARedetection = mustApplyARedetection;
    }

    public boolean isMustRefreshResolutionSet() {
        return this.mustRefreshResolutionSet;
    }

    private void setMustRefreshResolutionSet(boolean mustRefreshResolutionSet) {
        this.mustRefreshResolutionSet = mustRefreshResolutionSet;
    }

    private void doClose() throws HeadlessException {
        if (this.changeStatusRes.hasChanged()) {
            this.setMustRefreshResolutionSet(true);
        }
        if (this.changeStatusDet.hasChanged()) {
            this.setMustApplyARedetection(true);
        }
        this.setVisible(false);
    }

    private void multipleEnabler(JTable table, boolean enableState) {
        DefaultTableModel modelRules = (DefaultTableModel)table.getModel();
        for (int i = 0; i < modelRules.getRowCount(); ++i) {
            ListRuleItem lri = (ListRuleItem)modelRules.getValueAt(i, 0);
            lri.setEnabled(enableState);
            modelRules.setValueAt(enableState, i, 1);
        }
        modelRules.fireTableDataChanged();
    }

    private void initComponents() {
        this.jLabGGXFile5 = new JLabel();
        this.jTextGGXIMCaps = new JTextField();
        this.jLabGGXFile1 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jListTypesInco = new JList();
        this.jLabGGXFile9 = new JLabel();
        this.jLabGGXFile2 = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.jListIncos = new JList();
        this.jLabGGXFile10 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableRules = new JTable(){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    try {
                        ListRuleItem lri = (ListRuleItem)this.getValueAt(rowIndex, vColIndex);
                        Rule r = lri.getRule();
                        String rigthName = RuleProperties.this.ggxAna.getRuleRightGraphName(r);
                        String leftName = RuleProperties.this.ggxAna.getRuleLeftGraphName(r);
                        String tooltip = "applies " + leftName + " on " + rigthName;
                        jc.setToolTipText(tooltip);
                        if (!this.isCellSelected(rowIndex, vColIndex)) {
                            if (rowIndex % 2 == 0) {
                                c.setBackground(Color.getHSBColor(60.0f, 6.0f, 100.0f));
                                c.setForeground(Color.black);
                            } else {
                                c.setBackground(this.getBackground());
                            }
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                return c;
            }
        };
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableRes = new JTable(){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    try {
                        ListRuleItem lri = (ListRuleItem)this.getValueAt(rowIndex, vColIndex);
                        Rule r = lri.getRule();
                        String rigthName = RuleProperties.this.ggxAna.getRuleRightGraphName(r);
                        String leftName = RuleProperties.this.ggxAna.getRuleLeftGraphName(r);
                        String tooltip = "applies " + leftName + " on " + rigthName;
                        jc.setToolTipText(tooltip);
                        if (!this.isCellSelected(rowIndex, vColIndex)) {
                            if (rowIndex % 2 == 0) {
                                c.setBackground(Color.getHSBColor(60.0f, 6.0f, 100.0f));
                                c.setForeground(Color.black);
                            } else {
                                c.setBackground(this.getBackground());
                            }
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                return c;
            }
        };
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.setTitle("Properties");
        this.setCursor(new Cursor(0));
        this.setLocationByPlatform(true);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RuleProperties.this.formWindowClosing(evt);
            }
        });
        this.jLabGGXFile5.setText("Status");
        this.jTextGGXIMCaps.setEditable(false);
        this.jTextGGXIMCaps.setAutoscrolls(false);
        this.jTextGGXIMCaps.setFocusable(false);
        this.jLabGGXFile1.setText("Artefacts that can be identified as defect");
        this.jListTypesInco.setSelectionMode(0);
        this.jListTypesInco.setPreferredSize(null);
        this.jScrollPane3.setViewportView(this.jListTypesInco);
        this.jLabGGXFile9.setText("Detection Rules defined in the Grammar");
        this.jLabGGXFile2.setText("Defects that are supported by the Grammar");
        this.jListIncos.setSelectionMode(0);
        this.jListIncos.setPreferredSize(null);
        this.jScrollPane6.setViewportView(this.jListIncos);
        this.jLabGGXFile10.setText("Resolution Rules defined in the Grammar");
        this.jTableRules.setModel(new DefaultTableModel(new Object[0][], new String[]{"Rule", "Enabled"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Boolean.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTableRules);
        this.jButton1.setText("Disable All");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RuleProperties.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Enable All");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RuleProperties.this.jButton2ActionPerformed(evt);
            }
        });
        this.jTableRes.setModel(new DefaultTableModel(new Object[0][], new String[]{"Rule", "Enabled"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Boolean.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.jTableRes);
        this.jButton3.setText("Enable All");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RuleProperties.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText("Disable All");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RuleProperties.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane3, -1, 426, Short.MAX_VALUE).add(1, (Component)this.jScrollPane6, -1, 426, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabGGXFile5, -2, 48, -2).addPreferredGap(0).add((Component)this.jTextGGXIMCaps, -1, 374, Short.MAX_VALUE)).add(1, (Component)this.jLabGGXFile1, -1, 426, Short.MAX_VALUE).add(1, (Component)this.jLabGGXFile10, -2, 344, -2).add(1, (Component)this.jLabGGXFile9, -2, 344, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 320, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButton4, -2, 100, -2).add((Component)this.jButton3, -2, 100, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabGGXFile2, -1, 341, Short.MAX_VALUE).add(85, 85, 85)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 321, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButton1, -2, 99, -2).add((Component)this.jButton2, -2, 99, -2)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabGGXFile5).add((Component)this.jTextGGXIMCaps, -2, -1, -2)).add(22, 22, 22).add((Component)this.jLabGGXFile1).addPreferredGap(0).add((Component)this.jScrollPane3, -2, 84, -2).add(19, 19, 19).add((Component)this.jLabGGXFile9).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 92, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButton2).addPreferredGap(0).add((Component)this.jButton1))).addPreferredGap(0).add((Component)this.jLabGGXFile2, -2, 22, -2).add(6, 6, 6).add((Component)this.jScrollPane6, -1, 70, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabGGXFile10).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButton3).addPreferredGap(0).add((Component)this.jButton4)).add((Component)this.jScrollPane2, -1, 92, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doClose();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.multipleEnabler(this.jTableRes, false);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.multipleEnabler(this.jTableRes, true);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.multipleEnabler(this.jTableRules, false);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.multipleEnabler(this.jTableRules, true);
    }

    private JDialog getParentFrame() {
        return this.parentFrame;
    }

    public class MyTableModelListener
    implements TableModelListener {
        JTable table;
        ChangeStatus changeStatus;

        MyTableModelListener(JTable table, ChangeStatus changeStatus) {
            this.table = table;
            this.changeStatus = changeStatus;
        }

        public void tableChanged(TableModelEvent e) {
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            int mColIndex = e.getColumn();
            if (e.getType() != 0) {
                return;
            }
            if (firstRow != -1) {
                if (firstRow != lastRow) {
                    return;
                }
                DefaultTableModel model = (DefaultTableModel)this.table.getModel();
                if (mColIndex == -1) {
                    return;
                }
                if (mColIndex == 1) {
                    try {
                        Boolean val = (Boolean)model.getValueAt(firstRow, mColIndex);
                        ListRuleItem lri = (ListRuleItem)model.getValueAt(firstRow, 0);
                        lri.setEnabled(val);
                        this.changeStatus.setChanged();
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(null, "Valeur sp\u00e9cifi\u00e9e incorrecte. Raison :" + exc.getMessage());
                    }
                }
            }
        }
    }

    public class ChangeStatus {
        private boolean changed = false;

        ChangeStatus() {
        }

        public void setChanged() {
            this.changed = true;
        }

        public boolean hasChanged() {
            return this.changed;
        }
    }

    public class ListRuleItem {
        private Rule r;
        private String text;
        private String addInfo;

        ListRuleItem(Rule _r, String _text, String _addInfo) {
            this.r = _r;
            this.text = _text;
            this.addInfo = _addInfo;
        }

        public String toString() {
            return this.r.getName() + " (" + this.text + ")" + (this.addInfo != null ? " " + this.addInfo : "");
        }

        public void setEnabled(boolean enabled) {
            this.r.setEnabled(enabled);
            RuleProperties.this.treeView.getTreeModel().ruleNameChanged(RuleProperties.this.treeView.getCurrentGraGra(), RuleProperties.this.treeView.getCurrentGraGra().getBasisGraGra().isLayered());
        }

        public Rule getRule() {
            return this.r;
        }
    }
}

