/*
 * Decompiled with CFR 0.152.
 */
package agg.plugins.dm.forms;

import agg.attribute.facade.impl.DefaultEditorFacade;
import agg.attribute.gui.AttrTopEditor;
import agg.attribute.view.AttrViewSetting;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.gui.GraGraEditor;
import agg.gui.GraGraTreeView;
import agg.layout.LayoutArc;
import agg.layout.LayoutNode;
import agg.plugins.commonlib.ScoreHelper;
import agg.plugins.dm.IncManagedGraGra;
import agg.plugins.dm.InconsistencyPair;
import agg.plugins.dm.ResolutionRuleItem;
import agg.plugins.dm.SimpleParameter;
import agg.plugins.dm.forms.ApplicationSelection;
import agg.plugins.dm.forms.ResParameters;
import agg.plugins.dm.forms.RuleProperties;
import agg.xt_basis.Node;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SIRP
extends JDialog {
    private Frame parentFrame = null;
    private IncManagedGraGra ggx = null;
    private IncSelectionListener incListener = null;
    private EdGraGra EDgragra;
    private GraGraTreeView treeView;
    private GraGraEditor editor;
    private JTable applicableResRules;
    private JButton applyAResButton;
    private JCheckBox checkAutofillParams;
    private JTable detectedInconsistencies;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSplitPane jSplitPane1;
    private JTextField jTextGGXGrammar;
    private JTextField jTextGGXGraphName;
    private JTextField jTextGGXTypeGraph;
    private JTree jTreeHistory;
    private JButton moreDetailsButton;
    private JButton openAndDetectButton;

    public SIRP(Frame parent, EdGraGra EDgragra, GraGraTreeView treeView, GraGraEditor editor) {
        super(parent, true);
        this.parentFrame = parent;
        this.EDgragra = EDgragra;
        this.treeView = treeView;
        this.editor = editor;
        this.initComponents();
        this.initMyForm();
        this.jPanel2.setVisible(false);
        this.jLabel9.setVisible(false);
        this.jCheckBox1.setVisible(false);
        this.jTreeHistory.setVisible(false);
        this.jScrollPane6.setVisible(false);
        this.doLoad(false);
    }

    private void freshResTable() {
        try {
            DefaultTableModel resModel = (DefaultTableModel)this.applicableResRules.getModel();
            resModel.setRowCount(0);
            DefaultTableModel incModel = (DefaultTableModel)this.detectedInconsistencies.getModel();
            if (incModel.getRowCount() <= 0) {
                return;
            }
            int idx = this.detectedInconsistencies.getSelectedRow();
            if (idx < 0) {
                return;
            }
            InconsistencyPair incNode = (InconsistencyPair)incModel.getValueAt(idx, 0);
            ArrayList<Rule> convenientResRules = this.ggx.getResolutionRulesBasedOn(incNode.getInconsistencyNodeName(), false);
            ScoreHelper sh = this.ggx.getScoreHelper();
            ArrayList<Integer> scores = sh.readScores(convenientResRules);
            boolean allActive = true;
            for (int i = 0; i < convenientResRules.size(); ++i) {
                Rule resol = convenientResRules.get(i);
                if (resol.isEnabled()) {
                    resModel.addRow(new Object[]{new ResolutionRuleItem(resol, ResolutionRuleItem.ItemPresentationMode.extendedMode), String.valueOf(scores.get(i))});
                    continue;
                }
                allActive = false;
            }
            this.sortAllRowsBy(resModel, 1, false);
            if (resModel.getRowCount() > 0) {
                this.applicableResRules.setRowSelectionInterval(0, 0);
            }
            this.freshAppButton();
            this.jLabel11.setVisible(!allActive);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void freshAppButton() {
        try {
            int[] idxDs = this.detectedInconsistencies.getSelectedRows();
            int[] idxRs = this.applicableResRules.getSelectedRows();
            this.applyAResButton.setEnabled(idxDs.length == 1 && idxRs.length == 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initMyForm() {
        this.jLabel10.setVisible(false);
        this.jLabel11.setVisible(false);
        this.jButton1.setVisible(false);
        this.checkAutofillParams.setVisible(false);
        this.setSize(650, 675);
        this.incListener = new IncSelectionListener(this.detectedInconsistencies);
        this.detectedInconsistencies.setColumnSelectionAllowed(false);
        this.detectedInconsistencies.setRowSelectionAllowed(true);
        this.applicableResRules.setColumnSelectionAllowed(false);
        this.applicableResRules.setRowSelectionAllowed(true);
        this.detectedInconsistencies.setSelectionMode(0);
        this.applicableResRules.setSelectionMode(0);
        this.detectedInconsistencies.getColumnModel().getColumn(0).setPreferredWidth(195);
        this.detectedInconsistencies.getColumnModel().getColumn(0).setMinWidth(120);
        this.detectedInconsistencies.getColumnModel().getColumn(0).setMaxWidth(280);
        this.detectedInconsistencies.getColumnModel().getColumn(1).setPreferredWidth(205);
        this.detectedInconsistencies.getColumnModel().getColumn(1).setMinWidth(120);
        this.detectedInconsistencies.getColumnModel().getColumn(1).setMaxWidth(280);
        this.applicableResRules.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.applicableResRules.getColumnModel().getColumn(0).setMinWidth(280);
        this.applicableResRules.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.applicableResRules.getColumnModel().getColumn(1).setMinWidth(80);
        this.applicableResRules.getColumnModel().getColumn(1).setMaxWidth(80);
        this.applyAResButton.setEnabled(false);
        this.moreDetailsButton.setEnabled(false);
        this.detectedInconsistencies.setAutoCreateColumnsFromModel(false);
        this.applicableResRules.setAutoCreateColumnsFromModel(false);
        JTableHeader incHeader = this.detectedInconsistencies.getTableHeader();
        incHeader.addMouseListener(new IncColumnHeaderListener());
        DefaultTreeModel model = (DefaultTreeModel)this.jTreeHistory.getModel();
        model.setRoot(null);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = this.getBounds();
        this.setLocation((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
    }

    private void doLoad(boolean withDetection) {
        try {
            String typeGraphName;
            this.moreDetailsButton.setEnabled(false);
            this.ggx = new IncManagedGraGra(this.EDgragra.getBasisGraGra());
            String grammarName = this.ggx.getGTSName();
            if (grammarName != null) {
                this.jTextGGXGrammar.setText(grammarName);
            }
            if ((typeGraphName = this.ggx.getTypeGraphName()) != null) {
                this.jTextGGXTypeGraph.setText(typeGraphName);
            }
            String graphName = this.ggx.getHostGraphName();
            this.jTextGGXGraphName.setText(graphName);
            this.moreDetailsButton.setEnabled(true);
            if (withDetection) {
                this.doDetectDefects(true);
            }
            this.doDisplayFoundDefects();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.jLabel10.setVisible(!this.ggx.allDetRuleActive());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doDetectDefects(boolean withHist) {
        this.doApplyDetectionTransformations(withHist);
        this.doDisplayFoundDefects();
    }

    private void doApplyDetectionTransformations(boolean withHist) {
        boolean allActive = false;
        try {
            this.ggx.doClean();
            allActive = this.ggx.doDetect(withHist);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jLabel10.setVisible(!allActive);
    }

    private Vector<LayoutArc> getLayoutArcs(EdGraph e) {
        Vector<LayoutArc> ret = new Vector<LayoutArc>();
        Vector earcs = e.getArcs();
        for (int i = 0; i < earcs.size(); ++i) {
            ret.addElement(((EdArc)earcs.get(i)).getLArc());
        }
        return ret;
    }

    private EdGraph getGraph() {
        return this.treeView.getCurrentGraGra().getGraph();
    }

    private void doReorderNodes() {
        AttrTopEditor topEditor = DefaultEditorFacade.self().getTopEditor();
        AttrViewSetting view = topEditor.getViewSetting();
        Hashtable<Node, Integer> nodeOffset = new Hashtable<Node, Integer>();
        nodeOffset.clear();
        try {
            EdGraph hostg = this.treeView.getCurrentGraGra().getGraph();
            Type incNodeType = this.ggx.getInconsistentNodeType();
            hostg.updateGraph(true, true);
            hostg.deselectAll();
            Vector<LayoutArc> larcs = this.getLayoutArcs(hostg);
            for (int i = 0; i < larcs.size(); ++i) {
                LayoutArc lArc = larcs.get(i);
                EdArc a = lArc.getEdArc();
                EdNode sourceNode = (EdNode)a.getSource();
                EdNode targetNode = (EdNode)a.getTarget();
                EdType arcType = a.getType();
                if (!targetNode.getBasisNode().getType().getName().equals(incNodeType.getName())) continue;
                Integer offset = (Integer)nodeOffset.get(sourceNode.getBasisNode());
                offset = offset == null ? new Integer(0) : new Integer(offset + 5);
                nodeOffset.put(sourceNode.getBasisNode(), offset);
                LayoutNode sourceLayoutNode = sourceNode.getLNode();
                LayoutNode targetLayoutNode = targetNode.getLNode();
                int XTarget = Math.max(0, sourceNode.getX());
                int YSourceTop = sourceNode.getY() - 1 - sourceNode.getHeight() / 2;
                int YSourceBot = sourceNode.getY() + 1 + sourceNode.getHeight() / 2;
                int YTarget = Math.max(0, YSourceBot + targetNode.getHeight() / 2);
                targetLayoutNode.setAkt(new Point(XTarget += offset.intValue(), YTarget += offset.intValue()));
                targetLayoutNode.setOpt(new Point(XTarget, YTarget));
                targetNode.setXY(targetLayoutNode.getAkt().x, targetLayoutNode.getAkt().y);
            }
            this.treeView.graphDidChange();
            this.editor.updateGraphics();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doDisplayFoundDefects() {
        this.doReorderNodes();
        try {
            this.detectedInconsistencies.getSelectionModel().removeListSelectionListener(this.incListener);
            DefaultTableModel model = (DefaultTableModel)this.detectedInconsistencies.getModel();
            model.setRowCount(0);
            ArrayList<InconsistencyPair> inconsistentGraphNodes = this.ggx.getMarkedGraphNodes();
            for (int i = 0; i < inconsistentGraphNodes.size(); ++i) {
                InconsistencyPair n = inconsistentGraphNodes.get(i);
                n.choosePresentationMode(InconsistencyPair.ItemPresentationMode.showInconsistency);
                model.addRow(new Object[]{n, n.getInconsistentNodeDesc(), n.getInconsistentNodeAttributes()});
            }
            this.detectedInconsistencies.getSelectionModel().addListSelectionListener(this.incListener);
            if (inconsistentGraphNodes.size() > 0) {
                this.detectedInconsistencies.setRowSelectionInterval(0, 0);
                this.detectedInconsistencies.requestFocusInWindow();
            } else {
                this.incListener.resetResModel();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void oneStepProcess() {
        this.doApplyAResolution();
    }

    private void doApplyAResolution() {
        int idxD = this.detectedInconsistencies.getSelectedRow();
        int idxR = this.applicableResRules.getSelectedRow();
        TableModel detectedIncModel = this.detectedInconsistencies.getModel();
        TableModel resolModel = this.applicableResRules.getModel();
        if (idxD >= 0 && idxR >= 0) {
            HashMap<String, SimpleParameter> parms;
            InconsistencyPair inconsistentNode = (InconsistencyPair)detectedIncModel.getValueAt(idxD, 0);
            ResolutionRuleItem resItem = (ResolutionRuleItem)resolModel.getValueAt(idxR, 0);
            Rule resRule = resItem.getRule();
            Node incNode = inconsistentNode.getInconsistentNode();
            ArrayList<IncManagedGraGra.MatchOccurrence> matchList = this.ggx.getMatches(incNode, resRule, parms = new HashMap<String, SimpleParameter>());
            ApplicationSelection mod = new ApplicationSelection(this, matchList);
            if (mod.queryMatch()) {
                IncManagedGraGra.MatchOccurrence mo = mod.getChosenMatch();
                mod.dispose();
                boolean success = true;
                if (parms.size() > 0) {
                    ResParameters prmMod = new ResParameters(this, parms);
                    prmMod.setVisible(true);
                    success = prmMod.isFillResult();
                    prmMod.dispose();
                }
                if (success) {
                    try {
                        if (this.ggx.doTransform(incNode, resRule, this.checkAutofillParams.isSelected(), mo, parms)) {
                            this.doDetectDefects(true);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, "A problem occured while showing application choices.");
            }
        }
    }

    public void sortAllRowsBy(DefaultTableModel model, int colIndex, boolean ascending) {
        Vector<Vector> data = model.getDataVector();
        Collections.sort(data, new ColumnSorter(colIndex, ascending));
        model.fireTableStructureChanged();
    }

    private void showProperties() throws HeadlessException {
        RuleProperties moreInfo = this.doMoreDetails();
        moreInfo.dispose();
    }

    private RuleProperties doMoreDetails() throws HeadlessException {
        RuleProperties moreInfo = new RuleProperties(this, this.ggx, this.treeView);
        moreInfo.setVisible(true);
        if (moreInfo.isMustApplyARedetection()) {
            this.doDetectDefects(true);
        }
        if (moreInfo.isMustRefreshResolutionSet()) {
            DefaultTableModel model = (DefaultTableModel)this.detectedInconsistencies.getModel();
            this.freshResTable();
        }
        return moreInfo;
    }

    private void applyDoubleClick(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.oneStepProcess();
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.openAndDetectButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextGGXGrammar = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextGGXTypeGraph = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextGGXGraphName = new JTextField();
        this.moreDetailsButton = new JButton();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.detectedInconsistencies = new JTable();
        this.jLabel8 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.applicableResRules = new JTable();
        this.applyAResButton = new JButton();
        this.checkAutofillParams = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jSeparator1 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jScrollPane6 = new JScrollPane();
        this.jTreeHistory = new JTree();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Simple Iterative Resolution Process");
        this.jSplitPane1.setDividerLocation(425);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setMinimumSize(new Dimension(12, 410));
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setPreferredSize(new Dimension(12, 410));
        this.jPanel1.setMinimumSize(new Dimension(10, 410));
        this.jPanel1.setPreferredSize(new Dimension(10, 410));
        this.openAndDetectButton.setIcon(new ImageIcon(this.getClass().getResource("/ggx/lib/icons/SMALLSOLVEINCTR.gif")));
        this.openAndDetectButton.setText("Re-detect defects");
        this.openAndDetectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SIRP.this.openAndDetectButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Internal name");
        this.jTextGGXGrammar.setEditable(false);
        this.jLabel4.setText("TypeGraph name");
        this.jTextGGXTypeGraph.setEditable(false);
        this.jLabel5.setText("StartGraph name");
        this.jTextGGXGraphName.setEditable(false);
        this.moreDetailsButton.setIcon(new ImageIcon(this.getClass().getResource("/ggx/lib/icons/SMALLOPENONLY.gif")));
        this.moreDetailsButton.setText("Properties ...");
        this.moreDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SIRP.this.moreDetailsButtonActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Found defects");
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setMinimumSize(new Dimension(380, 82));
        this.jScrollPane1.setPreferredSize(new Dimension(380, 82));
        this.detectedInconsistencies.setModel(new DefaultTableModel(new Object[0][], new String[]{"Defect Name", "Concerned Artifact", "Information"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.detectedInconsistencies);
        this.jLabel8.setText("Available resolution rules");
        this.jScrollPane2.setMinimumSize(new Dimension(365, 82));
        this.jScrollPane2.setPreferredSize(new Dimension(365, 82));
        this.jScrollPane2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SIRP.this.jScrollPane2MouseClicked(evt);
            }
        });
        this.applicableResRules.setModel(new DefaultTableModel(new Object[0][], new String[]{"Rule Name", "Popularity"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.applicableResRules.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SIRP.this.applicableResRulesMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.applicableResRules);
        this.applyAResButton.setIcon(new ImageIcon(this.getClass().getResource("/ggx/lib/icons/SMALLSOLVEINCTR.gif")));
        this.applyAResButton.setText("Apply the chosen resolution");
        this.applyAResButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SIRP.this.applyAResButtonActionPerformed(evt);
            }
        });
        this.checkAutofillParams.setSelected(true);
        this.checkAutofillParams.setText("Fill the required parameters automatically (with default data)");
        this.checkAutofillParams.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkAutofillParams.setEnabled(false);
        this.checkAutofillParams.setFocusable(false);
        this.checkAutofillParams.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel10.setText("Warning ! Some detection rules are disabled. It may ignore some defects.");
        this.jLabel11.setText("Warning ! Some resolution rules are disabled. Disabled rule are not shown.");
        this.jSeparator3.setOrientation(1);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel4).add((Component)this.jLabel2, -2, 94, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextGGXTypeGraph, -1, 348, Short.MAX_VALUE).add((Component)this.jTextGGXGraphName, -1, 348, Short.MAX_VALUE).add((Component)this.jTextGGXGrammar, -1, 348, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jSeparator3, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.moreDetailsButton, -2, 144, -2).add((Component)this.openAndDetectButton))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel7).addPreferredGap(0, 180, Short.MAX_VALUE).add((Component)this.jLabel10)).add((Component)this.jSeparator1, -1, 612, Short.MAX_VALUE))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel8).addPreferredGap(0, 126, Short.MAX_VALUE).add((Component)this.jLabel11)).add((Component)this.jScrollPane1, -1, 602, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.applyAResButton).addPreferredGap(0, 108, Short.MAX_VALUE).add((Component)this.checkAutofillParams)).add((Component)this.jScrollPane2, -1, 602, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2, -2, 14, -2).add((Component)this.jTextGGXGrammar, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextGGXTypeGraph, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextGGXGraphName, -2, -1, -2))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.moreDetailsButton).addPreferredGap(0).add((Component)this.openAndDetectButton)).add((Component)this.jSeparator3, -2, 70, -2)).add(14, 14, 14).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel7, -2, 22, -2).add((Component)this.jLabel10)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.jLabel11)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 135, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.applyAResButton).add((Component)this.checkAutofillParams)).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel2.setMinimumSize(new Dimension(10, 130));
        this.jPanel2.setPreferredSize(new Dimension(10, 130));
        this.jLabel9.setText("Resolution history");
        this.jCheckBox1.setText("Detailed view");
        this.jCheckBox1.setToolTipText("if checked : shows all differences and similarities with previous version");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SIRP.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jTreeHistory.setRootVisible(false);
        this.jTreeHistory.setShowsRootHandles(true);
        this.jTreeHistory.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SIRP.this.jTreeHistoryMouseClicked(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.jTreeHistory);
        this.jButton1.setText("Undo the previous resolution");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane6, -1, 612, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel9).add(26, 26, 26).add((Component)this.jCheckBox1, -2, 125, -2).addPreferredGap(0, 204, Short.MAX_VALUE).add((Component)this.jButton1))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.jButton1).add((Component)this.jCheckBox1)).addPreferredGap(0).add((Component)this.jScrollPane6, -1, 105, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane1, -1, 634, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1, -1, 587, Short.MAX_VALUE));
        this.pack();
    }

    private void applicableResRulesMouseClicked(MouseEvent evt) {
        this.applyDoubleClick(evt);
    }

    private void jTreeHistoryMouseClicked(MouseEvent evt) {
    }

    private void jScrollPane2MouseClicked(MouseEvent evt) {
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
    }

    private void applyAResButtonActionPerformed(ActionEvent evt) {
        this.oneStepProcess();
    }

    private void moreDetailsButtonActionPerformed(ActionEvent evt) {
        this.showProperties();
    }

    private void openAndDetectButtonActionPerformed(ActionEvent evt) {
        this.doDetectDefects(false);
    }

    public class IncColumnHeaderListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            JTable table = ((JTableHeader)evt.getSource()).getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            if (vColIndex == -1) {
                return;
            }
            int mColIndex = table.convertColumnIndexToModel(vColIndex);
            DefaultTableModel incModel = (DefaultTableModel)SIRP.this.detectedInconsistencies.getModel();
            SIRP.this.sortAllRowsBy(incModel, mColIndex, true);
            SIRP.this.applyAResButton.setEnabled(false);
        }
    }

    public class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        public int compare(Object a, Object b) {
            Vector v1 = (Vector)a;
            Vector v2 = (Vector)b;
            Object o1 = v1.get(this.colIndex);
            Object o2 = v2.get(this.colIndex);
            if (o1 instanceof String && ((String)o1).length() == 0) {
                o1 = null;
            }
            if (o2 instanceof String && ((String)o2).length() == 0) {
                o2 = null;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return ((Comparable)o2).compareTo(o1);
            }
            if (this.ascending) {
                return o1.toString().compareTo(o2.toString());
            }
            return o2.toString().compareTo(o1.toString());
        }
    }

    private class IncSelectionListener
    implements ListSelectionListener {
        JTable table;

        IncSelectionListener(JTable table) {
            this.table = table;
        }

        public void resetResModel() {
            DefaultTableModel resModel = (DefaultTableModel)SIRP.this.applicableResRules.getModel();
            resModel.setRowCount(0);
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                SIRP.this.freshResTable();
            }
        }
    }
}

