/*
 * Decompiled with CFR 0.152.
 */
package agg.termination;

import agg.termination.TypeLayer;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.Type;
import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TerminationLGTS {
    private GraGra grammar;
    private Vector deletionRule;
    private Vector nondeletionRule;
    private Vector creationRule;
    private Hashtable ruleLayer;
    private Hashtable creationLayer;
    private Hashtable deletionLayer;
    private boolean generateRuleLayer;
    private Hashtable oldRuleLayer;
    private int maxl;
    private Hashtable invertedRuleLayer;
    private OrderedSet orderedRuleLayerSet;
    private Hashtable invertedTypeDeletionLayer;
    private OrderedSet orderedTypeDeletionLayerSet;
    private Hashtable invertedTypeCreationLayer;
    private OrderedSet orderedTypeCreationLayerSet;
    private Integer startLayer;
    private Integer startRuleLayer;
    private Vector orderedRuleLayer;
    private Vector orderedTypeDeletionLayer;
    private Vector orderedTypeCreationLayer;
    private Hashtable resultTypeDeletion;
    private Hashtable resultDeletion;
    private Hashtable resultNondeletion;
    private Hashtable deletionType;
    private boolean needCorrection = false;
    private String errMsg;
    private boolean valid;

    public void setGrammar(GraGra grammar) {
        this.grammar = grammar;
        this.errMsg = "";
        this.valid = false;
        this.oldRuleLayer = new Hashtable();
        this.saveRuleLayerInto(this.oldRuleLayer);
        this.initRuleLayer(grammar);
        this.initCreationLayer(grammar);
        this.initDeletionLayer(grammar);
        this.initOrderedRuleLayer(grammar);
        this.deletionType = new Hashtable();
        this.initResults();
    }

    public GraGra getGrammar() {
        return this.grammar;
    }

    public Hashtable getInvertedRuleLayer() {
        return this.invertedRuleLayer;
    }

    public Vector getOrderedRuleLayer() {
        return this.orderedRuleLayer;
    }

    public Hashtable getInvertedTypeDeletionLayer() {
        return this.invertedTypeDeletionLayer;
    }

    public Vector getOrderedTypeDeletionLayer() {
        return this.orderedTypeDeletionLayer;
    }

    public Hashtable getInvertedTypeCreationLayer() {
        return this.invertedTypeCreationLayer;
    }

    public Vector getOrderedTypeCreationLayer() {
        return this.orderedTypeCreationLayer;
    }

    public Hashtable getDeletionType() {
        return this.deletionType;
    }

    public Hashtable getResultTypeDeletion() {
        return this.resultTypeDeletion;
    }

    public Hashtable getResultDeletion() {
        return this.resultDeletion;
    }

    public Hashtable getResultNondeletion() {
        return this.resultNondeletion;
    }

    public void resetLayer() {
        this.maxl = 0;
        this.initRuleLayer(this.oldRuleLayer);
        this.initCreationLayer(this.grammar);
        this.initDeletionLayer(this.grammar);
        this.initOrderedRuleLayer(this.grammar);
        this.deletionType = new Hashtable();
        this.initResults();
    }

    private void initRuleLayer(GraGra gragra) {
        this.ruleLayer = new Hashtable();
        this.deletionRule = new Vector();
        this.nondeletionRule = new Vector();
        this.creationRule = new Vector();
        Enumeration rules = gragra.getRules();
        while (rules.hasMoreElements()) {
            Rule rule = (Rule)rules.nextElement();
            this.ruleLayer.put(rule, new Integer(rule.getLayer()));
            if (this.isDeleting(rule)) {
                this.deletionRule.add(rule);
                continue;
            }
            if (this.isCreating(rule)) {
                this.creationRule.add(rule);
            }
            this.nondeletionRule.add(rule);
        }
    }

    private void initRuleLayer(int init) {
        Enumeration keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Rule rule = (Rule)keys.nextElement();
            this.ruleLayer.put(rule, new Integer(init));
        }
    }

    public void initRuleLayer(Hashtable init) {
        Enumeration keys = init.keys();
        while (keys.hasMoreElements()) {
            Rule r = (Rule)keys.nextElement();
            Integer rl = (Integer)init.get(r);
            this.ruleLayer.put(r, new Integer(rl));
        }
    }

    private void initCreationLayer(GraGra gragra) {
        this.creationLayer = new Hashtable();
        Enumeration types = gragra.getTypes();
        while (types.hasMoreElements()) {
            Object t = types.nextElement();
            this.creationLayer.put(t, new Integer(0));
        }
    }

    private void initCreationLayer(int init) {
        Enumeration keys = this.creationLayer.keys();
        while (keys.hasMoreElements()) {
            Type t = (Type)keys.nextElement();
            this.creationLayer.put(t, new Integer(init));
        }
    }

    private void initDeletionLayer(GraGra gragra) {
        this.deletionLayer = new Hashtable();
        Enumeration types = gragra.getTypes();
        while (types.hasMoreElements()) {
            Object t = types.nextElement();
            this.deletionLayer.put(t, new Integer(0));
        }
    }

    private void initDeletionLayer(int init) {
        Enumeration keys = this.deletionLayer.keys();
        while (keys.hasMoreElements()) {
            Type t = (Type)keys.nextElement();
            this.deletionLayer.put(t, new Integer(init));
        }
    }

    private void initOrderedRuleLayer(GraGra gragra) {
        RuleLayer layer = new RuleLayer(gragra.getRules());
        this.invertedRuleLayer = layer.invertLayer();
        this.startRuleLayer = layer.getStartLayer();
        this.invertedRuleLayer = layer.invertLayer();
        this.orderedRuleLayerSet = new OrderedSet();
        Enumeration en = this.invertedRuleLayer.keys();
        while (en.hasMoreElements()) {
            this.orderedRuleLayerSet.add(en.nextElement());
        }
    }

    private void initOrderedTypeDeletionLayer() {
        TypeLayer layer = new TypeLayer(this.deletionLayer);
        this.invertedTypeDeletionLayer = layer.invertLayer();
        this.startLayer = layer.getStartLayer();
        this.invertedTypeDeletionLayer = layer.invertLayer();
        this.orderedTypeDeletionLayerSet = new OrderedSet();
        Enumeration en = this.invertedTypeDeletionLayer.keys();
        while (en.hasMoreElements()) {
            this.orderedTypeDeletionLayerSet.add(en.nextElement());
        }
    }

    private void initOrderedTypeCreationLayer() {
        TypeLayer layer = new TypeLayer(this.creationLayer);
        this.invertedTypeCreationLayer = layer.invertLayer();
        this.startLayer = layer.getStartLayer();
        this.invertedTypeCreationLayer = layer.invertLayer();
        this.orderedTypeCreationLayerSet = new OrderedSet();
        Enumeration en = this.invertedTypeCreationLayer.keys();
        while (en.hasMoreElements()) {
            this.orderedTypeCreationLayerSet.add(en.nextElement());
        }
    }

    private void initResults() {
        this.orderedRuleLayer = new Vector();
        this.resultTypeDeletion = new Hashtable();
        this.resultDeletion = new Hashtable();
        this.resultNondeletion = new Hashtable();
    }

    public void initAll(boolean generate) {
        if (generate) {
            this.initRuleLayer(this.oldRuleLayer);
            this.initCreationLayer(0);
            this.initDeletionLayer(0);
            this.initResults();
            this.maxl = 0;
        } else {
            this.resetLayer();
        }
    }

    private boolean isDeleting(Rule r) {
        Enumeration elems = r.getLeft().getElements();
        while (elems.hasMoreElements()) {
            GraphObject go = (GraphObject)elems.nextElement();
            if (r.getImage(go) != null) continue;
            return true;
        }
        return false;
    }

    private boolean isCreating(Rule r) {
        Enumeration elems = r.getRight().getElements();
        while (elems.hasMoreElements()) {
            GraphObject go = (GraphObject)elems.nextElement();
            if (r.getInverseImage(go).hasMoreElements()) continue;
            return true;
        }
        return false;
    }

    public Vector getCreatedTypesOnDeletionLayer(Integer layer) {
        Vector<Type> types = new Vector<Type>();
        Enumeration en = this.deletionRule.elements();
        while (en.hasMoreElements()) {
            Rule r = (Rule)en.nextElement();
            Enumeration elems = r.getRight().getElements();
            while (elems.hasMoreElements()) {
                Type t;
                Integer tLayer;
                GraphObject go = (GraphObject)elems.nextElement();
                if (r.getInverseImage(go).hasMoreElements() || (tLayer = (Integer)this.creationLayer.get(t = go.getType())).intValue() != layer.intValue() || types.contains(t)) continue;
                types.add(t);
            }
        }
        return types;
    }

    private void generateCreationLayer() {
        Enumeration en = this.nondeletionRule.elements();
        while (en.hasMoreElements()) {
            Rule r = (Rule)en.nextElement();
            Enumeration types = this.creationLayer.keys();
            while (types.hasMoreElements()) {
                Type t = (Type)types.nextElement();
                this.setCreationLayer(r, t);
            }
        }
    }

    private void setCreationLayer(Rule r, Type t) {
        Integer cl;
        Integer rl;
        GraphObject grob;
        Enumeration en = r.getRight().getElements();
        while (en.hasMoreElements()) {
            grob = (GraphObject)en.nextElement();
            if (r.getInverseImage(grob).hasMoreElements() || !grob.getType().compareTo(t)) continue;
            rl = (Integer)this.ruleLayer.get(r);
            cl = (Integer)this.creationLayer.get(t);
            if (cl > rl) continue;
            int l = rl + 1;
            this.creationLayer.put(t, new Integer(l));
            cl = (Integer)this.creationLayer.get(t);
            if (l <= this.maxl) continue;
            this.maxl = l;
        }
        en = r.getLeft().getElements();
        while (en.hasMoreElements()) {
            grob = (GraphObject)en.nextElement();
            if (r.getImage(grob) == null || !grob.getType().compareTo(t)) continue;
            rl = (Integer)this.ruleLayer.get(r);
            cl = (Integer)this.creationLayer.get(t);
            if (cl <= rl) continue;
            if (this.generateRuleLayer) {
                this.ruleLayer.put(r, new Integer(cl));
                rl = (Integer)this.ruleLayer.get(r);
                this.needCorrection = true;
            } else {
                this.creationLayer.put(t, new Integer(rl));
            }
            cl = (Integer)this.creationLayer.get(t);
        }
    }

    private boolean increaseRuleLayer(Enumeration rules, Type t, Rule excludedRule) {
        boolean increased = false;
        while (rules.hasMoreElements()) {
            Rule r = (Rule)rules.nextElement();
            if (r.equals(excludedRule) || !this.usesType(t, r)) continue;
            r.setLayer(r.getLayer() + 1);
            increased = true;
        }
        return increased;
    }

    private boolean usesType(Type t, Rule r) {
        Enumeration elems = r.getLeft().getElements();
        while (elems.hasMoreElements()) {
            GraphObject go = (GraphObject)elems.nextElement();
            if (r.getImage(go) == null || !go.getType().compareTo(t)) continue;
            return true;
        }
        return false;
    }

    private void passCreationLayer() {
        Enumeration en = this.creationRule.elements();
        while (en.hasMoreElements()) {
            Rule r = (Rule)en.nextElement();
            Enumeration types = this.creationLayer.keys();
            while (types.hasMoreElements()) {
                Type t = (Type)types.nextElement();
                Integer rl = (Integer)this.ruleLayer.get(r);
                Integer cl = (Integer)this.creationLayer.get(t);
                if (cl > rl) continue;
                int l = rl + 1;
                this.creationLayer.put(t, new Integer(l));
                cl = (Integer)this.creationLayer.get(t);
                if (l <= this.maxl) continue;
                this.maxl = l;
            }
        }
    }

    private void generateDeletionLayer() {
        Rule r;
        Enumeration<Object> en;
        if (this.generateRuleLayer) {
            en = this.deletionRule.elements();
            while (en.hasMoreElements()) {
                r = (Rule)en.nextElement();
                Integer rl = (Integer)this.getRuleLayer().get(r);
                if (rl >= this.maxl) continue;
                this.ruleLayer.put(r, new Integer(this.maxl));
            }
        }
        en = this.deletionRule.elements();
        while (en.hasMoreElements()) {
            r = (Rule)en.nextElement();
            Enumeration types = this.deletionLayer.keys();
            while (types.hasMoreElements()) {
                Type t = (Type)types.nextElement();
                this.setDeletionLayer(r, t);
            }
        }
        en = this.getDeletionLayer().keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Integer dl = (Integer)this.getDeletionLayer().get(key);
            Integer cl = (Integer)this.creationLayer.get(key);
            if (dl >= cl) continue;
            this.deletionLayer.put(key, new Integer(cl));
        }
    }

    private void setDeletionLayer(Rule r, Type t) {
        Integer rl;
        GraphObject grob;
        Enumeration en = r.getLeft().getElements();
        while (en.hasMoreElements()) {
            grob = (GraphObject)en.nextElement();
            if (r.getImage(grob) != null || !grob.getType().compareTo(t)) continue;
            rl = (Integer)this.ruleLayer.get(r);
            Integer cl = (Integer)this.creationLayer.get(t);
            Integer dl = (Integer)this.deletionLayer.get(t);
            int l = cl;
            if (l > this.maxl) {
                this.maxl = l;
            }
            if (this.generateRuleLayer && rl < this.maxl) {
                this.ruleLayer.put(r, new Integer(this.maxl));
                rl = (Integer)this.ruleLayer.get(r);
            }
            if (dl < cl) {
                this.deletionLayer.put(t, new Integer(this.maxl));
                dl = (Integer)this.deletionLayer.get(t);
            }
            if (dl > rl && this.generateRuleLayer) {
                this.ruleLayer.put(r, new Integer(dl));
                rl = (Integer)this.ruleLayer.get(r);
            }
            if (dl != 0) continue;
            this.deletionLayer.put(t, new Integer(rl));
            dl = (Integer)this.deletionLayer.get(t);
        }
        en = r.getRight().getElements();
        while (en.hasMoreElements()) {
            grob = (GraphObject)en.nextElement();
            if (r.getInverseImage(grob).hasMoreElements() || !grob.getType().compareTo(t)) continue;
            rl = (Integer)this.ruleLayer.get(r);
            Integer dl = (Integer)this.deletionLayer.get(t);
            Integer cl = (Integer)this.creationLayer.get(t);
            if (cl > rl) continue;
            this.creationLayer.put(t, new Integer(rl + 1));
            cl = (Integer)this.creationLayer.get(t);
        }
    }

    public boolean checkTermination() {
        if (this.generateRuleLayer) {
            this.initAll(this.generateRuleLayer);
        }
        this.generateCreationLayer();
        this.generateDeletionLayer();
        for (int n = this.grammar.getRulesVec().size(); this.needCorrection && n >= 0; --n) {
            this.needCorrection = false;
            this.generateCreationLayer();
            this.generateDeletionLayer();
        }
        Enumeration en = this.grammar.getRules();
        while (en.hasMoreElements()) {
            Object r = en.nextElement();
            Integer rl = (Integer)this.ruleLayer.get(r);
            if (rl != null) continue;
            this.errMsg = "Termination check is failed.\n\nRule :  <" + ((Rule)r).getName() + "> \n" + "The condition that \n" + "rl  is a total function \n" + "is not satisfied.";
            return false;
        }
        en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            Object t = en.nextElement();
            Integer dl = (Integer)this.deletionLayer.get(t);
            Integer cl = (Integer)this.creationLayer.get(t);
            if (cl == null) {
                this.errMsg = "Termination check is failed.\n\nType :  <" + ((Type)t).getStringRepr() + ">\n" + "The condition that \n" + "cl  is total function \n" + "is not satisfied.";
                return false;
            }
            if (dl != null) continue;
            this.errMsg = "Termination check is failed.\n\nType :  <" + ((Type)t).getStringRepr() + ">\n" + "The condition that\n" + "dl  is total function\n" + "is not satisfied.";
            return false;
        }
        boolean result = this.checkTerminationConditions();
        this.initOrderedTypeDeletionLayer();
        this.initOrderedTypeCreationLayer();
        return result;
    }

    private boolean checkTerminationConditions() {
        Integer currentLayer = this.startRuleLayer;
        boolean nextLayerExists = true;
        while (nextLayerExists && currentLayer != null) {
            OrderedSetIterator osi;
            HashSet rulesForLayer = (HashSet)this.invertedRuleLayer.get(currentLayer);
            if (rulesForLayer != null) {
                Pair value;
                this.orderedRuleLayer.addElement(currentLayer);
                Vector<Rule> currentRules = new Vector<Rule>();
                Enumeration en = rulesForLayer.elements();
                while (en.hasMoreElements()) {
                    Rule rule = (Rule)en.nextElement();
                    currentRules.addElement(rule);
                }
                if (this.checkTypeDeletion(currentLayer, currentRules)) {
                    value = new Pair(new Boolean(true), currentRules);
                    this.resultTypeDeletion.put(currentLayer, value);
                } else {
                    value = new Pair(new Boolean(false), currentRules);
                    this.resultTypeDeletion.put(currentLayer, value);
                }
                if (this.checkNondeletionLayer(currentRules)) {
                    value = new Pair(new Boolean(true), currentRules);
                    this.resultNondeletion.put(currentLayer, value);
                } else {
                    value = new Pair(new Boolean(false), currentRules);
                    this.resultNondeletion.put(currentLayer, value);
                }
                if (this.checkDeletionLayer(currentRules)) {
                    value = new Pair(new Boolean(true), currentRules);
                    this.resultDeletion.put(currentLayer, value);
                } else {
                    value = new Pair(new Boolean(false), currentRules);
                    this.resultDeletion.put(currentLayer, value);
                }
            }
            if ((osi = this.orderedRuleLayerSet.find(currentLayer)) == null || osi.atEnd()) {
                nextLayerExists = false;
                continue;
            }
            osi.advance();
            currentLayer = (Integer)osi.get();
        }
        return true;
    }

    private boolean checkTypeDeletion(Integer layer, Vector rules) {
        String errText1 = "Type Deletion Condition ( Deletion_1 ): \nTermination check is failed.\n\n";
        String errText2 = "The condition that on deletion layer " + layer + "\n" + "each rule decreases the number of graph items\n" + "or\n" + "each rule decreases the number of graph items of one special type\n" + "is not satisfied.";
        boolean checkOK = true;
        for (int j = 0; j < rules.size(); ++j) {
            Rule r = (Rule)rules.elementAt(j);
            if (this.deletionRule.contains(r)) {
                if (r.getLeft().getSize() > r.getRight().getSize()) continue;
                checkOK = false;
                this.errMsg = errText1 + "Rule :  <" + r.getName() + "> \n" + errText2;
                break;
            }
            return false;
        }
        if (checkOK) {
            return true;
        }
        Hashtable deletedType = new Hashtable();
        for (int j = 0; j < rules.size(); ++j) {
            Rule r = (Rule)rules.elementAt(j);
            Enumeration en = r.getLeft().getElements();
            while (en.hasMoreElements()) {
                Vector<Rule> v;
                GraphObject o = (GraphObject)en.nextElement();
                if (r.getImage(o) != null) continue;
                boolean containsKey = false;
                Type t = o.getType();
                Pair delt = new Pair(t, null);
                if (o.isArc()) {
                    delt = new Pair(t, new Pair(((Arc)o).getSource().getType(), ((Arc)o).getTarget().getType()));
                }
                Pair t1 = null;
                Enumeration e = deletedType.keys();
                while (e.hasMoreElements()) {
                    t1 = (Pair)e.nextElement();
                    if (!t.isRelatedTo((Type)t1.first)) continue;
                    if (t1.second == null && delt.second == null) {
                        containsKey = true;
                        break;
                    }
                    if (t1.second == null || delt.second == null) continue;
                    Pair t1sec = (Pair)t1.second;
                    Pair deltsec = (Pair)delt.second;
                    if (!((Type)deltsec.first).isRelatedTo((Type)t1sec.first) || !((Type)deltsec.second).isRelatedTo((Type)t1sec.second)) continue;
                    containsKey = true;
                    break;
                }
                if (containsKey) {
                    v = (Vector<Rule>)deletedType.get(t1);
                    if (!v.contains(r)) {
                        v.add(r);
                    }
                    deletedType.put(t1, v);
                    continue;
                }
                v = new Vector<Rule>(rules.size());
                v.add(r);
                deletedType.put(delt, v);
            }
        }
        Vector<Type> ltypes = new Vector<Type>();
        Enumeration en = deletedType.keys();
        while (en.hasMoreElements()) {
            Pair key = (Pair)en.nextElement();
            Type t = (Type)key.first;
            Vector v = (Vector)deletedType.get(key);
            if (v.size() != rules.size()) continue;
            for (int j = 0; j < rules.size(); ++j) {
                Rule r = (Rule)rules.elementAt(j);
                if (key.second == null) {
                    if (r.getLeft().getElementsOfTypeAsVector(t).size() > r.getRight().getElementsOfTypeAsVector(t).size()) continue;
                    this.errMsg = errText1 + "Rule :  <" + r.getName() + "> \n" + errText2;
                    return false;
                }
                if (r.getLeft().getElementsOfTypeAsVector(t, (Type)((Pair)key.second).first, (Type)((Pair)key.second).second).size() > r.getRight().getElementsOfTypeAsVector(t, (Type)((Pair)key.second).first, (Type)((Pair)key.second).second).size()) continue;
                this.errMsg = errText1 + "Rule :  <" + r.getName() + "> \n" + errText2;
                return false;
            }
            ltypes.add(t);
        }
        if (ltypes.size() != 0) {
            this.deletionType.put(layer, ltypes);
            return true;
        }
        this.errMsg = errText1 + errText2;
        return false;
    }

    private boolean checkDeletionLayer(Vector rules) {
        boolean result = true;
        HashSet deletionSet = new HashSet();
        HashSet creationSet = new HashSet();
        block0: for (int j = 0; j < rules.size(); ++j) {
            deletionSet.clear();
            creationSet.clear();
            Rule rule = (Rule)rules.elementAt(j);
            if (this.deletionRule.contains(rule)) {
                Type t;
                Integer cl;
                GraphObject grob;
                Integer rl = (Integer)this.ruleLayer.get(rule);
                Graph leftGraph = rule.getLeft();
                Graph rightGraph = rule.getRight();
                Enumeration en = leftGraph.getElements();
                while (en.hasMoreElements()) {
                    grob = (GraphObject)en.nextElement();
                    if (rule.getImage(grob) != null) continue;
                    deletionSet.add(grob);
                }
                if (deletionSet.isEmpty()) {
                    result = false;
                    this.errMsg = "Termination check is failed.\n\nRule :  <" + rule.getName() + "> \n" + "The condition that \n" + "r  deletes at least one node or edge \n" + "is not satisfied.";
                    break;
                }
                en = this.getDeletionLayer().keys();
                while (en.hasMoreElements() && result) {
                    Object key = en.nextElement();
                    Integer dl = (Integer)this.getDeletionLayer().get(key);
                    cl = (Integer)this.getCreationLayer().get(key);
                    if (0 <= cl && cl <= dl) continue;
                    result = false;
                    this.errMsg = "Deletion Layer Condition ( Deletion_2 ): \nTermination check is failed.\n\nType :  <" + ((Type)key).getStringRepr() + ">\n" + "The condition that \n" + "r  deletes only nodes and edges with label \n" + "l  such that  0 <= cl(l) <= dl(l) <= n \n" + "is not satisfied. \n" + "( cl = " + cl + " , " + "dl = " + dl + " )";
                    break;
                }
                en = deletionSet.elements();
                while (en.hasMoreElements() && result) {
                    grob = (GraphObject)en.nextElement();
                    t = grob.getType();
                    Integer dl = (Integer)this.getDeletionLayer().get(t);
                    if (dl <= rl) continue;
                    result = false;
                    this.errMsg = "Deletion Layer Condition ( Deletion_2 ): \nTermination check is failed.\n\nRule :  <" + rule.getName() + "> \n" + "Type :  <" + t.getStringRepr() + "> \n" + "The condition that \n" + "r  deletes only nodes and edges with label \n" + "l  such that  dl(l) <= rl(r) \n" + "is not satisfied. \n" + "( dl = " + dl + " , " + "rl = " + rl + " )";
                    break;
                }
                if (!result) break;
                en = rightGraph.getElements();
                while (en.hasMoreElements()) {
                    grob = (GraphObject)en.nextElement();
                    if (rule.getInverseImage(grob).hasMoreElements()) continue;
                    creationSet.add(grob);
                }
                en = creationSet.elements();
                while (en.hasMoreElements() && result) {
                    grob = (GraphObject)en.nextElement();
                    t = grob.getType();
                    cl = (Integer)this.getCreationLayer().get(t);
                    if (cl > rl) continue;
                    result = false;
                    this.errMsg = "Deletion Layer Condition ( Deletion_2 ): \nTermination check is failed.\n\nRule :  <" + rule.getName() + "> \n" + "Type :  <" + t.getStringRepr() + "> \n" + "The condition that\n " + "r  creates only nodes and edges with label \n" + "l  such that  cl(l) > rl(r) \n" + "is not satisfied. \n" + "( cl = " + cl + " , " + "rl = " + rl + " )";
                    continue block0;
                }
                continue;
            }
            result = false;
            break;
        }
        return result;
    }

    private boolean checkNondeletionLayer(Vector rules) {
        boolean result = true;
        HashSet preservedSet = new HashSet();
        HashSet creationSet = new HashSet();
        block2: for (int j = 0; j < rules.size(); ++j) {
            Rule rule = (Rule)rules.elementAt(j);
            if (this.nondeletionRule.contains(rule)) {
                Integer cl;
                Type t;
                GraphObject grob;
                if (!rule.isTotal()) {
                    this.errMsg = "Termination check is failed.\n\nNondeleting rule  <" + rule.getName() + ">  is not  total.";
                    return false;
                }
                if (!rule.isInjective()) {
                    this.errMsg = "Termination check is failed.\n\nNondeleting rule  <" + rule.getName() + ">  is not  injective.";
                    return false;
                }
                if (!rule.getNACs().hasMoreElements()) {
                    this.errMsg = "Termination check is failed.\n\nNondeleting rule  <" + rule.getName() + ">  should have a NAC.";
                    return false;
                }
                boolean localTrue = false;
                Enumeration nacs = rule.getNACs();
                while (nacs.hasMoreElements() && !localTrue) {
                    OrdinaryMorphism nac = (OrdinaryMorphism)nacs.nextElement();
                    OrdinaryMorphism nprime = BaseFactory.theFactory().createMorphism(nac.getTarget(), rule.getRight());
                    nprime.setCompletionStrategy(new Completion_InjCSP());
                    Enumeration dom = rule.getDomain();
                    while (dom.hasMoreElements()) {
                        GraphObject grob2 = (GraphObject)dom.nextElement();
                        GraphObject nacob = nac.getImage(grob2);
                        if (nacob == null) continue;
                        try {
                            nprime.addMapping(nacob, rule.getImage(grob2));
                            if (nprime.getImage(nacob) != null) continue;
                            this.errMsg = "Nondeleting rule  <" + rule.getName() + "> : " + "\nMapping of N': N->R accross  N<-L->R  failed.";
                            return false;
                        }
                        catch (BadMappingException ex) {
                            this.errMsg = "Nondeleting rule  <" + rule.getName() + "> : " + "\nMapping of N': N->R accross  N<-L->R  failed.";
                            return false;
                        }
                    }
                    localTrue = true;
                    if (nprime.nextCompletionWithConstantsChecking()) continue;
                    this.errMsg = "Nondeletion Layer Condition ( Nondeletion ): \nTermination check is failed.\n\nRule  <" + rule.getName() + "> :  \n" + "the condition that this rule " + "has a NAC  n : L -> N  \n" + "with  n' : N -> R  injective s.t.  n' o n = r\n" + "is not satisfied.";
                    localTrue = false;
                }
                if (!localTrue) {
                    return false;
                }
                Integer rl = (Integer)this.ruleLayer.get(rule);
                creationSet.clear();
                preservedSet.clear();
                Graph leftGraph = rule.getLeft();
                Graph rightGraph = rule.getRight();
                Enumeration en = leftGraph.getElements();
                while (en.hasMoreElements()) {
                    grob = (GraphObject)en.nextElement();
                    if (rule.getImage(grob) == null) continue;
                    preservedSet.add(grob);
                }
                en = rightGraph.getElements();
                while (en.hasMoreElements()) {
                    grob = (GraphObject)en.nextElement();
                    if (rule.getInverseImage(grob).hasMoreElements()) continue;
                    creationSet.add(grob);
                }
                en = preservedSet.elements();
                while (en.hasMoreElements() && result) {
                    grob = (GraphObject)en.nextElement();
                    t = grob.getType();
                    cl = (Integer)this.getCreationLayer().get(t);
                    if (cl <= rl) continue;
                    result = false;
                    this.errMsg = "Nondeletion Layer Condition ( Nondeletion ): \nTermination check is failed.\n\nRule :  <" + rule.getName() + "> \n" + "Type :  <" + t.getStringRepr() + "> \n" + "The condition that \n" + "r preserves nodes and edges with label \n" + "l  such that  cl(l) <= rl(r) \n" + "is not satisfied. \n" + "( cl = " + cl + " , " + "rl = " + rl + " )";
                    break;
                }
                en = creationSet.elements();
                while (en.hasMoreElements() && result) {
                    grob = (GraphObject)en.nextElement();
                    t = grob.getType();
                    cl = (Integer)this.getCreationLayer().get(t);
                    if (cl > rl) continue;
                    result = false;
                    this.errMsg = "Nondeletion Layer Condition ( Nondeletion ): \nTermination check is failed.\n\nRule :  <" + rule.getName() + "> \n" + "Type :  <" + t.getStringRepr() + "> \n" + "The condition that \n" + "r  creates only nodes and edges with label \n" + "l  such that  cl(l) > rl(r) \n" + "is not satisfied. \n" + "( cl = " + cl + " , " + "rl = " + rl + " )";
                    continue block2;
                }
                continue;
            }
            result = false;
            break;
        }
        return result;
    }

    public boolean isValid() {
        this.valid = true;
        for (int i = 0; i < this.orderedRuleLayer.size(); ++i) {
            boolean val = false;
            Integer currentLayer = (Integer)this.orderedRuleLayer.elementAt(i);
            Pair p = (Pair)this.resultTypeDeletion.get(currentLayer);
            if (p != null) {
                val = (Boolean)p.first;
            }
            if (!val) {
                p = (Pair)this.resultNondeletion.get(currentLayer);
                val = (Boolean)p.first;
                if (!val) {
                    p = (Pair)this.resultDeletion.get(currentLayer);
                    val = (Boolean)p.first;
                }
            }
            this.valid = this.valid && val;
        }
        return this.valid;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public Hashtable getRuleLayer() {
        int size = 0;
        Enumeration en = this.grammar.getRules();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++size;
        }
        if (size != this.ruleLayer.size()) {
            this.initRuleLayer(this.grammar);
            return this.ruleLayer;
        }
        en = this.grammar.getRules();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (this.ruleLayer.containsKey(key)) continue;
            this.initRuleLayer(this.grammar);
            return this.ruleLayer;
        }
        return this.ruleLayer;
    }

    public int getRuleLayer(Rule r) {
        if (this.ruleLayer.containsKey(r)) {
            return (Integer)this.ruleLayer.get(r);
        }
        return 0;
    }

    public Hashtable getCreationLayer() {
        int size = 0;
        Enumeration en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++size;
        }
        if (size != this.creationLayer.size()) {
            this.initCreationLayer(this.grammar);
            return this.creationLayer;
        }
        en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (this.creationLayer.containsKey(key)) continue;
            this.initCreationLayer(this.grammar);
            return this.creationLayer;
        }
        return this.creationLayer;
    }

    public int getCreationLayer(Type t) {
        if (this.creationLayer.containsKey(t)) {
            return (Integer)this.creationLayer.get(t);
        }
        return 0;
    }

    public Hashtable getDeletionLayer() {
        int size = 0;
        Enumeration en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            en.nextElement();
            ++size;
        }
        if (size != this.deletionLayer.size()) {
            this.initDeletionLayer(this.grammar);
            return this.deletionLayer;
        }
        en = this.grammar.getTypes();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (this.deletionLayer.containsKey(key)) continue;
            this.initDeletionLayer(this.grammar);
            return this.deletionLayer;
        }
        return this.deletionLayer;
    }

    public int getDeletionLayer(Type t) {
        if (this.deletionLayer.containsKey(t)) {
            return (Integer)this.deletionLayer.get(t);
        }
        return 0;
    }

    public Integer getStartLayer() {
        int startL = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer layer = (Integer)this.ruleLayer.get(key);
            if (layer >= startL) continue;
            startL = layer;
            result = layer;
        }
        return result;
    }

    public Hashtable invertLayer(Hashtable layer) {
        Hashtable<Integer, HashSet> inverted = new Hashtable<Integer, HashSet>();
        Enumeration keys = layer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer value = (Integer)layer.get(key);
            HashSet invertedValue = (HashSet)inverted.get(value);
            if (invertedValue == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(value, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public void saveRuleLayer() {
        Enumeration keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Rule r = (Rule)keys.nextElement();
            Integer layer = (Integer)this.ruleLayer.get(r);
            r.setLayer(layer);
        }
        this.saveRuleLayerInto(this.oldRuleLayer);
    }

    private void saveRuleLayerInto(Hashtable table) {
        Enumeration e = this.grammar.getRules();
        while (e.hasMoreElements()) {
            Rule r = (Rule)e.nextElement();
            table.put(r, new Integer(r.getLayer()));
        }
    }

    public void setGenerateRuleLayer(boolean b) {
        this.generateRuleLayer = b;
    }

    public void showLayer() {
        Type t;
        Integer layer;
        Enumeration keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Rule r = (Rule)keys.nextElement();
            layer = (Integer)this.ruleLayer.get(r);
        }
        keys = this.creationLayer.keys();
        while (keys.hasMoreElements()) {
            t = (Type)keys.nextElement();
            layer = (Integer)this.creationLayer.get(t);
        }
        keys = this.deletionLayer.keys();
        while (keys.hasMoreElements()) {
            t = (Type)keys.nextElement();
            Integer n = (Integer)this.deletionLayer.get(t);
        }
    }

    public String toString() {
        String resultString = super.toString() + " LayerFunction:\n";
        resultString = resultString + "\tRuleLayer:\n";
        resultString = resultString + this.getRuleLayer().toString() + "\n";
        resultString = resultString + "\tCreationLayer:\n";
        resultString = resultString + this.getCreationLayer().toString() + "\n";
        resultString = resultString + "\tDeletionLayer:\n";
        resultString = resultString + this.getDeletionLayer().toString() + "\n";
        return resultString;
    }
}

