/*
 * Decompiled with CFR 0.152.
 */
package agg.termination;

import agg.xt_basis.Type;
import com.objectspace.jgl.HashSet;
import java.util.Enumeration;
import java.util.Hashtable;

public class TypeLayer {
    private Hashtable typeLayer;
    private Hashtable types;

    public TypeLayer(Hashtable types) {
        this.types = types;
        this.initTypeLayer();
    }

    public void setLayer(Type type, int layer) {
        this.typeLayer.put(type, new Integer(layer));
    }

    private void initTypeLayer() {
        this.typeLayer = new Hashtable();
        Enumeration keys = this.types.keys();
        while (keys.hasMoreElements()) {
            Type t = (Type)keys.nextElement();
            this.typeLayer.put(t, this.types.get(t));
        }
    }

    public Hashtable getTypeLayer() {
        return this.typeLayer;
    }

    public Integer getStartLayer() {
        int startLayer = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration keys = this.getTypeLayer().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer layer = (Integer)this.getTypeLayer().get(key);
            if (layer >= startLayer) continue;
            startLayer = layer;
            result = layer;
        }
        return result;
    }

    public Hashtable invertLayer() {
        Hashtable<Integer, HashSet> inverted = new Hashtable<Integer, HashSet>();
        Enumeration keys = this.typeLayer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer value = (Integer)this.typeLayer.get(key);
            HashSet invertedValue = (HashSet)inverted.get(value);
            if (invertedValue == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(value, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String toString() {
        String resultString = "Type:\t\tLayer:\n";
        Enumeration keys = this.typeLayer.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Integer value = (Integer)this.typeLayer.get(key);
            resultString = resultString + ((Type)key).getStringRepr() + "\t\t" + value.toString() + "\n";
        }
        return resultString;
    }
}

