/*
 * Decompiled with CFR 0.152.
 */
package agg.util;

import agg.attribute.AttrInstance;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;

public final class Debug {
    public static boolean DEBUG = false;
    public static boolean ABSTRACTION = false;
    public static boolean PARSING = false;
    public static boolean HASHCODE = false;
    public static boolean MATCH = false;
    private static HashMap hash = null;
    private static int new_id;
    private static File f;
    private static FileOutputStream os;

    private Debug() {
    }

    public static final void println(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public static final void print(String msg) {
        if (DEBUG) {
            System.out.print(msg);
        }
    }

    public static final void println(String msg, Object obj) {
        if (DEBUG) {
            System.out.println(obj.getClass().getName() + ": " + msg);
        }
    }

    public static final void print(String msg, Object obj) {
        if (DEBUG) {
            System.out.print(obj.getClass().getName() + ": " + msg);
        }
    }

    public static final void println(String msg, Object obj, boolean topic) {
        if (topic) {
            System.out.println(obj.getClass().getName() + ": " + msg);
        }
    }

    public static void printlnGraph(Graph printGraph, String name, boolean topic) {
        if (topic) {
            Debug.printlnGraph(printGraph, name);
        }
    }

    private static void reset() {
        hash = new HashMap();
        new_id = 1;
    }

    private static int get_id(Object o) {
        if (hash == null) {
            return 0;
        }
        Object i = hash.get(o);
        if (i == null) {
            i = new Integer(new_id++);
            hash.put(o, i);
        }
        return (Integer)i;
    }

    public static void printlnGraph(Graph g, String name) {
        Debug.printlnGraph2(g, name, false);
    }

    public static void printlnNode(GraphObject o) {
        System.out.print(o.getType().getStringRepr() + ": (");
        Debug.printAttributes(o.getAttribute());
        System.out.println(")");
    }

    private static void printlnGraph2(Graph printGraph, String name, boolean for_morph) {
        Enumeration nodes = printGraph.getNodes();
        System.out.println("--------------- Graph: " + name + " beginns ---------------");
        if (!for_morph) {
            System.out.println();
        }
        while (nodes.hasMoreElements()) {
            Enumeration outgoing;
            Arc arc;
            Node node = (Node)nodes.nextElement();
            System.out.print(Debug.get_id(node) + " " + node.getType().getStringRepr() + ": (");
            Debug.printAttributes(node.getAttribute());
            System.out.println(") ");
            Enumeration incoming = node.getIncomingArcs();
            if (incoming.hasMoreElements()) {
                System.out.print("  incoming: ");
                while (incoming.hasMoreElements()) {
                    arc = (Arc)incoming.nextElement();
                    Node src = (Node)arc.getSource();
                    System.out.print("(" + Debug.get_id(arc) + " " + arc.getType().getStringRepr() + " <--  " + Debug.get_id(src) + " " + src.getType().getStringRepr() + "[ ");
                    Debug.printAttributes(arc.getAttribute());
                    System.out.print("]) ");
                }
                System.out.println();
            }
            if (!(outgoing = node.getOutgoingArcs()).hasMoreElements()) continue;
            System.out.print("  outgoing: ");
            while (outgoing.hasMoreElements()) {
                arc = (Arc)outgoing.nextElement();
                Node tar = (Node)arc.getTarget();
                System.out.print("(" + Debug.get_id(arc) + " " + arc.getType().getStringRepr() + " --> " + Debug.get_id(tar) + " " + tar.getType().getStringRepr() + "[ ");
                Debug.printAttributes(arc.getAttribute());
                System.out.print("]) ");
            }
            System.out.println();
        }
        if (!for_morph) {
            System.out.println("--------------- Graph: " + name + " ends ---------------\n");
        }
    }

    private static void printAttributes(AttrInstance attribute) {
        for (int i = 0; i < attribute.getNumberOfEntries(); ++i) {
            System.out.print(attribute.getNameAsString(i) + "=");
            System.out.print(attribute.getValueAsString(i) + " ");
        }
    }

    public static void printlnMorph(Morphism morph, String name, boolean topic) {
        if (topic) {
            Debug.printlnMorph(morph, name);
        }
    }

    public static void printlnMorph(Morphism morph, String name) {
        Graph srcG = morph.getOriginal();
        Graph tarG = morph.getImage();
        Debug.reset();
        System.out.println("--------------- Morphism: " + name + " beginns ---------------");
        Debug.printlnGraph2(srcG, "source graph", true);
        Debug.printlnGraph2(tarG, "target graph", true);
        System.out.println("  ---- mappings ----");
        System.out.println("Nodes: ");
        Enumeration nodes = srcG.getNodes();
        while (nodes.hasMoreElements()) {
            Node node = (Node)nodes.nextElement();
            System.out.print("  source: " + Debug.get_id(node) + " " + node.getType().getStringRepr() + ": (");
            Debug.printAttributes(node.getAttribute());
            System.out.print(") --> ");
            Node mappedNode = (Node)morph.getImage(node);
            if (mappedNode != null) {
                System.out.print("target: " + Debug.get_id(mappedNode) + " " + mappedNode.getType().getStringRepr() + ": (");
                Debug.printAttributes(mappedNode.getAttribute());
                System.out.println(")");
                continue;
            }
            System.out.println("no target");
        }
        System.out.println("--------------- Morphism: " + name + " ends ---------------\n");
        hash = null;
    }

    public static void openFile(String fname, String text) {
        f = new File(fname);
        try {
            os = new FileOutputStream(f);
            try {
                os.write(text.getBytes());
                os.write(10);
                try {
                    os.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static void closeFile(String fname) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        os = null;
        f = null;
    }

    public static void outInFile(String fname, String text) {
        f = new File(fname);
        try {
            os = new FileOutputStream(f, true);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        if (os != null) {
            try {
                os.write(text.getBytes());
                os.write(10);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

