/*
 * Decompiled with CFR 0.152.
 */
package agg.util;

import agg.util.XMLObject;
import agg.xt_basis.Version;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class XMLHelper
implements ExceptionListener {
    private Document doc = new DocumentImpl();
    private Map object2index;
    private Map index2object;
    private Map index2element;
    private Vector estack;
    private Vector chld_stack;
    private int esp;
    private static final String VERSION = "1.0";
    private String version = "";
    private String ioException = "";

    public XMLHelper() {
        Element top_elem = null;
        Element e = this.doc.createElement("Document");
        String AGGver = "AGG " + Version.getID();
        this.version = VERSION;
        e.setAttribute("version", this.version);
        this.doc.appendChild(e);
        top_elem = this.doc.getDocumentElement();
        this.object2index = new HashMap(400);
        this.index2object = new HashMap(400);
        this.index2element = new HashMap(400);
        this.estack = new Vector(10);
        this.chld_stack = new Vector(10);
        this.esp = 0;
        this.push(top_elem);
    }

    public String getDocumentVersion() {
        return this.version;
    }

    private String getO2I(Object o) {
        if (this.object2index.containsKey(o)) {
            return (String)this.object2index.get(o);
        }
        return "";
    }

    private String newO2I(Object o) {
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            newi = new String("I").concat(String.valueOf(this.index2object.size()));
            this.index2object.put(o, newi);
            this.object2index.put(o, newi);
        }
        return newi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save_to_xml(String fname) {
        OutputFormat format = new OutputFormat(this.doc, "UTF-8", true);
        File f = new File(fname);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
            XMLSerializer serializer = new XMLSerializer(os, format);
            serializer.setOutputByteStream(os);
            serializer.serialize(this.doc);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void read_from_xml(String fname) {
        Node n;
        this.esp = 0;
        try {
            DOMParser parser = new DOMParser();
            InputSource inSrc = new InputSource();
            BufferedReader in = new BufferedReader(new FileReader(fname));
            inSrc.setCharacterStream(in);
            parser.parse(inSrc);
            this.doc = parser.getDocument();
            this.doc.getDocumentElement().normalize();
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.push(this.doc.getDocumentElement());
        NodeIterator ni = ((DocumentTraversal)((Object)this.doc)).createNodeIterator(this.top(), -1, new NodeFilter(){

            public short acceptNode(Node n) {
                if (n.getNodeType() != 1) {
                    return 3;
                }
                Element e = (Element)n;
                if (e.getAttributeNode("ID") == null) {
                    return 3;
                }
                return 1;
            }
        }, true);
        while ((n = ni.nextNode()) != null) {
            Element e = (Element)n;
            String id = e.getAttribute("ID");
            this.index2element.put(id, e);
        }
        this.version = this.doc.getDocumentElement().getAttribute("version");
    }

    public String getIOException() {
        return this.ioException;
    }

    private void push(Node e) {
        this.estack.setSize(this.esp + 1);
        this.estack.set(this.esp, e);
        this.chld_stack.setSize(this.esp + 1);
        this.chld_stack.set(this.esp, e.getFirstChild());
        ++this.esp;
    }

    private Element top() {
        if (this.esp <= 0) {
            return null;
        }
        return (Element)this.estack.get(this.esp - 1);
    }

    private Element top_child() {
        return this.next_child(this.esp - 1);
    }

    private Element next_child(int i) {
        Node n;
        Node m;
        if (i < 0) {
            return null;
        }
        for (m = n = (Node)this.chld_stack.get(i); m != null && m.getNodeType() != 1; m = m.getNextSibling()) {
        }
        if (m != null) {
            Node sib;
            Node sib1;
            for (sib1 = sib = m.getNextSibling(); sib1 != null && sib1.getNodeType() != 1; sib1 = sib1.getNextSibling()) {
            }
            this.chld_stack.set(i, sib1);
        } else {
            this.chld_stack.set(i, this.top().getFirstChild());
        }
        return (Element)m;
    }

    private Element parent() {
        if (this.esp <= 1) {
            return null;
        }
        return (Element)this.estack.get(this.esp - 2);
    }

    private void pop() {
        if (this.esp <= 0) {
            return;
        }
        --this.esp;
        this.estack.setSize(this.esp);
        this.chld_stack.setSize(this.esp);
    }

    public Document getDoc() {
        return this.doc;
    }

    public boolean openObject(XMLObject o, XMLObject t) {
        if (o == null) {
            return false;
        }
        String newi = this.getO2I(o);
        String thisi = this.getO2I(t);
        if (newi.length() == 0 || thisi.length() == 0) {
            return false;
        }
        this.push((Element)this.index2element.get(newi));
        if (this.index2element.get(thisi) == null) {
            this.index2element.put(thisi, this.top());
        }
        return true;
    }

    public boolean reopenObject(XMLObject o, XMLObject t) {
        if (o == null) {
            return false;
        }
        String newi = this.getO2I(o);
        String thisi = this.getO2I(t);
        if (newi.length() == 0 || thisi.length() == 0) {
            return false;
        }
        this.push((Element)this.index2element.get(newi));
        if (this.index2element.get(thisi) == null) {
            this.index2element.put(thisi, this.top());
        }
        return true;
    }

    public boolean peekObject(XMLObject o, XMLObject t) {
        if (o == null) {
            return false;
        }
        String id = this.getO2I(o);
        if (id.length() == 0) {
            return false;
        }
        if (t != null && this.getO2I(t).length() == 0) {
            this.object2index.put(id, t);
        }
        this.push((Element)this.index2element.get(id));
        return true;
    }

    public void openNewElem(String tagname, XMLObject t) {
        String newi = this.getO2I(t);
        if (newi.length() != 0) {
            Element e = this.doc.createElement(tagname);
            e.setAttribute("ID", newi);
            this.index2element.put(newi, e);
            this.push(e);
        }
    }

    public void openSubTag(String tagname) {
        Element e = this.doc.createElement(tagname);
        this.top().appendChild(e);
        this.push(e);
    }

    public boolean readSubTag(String tagname) {
        Element e;
        do {
            if ((e = this.top_child()) != null) continue;
            return false;
        } while (!e.getTagName().equals(tagname));
        this.push(e);
        return true;
    }

    public boolean readSubTag(Vector tagnames) {
        Element e;
        do {
            if ((e = this.top_child()) != null) continue;
            return false;
        } while (!tagnames.contains(e.getTagName()));
        this.push(e);
        return true;
    }

    public String readSubTag() {
        String tagname = "";
        Element e = this.top_child();
        if (e == null) {
            return null;
        }
        tagname = e.getTagName();
        this.push(e);
        return tagname;
    }

    public void addObject(String mem_name, XMLObject o, boolean sub) {
        if (o == null) {
            return;
        }
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            Element el;
            newi = this.newO2I(o);
            this.index2element.put(newi, null);
            o.XwriteObject(this);
            if (this.index2element.get(newi) != null && (el = (Element)this.index2element.get(newi)).getParentNode() == null) {
                if (sub) {
                    this.top().appendChild(el);
                } else {
                    this.parent().appendChild(el);
                }
            }
        } else if (sub) {
            // empty if block
        }
        if (!sub) {
            this.top().setAttribute(mem_name, newi);
        }
    }

    public void addObjectRef(String mem_name, XMLObject o) {
        this.addObject(mem_name, o, false);
    }

    public void addObjectSub(XMLObject o) {
        this.addObject("", o, true);
    }

    public XMLObject getObject(String mem_name, XMLObject templ, boolean sub) {
        Element e;
        String s;
        if (!sub) {
            String i = "";
            String s2 = this.top().getAttribute(mem_name);
            if (!s2.equals("")) {
                i = s2;
                XMLObject o = (XMLObject)this.index2object.get(i);
                if (o == null && templ != null) {
                    o = templ;
                    this.index2object.put(i, o);
                    this.object2index.put(o, i);
                    o.XreadObject(this);
                    if (this.index2element.get(i) == null) {
                        System.out.println("XMLHelper: Object " + templ + " has no DOM elements");
                    }
                }
                return o;
            }
            return null;
        }
        do {
            if ((e = this.top_child()) == null) {
                return null;
            }
            s = e.getAttribute("ID");
            if (!s.equals("")) continue;
        } while (s.equals(""));
        if (!s.equals("")) {
            String i = s;
            if (this.index2object.get(i) != null) {
                System.err.println("XMLHelper: FATAL: subobject ID=" + i + " already read in.");
                return (XMLObject)this.index2object.get(i);
            }
            this.index2object.put(i, templ);
            this.object2index.put(templ, i);
            templ.XreadObject(this);
            if (this.index2element.get(i) == null) {
                System.out.println("XMLHelper: Object " + templ + " has no DOM elements");
            }
            return templ;
        }
        System.err.println("XMLHelper: getObject: next SubElement  " + e + "  has no ID attribute");
        return null;
    }

    public XMLObject getObjectRef(String mem_name, XMLObject templ) {
        return this.getObject(mem_name, templ, false);
    }

    public XMLObject getObjectSub(XMLObject templ) {
        return this.getObject("", templ, true);
    }

    public XMLObject loadObject(XMLObject templ) {
        Element e = this.top();
        if (e == null) {
            return null;
        }
        String s = e.getAttribute("ID");
        if (s.equals("")) {
            System.out.println("XMLHelper: Warning: ignoring Element " + e + " as it has no ID");
            return null;
        }
        String i = s;
        if (this.index2object.get(i) != null) {
            System.err.println("XMLHelper: FATAL: subobject ID=" + i + " already read in.");
            return (XMLObject)this.index2object.get(i);
        }
        this.index2object.put(i, templ);
        this.object2index.put(templ, i);
        templ.XreadObject(this);
        if (this.index2element.get(i) == null) {
            System.out.println("XMLHelper: Object " + templ + " has no DOM elements");
        }
        return templ;
    }

    public void enrichObject(XMLObject templ) {
        String id = this.getO2I(templ);
        templ.XreadObject(this);
    }

    public void addEnumeration(String mem_name, Enumeration e, boolean sub) {
        String refs = "";
        while (e.hasMoreElements()) {
            XMLObject o = (XMLObject)e.nextElement();
            String newi = this.getO2I(o);
            if (newi.length() == 0) {
                newi = this.newO2I(o);
                this.index2element.put(newi, null);
                o.XwriteObject(this);
                if (this.index2element.get(newi) == null) {
                    System.err.println("XMLHelper: Enumeration-Object has no DOM-Elements " + o.toString());
                } else if (sub) {
                    this.top().appendChild((Element)this.index2element.get(newi));
                } else {
                    this.top().getParentNode().appendChild((Element)this.index2element.get(newi));
                }
            } else if (sub) {
                // empty if block
            }
            if (sub) continue;
            String s = newi;
            if (refs.length() == 0) {
                refs = s;
                continue;
            }
            refs = refs + "," + s;
        }
        if (!sub) {
            this.top().setAttribute(mem_name, refs);
        }
    }

    public Enumeration getEnumeration(String mem_name, XMLObject templ, boolean sub, String tagname) {
        Element e;
        Vector<Element> v = new Vector<Element>();
        this.push(this.top());
        while ((e = this.top_child()) != null) {
            if (!e.getTagName().equals(tagname)) continue;
            v.add(e);
        }
        this.pop();
        return v.elements();
    }

    public void addTopObject(XMLObject o) {
        if (o == null) {
            return;
        }
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            newi = this.newO2I(o);
            this.index2element.put(newi, null);
            o.XwriteObject(this);
            if (this.index2element.get(newi) == null) {
                System.err.println("XMLHelper: Top-Object has no DOM-Elements " + o.toString());
            } else if (this.doc.getDocumentElement() == null) {
                this.doc.appendChild((Element)this.index2element.get(newi));
            } else {
                this.doc.getDocumentElement().appendChild((Element)this.index2element.get(newi));
            }
        }
    }

    public boolean isTag(String tag, XMLObject th) {
        String i = this.getO2I(th);
        if (i.length() == 0) {
            System.err.println("XMLHelper: FATAL: isTag called, without caller being in order");
            return false;
        }
        Element e = (Element)this.index2element.get(i);
        if (e == null) {
            System.err.println("XMLHelper: FATAL: ID " + i + " has no DOM element");
            return false;
        }
        this.push(e);
        if (!tag.equals(this.top().getTagName())) {
            this.pop();
            return false;
        }
        return true;
    }

    public XMLObject getTopObject(XMLObject t) {
        Element e = this.next_child(0);
        if (e == null) {
            return null;
        }
        String i = "";
        String s = e.getAttribute("ID");
        if (!s.equals("")) {
            i = s;
            if (this.index2object.get(i) != null) {
                return (XMLObject)this.index2object.get(i);
            }
            this.index2object.put(i, t);
            this.object2index.put(t, i);
        }
        t.XreadObject(this);
        return t;
    }

    public void peekElement(Object o) {
        this.push((Element)o);
    }

    public void close() {
        this.pop();
    }

    public void addObject(String tagname, String mem_name, XMLObject o) {
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            newi = this.newO2I(o);
            Element e = this.doc.createElement(tagname);
            e.setAttribute("ID", newi);
            this.top().getParentNode().appendChild(e);
            this.index2element.put(newi, e);
            this.push(e);
            o.XwriteObject(this);
            this.pop();
        }
        this.top().setAttribute(mem_name, newi);
    }

    public void addTopObject(String tagname, XMLObject o) {
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            newi = this.newO2I(o);
            Element e = this.doc.createElement(tagname);
            e.setAttribute("ID", newi);
            if (this.doc.getDocumentElement() == null) {
                this.doc.appendChild(e);
            } else {
                this.doc.getDocumentElement().appendChild(e);
            }
            this.push(e);
            o.XwriteObject(this);
            this.pop();
        }
    }

    public String escapeString(String s) {
        if (s == null) {
            return null;
        }
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '.') {
                r = r + c;
                continue;
            }
            String t = String.valueOf((int)c);
            r = r + "/" + t + "/";
        }
        return r;
    }

    public String unescapeString(String s) {
        if (s == null) {
            return null;
        }
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '/') {
                int j;
                for (j = ++i; j < s.length() && s.charAt(j) != '/'; ++j) {
                }
                String t = s.substring(i, j);
                i = j;
                c = (char)Integer.parseInt(t);
                r = r + c;
                continue;
            }
            r = r + c;
        }
        return r;
    }

    public void addAttr(String name, String value) {
        this.top().setAttribute(name, value);
    }

    public void addAttr(String name, int value) {
        this.addAttr(name, Integer.toString(value));
    }

    public void addAttrValue(String typeName, Object value) {
        String result = "";
        boolean useXMLEncoder = false;
        if (value == null) {
            this.openSubTag("string");
            Text text = this.doc.createTextNode("null");
            this.top().appendChild(text);
            this.push(text);
            this.close();
            this.close();
            return;
        }
        Class<?> cl = value.getClass();
        String className = cl.getName();
        if (typeName.equals("char") || typeName.equals("Character")) {
            this.openSubTag("char");
            Text text = this.doc.createTextNode(((Character)value).toString());
            this.top().appendChild(text);
            this.push(text);
            this.close();
            this.close();
            return;
        }
        if (typeName.equals("int") || typeName.equals("Integer")) {
            this.openSubTag("int");
            Text text = this.doc.createTextNode(((Integer)value).toString());
            this.top().appendChild(text);
            this.push(text);
            this.close();
            this.close();
            return;
        }
        if (typeName.equals("boolean") || typeName.equals("Boolean")) {
            this.openSubTag("boolean");
            Text text = this.doc.createTextNode(((Boolean)value).toString());
            this.top().appendChild(text);
            this.push(text);
            this.close();
            this.close();
            return;
        }
        if (typeName.equals("float") || typeName.equals("Float")) {
            if (value instanceof Float) {
                this.openSubTag("float");
                Text text = this.doc.createTextNode(((Float)value).toString());
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
                return;
            }
            this.openSubTag("float");
            Text text = null;
            if (className.equals("java.lang.Double")) {
                Float floatVal = new Float(((Double)value).floatValue());
                text = this.doc.createTextNode(floatVal.toString());
            } else {
                text = this.doc.createTextNode(((Float)value).toString());
            }
            this.top().appendChild(text);
            this.push(text);
            this.close();
            this.close();
            return;
        }
        if (typeName.equals("double") || typeName.equals("Double")) {
            if (value instanceof Double) {
                this.openSubTag("double");
                Text text = this.doc.createTextNode(((Double)value).toString());
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
                return;
            }
            this.openSubTag("double");
            Text text = null;
            if (className.equals("java.lang.Double")) {
                text = this.doc.createTextNode(((Double)value).toString());
            } else {
                Double doubleVal = new Double(((Float)value).doubleValue());
                text = this.doc.createTextNode(doubleVal.toString());
            }
            this.top().appendChild(text);
            this.push(text);
            this.close();
            this.close();
            return;
        }
        if (typeName.equals("long") || typeName.equals("Long")) {
            if (value instanceof Long) {
                this.openSubTag("long");
                Text text = this.doc.createTextNode(((Long)value).toString());
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
            } else {
                this.openSubTag("long");
                Text text = null;
                if (className.equals("java.lang.Float")) {
                    Long longVal = new Long(((Float)value).longValue());
                    text = this.doc.createTextNode(longVal.toString());
                } else {
                    Long longVal = new Long(((Integer)value).longValue());
                    text = this.doc.createTextNode(longVal.toString());
                }
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
            }
            return;
        }
        if (typeName.equals("short") || typeName.equals("Short")) {
            if (value instanceof Short) {
                this.openSubTag("short");
                Text text = this.doc.createTextNode(((Short)value).toString());
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
            } else {
                this.openSubTag("short");
                Text text = null;
                if (className.equals("java.lang.Float")) {
                    Short shortVal = new Short(((Float)value).shortValue());
                    text = this.doc.createTextNode(shortVal.toString());
                } else {
                    Short shortVal = new Short(((Integer)value).shortValue());
                    text = this.doc.createTextNode(shortVal.toString());
                }
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
            }
            return;
        }
        if (typeName.equals("byte") || typeName.equals("Byte")) {
            if (value instanceof Byte) {
                this.openSubTag("byte");
                Text text = this.doc.createTextNode(((Byte)value).toString());
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
            } else {
                this.openSubTag("byte");
                Byte byteVal = new Byte(((Integer)value).byteValue());
                Text text = this.doc.createTextNode(byteVal.toString());
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
            }
            return;
        }
        if (typeName.equals("string")) {
            String str = (String)value;
            if (str.indexOf("\"") == -1) {
                this.openSubTag("string");
                Text text = this.doc.createTextNode(str);
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
                return;
            }
            useXMLEncoder = true;
        } else if (typeName.equals("String")) {
            useXMLEncoder = true;
        } else {
            Object obj = null;
            try {
                cl.newInstance();
                useXMLEncoder = true;
            }
            catch (InstantiationException ex1) {
                System.out.println("XMLHelper: WARNING!\n\t" + ex1);
                System.out.println("\tContinue with using SerializedData for saving.");
                useXMLEncoder = false;
            }
            catch (IllegalAccessException ex2) {
                System.out.println("XMLHelper: WARNING!\n\t" + ex2);
                System.out.println("\tContinue with using SerializedData for saving.");
                useXMLEncoder = false;
            }
        }
        if (useXMLEncoder) {
            this.addAttrUsingXMLEncoder("Value", value);
        } else {
            this.addAttrUsingSerializedData("Value", typeName, value);
        }
        this.doc.getDocumentElement().normalize();
    }

    public Object getAttrValue(String typeName) {
        Object result = null;
        boolean useXMLDecoder = false;
        if (this.readSubTag("string")) {
            Element e = this.top();
            if (e.hasChildNodes()) {
                Text text = (Text)e.getFirstChild();
                try {
                    String data = text.getData();
                    result = data;
                }
                catch (DOMException ex) {
                    // empty catch block
                }
            }
            this.close();
            return result;
        }
        if (typeName.equals("char") || typeName.equals("Character")) {
            if (this.readSubTag("char")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = new Character(data.charAt(0));
                    }
                    catch (DOMException ex) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("int") || typeName.equals("Integer")) {
            if (this.readSubTag("int")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = new Integer(data);
                    }
                    catch (DOMException ex) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("boolean") || typeName.equals("Boolean")) {
            if (this.readSubTag("boolean")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = new Boolean(data);
                    }
                    catch (DOMException ex) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("float") || typeName.equals("Float")) {
            if (this.readSubTag("float")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = typeName.equals("float") ? new Float(data) : new Float(data);
                    }
                    catch (DOMException ex) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("double") || typeName.equals("Double")) {
            if (this.readSubTag("double")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = new Double(data);
                    }
                    catch (DOMException ex) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("long") || typeName.equals("Long")) {
            if (this.readSubTag("long")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = typeName.equals("long") ? new Long(data) : new Long(data);
                    }
                    catch (DOMException ex) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("short") || typeName.equals("Short")) {
            if (this.readSubTag("short")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = typeName.equals("short") ? new Short(data) : new Short(data);
                    }
                    catch (DOMException ex) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("byte") || typeName.equals("Byte")) {
            if (this.readSubTag("byte")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = typeName.equals("byte") ? new Byte(data) : new Byte(data);
                    }
                    catch (DOMException ex) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else {
            if (typeName.equals("string")) {
                if (result != null && result instanceof String) {
                    return result;
                }
                return null;
            }
            if (typeName.equals("String")) {
                useXMLDecoder = true;
            } else if (this.readSubTag("object")) {
                String s = this.readAttr("class");
                if (s.equals(typeName)) {
                    if (this.readSubTag("SerializedData")) {
                        result = this.getAttrUsingSerializedData("SerializedData");
                        this.close();
                        this.close();
                        return result;
                    }
                } else {
                    this.close();
                }
            } else {
                useXMLDecoder = true;
            }
        }
        if (useXMLDecoder) {
            result = this.getAttrUsingXMLDecoder("Value");
        }
        return result;
    }

    private void addAttrUsingXMLEncoder(String tagName, Object value) {
        if (!tagName.equals("Value")) {
            return;
        }
        String xmlFilename = "AGG_tmpout1.xml";
        File xmlFile = new File(xmlFilename);
        xmlFile.deleteOnExit();
        try {
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(xmlFile)));
            e.writeObject(value);
            e.close();
        }
        catch (FileNotFoundException ex) {
            System.out.println("agg.util.XMLHelper.addAttrUsingXMLEncoder: write attribute value is FAILED!");
        }
        catch (Exception ex) {
            System.out.println("agg.util.XMLHelper.addAttrUsingXMLEncoder: write attribute value is FAILED!");
        }
        Document tmpDoc = null;
        try {
            DOMParser parser = new DOMParser();
            parser.parse(xmlFilename);
            tmpDoc = parser.getDocument();
            tmpDoc.getDocumentElement().normalize();
            Element element = tmpDoc.getDocumentElement();
            try {
                Node n = this.doc.importNode(element, true);
                this.top().appendChild(n);
                this.push(n);
                this.close();
            }
            catch (DOMException ex2) {
                System.out.println("XMLHelper: DOMException: " + ex2.getMessage());
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttrUsingXMLDecoder(String tagName) {
        if (!tagName.equals("Value")) {
            return null;
        }
        Object result = null;
        Element element = this.top();
        if (element.getElementsByTagName("java").getLength() == 0) {
            return null;
        }
        DocumentImpl tmpDoc = null;
        tmpDoc = new DocumentImpl();
        Node n = null;
        try {
            n = tmpDoc.importNode(element, true);
            tmpDoc.appendChild(n);
        }
        catch (DOMException ex2) {
            System.out.println("XMLHelper: DOMException: " + ex2.getMessage());
            return null;
        }
        String xmlFile = "AGG_tmpout2.xml";
        OutputFormat format = new OutputFormat(tmpDoc, "UTF-8", true);
        File f = new File(xmlFile);
        f.deleteOnExit();
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
            XMLSerializer serializer = new XMLSerializer(os, format);
            serializer.setOutputByteStream(os);
            serializer.serialize(tmpDoc);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {}
        }
        try {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(xmlFile)), this, this);
            result = d.readObject();
            d.close();
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        return result;
    }

    private void addAttrUsingSerializedData(String tagName, String typeName, Object value) {
        if (!tagName.equals("Value")) {
            return;
        }
        Class<?> cl = value.getClass();
        if (!(value instanceof Serializable)) {
            System.out.println("XMLHelper: WARNING!  Save attribute value:  Class " + cl.getName() + "  CANNOT BE SAVED.\n\tThis class should implements interface java.io.Serializable.");
            return;
        }
        String clName = cl.getName();
        if (clName.indexOf(typeName) == -1) {
            System.out.println("XMLHelper: WARNING! Save attribute value:  Class " + cl.getName() + "  CANNOT BE SAVED.\n\tClass name and the name of the AttributeMember type are not equal.");
            return;
        }
        this.openSubTag("object");
        this.addAttr("class", typeName);
        this.openSubTag("SerializedData");
        boolean successfullySaved = true;
        if (value == null) {
            successfullySaved = false;
        } else {
            try {
                ByteArrayOutputStream baOut = new ByteArrayOutputStream();
                ObjectOutputStream oOut = new ObjectOutputStream(baOut);
                oOut.writeObject(value);
                oOut.flush();
                byte[] bytes = baOut.toByteArray();
                char[] conversionTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
                int blockSize = 16;
                int i = 0;
                while (i < bytes.length) {
                    int thisBlock = bytes.length - i;
                    if (thisBlock > blockSize) {
                        thisBlock = blockSize;
                    }
                    String block = new String();
                    int k = 0;
                    while (k < thisBlock) {
                        int b = bytes[i];
                        if (b < 0) {
                            b += 256;
                        }
                        block = block + String.valueOf(conversionTable[b / 16]);
                        block = block + String.valueOf(conversionTable[b % 16]);
                        ++k;
                        ++i;
                    }
                    Text text = this.doc.createTextNode(block);
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                }
            }
            catch (IOException e) {
                successfullySaved = false;
            }
        }
        if (!successfullySaved) {
            Text text = this.doc.createTextNode("isNULL");
            this.top().appendChild(text);
            this.push(text);
            this.close();
        }
        this.close();
        this.close();
    }

    private Object getAttrUsingSerializedData(String tagName) {
        Object object = null;
        if (this.top().getNodeName().equals(tagName)) {
            int len;
            Vector<String> dataList = new Vector<String>();
            int byteCount = 0;
            String data = null;
            Element e = this.top();
            if (e.hasChildNodes()) {
                Text text = (Text)e.getFirstChild();
                try {
                    data = text.getData();
                }
                catch (DOMException ex) {
                    // empty catch block
                }
            }
            if (data != null && !data.equals("isNULL") && (len = data.length()) >= 2) {
                dataList.add(data);
                byteCount += len / 2;
            }
            byte[] bytes = new byte[byteCount];
            Iterator dataIt = dataList.iterator();
            String currentData = null;
            int dataIndex = 0;
            int dataLen = 0;
            for (int i = 0; i < byteCount; ++i) {
                if (dataIndex + 1 >= dataLen) {
                    currentData = (String)dataIt.next();
                    dataIndex = 0;
                    dataLen = currentData.length();
                }
                int b = 0;
                for (int d = 0; d < 2; ++d) {
                    b *= 16;
                    switch (currentData.charAt(dataIndex)) {
                        case '0': {
                            b += 0;
                            break;
                        }
                        case '1': {
                            ++b;
                            break;
                        }
                        case '2': {
                            b += 2;
                            break;
                        }
                        case '3': {
                            b += 3;
                            break;
                        }
                        case '4': {
                            b += 4;
                            break;
                        }
                        case '5': {
                            b += 5;
                            break;
                        }
                        case '6': {
                            b += 6;
                            break;
                        }
                        case '7': {
                            b += 7;
                            break;
                        }
                        case '8': {
                            b += 8;
                            break;
                        }
                        case '9': {
                            b += 9;
                            break;
                        }
                        case 'a': {
                            b += 10;
                            break;
                        }
                        case 'b': {
                            b += 11;
                            break;
                        }
                        case 'c': {
                            b += 12;
                            break;
                        }
                        case 'd': {
                            b += 13;
                            break;
                        }
                        case 'e': {
                            b += 14;
                            break;
                        }
                        case 'f': {
                            b += 15;
                            break;
                        }
                    }
                    ++dataIndex;
                }
                if (b > 127) {
                    b -= 256;
                }
                bytes[i] = (byte)b;
            }
            try {
                ByteArrayInputStream baIn = new ByteArrayInputStream(bytes);
                ObjectInputStream oOut = new ObjectInputStream(baIn);
                object = oOut.readObject();
            }
            catch (Exception exc) {
                object = null;
            }
        }
        return object;
    }

    public void addAttrToObject(Object obj, String name, String value) {
        String indx = this.getO2I(obj);
        if (!indx.equals("")) {
            Element elem = (Element)this.index2element.get(indx);
            elem.setAttribute(name, value);
        }
    }

    public String readAttr(String name) {
        String r = this.top().getAttribute(name);
        if (r == null) {
            r = "";
        }
        return r;
    }

    public int readIAttr(String name) {
        String s = this.readAttr(name);
        if (s == "") {
            return 0;
        }
        return new Integer(s);
    }

    public void addSubObject(String tagname, XMLObject o) {
        Element e = this.doc.createElement(tagname);
        this.push(e);
        o.XwriteObject(this);
        this.pop();
        this.top().appendChild(e);
    }

    public Object getObject(String tagname) {
        return null;
    }

    public void exceptionThrown(Exception e) {
    }
}

