/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.csp.SolutionStrategy;
import agg.util.csp.Variable;
import java.util.Enumeration;

public abstract class CSP {
    private Object itsDomain = null;
    private SolutionStrategy itsSolver;
    private boolean itsTouchedFlag;

    public CSP(SolutionStrategy solver) {
        this.setSolutionStrategy(solver);
    }

    public abstract Enumeration getVariables();

    public abstract int getSize();

    public final void setDomain(Object domain) {
        Enumeration en = this.getVariables();
        while (en.hasMoreElements()) {
            ((Variable)en.nextElement()).setInstance(null);
        }
        this.itsTouchedFlag = true;
        this.itsDomain = domain;
        this.preprocessDomain(domain);
    }

    protected abstract void preprocessDomain(Object var1);

    public final Object getDomain() {
        return this.itsDomain;
    }

    public final boolean nextSolution() {
        if (this.itsTouchedFlag) {
            this.itsSolver.reset();
            this.itsTouchedFlag = false;
        }
        return this.itsSolver.next(this);
    }

    public final void setSolutionStrategy(SolutionStrategy solver) {
        this.itsSolver = solver;
        this.itsTouchedFlag = true;
    }

    public boolean hasMoreSolutions() {
        return this.itsSolver.hasMoreSolutions();
    }

    public final void reset() {
        this.itsSolver.reset();
        this.itsTouchedFlag = false;
    }
}

