/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.csp.Variable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Query {
    private Vector itsSources = new Vector(2, 1);
    private Variable itsTarget;
    protected int itsWeight;
    public String typeNameOfVariable = "";

    public Query(Variable tar, int weight) {
        this.itsTarget = tar;
        this.itsWeight = weight;
        this.initialize();
    }

    public Query(Variable src, Variable tar, int weight) {
        this.itsSources.addElement(src);
        this.itsTarget = tar;
        this.itsWeight = weight;
        this.initialize();
    }

    public Query(Variable src1, Variable src2, Variable tar, int weight) {
        this.itsSources.addElement(src1);
        this.itsSources.addElement(src2);
        this.itsTarget = tar;
        this.itsWeight = weight;
        this.initialize();
    }

    private final void initialize() {
        for (int i = 0; i < this.itsSources.size(); ++i) {
            ((Variable)this.itsSources.elementAt(i)).addOutgoingQuery(this);
        }
        if (this.itsTarget != null) {
            this.itsTarget.addIncomingQuery(this);
        } else {
            System.out.println("agg.util.csp.Query.initialize():: itsTarget is null!");
        }
    }

    public boolean isApplicable() {
        if (this.itsTarget.getInstance() != null) {
            return false;
        }
        for (int i = 0; i < this.itsSources.size(); ++i) {
            Variable v = (Variable)this.itsSources.elementAt(i);
            if (v.getInstance() != null) continue;
            return false;
        }
        return true;
    }

    public boolean isConstant() {
        return this.itsSources.size() == 0;
    }

    public abstract Enumeration execute();

    public Variable getTarget() {
        return this.itsTarget;
    }

    public final Enumeration getSources() {
        return this.itsSources.elements();
    }

    public final Variable getSource(int i) {
        return (Variable)this.itsSources.elementAt(i);
    }

    public abstract int getSize();

    public final int getWeight() {
        return this.itsWeight;
    }

    public abstract int getDomainSize();

    public abstract String getKind();

    protected final Object getSourceInstance(int i) {
        return ((Variable)this.itsSources.elementAt(i)).getInstance();
    }
}

