/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.Debug;
import agg.util.csp.BinaryConstraint;
import agg.util.csp.CSP;
import agg.util.csp.Query;
import agg.util.csp.SearchStrategy;
import agg.util.csp.SimpleVariableOrder;
import agg.util.csp.Variable;
import com.objectspace.jgl.BidirectionalIterator;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Deque;
import com.objectspace.jgl.OrderedSet;
import java.util.Enumeration;
import java.util.Vector;

public class Search_BreadthFirst
implements SearchStrategy {
    private static BinaryPredicate theirVariableOrder = new SimpleVariableOrder();
    private Vector orderedVars = new Vector(5);

    public final Vector execute(CSP csp) {
        OrderedSet allVarsLeft = new OrderedSet(theirVariableOrder);
        Enumeration anEnum = csp.getVariables();
        while (anEnum.hasMoreElements()) {
            Variable aVar = (Variable)anEnum.nextElement();
            if (aVar.getInstance() != null) continue;
            allVarsLeft.add(aVar);
        }
        Deque aQueryList = this.bfs(new OrderedSet(), allVarsLeft);
        Vector<Query> aQueryVec = new Vector<Query>(aQueryList.size());
        anEnum = aQueryList.elements();
        while (anEnum.hasMoreElements()) {
            Query aQuery = (Query)anEnum.nextElement();
            if (aQuery == null || aQuery.getTarget() == null) continue;
            aQuery.getTarget().setInstance(null);
            aQueryVec.addElement(aQuery);
        }
        Debug.println("Search plan has " + aQueryVec.size() + " Queries.", this);
        return aQueryVec;
    }

    private void showQueries(Vector aQueryVec) {
        for (int i = 0; i < aQueryVec.size(); ++i) {
            Query aQuery = (Query)aQueryVec.get(i);
            System.out.println("Query kind: " + aQuery.getKind() + "  Applicable: " + aQuery.isApplicable() + "  Query tar: " + aQuery.getTarget() + "  Query weight: " + aQuery.getWeight() + "  Query tar weight: " + aQuery.getTarget().getWeight() + "  Query tar obj is NODE: " + (aQuery.getTarget().getKind() == 0));
        }
    }

    private final Deque bfs(OrderedSet breadthvars, OrderedSet varsleft) {
        if (!breadthvars.isEmpty()) {
            OrderedSet aVarSet = new OrderedSet(theirVariableOrder);
            Deque aQueryList = new Deque();
            Enumeration en = breadthvars.elements();
            while (en.hasMoreElements()) {
                Variable aVar = (Variable)en.nextElement();
                aQueryList.pushBack(this.getBestQuery(aVar));
                varsleft.remove(aVar);
                aVar.setInstance(this);
                aVarSet = aVarSet.union(this.getVicinity(aVar, varsleft));
            }
            Deque aVicQueryList = this.bfs(aVarSet, varsleft);
            aQueryList.insert(aQueryList.end(), (BidirectionalIterator)aVicQueryList.begin(), (BidirectionalIterator)aVicQueryList.end());
            return aQueryList;
        }
        if (varsleft.isEmpty()) {
            return new Deque();
        }
        Variable aVar = this.getBestVar(varsleft);
        breadthvars.add(aVar);
        return this.bfs(breadthvars, varsleft);
    }

    private final Query getBestQuery(Variable var) {
        Enumeration anEnum = var.getIncomingQueries();
        Query aBestQuery = null;
        int aBestSize = -1;
        while (anEnum.hasMoreElements()) {
            aBestQuery = (Query)anEnum.nextElement();
            if (!aBestQuery.isApplicable()) continue;
            aBestSize = aBestQuery.getSize();
            break;
        }
        if (aBestSize == -1) {
            return null;
        }
        while (anEnum.hasMoreElements()) {
            Query aQuery = (Query)anEnum.nextElement();
            int aSize = aQuery.getSize();
            if (!aQuery.isApplicable() || aSize >= aBestSize) continue;
            aBestSize = aSize;
            aBestQuery = aQuery;
        }
        return aBestQuery;
    }

    private final OrderedSet getVicinity(Variable v, OrderedSet varsleft) {
        OrderedSet aVicinity = new OrderedSet(theirVariableOrder);
        Enumeration allConstraints = v.getConstraints();
        while (allConstraints.hasMoreElements()) {
            Variable aVar = this.getOtherVariable((BinaryConstraint)allConstraints.nextElement(), v);
            if (varsleft.find(aVar).equals(varsleft.end())) continue;
            boolean check = true;
            if (aVar.getKind() == 1) {
                Enumeration aVarConstraints = aVar.getConstraints();
                while (aVarConstraints.hasMoreElements()) {
                    Variable av = this.getOtherVariable((BinaryConstraint)aVarConstraints.nextElement(), aVar);
                    if (av == null || av == aVar || varsleft.find(av).equals(varsleft.end())) continue;
                    check = false;
                }
            }
            if (!check) continue;
            aVicinity.add(aVar);
        }
        return aVicinity;
    }

    private final Variable getBestVar(OrderedSet vars) {
        return (Variable)vars.start().get();
    }

    private final Variable getOtherVariable(BinaryConstraint bc, Variable v) {
        return v.equals(bc.getVar1()) ? bc.getVar2() : bc.getVar1();
    }
}

