/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.Debug;
import agg.util.csp.CSP;
import agg.util.csp.Query;
import agg.util.csp.SearchStrategy;
import agg.util.csp.Search_BreadthFirst;
import agg.util.csp.SimpleVariableOrder;
import agg.util.csp.SolutionStrategy;
import agg.util.csp.Variable;
import agg.xt_basis.GraphObject;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.HashSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Solution_Backjump
implements SolutionStrategy {
    private CSP itsCSP;
    private Vector itsQueries = new Vector(20, 10);
    private Dictionary itsVarIndexMap;
    private boolean itsInjectiveFlag;
    private Dictionary itsInstanceVarMap;
    private BinaryPredicate itsVariableOrder = new SimpleVariableOrder();
    private SearchStrategy itsSearcher = new Search_BreadthFirst();
    private HashSet itsBackjumpTargets = new HashSet();
    private int itsDirection;
    private int itsCurrentIndex;
    private Variable itsCurrentVar;
    private int itsState;
    private int itsInstantiationCounter;
    private int itsBackstepCounter;
    private Variable startVar;
    private int allInstances = 0;
    private static final int START = 1;
    private static final int NEXT = 2;
    private static final int INSTANTIATE = 3;
    private static final int BACK = 4;
    private static final int SUCCESS = 5;
    private static final int NO_MORE_SOLUTIONS = 6;
    private static final int BACKJUMP = 7;

    public Solution_Backjump() {
        this.itsInjectiveFlag = false;
    }

    public Solution_Backjump(boolean injective) {
        this.itsInjectiveFlag = injective;
    }

    private final synchronized boolean initialize(CSP csp) {
        Debug.println("Solution_Backjump.initialize ", this, Debug.MATCH);
        this.itsCSP = csp;
        this.itsQueries.removeAllElements();
        this.itsQueries = this.itsSearcher.execute(this.itsCSP);
        this.itsQueries.trimToSize();
        this.itsInstanceVarMap = new Hashtable(this.itsCSP.getSize());
        this.itsVarIndexMap = new Hashtable(this.itsCSP.getSize());
        if (Debug.MATCH) {
            this.showQueries(this.itsQueries);
        }
        for (int i = 0; i < this.itsQueries.size(); ++i) {
            Variable v = ((Query)this.itsQueries.elementAt(i)).getTarget();
            this.itsVarIndexMap.put(v, new Integer(i));
        }
        if (!this.itsQueries.isEmpty()) {
            this.startVar = ((Query)this.itsQueries.elementAt(0)).getTarget();
        }
        Enumeration anEnum = this.itsCSP.getVariables();
        while (anEnum.hasMoreElements()) {
            Variable aVar = (Variable)anEnum.nextElement();
            if (aVar.getInstance() == null) continue;
            if (aVar.checkConstraints().hasMoreElements()) {
                return false;
            }
            this.itsVarIndexMap.put(aVar, new Integer(-1));
            this.itsInstanceVarMap.put(aVar.getInstance(), aVar);
        }
        return true;
    }

    public final void reset() {
        Debug.println("Resetting!", this);
        this.itsState = 1;
    }

    public final synchronized boolean next(CSP csp) {
        Debug.println("Solution_Backjump.next", this, Debug.MATCH);
        if (!csp.equals(this.itsCSP)) {
            Debug.println("Got new CSP!", this, Debug.MATCH);
            if (!this.initialize(csp)) {
                return false;
            }
            this.itsState = 1;
        }
        if (this.itsState == 5) {
            this.itsState = 4;
            ++this.itsCurrentIndex;
        }
        block9: while (true) {
            switch (this.itsState) {
                case 1: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- START", this, Debug.MATCH);
                    this.itsInstantiationCounter = 0;
                    this.itsBackstepCounter = 0;
                    this.itsCurrentIndex = -1;
                    this.itsState = 2;
                    continue block9;
                }
                case 2: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- NEXT", this, Debug.MATCH);
                    if (this.itsCurrentIndex >= this.itsQueries.size() - 1) {
                        this.itsState = 5;
                    } else {
                        this.itsBackjumpTargets.clear();
                        Query aCurrentQuery = (Query)this.itsQueries.elementAt(++this.itsCurrentIndex);
                        this.itsCurrentVar = aCurrentQuery.getTarget();
                        if (aCurrentQuery.isApplicable()) {
                            Debug.println("used Query: " + aCurrentQuery, this);
                            this.itsCurrentVar.setDomainEnum(aCurrentQuery.execute());
                            if (Debug.MATCH) {
                                this.showDomainEnum(aCurrentQuery);
                            }
                            if (aCurrentQuery.getDomainSize() > 0) {
                                this.addToBackjumpTargets(aCurrentQuery.getSources());
                            }
                        } else {
                            Debug.println("used Query: " + aCurrentQuery, this);
                            Debug.println("Solution_Backjump: Query not applicable!  Should have never come here! ", this, Debug.MATCH);
                            Debug.println("CurrentQuery:  " + aCurrentQuery + " : " + aCurrentQuery.getTarget(), this, Debug.MATCH);
                            if (Debug.MATCH) {
                                this.showDomainEnum(aCurrentQuery);
                            }
                            this.itsState = 6;
                        }
                        this.itsState = 3;
                    }
                    this.itsDirection = 2;
                    continue block9;
                }
                case 3: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- INSTANTIATE", this, Debug.MATCH);
                    this.itsState = this.itsDirection == 2 ? 7 : 4;
                    Enumeration aDomain = this.itsCurrentVar.getDomainEnum();
                    while (true) {
                        if (!aDomain.hasMoreElements()) continue block9;
                        ++this.itsInstantiationCounter;
                        this.itsCurrentVar.setInstance(aDomain.nextElement());
                        Object inst = this.itsCurrentVar.getInstance();
                        ++this.allInstances;
                        Variable aConflictVar = this.checkInjection(this.itsCurrentVar);
                        if (aConflictVar != null) {
                            this.itsCurrentVar.setInstance(null);
                            --this.allInstances;
                            this.itsBackjumpTargets.add(aConflictVar);
                            continue;
                        }
                        Enumeration allConflictVars = this.itsCurrentVar.checkConstraints();
                        if (!allConflictVars.hasMoreElements()) {
                            this.itsState = 2;
                            this.addInjection(this.itsCurrentVar);
                            continue block9;
                        }
                        if (this.itsState == 7) {
                            Variable conflictVar1 = this.getFirstOf(allConflictVars);
                            this.itsBackjumpTargets.add(conflictVar1);
                        }
                        if (aDomain.hasMoreElements() || !this.itsBackjumpTargets.isEmpty()) continue;
                        this.itsState = 4;
                    }
                }
                case 4: {
                    ++this.itsBackstepCounter;
                    Debug.println("[" + this.itsCurrentIndex + "] -- BACK", this, Debug.MATCH);
                    if (this.itsCurrentIndex == 0) {
                        if (this.itsCurrentVar != null && this.itsCurrentVar.getDomainEnum().hasMoreElements()) {
                            this.removeInjection(this.itsCurrentVar);
                            this.itsCurrentVar.setInstance(null);
                            --this.allInstances;
                            this.itsState = 3;
                            this.itsDirection = 2;
                            continue block9;
                        }
                        this.itsState = 6;
                        this.itsDirection = 4;
                        continue block9;
                    }
                    this.removeInjection(this.itsCurrentVar);
                    this.itsCurrentVar.setInstance(null);
                    --this.allInstances;
                    if (this.itsCurrentIndex > 0) {
                        this.itsCurrentVar = ((Query)this.itsQueries.elementAt(--this.itsCurrentIndex)).getTarget();
                    }
                    this.removeInjection(this.itsCurrentVar);
                    this.itsState = 3;
                    this.itsDirection = 4;
                    continue block9;
                }
                case 7: {
                    ++this.itsBackstepCounter;
                    int aStepCounter = 0;
                    Debug.println("[" + this.itsCurrentIndex + "] -- BACKJUMP: ", this, Debug.MATCH);
                    this.itsState = 6;
                    while (this.itsCurrentIndex > 0) {
                        ++aStepCounter;
                        this.removeInjection(this.itsCurrentVar);
                        this.itsCurrentVar.setInstance(null);
                        --this.allInstances;
                        this.itsCurrentVar = ((Query)this.itsQueries.elementAt(--this.itsCurrentIndex)).getTarget();
                        this.removeInjection(this.itsCurrentVar);
                        if (this.itsBackjumpTargets.find(this.itsCurrentVar).equals(this.itsBackjumpTargets.end())) continue;
                        this.itsState = 3;
                        break;
                    }
                    if (this.itsCurrentIndex == 0 && this.itsState != 3) {
                        this.itsState = 3;
                    }
                    Debug.println("Jumped " + aStepCounter + " steps.", this, Debug.MATCH);
                    this.itsDirection = 4;
                    continue block9;
                }
                case 5: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- SUCCESS: " + this.itsInstantiationCounter + " variable instantiations so far.", this, Debug.MATCH);
                    return true;
                }
                case 6: {
                    Debug.println("[" + this.itsCurrentIndex + "] -- NO_MORE_SOLUTIONS after " + this.itsInstantiationCounter + " variable instantiations \tand " + this.itsBackstepCounter + " backsteps.", this, Debug.MATCH);
                    Debug.println("allVariables:  " + this.itsQueries.size() + "   allInstances:  " + this.allInstances, this, Debug.MATCH);
                    return false;
                }
            }
            System.out.println("Should have never come here " + this.itsState);
        }
    }

    public boolean hasMoreSolutions() {
        return this.itsState != 6;
    }

    private final Variable getFirstOf(Enumeration vars) {
        Variable aFirstVar = (Variable)vars.nextElement();
        int aFirstIndex = this.itsQueries.size();
        while (vars.hasMoreElements()) {
            int aCurrentIndex;
            Variable aCurrentVar = (Variable)vars.nextElement();
            if (this.itsVarIndexMap.get(aCurrentVar) == null || (aCurrentIndex = ((Integer)this.itsVarIndexMap.get(aCurrentVar)).intValue()) >= aFirstIndex) continue;
            aFirstIndex = aCurrentIndex;
            aFirstVar = aCurrentVar;
        }
        return aFirstVar;
    }

    private final void addInjection(Variable var) {
        if (this.itsInjectiveFlag && var.getInstance() != null) {
            this.itsInstanceVarMap.put(var.getInstance(), var);
        }
    }

    private final void removeInjection(Variable var) {
        if (this.itsInjectiveFlag && var.getInstance() != null) {
            this.itsInstanceVarMap.remove(var.getInstance());
        }
    }

    private final Variable checkInjection(Variable var) {
        if (this.itsInjectiveFlag && var.getInstance() != null) {
            return (Variable)this.itsInstanceVarMap.get(var.getInstance());
        }
        return null;
    }

    private final void addToBackjumpTargets(Enumeration en) {
        while (en.hasMoreElements()) {
            Variable var = (Variable)en.nextElement();
            this.itsBackjumpTargets.add(var);
        }
    }

    private void showQueries(Vector queries) {
        System.out.println("**** QUERIES ****");
        for (int i = 0; i < queries.size(); ++i) {
            Query q = (Query)queries.elementAt(i);
            Variable v = q.getTarget();
            System.out.println(q + " : GraphObject is Node: " + (v.getKind() == 0));
            Enumeration en = q.getSources();
            while (en.hasMoreElements()) {
                Variable sv = (Variable)en.nextElement();
                System.out.println("\tsource  GraphObject is Node: " + (sv.getKind() == 0));
            }
        }
        System.out.println("***********");
    }

    private void showVariables(Vector queries) {
        System.out.println("**** VARIABLES ****");
        for (int i = 0; i < queries.size(); ++i) {
            Query q = (Query)queries.elementAt(i);
            Variable v = q.getTarget();
            if (v.getInstance() == null) continue;
            System.out.println(v + " : " + v.getInstance());
        }
        System.out.println("***********");
    }

    private void showDomainEnum(Query q) {
        System.out.println("**** DOMAIN OF VARIABLE: ****");
        System.out.println(q + " : " + q.getTarget() + "  is Node: " + (q.getTarget().getKind() == 0));
        Enumeration dom = q.execute();
        while (dom.hasMoreElements()) {
            GraphObject o = (GraphObject)dom.nextElement();
            System.out.print(o);
        }
        System.out.println();
        System.out.println("***********");
    }
}

